<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup timetrack
 * @module timetrack_new
 * @package timetrack
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("timetrack","new");
 loadlayout();

 /**
  * change/modify a timetrack entry
  */
 class timetrack_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $lang, $tutos, $table;

     if ( $this->mode == 1 ) {
       # if we are in time record mode we first give a list of all OPEN records
       $q = "SELECT * from ". $this->obj->tablename ." WHERE t_start is not null AND t_end is NULL and adr_id = ". $this->obj->worker->id;
       $r = $this->dbconn->Exec($q);
       $n = $r->numrows();
       $a = 0;
       if ( $n > 0 ) {
         echo $this->DataTableStart();
         echo "<tr>\n";
         echo "<th>". $lang['Timetrack'] ."</th>\n";
         echo "<th>". $lang['AppStart'] ."</th>\n";
         echo "<th>". $lang['TimetrackRef'] ."</th>\n";
         echo "<th>". $lang['TimetrackModify'] ."</th>\n";
         echo "<th>". $lang['TTfinish'] ."</th>\n";
         echo "</tr>\n";
       }
       $line = 0 ;
       while ( $a < $n ) {
         $f = new timetrack($this->dbconn);
         $f->read_result($r,$a);
         $a++;
         echo $this->OverviewRowStart($line);
         echo "<td>". $f->getLink() ."</td>";
         echo "<td>". $f->t_start->getDateTime() ."</td>";
         echo "<td>". $f->ref->getLink() ."</td>";
         echo "<td>". makelink("timetrack_new.php?mode=2&id=". $f->id,$lang['Modify'],$lang['TimetrackModify']) ."</td>";
         echo "<td>". makelink("timetrack_finish.php?id=". $f->id,$lang['TTfinish'],$lang['TTfinish']) ."</td>";
         echo $this->OverviewRowEnd($line++);
       }
       $r->free();
       if ( $n > 0 ) {
         echo $this->DataTableEnd();
         return;
       }
     }

     echo "<form name=\"ttadd\" action=\"timetrack_ins.php\" method=\"POST\">\n";
     $this->addHidden("mode",$this->mode);
     echo $this->DataTableStart();
     echo "<tr><th colspan=\"4\">";
     echo "&nbsp;";
     echo "</th></tr>\n";

     if ( $this->obj->id > 0 ) {
       $this->addHidden("id",$this->obj->id);
     }
     echo "<tr>\n";
     echo $this->showfield($lang['TimetrackRef']);
     echo " <td colspan=\"2\">\n";
     if ( $this->mode != 0 ) {
       if ( $this->obj->reftype == 'installation' ) {
         echo  $lang[$this->obj->ref->getType()] ." ". $this->obj->ref->getLink() ."\n";
         $this->addHidden("lid",$this->obj->ref->id);
       } else {
         select_from_array_or_input($this->obj,"l",$this->obj->ref,0);
       }
     } else {
       if ( $this->obj->ref > 0 ) {
         echo  $lang[$this->obj->ref->getType()] ." ". $this->obj->ref->getLink() ."\n";
       } else {
         echo  $lang['HistoryDeleted'] ."\n";
       }
       $this->addHidden("lid",$this->obj->ref->id);
     }
     echo " </td>\n";
     echo " <td align=\"right\">". acl_link($this->obj) ."</td>";
     echo "</tr>\n";
     echo "<tr>\n";
     echo $this->showfieldc($lang['TimetrackWorker'],1,"wfn");
     echo " <td colspan=\"3\">\n";
     if ( $this->mode == 0 ) {
       select_from_array_or_input($this->obj,"w",$this->obj->worker,0);
     } else {
       echo $this->obj->worker->getLink();
       $this->addHidden("wid",$this->obj->worker->id);
     }
     echo " </td>\n";
     echo "</tr>\n";

     if ( $this->obj->t_start->notime != 0 ) {
       echo "<tr>\n";
       echo $this->showfieldc($lang['TaskVolumeDone'],1,"volume");
       echo " <td colspan=\"1\"><input size=\"10\" maxlength=\"10\" name=\"volume\" value=\"". $this->obj->volume ."\">". $lang['hours'] ."</td>\n";
       echo $this->showfieldc($lang['atDateTime'],1,"wd");
       echo " <td>\n";
       $this->obj->wday->EnterDate("wd",1);
       echo " </td>\n";
       echo "</tr>\n";
     } else {
       echo "<tr>\n";
       echo $this->showfieldc($lang['AppStart'],1,"start");
       echo " <td>\n";
       $this->obj->t_start->EnterDateTime("start",1);
       echo " </td>\n";
       echo $this->showfieldc($lang['AppEnd'],0,"end");
       echo " <td>\n";
       $this->obj->t_end->EnterDateTime("end",1);
       echo " </td>\n";
       echo "</tr>\n";
     }

     if ($this->obj->ref->getType() == "task") {
       if( $this->obj->ref->volume_todo == -1 )
         $volume_todo = $this->obj->ref->volume - $this->obj->ref->volume_done;
       else
         $volume_todo = $this->obj->ref->volume_todo;

       echo "<tr>\n";
       echo $this->showfieldc($lang['TaskVolumeTodo'],0,"volume_todo");
       echo " <td><input size=\"10\" maxlength=\"10\" name=\"volume_todo\">". $lang['hours'] ."</td>\n";

       echo "<td colspan=\"2\"> <i>". $lang['TaskVolumeTodo'] .": ". $volume_todo ." ". $lang['hours'] ."</i></td>";

       echo "</tr>";
     }

     if( $tutos[useinvoice] ) {
       echo "<tr>\n";
       echo $this->showfieldc($lang['TTcph'],0,"cph");
       echo " <td colspan=\"1\"><input size=\"10\" maxlength=\"10\" name=\"cph\" value=\"". $this->obj->cph ."\">\n";
       Currency_Select("currency",$this->obj->currency);
       echo "</td>\n";
       echo $this->showfieldc($lang['TTState'],1,"state");
       echo " <td><select name=\"state\">\n";
       @reset($lang['TTStates']);
       while ( list ($s,$x) = @each ($lang['TTStates']) ) {
         echo "   <option value=\"". $s ."\"". ($this->obj->state == $s ? " selected" : "") .">". $lang['TTStates'][$s] ."</option>\n";
       }
       echo "</select></td>\n";
       echo "</tr>\n";
     }

     echo "<tr>\n";
     echo $this->showfieldc($lang['Description'],1,"desc");
     echo " <td colspan=\"3\"><input size=\"".min(60,$table['timetrack']['description'][size])."\" maxlength=\"". $table['timetrack']['description'][size] ."\" name=\"desc\" value=\"". $this->obj->desc ."\"></td>\n";
     echo "</tr>\n";

     # References to modules
     module_addforms($this->user,$this->obj,4);

     echo "<tr>\n";
     if ( $this->obj->id != -1 ) {
       submit_reset(0,1,1,1,1,0);
     } else {
       submit_reset(0,-1,1,1,1,0);
     }
     echo "</tr>\n";

     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("ttadd.desc");
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * naviagte
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$tutos,$lang;
     #
     # Mode
     # 0 = classical Timetrack
     # 1 = timerecord with a list of open entries
     # 2 = timerecord editable
     #
     if ( isset($_GET['mode']) ) {
       $this->mode = $_GET['mode'];
     } else {
       $this->mode = 0;
     }
     $this->obj = new timetrack($this->dbconn);
     if ( isset($_GET['id']) && ($_GET['id'] > 0) ) {
       # existing timetrack
       $this->obj->read($_GET['id']);
       if ( ($this->obj->t_start->notime == 0) && ( $this->mode != 2) ) {
         $this->mode = 1;
       }
       if ( ($this->obj->id < 0) ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
     } else {
       # new stuff
       if ( $this->mode == 1 ) {
         $this->obj->t_start = new DateTime();
       }
       $this->obj->ref = $this->user;
     }
     if ( ($this->obj->id < 0) && !$this->user->feature_ok(usetimetrack,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     if ( $this->mode != 0 ) {
       $this->name = $lang['TTRecord'];
     } else if ( $this->obj->id > 0 )  {
       $this->name = $lang['TimetrackModify'];
     } else {
       $this->name = $lang['TimetrackNew'];
     }

     if ( isset($_GET['reftype']) ) {
       $this->obj->reftype = StripSlashes($_GET['reftype']);
     } else {
       $this->obj->reftype = "";
     }
     if ( isset($_GET['desc']) ) {
       $this->obj->desc = StripSlashes($_GET['desc']);
     }
     if ( isset($_GET['volume']) ) {
       $this->obj->volume = $_GET['volume'];
     }
     if ( isset($_GET['state']) ) {
       $this->obj->state = $_GET['state'];
     }
     if ( isset($_GET['cph']) ) {
       $this->obj->cph = $_GET['cph'];
     }
     if ( isset($_GET['currency']) ) {
       $this->obj->currncy = $_GET['currency'];
     }
     if ( isset($_GET['wd']) ) {
       $this->obj->wday->setDateTime($_GET['wd']);
     }
     if ( isset($_GET['start']) ) {
       $this->obj->t_start->setDateTime($_GET['start']);
     }
     if ( isset($_GET['end']) ) {
       $this->obj->t_end->setDateTime($_GET['end']);
     }

     preset_from_array_or_input($this->obj,'worker',"w");
     preset_from_array_or_input($this->obj,'ref',"l");

     $this->obj->link_id = $this->obj->ref->id;
     if ( $this->obj->link_id == -1 ) {
       $msg .= "Unknown reference";
       $this->stop = true;
     }
     # menu
     $x = timetrack::getSelectLink($this->user,$lang['Search']);
     $x[category][] = "obj";
     $this->addmenu($x);

     $x = timetrack::getaddlink($this->user,$this->obj->ref);
     $this->addMenu($x);


     if ( ($this->obj->id > 0) && $this->obj->del_ok() && ($this->obj->ref >0 ) ) {
       $x = array( url => "timetrack_del.php?id=". $this->obj->id,
                   text => $lang['Delete'],
                   info => sprintf($lang['TimetrackDelI'],$this->obj->ref->getFullname()),
                   confirm => true,
                   category => array("timetrack","del","obj")
                 );
       $this->addMenu($x);
     }


     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new timetrack_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: timetrack_new.php,v 1.42.2.5 2003/10/08 15:03:07 gokohnert Exp $
    $Author: gokohnert $
-->