<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup department
 * @module department_ins
 * @package department
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use tutos */
 check_user();
 loadmodules("department","ins");

 $d = new department($dbconn);

 $gotourl = "department_new.php";
 $msg = "";

 if ( !isset($_POST['id']) ) {
   $msg .= "Please enter a id<br>";
 } else {
   $d->read($_POST['id']);
   if ( $d->id > 0 ) {
     $gotourl = addUrlParameter($gotourl,"id=". $_POST['id']);
   }
 }



 if ( !isset($_POST['name']) || ($_POST['name'] == $lang['PlsChangeName']) || empty($_POST['name']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['Department']) ."<br>";
 } else {
   $name = trim(StripSlashes($_POST['name']));
   $gotourl = addUrlParameter($gotourl,"name=". UrlEncode($name));
 }

 # Check Company
 if ( isset($_POST['cfn']) ) {
   if ( empty($_POST['cfn']) ) {
     $msg .= sprintf($lang['Err0009'],$lang['Company']) ."<br>";
   } else {
     $x = check_field(StripSlashes($_POST['cfn']),"cfn","cl","c");
     $d->setCompany($x->id);
   }
 }
 if ( isset($_POST['cid']) ) {
   $d->setCompany($_POST['cid']);
 }


 if ( $msg == "" ) {
   if ( ($d->id < 0) || ($name != $d->name) ) {
     $q = "SELECT * FROM ". $d->tablename ." WHERE ". $dbconn->Like2("name",$name) ." AND c_id = ". $d->company->id;
     $r = $dbconn->Exec($q);
     $n = $r->numrows();
     if ( 0 != $n) {
       $x = new department($dbconn);
       $x->read_result($r,0);
       $msg .= sprintf($lang['Err0045'],$x->getLink()) ."<br>";
     }
     $r->free();
   }
 }

 # other modules
 $msg .= module_parseforms($current_user,$d,$gotourl);

 if ( $msg == "" ) {
   $d->setName($name);
   $d->c_id = $d->company->id;

   $dbconn->Begin("WORK");
   $msg .= $d->save();
   $dbconn->Commit("WORK");

   $gotourl = $d->getURL();
 }

 $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));
 $gotourl = addSessionKey($gotourl);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: department_ins.php,v 1.24.2.2 2003/06/18 14:34:32 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
