// #ifndef __JPTR_H__
// #define __JPTR_H__



#include <iostream>
#include <stl.h>
#include <assert.h>
#include <string.h>

const int gDebugLevel = 0 ;

// level 0: no Debugging
// level 1: construction of test object
// level 2: list of memory after add or delete of pointer to object
// level 3: Public api of jptr
// level 4: all api of jptr


#define ldebug(oRoutine,level) {if (level <= gDebugLevel)  \
   {for(int i = 0; i < max(level,1); i++ )	\
      cout << "\t";				\
    cout<<"D"<<level<<": "; oRoutine; }}


// ===============================================================
// class template clJPTR
// purpose:  simulate symantics of Java Pointers.
// benefits:
// 1.  Don't need to worry about freeing the memory.
// 2.  Don't need to design ownership models.
// 3.  Generic.
// 4.  Easy to use, almost fool proof.
//
// ===============================================================
template <class tType>
   class clJPTR
   {
   private: // declarations
      // The following is declaration of a global multimap
      // for an instanciation of this template class.
      //
      class clMap :
	 public map<  tType*, int, less< tType* > >
	 {  };


      private: // variables
	 static clMap	_oMap;
	 tType*  	_pKey;


     public: // public member functions
      void operator=( tType* pMem );
      void operator=( const clJPTR& oOther );
      tType* operator->() const;
      tType* clone() const;
      tType* ptr() const;
      

   private: // private helper functions
      void add( tType* pMem );
      void remove();
      void print(int level);

/*
	 The reason this is private is so the you the programmer are not
	 tempted to write something like
	 clJPTR< xcl > oNew;

	 because this pointer will not have an object to after it's 
	 constructor and a little too dangerous.   
*/

   public:  // Constructors
         clJPTR();

      clJPTR(  tType* pMem );
      clJPTR(const clJPTR<tType>& oThat);

   public: // Virtual Methods!

      virtual ~clJPTR();

	/* override this method,
	 it is for the instance when new returns
	 NULL
	 */
      virtual void OutOfMemory();

};

#include "jptr.C"

// #endif // JPTR
