<?
  /*
   * Common functions for netsaint program
   * (C) 2001 Craig Small
   */

include "../phpgwnetsaint/inc/output.inc.php";

function my_difftime($from, $to)
{
  $mytime = $to - $from ;

  $days = floor($mytime / 86400);
  $mytime = $mytime - $days * 86400;
  $hours = floor($mytime / 3600);
  $mytime = $mytime - $hours * 3600;
  $minutes = floor($mytime / 60);
  $seconds = $mytime - $minutes * 60;

  return $days . 'd ' . $hours . 'h ' . $minutes . 'm ' . $seconds . 's';
}
function read_status()
{
  global $pgns_hoststatus;
  global $pgns_hostcount;
  global $pgns_progstatus;
  global $pgns_servstatus;
  global $pgns_servcount;

$STATUS_FILE='/var/log/netsaint/status.log';

  $pgns_hostcount = array ('UP' => 0, 'DOWN' => 0, 'PENDING' => 0, 'UNREACHABLE' => 0);
  $pgns_servcount = array ('OK' => 0, 'UNKNOWN' => 0, 'WARNING' => 0, 
      'CRITICAL' => 0, 'RECOVERY' => 0, 'UNREACHABLE' => 0,
      'HOST DOWN' => 0, 'PENDING' => 0);

  if ( ($fd = fopen($STATUS_FILE, 'r')) == NULL)
  {
    echo "Cannot open status file\n";
    return FALSE;
  }
  while($line = fgets($fd,1024))
  {
    if (preg_match('/^\[(\d+)\] PROGRAM;(\d+);(\d);([a-z]+);(\d+);(\d+);(\d+);(\d);(\d);(\d);(\d)/i', $line, $regs))
    {
      $pgns_progstatus['timestamp'] = $regs[1];
      $pgns_progstatus['start_time'] = $regs[2];
      $pgns_progstatus['daemon_mode'] = $regs[3];
      $pgns_progstatus['program_mode'] = $regs[4];
      $pgns_progstatus['last_mode_change'] = $regs[5];
      $pgns_progstatus['last_command_check'] = $regs[6];
      $pgns_progstatus['last_log_rotation'] = $regs[7];
    }
    if (preg_match('/^\[(\d+)\] HOST;([^;]+);([a-z]+);\d+;(\d+);(\d);(\d+);(\d+);(\d+);\d+;\d+;\d+;\d+;\d+;(.+)$/i', $line, $regs))
    {
      $pgns_hostcount["$regs[3]"]++;
      $host = $regs[2];
      $pgns_hoststatus[$host]['state'] = $regs[3];
      $pgns_hoststatus[$host]['last_state_change'] = $regs[4];
      $pgns_hoststatus[$host]['last_check'] = $regs[5];
      $pgns_hoststatus[$host]['prob_acked'] = $regs[6];
      $pgns_hoststatus[$host]['time_up'] = $regs[7];
      $pgns_hoststatus[$host]['time_down'] = $regs[8];
      $pgns_hoststatus[$host]['time_unreachable'] = $regs[9];
      $pgns_hoststatus[$host]['plugin_output'] = $regs[10];
    }
    if (preg_match('/^\[(\d+)\] SERVICE;([^;]+);([^;]+);([a-z]+);(\d+)\/(\d+);([a-z]+);(\d+);\d+;([a-z]+);(\d);(\d);\d;(\d+);(\d);([a-z]+);(\d+);(\d+);(\d+);(\d+);(\d+);(\d+);(\d);(\d);(\d+);(.+$)/i', $line, $regs)) {
      if ($regs[4] == 'RECOVERY') 
      { 
        $pgns_servcount['OK']++;
      } else {
        $pgns_servcount["$regs[4]"]++;
      }
      /*echo "state $regs[4] is now ", $pgns_servcount["$regs[4]"], "<BR>";*/
      $key = "$regs[2]:$regs[3]";
      $pgns_servstatus[$key] = array ('timestamp' => $regs[1],
                                      'host' => $regs[2],
                                      'service' => $regs[3],
                                      'state' => $regs[4],
				      'current_attempt' => $regs[5],
				      'max_attempts' => $regs[6],
				      'state_type' => $regs[7],
				      'next_check' => $regs[8],
				      'check_type' => $regs[9],
				      'checks_enabled' => $regs[10],
				      'passive_checks_accepted' => $regs[11],
				      'last_state_change' => $regs[12],
				      'prob_acked' => $regs[13],
				      'last_hard_state' => $regs[14],
				      'time_ok' => $regs[15],
				      'time_unknown' => $regs[16],
				      'time_warn' => $regs[17],
				      'time_crit' => $regs[18],
				      'last_notification' => $regs[19],
				      'notification_number' => $regs[20],
				      'notifications_enabled' => $regs[21],
				      'check_latency' => $regs[22],
				      'execution_time' => $regs[23],
				      'plugin_output' => $regs[24]);
    }

  }
  fclose($fd);
}
    

?>
