<?php
	/*******************************************************************\
	* phpGroupWare - Netsaint                                           *
	* http://www.phpgroupware.org                                       *
	*                                                                   *
	* Administration Tool for NetSaint Network Monitor                  *
	* http://www.netsaint.org                                           *
	* Ethan A. Galstad <netsaint@linuxbox.com>                          *
	*                                                                   *
	* Written by Bettina Gille [ceb@phpgroupware.org]                   *
	* -----------------------------------------------                   *
	* Copyright (C) 2001 Bettina Gille                                  *
	*                                                                   *
	* This program is free software; you can redistribute it and/or     *
	* modify it under the terms of the GNU General Public License as    *
	* published by the Free Software Foundation; either version 2 of    *
	* the License, or (at your option) any later version.               *
	*                                                                   *
	* This program is distributed in the hope that it will be useful,   *
	* but WITHOUT ANY WARRANTY; without even the implied warranty of    *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  *
	* General Public License for more details.                          *
	*                                                                   *
	* You should have received a copy of the GNU General Public License *
	* along with this program; if not, write to the Free Software       *
	* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.         *
	\*******************************************************************/
	/* $Id: class.sonscontact.inc.php,v 1.7 2001/09/06 22:56:15 bettina Exp $ */

	class sonscontact
	{
		var $grants;

		function sonscontact()
		{
			global $phpgw, $phpgw_info;

			$this->db		= $phpgw->db;
			$this->db2		= $this->db;
			$this->grants	= $phpgw->acl->get_grants('netsaint');
			$this->owner	= $phpgw_info['user']['account_id'];
		}

		function read_contacts($start, $limit = True, $query = '', $filter = '', $sort = '', $order = '', $cat_id = '')
		{
			global $phpgw, $phpgw_info;

			if (!$sort)
			{
				$sort = "ASC";
			}

			if ($order)
			{
				$ordermethod = "order by $order $sort";
			}
			else
			{
				$ordermethod = "order by c_name asc";
			}

			if (! $filter)
			{
				$filter = 'none';
			}

			if ($filter == 'none')
			{
				$filtermethod = " ( c_owner=" . $this->owner;
				if (is_array($this->grants))
				{
					$grants = $this->grants;
					while (list($user) = each($grants))
					{
						$public_user_list[] = $user;
					}
					reset($public_user_list);
					$filtermethod .= " OR (c_access='public' AND c_owner in(" . implode(',',$public_user_list) . ")))";
				}
				else
				{
					$filtermethod .= ' )';
				}
			}
			elseif ($filter == 'yours')
			{
				$filtermethod = " c_owner='" . $this->owner . "'";
			}
			else
			{
				$filtermethod = " c_owner='" . $this->owner . "' AND c_access='private'";
			}

			if ($cat_id)
			{
				$filtermethod .= " AND c_cat='$cat_id' ";
			}

			if ($query)
			{
				$searchmethod = " AND c_name like '%$query%' OR c_alias like '%$query%'  OR c_email like '%$query%' OR c_pager like '%$query%'";
			}

			$sql = "SELECT * FROM phpgw_ns_contact WHERE $filtermethod $searchmethod";

			$this->db2->query($sql,__LINE__,__FILE__);
			$this->total_records = $this->db2->num_rows();
			$this->db->limit_query($sql . $ordermethod,$start,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$c[$i]['id']		= $this->db->f('c_id');
				$c[$i]['name']		= $this->db->f('c_name');
				$c[$i]['access']	= $this->db->f('c_access');
				$c[$i]['owner']		= $this->db->f('c_owner');
				$c[$i]['date']		= $this->db->f('c_date');
				$c[$i]['cat']		= $this->db->f('c_cat');
				$c[$i]['email']		= $this->db->f('c_email');
				$c[$i]['pager']		= $this->db->f('c_pager');
				$i++;
			}
			return $c;
		}

		function read_config_contacts()
		{
			global $phpgw;

			$sql = "SELECT * FROM phpgw_ns_contact";

			$this->db->query($sql,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$c[$i]['name']			= $this->db->f('c_name');
				$c[$i]['alias']			= $this->db->f('c_alias');
				$c[$i]['csv_period']	= $this->db->f('csv_not_period');
				$c[$i]['h_period']		= $this->db->f('h_not_period');
				$c[$i]['s_rec']			= $this->db->f('not_service_rec');
				$c[$i]['s_crit']		= $this->db->f('not_service_crit');
				$c[$i]['s_warn']		= $this->db->f('not_service_warn');
				$c[$i]['h_rec']			= $this->db->f('not_host_rec');
				$c[$i]['h_down']		= $this->db->f('not_host_down');
				$c[$i]['h_unreach']		= $this->db->f('not_host_unreach');
				$c[$i]['s_command']		= $this->db->f('service_not_comand');
				$c[$i]['h_command']		= $this->db->f('host_not_comand');
				$c[$i]['email']			= $this->db->f('c_email');
				$c[$i]['pager']			= $this->db->f('c_pager');
				$i++;
			}
			return $c;
		}

		function read_single_contact($c_id)
		{
			$this->db->query("select * from phpgw_ns_contact where c_id='$c_id'",__LINE__,__FILE__);

			if ($this->db->next_record())
			{
				$c['id']			= $this->db->f('c_id');
				$c['name']			= $this->db->f('c_name');
				$c['access']		= $this->db->f('c_access');
				$c['owner']			= $this->db->f('c_owner');
				$c['date']			= $this->db->f('c_date');
				$c['cat']			= $this->db->f('c_cat');
				$c['alias']			= $this->db->f('c_alias');
				$c['csv_period']	= $this->db->f('csv_not_period');
				$c['h_period']		= $this->db->f('h_not_period');
				$c['s_rec']			= $this->db->f('not_service_rec');
				$c['s_crit']		= $this->db->f('not_service_crit');
				$c['s_warn']		= $this->db->f('not_service_warn');
				$c['h_rec']			= $this->db->f('not_host_rec');
				$c['h_down']		= $this->db->f('not_host_down');
				$c['h_unreach']		= $this->db->f('not_host_unreach');
				$c['s_comand']		= $this->db->f('service_not_comand');
				$c['h_comand']		= $this->db->f('host_not_comand');
				$c['email']			= $this->db->f('c_email');
				$c['pager']			= $this->db->f('c_pager');
				return $c;
			}
		}

		function add_contact($values)
		{
			$values['name'] = addslashes($values['name']);
			$values['alias'] = addslashes($values['alias']);
			$values['email'] = addslashes($values['email']);
			$values['pager'] = addslashes($values['pager']);

			$this->db->query("INSERT INTO phpgw_ns_contact (c_name,c_owner,c_access,c_cat,c_date,c_alias,csv_not_period,h_not_period,not_service_rec,not_service_crit,"
							. "not_service_warn,not_host_rec,not_host_down,not_host_unreach,service_not_comand,host_not_comand,c_email,c_pager) VALUES ('"
							. $values['name'] . "','" . $this->owner . "','" . $values['access'] . "','" . $values['cat'] . "','" . time() . "','"
							. $values['alias'] . "','" . $values['csv_period'] . "','" . $values['h_period'] . "','" . $values['s_rec'] . "','" . $values['s_crit']
							. "','" . $values['s_warn'] . "','" . $values['h_rec'] . "','" . $values['h_down'] . "','" . $values['h_unreach'] . "','"
							. $values['s_comand'] . "','" . $values['h_comand'] . "','" . $values['email'] . "','" . $values['pager'] . "')",__LINE__,__FILE__);
		}

		function edit_contact($values)
		{
			$values['name'] = addslashes($values['name']);
			$values['alias'] = addslashes($values['alias']);
			$values['email'] = addslashes($values['email']);
			$values['pager'] = addslashes($values['pager']);

			$this->db->query("UPDATE phpgw_ns_contact set c_name='" . $values['name'] . "', c_access='" . $values['access'] . "', c_cat='"
							. $values['cat'] . "', c_date='" . time() . "', c_alias='" . $values['alias'] . "', csv_not_period='" . $values['csv_period']
							. "', h_not_period='" . $values['h_period'] . "', not_service_rec='" . $values['s_rec'] . "', not_service_crit='" . $values['s_crit']
							. "', not_service_warn='" . $values['s_warn'] . "', not_host_rec='" . $values['h_rec'] . "', not_host_down='"
							. $values['h_down'] . "', not_host_unreach='" . $values['h_unreach'] . "', service_not_comand='" . $values['s_comand']
							. "', host_not_comand='" . $values['h_comand'] . "', c_email='" . $values['email'] . "', c_pager='" . $values['pager'] . "' "
							. "WHERE c_id='" . $values['id'] . "'",__LINE__,__FILE__);
		}

		function delete_contact($action, $c_id)
		{
			if ($action == 'contact')
			{
				$this->db->query("DELETE FROM phpgw_ns_contact WHERE c_id='$c_id'",__LINE__,__FILE__);
			}
			else
			{
				$this->db->query("DELETE FROM phpgw_ns_contactgroup WHERE cg_id='$c_id'",__LINE__,__FILE__);
			}
		}

		function in_array($needle,$haystack)
		{
			if (function_exists('in_array'))
			{
				return in_array($needle,$haystack);
			}
			while (list ($k,$v) = each($haystack))
			{
				if ($v == $needle)
				{
					return True;
				}
			}
			return False;
		}

		function select_contact_list($action, $selected = '')
		{
			global $phpgw;

			if (!is_array($selected))
			{
				$selected = explode(',',$selected);
			}

			if ($action == 'contact')
			{
				$c = $this->read_contacts($start, False, $query, $filter, $sort, $order, $cat_id);
			}
			else
			{
				$c = $this->read_cgs($start, False, $query, $filter, $sort, $order, $cat_id);
			}

			for ($i=0;$i<count($c);$i++)
			{
				$c_select .= '<option value="' . $c[$i]['name'] . '"';
				if ($this->in_array($c[$i]['name'],$selected))
				{
					$c_select .= ' selected';
				}
				$c_select .= '>' . $phpgw->strip_html($c[$i]['name']) . '</option>';
			}
			return $c_select;
		}

		function exists($action, $c_name, $c_id = '')
		{
			if ($action == 'contact')
			{
				if ($c_id && ($c_id != 0))
				{
					$editexists = " and c_id != '$c_id'";
				}

				$this->db->query("select count(*) from phpgw_ns_contact where c_name = '$c_name' $editexists",__LINE__,__FILE__);
			}
			else
			{
				if ($c_id && ($c_id != 0))
				{
					$editexists = " and cg_id != '$c_id'";
				}

				$this->db->query("select count(*) from phpgw_ns_contactgroup where cg_name = '$c_name' $editexists",__LINE__,__FILE__);
			}

			$this->db->next_record();

			if ($this->db->f(0))
			{
				return True;
			}
			else
			{
				return False;
			}
		}

		function read_cgs($start, $limit = True, $query = '', $filter = '', $sort = '', $order = '', $cat_id = '')
		{
			global $phpgw, $phpgw_info;

			if (!$sort)
			{
				$sort = "ASC";
			}

			if ($order)
			{
				$ordermethod = "order by $order $sort";
			}
			else
			{
				$ordermethod = "order by cg_name asc";
			}

			if (! $filter)
			{
				$filter = 'none';
			}

			if ($filter == 'none')
			{
				$filtermethod = " ( cg_owner=" . $this->owner;
				if (is_array($this->grants))
				{
					$grants = $this->grants;
					while (list($user) = each($grants))
					{
						$public_user_list[] = $user;
					}
					reset($public_user_list);
					$filtermethod .= " OR (cg_access='public' AND cg_owner in(" . implode(',',$public_user_list) . ")))";
				}
				else
				{
					$filtermethod .= ' )';
				}
			}
			elseif ($filter == 'yours')
			{
				$filtermethod = " cg_owner='" . $this->owner . "'";
			}
			else
			{
				$filtermethod = " cg_owner='" . $this->owner . "' AND cg_access='private'";
			}

			if ($cat_id)
			{
				$filtermethod .= " AND cg_cat='$cat_id' ";
			}

			if ($query)
			{
				$searchmethod = " AND cg_name like '%$query%' OR cg_alias like '%$query%' ";
			}

			$sql = "SELECT * FROM phpgw_ns_contactgroup WHERE $filtermethod $searchmethod";

			$this->db2->query($sql,__LINE__,__FILE__);
			$this->total_records = $this->db2->num_rows();
			$this->db->limit_query($sql . $ordermethod,$start,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$cg[$i]['id']		= $this->db->f('cg_id');
				$cg[$i]['name']		= $this->db->f('cg_name');
				$cg[$i]['access']	= $this->db->f('cg_access');
				$cg[$i]['owner']	= $this->db->f('cg_owner');
				$cg[$i]['date']		= $this->db->f('cg_date');
				$cg[$i]['cat']		= $this->db->f('cg_cat');
				$cg[$i]['alias']	= $this->db->f('cg_alias');
				$i++;
			}
			return $cg;
		}

		function read_config_cgs()
		{
			global $phpgw;

			$sql = "SELECT * FROM phpgw_ns_contactgroup";
			$this->db->query($sql,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$cg[$i]['name']		= $this->db->f('cg_name');
				$cg[$i]['alias']	= $this->db->f('cg_alias');
				$cg[$i]['contacts']	= $this->db->f('cg_contacts');
				$i++;
			}
			return $cg;
		}

		function read_single_cg($cg_id)
		{
			$this->db->query("select * from phpgw_ns_contactgroup where cg_id='$cg_id'",__LINE__,__FILE__);

			if ($this->db->next_record())
			{
				$cg['id']		= $this->db->f('cg_id');
				$cg['name']		= $this->db->f('cg_name');
				$cg['access']	= $this->db->f('cg_access');
				$cg['owner']	= $this->db->f('cg_owner');
				$cg['date']		= $this->db->f('cg_date');
				$cg['cat']		= $this->db->f('cg_cat');
				$cg['alias']	= $this->db->f('cg_alias');
				$cg['contacts']	= $this->db->f('cg_contacts');

				return $cg;
			}
		}

		function add_cg($values)
		{
			$values['name'] = addslashes($values['name']);
			$values['alias'] = addslashes($values['alias']);
			$values['contacts'] = addslashes($values['contacts']);

			$this->db->query("INSERT INTO phpgw_ns_contactgroup (cg_name,cg_owner,cg_access,cg_cat,cg_date,cg_alias,cg_contacts) VALUES ('"
							. $values['name'] . "','" . $this->owner . "','" . $values['access'] . "','" . $values['cat'] . "','" . time() . "','"
							. $values['alias'] . "','" . $values['contacts'] . "')",__LINE__,__FILE__);
		}

		function edit_cg($values)
		{
			$values['name'] = addslashes($values['name']);
			$values['alias'] = addslashes($values['alias']);
			$values['contacts'] = addslashes($values['contacts']);

			$this->db->query("UPDATE phpgw_ns_contactgroup set cg_name='" . $values['name'] . "', cg_access='" . $values['access'] . "', cg_cat='"
							. $values['cat'] . "', cg_date='" . time() . "', cg_alias='" . $values['alias'] . "', cg_contacts='" . $values['contacts']
							. "' WHERE cg_id='" . $values['id'] . "'",__LINE__,__FILE__);
		}
	}
?>
