<?php
/**
*
* common.php [Sorani Kurdish]
*
* @package language
* @version $Id: $
* @copyright (c) 2009 phpBB Group
* @author 2009-01-01 - Chawg.org Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> '',
	'DIRECTION'	=> 'rtl',
	'DATE_FORMAT'	=> '|d M Y|',
	'USER_LANG'	=> 'ku-ckb',
	'1_DAY'	=> '1 ڕۆژ',
	'1_MONTH'	=> '1 مانگ',
	'1_YEAR'	=> '1 ساڵ',
	'2_WEEKS'	=> '2 هەفتە',
	'3_MONTHS'	=> '3 مانگ',
	'6_MONTHS'	=> '6 مانگ',
	'7_DAYS'	=> '7 ڕۆژ',
	'ACCOUNT_ALREADY_ACTIVATED'	=> 'هەژمارەکەت پێشتر چالاک کرا.',
	'ACCOUNT_DEACTIVATED'	=> 'هەژمارەکەت دەستکارانە چالاک کرا و تەنها بەڕێوەبەر ئەتوانێت چالاکی بکاتەوە.',
	'ACCOUNT_NOT_ACTIVATED'	=> 'هەژامارەکەت تا ئێستا چالاک نەکراوە.',
	'ACP'	=> 'کۆنترۆڵ پانێڵی بەڕێوەبەرایەتی',
	'ACTIVE'	=> 'چالاک',
	'ACTIVE_ERROR'	=> 'هەژماری دیاریکراو هەنووکە ناچالاکە. گەر کێشەت هەیە لەگەڵ چالاککردنی، تکایە پەیوەندی بە بەڕێوەبەرێکی مەکۆوە بکە.',
	'ADMINISTRATOR'	=> 'بەڕێوەبەر',
	'ADMINISTRATORS'	=> 'بەڕێوەبەران',
	'AGE'	=> 'تەمەن',
	'AIM'	=> 'AIM',
	'ALLOWED'	=> 'ڕێ پێدراو',
	'ALL_FILES'	=> 'هەموو پەڕگەکان',
	'ALL_FORUMS'	=> 'هەموو مەکۆکان',
	'ALL_MESSAGES'	=> 'هەموو پەیامەکان',
	'ALL_POSTS'	=> 'هەموو پەیامەکان',
	'ALL_TIMES'	=> 'هەموو کاتەکان %1$s %2$s ـن',
	'ALL_TOPICS'	=> 'هەموو بابەتەکان',
	'AND'	=> 'و',
	'ARE_WATCHING_FORUM'	=> 'بەژداریت کردووە کە ئاگادار بکرێیتەوە لە بوونی پەیامی نوێ لەم مەکۆیە.',
	'ARE_WATCHING_TOPIC'	=> 'بەژداریت کردووە کە ئاگادار بکرێیتەوە لە بوونی پەیامی نوێ لەم بابەتە.',
	'ASCENDING'	=> 'سەر بەرەوژوور',
	'ATTACHMENTS'	=> 'هاوپێچەکان',
	'ATTACHED_IMAGE_NOT_IMAGE'	=> 'ئەو پەڕگەی وێنەیەی ویستت هاوپێچی بکەیت ناتەواوە.',
	'AUTHOR'	=> 'نووسەر',
	'AUTH_NO_PROFILE_CREATED'	=> 'دروستکردنی پڕۆفایلی بەکارهێنەر سەرکەوتوو نەبوو.',
	'AVATAR_DISALLOWED_CONTENT'	=> 'بارکردن ڕەفز کرایەوە لەبەر ئەوەی پەڕگەی بارکراو وەک پەڕگەیەکی هێرشکەر ناسرا.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'نەتوانرا پەڕگە پیشانبدرێت لەبەر ئەوەی درێژکراوی <strong>%s</strong> ڕێ پێ نەدراوە.',
	'AVATAR_EMPTY_REMOTE_DATA'	=> 'نەتوانرا وێنۆچکەی دیاریکراو بار بکرێت لەبەر ئەوەی وا دەردەکەوێت دراوەی دوور ناتەواو بێت یان تێکچووبێت.',
	'AVATAR_EMPTY_FILEUPLOAD'	=> 'پەڕگەی وێنۆچکەی بارکراو بەتاڵە.',
	'AVATAR_INVALID_FILENAME'	=> '%s ناوێکی نەگونجاوی پەڕگەیە.',
	'AVATAR_NOT_UPLOADED'	=> 'نەتوانرا وێنۆچکە بار بکرێت.',
	'AVATAR_NO_SIZE'	=> 'نەتوانرا پانیی یان بەرزیی وێنۆچکەی بەستەرکراو بپێورێت. تکایە دەستکارانە بیان نووسە.',
	'AVATAR_PARTIAL_UPLOAD'	=> 'پەڕگەی دیاریکراو بەش بەش بارکرا.',
	'AVATAR_PHP_SIZE_NA'	=> 'قەبارەی پەڕگەی وێنۆچکە زۆر گەورەیە.<br /> نەتوانرا گەورەترین قەبارەی ڕێپێدراو لە php.ini دیاریی بکرێت.',
	'AVATAR_PHP_SIZE_OVERRUN'	=> 'قەبارەی پەڕگەی وێنۆچکە زۆر گەورەیە.<br /> گەورەترین قەبارەی ڕێپێدراوی بارکردن %1$d %2$s ـە.<br />تکایە سەرنجی ئەوە بدە ئەمە لە php.ini ڕێکخراوە و ناتوانرێت بگۆڕدرێت.',
	'AVATAR_URL_INVALID'	=> 'ئەو URL ـەی دیاریت کردووە نەگونجاوە.',
	'AVATAR_URL_NOT_FOUND'	=> 'نەتوانرا پەڕگەی دیاریکراو بدۆزرێتەوە',
	'AVATAR_WRONG_FILESIZE'	=> 'پێویستە قەبارەی وێنۆچکە لە نێوان 0 تا %1d %2s ـدا بێت.',
	'AVATAR_WRONG_SIZE'	=> 'وێنۆچکەی نێردراو %5$d خاڵ پانە و %6$d خاڵ بەرزە. پێویستە وێنۆچکە لانی کەم %1$d خاڵ پان بێت و %2$d خاڵ بەرز بێت، بەڵام زیاتر نەبێت لە %3$d خاڵ پانی و %4$d خاڵ بەرزی.',
	'BACK_TO_TOP'	=> 'لوتکە',
	'BACK_TO_PREV'	=> 'بگەڕێوە بۆ پەڕەی پێشوو',
	'BAN_TRIGGERED_BY_EMAIL'	=> 'A ban has been issued on your e-mail address.',
	'BAN_TRIGGERED_BY_IP'	=> 'A ban has been issued on your IP address.',
	'BAN_TRIGGERED_BY_USER'	=> 'A ban has been issued on your username.',
	'BBCODE_GUIDE'	=> 'ڕێبەریی BBCode',
	'BCC'	=> 'BCC',
	'BIRTHDAYS'	=> 'ڕۆژی لە دایکبوونەکان',
	'BOARD_BAN_PERM'	=> 'تۆ بە شێوەیەکی <strong>هەمیشەیی</strong> ڕاگیراویت لەم مەکۆیە.<br /><br />بۆ زانیاریی زیاتر تکایە پەیوەندی بە %2$sBoard Administrator%3$s ـەوە بکە.',
	'BOARD_BAN_REASON'	=> 'هۆکاری ڕاگرتن: <strong>%s</strong>',
	'BOARD_BAN_TIME'	=> 'تۆ لەم مەکۆیە ڕاگیراویت هەتا <strong>%1$s</strong>.<br /><br />بۆ زانیاریی زیاتر تکایە پەیوەندی بە %2$sBoard Administrator%3$s ـەوە بکە.',
	'BOARD_DISABLE'	=> 'ببورە بەڵام ئەم مەکۆیە لە ئێستادا ئامادە نییە.',
	'BOARD_DISABLED'	=> 'ئەم مەکۆیە هەنووکە ناچالاککراوە.',
	'BOARD_UNAVAILABLE'	=> 'ببورە، مەکۆ بە شێوەیەکی کاتی نائامادەیە، تکایە چەند خولەکێکی تر هەوڵ بدەوە.',
	'BROWSING_FORUM'	=> 'ئەو بەکارهێنەرانەی لەم مەکۆیەدان: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'ئەو بەکارهێنەرانەی لە مەکۆیەدان: %1$s و %2$d میوان',
	'BROWSING_FORUM_GUESTS'	=> 'ئەو بەکارهێنەرانەی لە مەکۆیەدان: %1$s و %2$d میوان',
	'BYTES'	=> 'بایت',
	'CANCEL'	=> 'پاشگەزبوونەوە',
	'CHANGE'	=> 'بیگۆڕە',
	'CHANGE_FONT_SIZE'	=> 'قەبارەی فۆنت بگۆڕە',
	'CHANGING_PREFERENCES'	=> 'گۆڕینی ویستراوەکانی مەکۆ',
	'CHANGING_PROFILE'	=> 'گۆڕینی ڕێکخستنەکانی پڕۆفایل',
	'CLICK_VIEW_PRIVMSG'	=> '%sبڕۆ بۆ سندوقی هاتووەکان%s',
	'COLLAPSE_VIEW'	=> 'پێچانەوەی بینین',
	'CLOSE_WINDOW'	=> 'داخستنی پەنجەرە',
	'COLOUR_SWATCH'	=> 'Colour swatch',
	'COMMA_SEPARATOR'	=> '،',
	'CONFIRM'	=> 'دڵنیابوون',
	'CONFIRM_CODE'	=> 'کۆدی دڵنیابوون',
	'CONFIRM_CODE_EXPLAIN'	=> 'کۆدەکە وەک خۆی بنووسەوە. پیتەکان هەستیار نین بەرانبەر گەورە و بچوکیی، ژمارە 0 ـی تیادا نییە.',
	'CONFIRM_CODE_WRONG'	=> 'ئەو کۆدە دڵنیابوونەی لێتدا نادروستە.',
	'CONFIRM_OPERATION'	=> 'دڵنیایت لە بە ئەنجام گەیاندنی ئەم کردەیە؟',
	'CONGRATULATIONS'	=> 'پیرۆزبایی بۆ',
	'CONNECTION_FAILED'	=> 'پەیوەندیکردن شکستی هێنا',
	'CONNECTION_SUCCESS'	=> 'پەیوەندیکردن سەرکەوتوو بوو',
	'COOKIES_DELETED'	=> 'هەموو کووکییەکانی مەکۆ بە سەرکەوتوویی سڕدرانەوە.',
	'CURRENT_TIME'	=> 'هەنووکە کات %s ـە',
	'DAY'	=> 'ڕۆژ',
	'DAYS'	=> 'ڕۆژ',
	'DELETE'	=> 'سڕینەوە',
	'DELETE_ALL'	=> 'شڕینەوەی هەموو',
	'DELETE_COOKIES'	=> 'هەموو کووکییەکانی مەکۆ بسڕەوە',
	'DELETE_MARKED'	=> 'نیشانەکراوەکان بسڕەوە',
	'DELETE_POST'	=> 'پەیام بسڕەوە',
	'DELIMITER'	=> 'Delimiter',
	'DESCENDING'	=> 'سەر بەرەوخوار',
	'DISABLED'	=> 'ناچالاککراو',
	'DISPLAY'	=> 'پیشاندان',
	'DISPLAY_GUESTS'	=> 'میوانان پیشان بدە',
	'DISPLAY_MESSAGES'	=> 'پەیامەکان لە پێشووەوە پیشان بدە',
	'DISPLAY_POSTS'	=> 'پەیامەکان لە پێشووەوە پیشان بدە',
	'DISPLAY_TOPICS'	=> 'بابەتەکان لە پێشووەوە پیشان بدە',
	'DOWNLOADED'	=> 'داگیراو',
	'DOWNLOADING_FILE'	=> 'داگرتنی پەڕگە',
	'DOWNLOAD_COUNT'	=> '%d جار داگیراوە',
	'DOWNLOAD_COUNTS'	=> '%d جار داگیراوە',
	'DOWNLOAD_COUNT_NONE'	=> 'تا ئێستا دانەگیراوە',
	'VIEWED_COUNT'	=> '%d جار بینراوە',
	'VIEWED_COUNTS'	=> '%d جار بینراوە',
	'VIEWED_COUNT_NONE'	=> 'تا ئێستا نەبیبراوە', // Short form for EMAIL_ADDRESS
	'EDIT_POST'	=> 'دەستکاری پەیام بکە',
	'EMAIL'	=> 'ئیمەیل',
	'EMAIL_ADDRESS'	=> 'ناونیشانی ئیمەیل',
	'EMAIL_SMTP_ERROR_RESPONSE'	=> 'Ran into problems sending e-mail at <strong>Line %1$s</strong>. Response: %2$s.',
	'EMPTY_SUBJECT'	=> 'پێویستە سەردێڕێک دیاری بکەیت کاتێک بابەتێکی نوێ دەنێریت.',
	'EMPTY_MESSAGE_SUBJECT'	=> 'پێویستە سەردێڕێک دیاری بکەیت لە کاتی نووسینی پەیامێکی نوێدا.',
	'ENABLED'	=> 'چالاککراو',
	'ENCLOSURE'	=> 'Enclosure',
	'ERR_CHANGING_DIRECTORY'	=> 'نەتوانرا بوخچە بگۆڕدرێت.',
	'ERR_CONNECTING_SERVER'	=> 'هەڵە ڕوویدا لە پەیوەندیکردن بە ڕاژەکارەوە.',
	'ERR_JAB_AUTH'	=> 'نەتوانرا ڕێگە پێبدرێت لە ڕاژەکاری جابەر.',
	'ERR_JAB_CONNECT'	=> 'نەتوانرا پەیوەندی بکرێت بە ڕاژەکاری جابەرەوە.',
	'ERR_UNABLE_TO_LOGIN'	=> 'ناوی بەکارهێنەر یان تێپەڕەوشەی دیاریکراو نادروستە.',
	'ERR_UNWATCHING'	=> 'هەڵەیەک ڕوویدا لە کاتی هەوڵدان بۆ بەشداری نەکردن.',
	'ERR_WATCHING'	=> 'هەڵەیەک ڕوویدا لە کاتی هەوڵدان بۆ بەشداریکردن.',
	'ERR_WRONG_PATH_TO_PHPBB'	=> 'وا دەردەکەوێت ڕێڕەوی دیاریکراوی phpBB نەگونجاو بێت.',
	'EXPAND_VIEW'	=> 'فراوانکردنی بینین',
	'EXTENSION'	=> 'درێژکراوە',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'درێژکراوەی <strong>%s</strong> ناچالاککراوە و چیتر ناتوانرێت پیشان بدرێت.',
	'FAQ'	=> 'پ هـ د',
	'FAQ_EXPLAIN'	=> 'پرسیارە هەمیشە دووبارەکان',
	'FILENAME'	=> 'ناوی پەڕگە',
	'FILESIZE'	=> 'قەبارەی پەڕگە',
	'FILEDATE'	=> 'ڕێکەوتی پەڕگە',
	'FILE_COMMENT'	=> 'دەربارەی پەڕگە',
	'FILE_NOT_FOUND'	=> 'نەتوانرا پەڕگەی داواکراو بدۆزرێتەوە.',
	'FIND_USERNAME'	=> 'ئەندامێک بدۆزەرەوە',
	'FOLDER'	=> 'بوخچە',
	'FORGOT_PASS'	=> 'تێپەڕەوشەم لەبیر چووە',
	'FORM_INVALID'	=> 'فۆڕمی نێردراو نەگونجاو بوو. جارێکی تر هەوڵی ناردنەوەی بدە',
	'FORUM'	=> 'مەکۆ',
	'FORUMS'	=> 'مەکۆکان',
	'FORUMS_MARKED'	=> 'هەموو مەکۆکان وەک خوێندراوە نیشانەکران.',
	'FORUM_CAT'	=> 'هاوپۆلی مەکۆ',
	'FORUM_INDEX'	=> 'دەستپێکی مەکۆ',
	'FORUM_LINK'	=> 'بەستەری مەکۆ',
	'FORUM_LOCATION'	=> 'شوێنی مەکۆ',
	'FORUM_LOCKED'	=> 'مەکۆ داخراوە',
	'FORUM_RULES'	=> 'یاساکانی مەکۆ',
	'FORUM_RULES_LINK'	=> 'تکایە کرتە لێرە بکە بۆ بینینی یاساکانی مەکۆ',
	'FROM'	=> 'لەلایەن',
	'FSOCK_DISABLED'	=> 'نەتوانرا ئەو کردەیە بە ئەنجام بگەیەنرێت لەبەر ئەوەی فرمانی <var>fsockopen</var> ناچالاککراوە یان نەتوانراوە پرسی ڕاژەکار بدۆزرێتەوە.',
	'FTP_FSOCK_HOST'	=> 'خانەخوێی FTP',
	'FTP_FSOCK_HOST_EXPLAIN'	=> 'ڕاژەکاری FTP بەکاربرا بۆ پەیوەندیکردن بە وێبگەکەتەوە.',
	'FTP_FSOCK_PASSWORD'	=> 'تێپەڕەوشەی FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'تێپەڕەوشە بۆ بەکارهێنەری FTP ـیەکەت.',
	'FTP_FSOCK_PORT'	=> 'دەرچەی FTP',
	'FTP_FSOCK_PORT_EXPLAIN'	=> 'دەرچە بەکاربرا بۆ پەیوەندیکردن بە ڕاژەکارەکەتەوە.',
	'FTP_FSOCK_ROOT_PATH'	=> 'ڕێڕەوی phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'ڕێڕەو لە ڕەگەوە بۆ مەکۆی phpBB ـیەکەت.',
	'FTP_FSOCK_TIMEOUT'	=> 'کاتی FTP تەواوبوو',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'	=> 'ماوەی ئەو کاتە، بە چرکە، کە سیستەم چاوەڕێ دەکات بۆ وەڵامدانەوە لە ڕاژەکارەوە.',
	'FTP_FSOCK_USERNAME'	=> 'ناوی بەکارهێنەری FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'ناوی بەکارهێنەر بەکاربرا بۆ پەیوەندیکردن بە ڕاژەکارەکەتەوە.',
	'FTP_HOST'	=> 'خانەخوێی FTP',
	'FTP_HOST_EXPLAIN'	=> 'ڕاژەکاری FTP بەکاربرا بۆ پەیوەندیکردن بە ڕاژەکارەکەتەوە.',
	'FTP_PASSWORD'	=> 'تێپەڕەوشەی FTP',
	'FTP_PASSWORD_EXPLAIN'	=> 'تێپەڕەوشە بۆ ناوی بەکاهێنەری FTP ـیەکەت.',
	'FTP_PORT'	=> 'دەرچەی FTP',
	'FTP_PORT_EXPLAIN'	=> 'دەرچەی بەکاربراوە بۆ پەیوەندیکردن بە ڕاژەکارەوە.',
	'FTP_ROOT_PATH'	=> 'ڕێڕەوی phpBB',
	'FTP_ROOT_PATH_EXPLAIN'	=> 'ڕێڕەو لە ڕەگەوە بۆ مەکۆی phpBB ـەکەت.',
	'FTP_TIMEOUT'	=> 'FTP کاتی تەواو بوو',
	'FTP_TIMEOUT_EXPLAIN'	=> 'ماوەی ئەو کاتە، بە چرکە، کە سیستەم چاوەڕێ دەکات بۆ وەڵامدانەوە لە ڕاژەکارەوە.',
	'FTP_USERNAME'	=> 'ناوی بەکارهێنەری FTP',
	'FTP_USERNAME_EXPLAIN'	=> 'ناوی بەکارهێنەر بەکاربرا بۆ پەیوەندیکردن بە ڕاژەکارەکەتەوە.',
	'GENERAL_ERROR'	=> 'هەڵەیەکی گشتی',
    'GB'                  => 'GB',
    'GIB'                  => 'GiB',
	'GO'	=> 'بڕۆ',
	'GOTO_PAGE'	=> 'بڕۆ بۆ پەڕەی',
	'GROUP'	=> 'گرووپ',
	'GROUPS'	=> 'گرووپەکان',
	'GROUP_ERR_TYPE'	=> 'جۆرێکی نەگونجاوی گرووپ دیاریکرا.',
	'GROUP_ERR_USERNAME'	=> 'ناوی هیچ گرووپێک دیاریی نەکراوە.',
	'GROUP_ERR_USER_LONG'	=> 'نابێت ناوی گرووپەکان لە 60 نووسە زیاتر بێت. ناوی گرووپی دیاریکراو زۆر درێژە.',
	'GUEST'	=> 'میوان',
	'GUEST_USERS_ONLINE'	=> '%d بەکارهێنەری میوان لەسەر هێڵن',
	'GUEST_USERS_TOTAL'	=> '%d میوان',
	'GUEST_USERS_ZERO_ONLINE'	=> '0 بەکارهێنەری میوان لەسەر هێڵن',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 میوان',
	'GUEST_USER_ONLINE'	=> '% بەکارهێنەری میوان لەسەر هێڵنd',
	'GUEST_USER_TOTAL'	=> '%d میوان',
	'G_ADMINISTRATORS'	=> 'بەڕێوەبەران',
	'G_BOTS'	=> 'بۆتەکان',
	'G_GUESTS'	=> 'میوانان',
	'G_REGISTERED'	=> 'بەکارهێنەرە خۆ تۆمارکردووەکان',
	'G_REGISTERED_COPPA'	=> 'بەکارهێنەرە خۆ تۆمارکردووەکانی COPPA',
	'G_GLOBAL_MODERATORS'	=> 'چاودێرە گشتییەکان',
	'G_NEWLY_REGISTERED'		=> 'بەکارهێنەرە خۆتۆمارکردووە نوێیەکان',
	'HIDDEN_USERS_ONLINE'	=> '%d بەکارهێنەری شارەوە لەسەر هێڵن',
	'HIDDEN_USERS_TOTAL'	=> '%d شاراوە',
	'HIDDEN_USERS_TOTAL_AND'	=> '%d شارەوە و ',
	'HIDDEN_USERS_ZERO_ONLINE'	=> '0 بەکارهێنەری شاراوە لەسەر هێڵە',
	'HIDDEN_USERS_ZERO_TOTAL'	=> '0 شاراوە',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 شاراوە و ',
	'HIDDEN_USER_ONLINE'	=> '%d بەکارهێنەری شاراوە لەسەر هێڵن',
	'HIDDEN_USER_TOTAL'	=> '%d شاراوە',
	'HIDDEN_USER_TOTAL_AND'	=> '%d شاراوە و ',
	'HIDE_GUESTS'	=> 'میوانان بشارەوە',
	'HIDE_ME'	=> 'دۆخی سەرهێڵیم بشارەوە ئەم دانیشتنە.',
	'HOURS'	=> 'کاژێر',
	'HOME'	=> 'ماڵەوە',
	'ICQ'	=> 'ICQ',
	'ICQ_STATUS'	=> 'دۆخی ICQ',
	'IF'	=> 'ئەگەر',
	'IMAGE'	=> 'وێنە',
	'IMAGE_FILETYPE_INVALID'	=> 'Image file type %d for mimetype %s not supported.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Image file type mismatch: expected extension %1$s but extension %2$s given.',
	'IN'	=> 'لە',
	'INDEX'	=> 'دەستپێک',
	'INFORMATION'	=> 'زانیاریی',
	'INTERESTS'	=> 'ئارەزووەکان',
	'INVALID_DIGEST_CHALLENGE'	=> 'Invalid digest challenge.',
	'INVALID_EMAIL_LOG'	=> '<strong>%s</strong> ئەشێت ناونیشانی ئیمەیلێکی نادروست بێت؟',
	'IP'	=> 'IP',
	'IP_BLACKLISTED'	=> 'IP ـیەکەت %1$s قەدەغەکراوە لەبەر ئەوەی کراوەتە لیستی ڕەشەوە. بۆ وردەکاریی زیاتر تکایە <a href="%2$s">%2$s</a> ببینە.',
	'JABBER'	=> 'جابەر',
	'JOINED'	=> 'بەشدارە لە',
	'JUMP_PAGE'	=> 'ژمارەی ئەو پەڕەیە لێ بدە کە ئەتەوێت بڕۆی بۆی.',
	'JUMP_TO'	=> 'بازدان بۆ',
	'JUMP_TO_PAGE'	=> 'کرتە بکە بۆ بازدان بۆ پەڕە...',
	'KB'	=> 'ک ب',
	'KIB'	=> 'ک ب',
	'LAST_POST'	=> 'دوا پەیام',
	'LAST_UPDATED'	=> 'دوا نوێکردنەوە',
	'LAST_VISIT'	=> 'دوا سەردان',
	'LDAP_NO_LDAP_EXTENSION'	=> 'درێژکراوەی LDAP نییە.',
	'LDAP_NO_SERVER_CONNECTION'	=> 'نەتوانرا پەیوەندی بکرێت بە ڕاژەکاری LDAP ـیەوە.',
	'LEGEND'	=> 'پلەداران',
	'LOCATION'	=> 'شوێن',
	'LOCK_POST'	=> 'داخستنی پەیام',
	'LOCK_POST_EXPLAIN'	=> 'قەدەغەکردنی دەستکاریکردن',
	'LOCK_TOPIC'	=> 'داخستنی بابەت',
	'LOGIN'	=> 'چوونەژوورەوە',
	'LOGIN_CHECK_PM'	=> 'بجۆ ژوورەوە بۆ بینینی پەیامە تایبەتییەکانت.',
	'LOGIN_CONFIRMATION'	=> 'دڵنیابوون لە چوونەژوورەوە',
	'LOGIN_CONFIRM_EXPLAIN'	=> 'مەکۆ پێویستی بەوەیە کە کۆدێکی دڵنیایی لێ بدەیت لە پاش چەند شکستێک لە چوونەژوورەوە. ئەتوانیت کۆدەکە لە خوارەوە ببینیتکە بە وێنە نیشان دراوە. گەر لە ڕووی بینینەوە لاوازیت و ناتوانیت ببینیت تکایە پەیوەندی بە %sبەڕێوەبەری مەکۆ%sوە بکە.',
	'LOGIN_ERROR_ATTEMPTS'	=> 'زۆرترین ژمارەی هەوڵدانت بۆ چوونەژوورەوە تێپەڕاند. سەرەڕای ناوی بەکارهێنەر و تێپەڕەوشەت ئێستا پێویستە کۆدی دڵنیابوون لێبدەیت لەو وێنەیەی کە لە خوارەوە ئەیبینیت.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'نەسەلمێندراویت لەلایەن Apache ـیەوە.',
	'LOGIN_ERROR_PASSWORD'	=> 'تێپەڕەوشەیەکی نادروستت نووسی. تکایە لە تێپەڕەوشەکە دڵنیابە و هەوڵ بدەوە. گەر هەر بەردەوامبوویت لە هەبوونی کێشە تکایە پەیوەندی بکە بە %sبەڕێوەبەری مەکۆ%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'	=> 'لە توانادا نەبوو کە تێپەڕەوشەکەت بگۆڕدرێت لە کاتی نوێکردنەوەی وەشانی مەکۆدا. تکایە %sداوای تێپەڕەوشەیەکی نوێ بکە%s. گەر هەر بەردەوامبوویت لە هەبوونی کێشە تکایە پەیوەندی بکە بە %sبەڕێوەبەری مەکۆ%s.',
	'LOGIN_ERROR_USERNAME'	=> 'ناوی بەکارهێنەرێکی نادروستت نووسی. تکایە لە ناوی بەکارهێنەرییت دڵنیابە و هەوڵ بدەوە. گەر هەر بەردەوامبوویت لە هەبوونی کێشە تکایە پەیوەندی بکە بە %sبەڕێوەبەری مەکۆ%s.',
	'LOGIN_FORUM'	=> 'بۆ بینین و ناردنی پەیام لەم مەکۆیەدا پێوسیتە تێپەڕەوشەی مەکۆ بنووسیت',
	'LOGIN_INFO'	=> 'بۆ ئەوەی بچیتە ژوورەوە پێویستە خۆت تۆمار کردبێت. خۆتۆمارکردن چەند ساتێکی کەمی دەوێت بەڵام توانای زیاترت ئەداتێ. دەشێت بەڕێوەبەری مەکۆ دەسەڵاتی زیادە بەخشێت بە بەکارهێنەرە خۆ تۆمارکردووەکان. پێش ئەوەی خۆت تۆمار بکەیت تکایە دڵنیابە لەوەی ڕەزامەنیت لەسەر مەرجەکانی بەکارهێنان. تکایە دڵنیابە لەوەی کە یاسای هەر مەکۆیەک دەخوێنیتەوە کاتێک سەردانیان دەکەیت.',
	'LOGIN_VIEWFORUM'	=> 'مەکۆ پێویستی بەوەیە کە خۆت تۆمار کردبێت و لە ژوورەوە بیت تۆ بتوانی بیبینیت.',
	'LOGIN_EXPLAIN_EDIT'	=> 'بۆ ئەوەی دەستکاری پەیامەکانی ئەم مەکۆیە بکەیت  پێویستە خۆت تۆمار کردبێت و لە ژوورەوە بیت.',
	'LOGIN_EXPLAIN_VIEWONLINE'	=> 'بۆ ئەوەی لیستی ئەوانە ببینیت کە لەسەر هێڵن پێویستە خۆت تۆمار کردبێت و لە ژوورەوە بیت.',
	'LOGOUT'	=> 'دەرچوون',
	'LOGOUT_USER'	=> 'دەرچوون [ %s ]',
	'LOG_ME_IN'	=> 'خۆکارانە بمهێنە ژوورەوە بۆ هەر سەردانێک',
	'MARK'	=> 'نیشانەکردن',
	'MARK_ALL'	=> 'نیشانەکردنی هەموو',
	'MARK_FORUMS_READ'	=> 'مەکۆکان وەک خوێندراوە لێبکە',
	'MB'	=> 'م ب',
	'MIB'	=> 'م ب',
	'MCP'	=> 'کۆنتڕۆڵ پانێڵی چاودێر',
	'MEMBERLIST'	=> 'ئەندامان',
	'MEMBERLIST_EXPLAIN'	=> 'لیستی تەواوەتی ئەندامان ببینە',
	'MERGE'	=> 'لکاندن',
	'MERGE_POSTS'	=> 'لکاندنی پەیامەکان',
	'MERGE_TOPIC'	=> 'لکاندنی بابەت',
	'MESSAGE'	=> 'پەیام',
	'MESSAGES'	=> 'پەیامەکان',
	'MESSAGE_BODY'	=> 'ناوەڕۆکی پەیام',
	'MINUTES'	=> 'خولەک',
	'MODERATE'	=> 'چاودێریی',
	'MODERATOR'	=> 'چاودێر',
	'MODERATORS'	=> 'چاودێران',
	'MONTH'	=> 'مانگ',
	'MOVE'	=> 'گواستنەوە',
	'MSNM'	=> 'MSNM/WLM',
	'NA'	=> 'N/A',
	'NEWEST_USER'	=> 'نوێترین ئەنداممان <strong>%s</strong>',
	'NEW_MESSAGE'	=> 'پەیامی نوێ',
	'NEW_MESSAGES'	=> 'پەیامی نوێ',
	'NEW_PM'	=> '<strong>%d</strong> پەیامی نوێ هەیە',
	'NEW_PMS'	=> '<strong>%d</strong> پەیامی نوێ هەیە',
	'NEW_POST'	=> 'پەیامی نوێ',
	'NEW_POSTS'	=> 'پەیامە نوێیەکان',
	'NEXT'	=> 'داهاتوو',
	'NEXT_STEP'	=> 'داهاتوو',
	'NEVER'	=> 'هەرگیز',
	'NO'	=> 'نەخێر',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'ڕێت پێ نەدراوە بە بەڕێوەبردنی ئەم مەکۆیە.',
	'NOT_AUTHORISED'	=> 'ڕێت پێ نەدراوە بە بینینی ئەم ناوچەیە.',
	'NOT_WATCHING_FORUM'	=> 'چیتر بەژدار نیت لە نوێکارییەکانی ئەم مەکۆیە.',
	'NOT_WATCHING_TOPIC'	=> 'چیتر بەژدار نیت لە نوێکارییەکانی ئەم بابەتە.',
	'NOTIFY_ADMIN'	=> 'تکایە بەڕێوەبەری مەکۆ یان وێب ماستەر ئاگادار بکەوە.',
	'NOTIFY_ADMIN_EMAIL'	=> 'تکایە بەڕێوەبەری مەکۆ یان وێب ماستەر ئاگادار بکەوە: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'	=> 'ڕێت پێ نەدراوە بە بینینی ئەم پەڕگەیە.',
	'NO_ACTION'	=> 'هیچ چالاکییەک دیاریی نەکراوە.',
	'NO_ADMINISTRATORS'	=> 'هیچ بەڕێوەبەرێک بوونی نییە.',
	'NO_AUTH_ADMIN'	=> 'چوونە ناو کۆنترۆڵ پانێڵ ڕێ پێ نەدراوە لەبەر ئەوەی دەسەڵاتەکانی بەڕێوەبەریت نییە.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'ناتوانیت خۆت بسەلمێنیتەوە وەک بەکارهێنەرێکی جیاواز.',
	'NO_AUTH_OPERATION'	=> 'دەسەڵاتی پێویستت نییە بۆ بە ئەنجام گەیاندنی ئەم کردەیە.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'نەتوانرا پەیوەندی بکات بە خانەخوێی smtp ـیەوە : %1$s : %2$s',
	'NO_BIRTHDAYS'	=> 'هیچ ڕۆژێکی لە دایبوون نییە ئەمڕۆ.',
	'NO_EMAIL_MESSAGE'	=> 'پەیامی ئیمەیل بەتاڵ بوو.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'نەتوانرا کۆدەکانی وەڵامی ڕاژەکاری مەیل بەدەست بهێنێت.',
	'NO_EMAIL_SUBJECT'	=> 'سەردێڕی ئیمەیل نەنووسراوە.',
	'NO_FORUM'	=> 'ئەو مەکۆیەی دیاریت کردووە بوونی نییە.',
	'NO_FORUMS'	=> 'سەکۆ هیچ مەکۆیەکی تیادا نییە.',
	'NO_GROUP'	=> 'گرووپی بەکارهێنەری داواکراو بوونی نییە.',
	'NO_GROUP_MEMBERS'	=> 'هەنووکە ئەم گرووپە هیچ ئەندامێکی تیادا نییە.',
	'NO_IPS_DEFINED'	=> 'هیچ ناونیشانێکی IP یان ناوی خانەخوێیەک دیاریی نەکراوە',
	'NO_MEMBERS'	=> 'هیچ ئەندامێک نەدۆزرایەوە بۆ ئەم گەڕانە',
	'NO_MESSAGES'	=> 'پەیام نییە',
	'NO_MODE'	=> 'هیچ جۆرێک دیاریی نەکراوە',
	'NO_MODERATORS'	=> 'هیچ چاودێرێک نییە',
	'NO_NEW_MESSAGES'	=> 'پەیامی نوێ نییە',
	'NO_NEW_PM'	=> '<strong>0</strong> پەیامی نوێ هەیە',
	'NO_NEW_POSTS'	=> 'پەیامی نوێ نییە',
	'NO_ONLINE_USERS'	=> 'هیچ بەکارهێنەرێکی خۆ تۆمارکردوو نییە.',
	'NO_POSTS'	=> 'پەیام نییە',
	'NO_POSTS_TIME_FRAME'	=> 'هیچ پەیامێک بوونی نییە لەم بابەتە لە چوارچێوەی کاتی دیاریکراودا.',
	'NO_FEED_ENABLED'			=> 'Feed ـەکان چالاک نین لەم مەکۆیە.',
	'NO_FEED'				=> 'feed ـی چالاککراو ئامادە نییە.',
	'NO_SUBJECT'	=> 'هیچ سەردێڕێک نەنووسراوە',
	'NO_SUCH_SEARCH_MODULE'	=> 'گەڕانی دیاریکراو بوونی نییە.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'هیچ ڕێگایەک بۆ سەلماندن پاڵپشتی نەکراوە.',
	'NO_TOPIC'	=> 'بابەتی داواکراو بوونی نییە.',
	'NO_TOPIC_FORUM'	=> 'بابەت یان مەکۆ چیتر بوونی نییە.',
	'NO_TOPICS'	=> 'هیچ بابەت یان پەیامێک لەم مەکۆیەدا نییە.',
	'NO_TOPICS_TIME_FRAME'	=> 'هیچ بابەتێک بوونی نییە لەم مەکۆیە لە نێوان ماوەی دیاریکراود.',
	'NO_UNREAD_PM'	=> '<strong>0</strong> پەیامی نەخوێندراوە',
	'NO_UPLOAD_FORM_FOUND'	=> 'بارکردن تەواوە بەڵام هیچ فۆڕمێکی بارکردنی گونجاو نەدۆزرایەوە.',
	'NO_USER'	=> 'بەکارهێنەری داواکراو بوونی نییە.',
	'NO_USERS'	=> 'بەکارهێنەرانی داواکراو بوونیان نییە.',
	'NO_USER_SPECIFIED'	=> 'هیچ ناوی بەکارهێنەرێک دیاریی نەکراوە.',

	'NUM_POSTS_IN_QUEUE'	=> array(
		'0'	=> 'هیچ پەیامێک لە چاوەڕوانییدا نییە.',
		'1'	=> '1 پەیام لە چاوەڕوانییدایە',
		'2'	=> '%d پەیام لە چاوەڕوانییدایە.',
	),

	'OCCUPATION'	=> 'پیشە',
	'OFFLINE'	=> 'دەرهێڵ',
	'ONLINE'	=> 'سەرهێڵ',
	'ONLINE_BUDDIES'	=> 'هاوڕێ سەرهێڵەکان',
	'ONLINE_USERS_TOTAL'	=> ':: کۆی گشتی <strong>%d</strong> بەکارهێنەر لەسەر هێڵن ',
	'ONLINE_USERS_ZERO_TOTAL'	=> ':: کۆی گشتی <strong>0</strong> بەکارهێنەر لەسەر هێڵن ',
	'ONLINE_USER_TOTAL'	=> ':: کۆی گشتی <strong>%d</strong> بەکارهێنەر لەسەر هێڵن ',
	'OPTIONS'	=> 'هەڵبژاردنەکان',
	'PAGE_OF'	=> 'پەڕەی <strong>%1$d</strong> لە <strong>%2$d</strong>',
	'PASSWORD'	=> 'تێپەڕەوشە',
	'PLAY_QUICKTIME_FILE'	=> 'پەڕگەی Quicktime لێبدە',
	'PM'	=> 'PM',
	'POSTING_MESSAGE'	=> 'ناردنی پەیام لە %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'پێکهێنانی پەیامی تایبەت',
	'POST'	=> 'پەیام',
	'POST_ANNOUNCEMENT'	=> 'ئاگاداری',
	'POST_STICKY'	=> 'جێگیر',
	'POSTED'	=> 'نێردراوە',
	'POSTED_IN_FORUM'	=> 'لە',
	'POSTED_ON_DATE'	=> 'لە ڕێکەوتی',
	'POSTS'	=> 'پەیامەکان',
	'POSTS_UNAPPROVED'	=> 'لانی کەم پەیامێک لەم بابەتەدا پەسەند نەکراوە.',
	'POST_BY_AUTHOR'	=> 'لە لایەن',
	'POST_BY_FOE'	=> 'ئەم پەیامە لەلایەن <strong>%1$s</strong> ـەوە نووسراوە کە هەنووکە لە لیستەی فەرامۆشکراوەکانتدایە. %2$ئەم پەیامە پیشان بدە%3$s',
	'POST_DAY'	=> '%.2f پەیام لە ڕۆژێکدا',
	'POST_DETAILS'	=> 'وردەکارییەکانی پەیام',
	'POST_NEW_TOPIC'	=> 'بابەتی نوێ بنێرە',
	'POST_PCT'	=> '%.2f%% لە هەموو پەیامەکاندا',
	'POST_PCT_ACTIVE'	=> '%.2f%% لە پەیامەکانی بەکارهێنەردا',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% لە پەیامەکانی خۆتدا',
	'POST_REPLY'	=> 'وەڵامێک بنێرە',
	'POST_REPORTED'	=> 'کرتە بکە بۆ بینینی ڕاپۆرت',
	'POST_SUBJECT'	=> 'سەردێڕ بنێرە',
	'POST_TIME'	=> 'کاتی ناردن',
	'POST_TOPIC'	=> 'بابەتێکی نوێ بنێرە',
	'POST_UNAPPROVED'	=> 'ئەم پەیامە چاوەڕێی پەسەندکردنە.',
	'PREVIEW'	=> 'پێشبینین',
	'PREVIOUS'	=> 'پێشوو',
	'PREVIOUS_STEP'	=> 'پێشوو',
	'PRIVACY'	=> 'تایبەتییەتی',
	'PRIVATE_MESSAGE'	=> 'پەیامی تایبەت',
	'PRIVATE_MESSAGES'	=> 'پەیامە تایبەتەکان',
	'PRIVATE_MESSAGING'	=> 'پەیام ناردنی تایبەت',
	'PROFILE'	=> 'کۆنترۆڵ پانێڵی بەکارهێنەر',
	'READING_FORUM'	=> 'بینینی بابەتەکانی %s',
	'RSS_EXPLAIN'	=> 'کرتە لێرە بکە بۆ زیادکردنی RSS',
	'RSS_READ_TOPIC'	=> 'بابەتە سەرەکییەکان بخوێنەوە',
	'RSS_COPYRIGHT'	=> 'مافی لەبەرگرتنەوەی پارێزراوە بۆ',
	'RSS_FAILURE'	=> 'شکستی هێنا لە بەدەستهێنانی دوا بابەتەکان',
	'READING_GLOBAL_ANNOUNCE'	=> 'خوێندنەوەی ئاگاداری گشتی',
	'READING_LINK'	=> 'دواکەوتنی بەستەری مەکۆ %s',
	'READING_TOPIC'	=> 'خوێندنەوەی بابەتی %s',
	'READ_PROFILE'	=> 'پڕۆفایل',
	'REASON'	=> 'هۆکار',
	'RECORD_ONLINE_USERS'	=> 'زۆرترین بەکارهێنەر کە لەسەر هێڵ بوون لە یەک کاتدا بریتیبوو لە <strong>%1$s</strong> لە %2$s',
	'REDIRECT'	=> 'ئاڕاستەکردن',
	'REDIRECTS'	=> 'سەرجەم ئاڕاستەکردنەکان',
	'REGISTER'	=> 'خۆتۆمارکردن',
	'REGISTERED_USERS'	=> 'بەکارهێنەرە خۆتۆمارکردووەکانی سەرهێڵ',
	'REG_USERS_ONLINE'	=> '%d بەکارهێنەری خۆتۆمارکردوو و',
	'REG_USERS_TOTAL'	=> '%d خۆتۆمارکردوو، ',
	'REG_USERS_TOTAL_AND'	=> '%d خۆتۆمارکردوو و ',
	'REG_USERS_ZERO_ONLINE'	=> '0 بەکارهێنەری خۆتۆمارکردوو و',
	'REG_USERS_ZERO_TOTAL'	=> '0 خۆتۆمارکردوو، ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 خۆتۆمارکردوو و ',
	'REG_USER_ONLINE'	=> '%d بەکارهێنەری خۆتۆمارکردوو و ',
	'REG_USER_TOTAL'	=> '%d خۆتۆمارکردوو، ',
	'REG_USER_TOTAL_AND'	=> '%d خۆتۆمارکردوو و ',
	'REMOVE'	=> 'لابردن',
	'REMOVE_INSTALL'	=> 'تکایە پێش بەکارهێنانی مەکۆ بوخچەی install بسڕەوە، بگوازەوە یان ناوی بگۆڕە. گەر بوخچەکە هەر هەیە، تەنها دەتوانیت کۆنترۆڵ پانێڵی بەڕێوەبەر ببینیت.',
	'REPLIES'	=> 'وەڵامەکان',
	'REPLY_WITH_QUOTE'	=> 'وەڵامدانەوە بە ئاماژەوە',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'وەڵئمدانەوەی ئاگادارییە گشتییەکان',
	'REPLYING_MESSAGE'	=> 'وەڵامدانەوەی پەیام لە %s',
	'REPORT_BY'	=> 'ڕاپۆرت لەلایەن',
	'REPORT_POST'	=> 'ئەم پەیامە ڕاپۆرت بکە',
	'REPORTING_POST'	=> 'ڕاپۆرتکردنی پەیام',
	'RESEND_ACTIVATION'	=> 'ئیمەیلی چالاککردن بنێرەوە',
	'RESET'	=> 'بەتاڵکردنەوە',
	'RESTORE_PERMISSIONS'	=> 'گێڕاندنەوەی دەسەڵاتەکان',
	'RETURN_INDEX'	=> '%sبگەڕێوە بۆ پەڕەی دەستپێک%s',
	'RETURN_FORUM'	=> '%sبگەڕێوە بۆ مەکۆی بابەت%s',
	'RETURN_PAGE'	=> '%sبگەڕێوە بۆ پەڕەی پێشوو%s',
	'RETURN_TOPIC'	=> '%sبگەڕێوە بۆ دوا بابەتی سەردانکراو%s',
	'RETURN_TO'	=> 'گەڕانەوە بۆ',
	'FEED'						=> 'Feed',
	'FEED_NEWS'					=> 'هەواڵ',
	'RULES_ATTACH_CAN'	=> '<strong>ئەتوانیت</strong> هاوپێچ بنێریت لەم مەکۆیە',
	'RULES_ATTACH_CANNOT'	=> '<strong>ناتوانیت</strong> هاوپێچ بنێریت لەم مەکۆیە',
	'RULES_DELETE_CAN'	=> '<strong>ئەتوانیت</strong> پەیامەکانت بسڕیتەوە لەم مەکۆیە',
	'RULES_DELETE_CANNOT'	=> '<strong>ناتوانیت</strong> پەیامەکانت بسڕیتەوە لەم مەکۆیە',
	'RULES_DOWNLOAD_CAN'	=> '<strong>ئەتوانیت</strong> هاوپێچەکان دابگریت لەم مەکۆیە',
	'RULES_DOWNLOAD_CANNOT'	=> '<strong>ناتوانیت</strong> هاوپێچەکان دابگریت لەم مەکۆیە',
	'RULES_EDIT_CAN'	=> '<strong>ئەتوانیت</strong> دەستکاری پەیامەکانت بکەیت لەم مەکۆیە',
	'RULES_EDIT_CANNOT'	=> '<strong>ناتوانیت</strong> دەستکاری پەیامەکانت بکەیت لەم مەکۆیە',
	'RULES_LOCK_CAN'	=> '<strong>ئەتوانیت</strong> بابەتەکانت دابخەیت لەم مەکۆیە',
	'RULES_LOCK_CANNOT'	=> '<strong>ناتوانیت</strong> بابەتەکانت دابخەیت لەم مەکۆیە',
	'RULES_POST_CAN'	=> '<strong>ئەتوانیت</strong> بابەتی نوێ بنێریت لەم مەکۆیە',
	'RULES_POST_CANNOT'	=> '<strong>ناتوانیت</strong> بابەتی نوێ بنێریت لەم مەکۆیە',
	'RULES_REPLY_CAN'	=> '<strong>ئەتوانیت</strong> وەڵامی بابەتەکان بدەیتەوە لەم مەکۆیە',
	'RULES_REPLY_CANNOT'	=> '<strong>ناتوانیت</strong> وەڵامی بابەتەکان بدەیتەوە لەم مەکۆیە',
	'RULES_VOTE_CAN'	=> '<strong>ئەتوانیت</strong> دەنگ بدەیت لە ڕاپرسییەکان لەم مەکۆیە',
	'RULES_VOTE_CANNOT'	=> '<strong>ناتوانیت</strong> دەنگ بدەیت لە ڕاپرسییەکان لەم مەکۆیە',
	'SEARCH'	=> 'گەڕان',
	'SEARCH_MINI'	=> 'گەڕان...',
	'SEARCH_ADV'	=> 'گەڕانی پەرەسەندوو',
	'SEARCH_ADV_EXPLAIN'	=> 'هەڵبژاردنە پەرەسەندووەکانی گەڕان ببینە',
	'SEARCH_KEYWORDS'	=> 'بگەڕێ بۆ وشەکلیل',
	'SEARCHING_FORUMS'	=> 'گەڕان لە مەکۆکان',
	'SEARCH_ACTIVE_TOPICS'	=> 'بابەتە چالاکەکان ببینە',
	'SEARCH_FOR'	=> 'بگەڕێ بۆ',
	'SEARCH_FORUM'	=> 'لەم مەکۆیە بگەڕێ...',
	'SEARCH_NEW'	=> 'پەیامە نوێیەکان ببینە',
	'SEARCH_POSTS_BY'	=> 'بگەڕێ لە پەیامەکانی نووسەر',
	'SEARCH_SELF'	=> 'پەیامەکانی خۆت ببینە',
	'SEARCH_TOPIC'	=> 'لەم بابەتەدا بگەڕێ...',
	'SEARCH_UNANSWERED'	=> 'پەیامە بێ وەڵامەکان ببینە',
	'SEARCH_UNREAD'				=> 'پەیامە نەخوێندراوەکان ببینە',
	'SECONDS'	=> 'چرکە',
	'SELECT'	=> 'دیاریکردن',
	'SELECT_ALL_CODE'	=> 'دیاریکردنی هەموو',
	'SELECT_DESTINATION_FORUM'	=> 'تکایە مەکۆیەکی مەبەست دیاری بکە',
	'SELECT_FORUM'	=> 'مەکۆیەک دیاری بکە',
	'SEND_EMAIL'	=> 'ئیمەیل', // Used for submit buttons
	'SEND_EMAIL_USER'	=> 'ئیمەیل بنێرە بۆ',
	'SEND_PRIVATE_MESSAGE'	=> 'پەیامی تایبەتی بنێرە',
	'SETTINGS'	=> 'ڕێکخستنەکان',
	'SIGNATURE'	=> 'واژۆ',
	'SKIP'	=> 'بیپەڕێنە بۆ ناوەڕۆک',
	'SMTP_NO_AUTH_SUPPORT'	=> ' ڕاژەکار پاڵپشتی سەلماندن ناکات',
	'SORRY_AUTH_READ'	=> 'ڕێت پێ نەدراوە ئەم مەکۆیە ببینیت.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'ڕێت پێ نەدراوە بە داگرتنی ئەم هاوپێچە',
	'SORT_BY'	=> 'ڕیزکردن بە پێی',
	'SORT_JOINED'	=> 'ڕێکەوتی بەشداربوون',
	'SORT_LOCATION'	=> 'شوێن',
	'SORT_RANK'	=> 'پلە',
	'SORT_POSTS'	=> 'پەیامەکان',
	'SORT_TOPIC_TITLE'	=> 'سەردێڕی بابەت',
	'SORT_USERNAME'	=> 'ناوی بەکارهێنەر',
	'SPLIT_TOPIC'	=> 'بەشکردنی بابەت',
	'SQL_ERROR_OCCURRED'	=> 'هەڵەیەکی SQL ڕوویدا لە کاتی کردنەوەی ئەم پەڕەیەدا. تکایە پەیوەندی بە %sBoard Administrator%s وە بکە گەر ئەم هەڵەیە بەردەوام بوو.',
	'STATISTICS'	=> 'ئامارەکان',
	'START_WATCHING_FORUM'	=> 'بەشداربوون لە مەکۆ',
	'START_WATCHING_TOPIC'	=> 'بەشداربوون لە بابەت',
	'STOP_WATCHING_FORUM'	=> 'بەشدار نەبوون لە مەکۆ',
	'STOP_WATCHING_TOPIC'	=> 'بەشدار نەبوون لە بابەت',
	'SUBFORUM'	=> 'ژێرمەکۆ',
	'SUBFORUMS'	=> 'ژێرمەکۆکان',
	'SUBJECT'	=> 'سەردێڕ',
	'SUBMIT'	=> 'ناردن',
	'TERMS_USE'	=> 'مەرجەکانی بەکارهێنان',
	'TEST_CONNECTION'	=> 'تاقیکردنەوەی پەیوەندی',
	'THE_TEAM'	=> 'پلەداران',
	'TIME'	=> 'کات',
	'TOO_LONG'	=> 'ئەو نرخەی لێتداوە زۆر درێژە.',
	'TOO_LONG_AIM'	=> 'ئەو ناوی پیشاندانەی لێتداوە زۆر درێژە.',
	'TOO_LONG_CONFIRM_CODE'	=> 'ئەو کۆدی دڵنیابوونەی نووسیوتە زۆر درێژە.',
	'TOO_LONG_DATEFORMAT'	=> 'ئەو شێوازی کاتەی نووسیوتە زۆر درێژە.',
	'TOO_LONG_ICQ'	=> 'ئەو ژمارەی ICQ ـەی لێتداوە زۆر درێژە.',
	'TOO_LONG_INTERESTS'	=> 'ئەو ئارەزووانەی نووسیوتن زۆر درێژن.',
	'TOO_LONG_JABBER'	=> 'ئەو ناوی هەژماری جابەرەی نووسیوتە زۆر درێژە.',
	'TOO_LONG_LOCATION'	=> 'ئەو شوێنەی لێتداوە زۆر درێژە.',
	'TOO_LONG_MSN'	=> 'ئەو ناوی MSNM/WLM ـەی نووسیوتە زۆر درێژە',
	'TOO_LONG_NEW_PASSWORD'	=> 'ئەو تێپەڕەوشەیەی نووسیوتە زۆر درێژە.',
	'TOO_LONG_OCCUPATION'	=> 'ئەو پیشەیەی نووسیوتە زۆر درێژە.',
	'TOO_LONG_PASSWORD_CONFIRM'	=> 'ئەو تێپەڕەوشە دڵنیابوونەی لێتداوە زۆر درێژە.',
	'TOO_LONG_USER_PASSWORD'	=> 'ئەو تێپەڕەوشەیەی نووسیوتە زۆر درێژە.',
	'TOO_LONG_USERNAME'	=> 'ئەو ناوی بەکارهێنەرەی نووسیوتە زۆر درێژە.',
	'TOO_LONG_EMAIL'	=> 'ئەو ناونیشانی ئیمەیلەی نووسیوتە زۆر درێژە.',
	'TOO_LONG_EMAIL_CONFIRM'	=> 'ئەو ناونیشانی ئیمەیلی دڵنیابونەی لێتداوە زۆر درێژە.',
	'TOO_LONG_WEBSITE'	=> 'ئەو ناونیشانی وێبگەیەی نووسیوتە زۆر درێژە.',
	'TOO_LONG_YIM'	=> 'ئەو ناوەی پەیامبەری یاهوو کە نووسیوتە زۆر درێژە.',
	'TOO_MANY_VOTE_OPTIONS'	=> 'هەوڵت دا دەنگ بە زیاتر لە یەک هەڵبژاردن بدەیت.',
	'TOO_SHORT'	=> 'ئەو نرخەی دیاریت کردووە زۆر کورتە.',
	'TOO_SHORT_AIM'	=> 'ئەو ناوی پیشاندانەی لێتداوە زۆر کورتە.',
	'TOO_SHORT_CONFIRM_CODE'	=> 'ئەو کۆدی دڵنیابوونەی لێتداوە زۆر کورتە.',
	'TOO_SHORT_DATEFORMAT'	=> 'ئەو شێوازی ڕێکەوتەی لێتداوە زۆر کورتە.',
	'TOO_SHORT_ICQ'	=> 'ئەو ژمارەی ICQ ـەی لێتداوە زۆر کورتە.',
	'TOO_SHORT_INTERESTS'	=> 'ئەو ئارەزووانەی نووسیوتن زۆر درێژن.',
	'TOO_SHORT_JABBER'	=> 'ئەو هەژماری جابەرەی نووسیوتە زۆر کورتە.',
	'TOO_SHORT_LOCATION'	=> 'ئەو شوێنەی نووسیوتە زۆر کورتە.',
	'TOO_SHORT_MSN'	=> 'ئەو ناوی MSNM/WLM ـەی نووسیوتە زۆر کورتە.',
	'TOO_SHORT_NEW_PASSWORD'	=> 'ئەو تێپەڕەوشەیەی نووسیوتە زۆر کورتە.',
	'TOO_SHORT_OCCUPATION'	=> 'ئەو پیشەیەی نووسیوتە زۆر کورتە.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'ئەو تێپەڕەوشەی دڵنیابوونەی لێتداوە زۆر کورتە.',
	'TOO_SHORT_USER_PASSWORD'	=> 'ئەو تێپەڕەوشەیەی نووسیوتە زۆر کورتە.',
	'TOO_SHORT_USERNAME'	=> 'ئەو ناوی بەکارهێنەرەی نووسیوتە زۆر کورتە.',
	'TOO_SHORT_EMAIL'	=> 'ئەو ناونیشانی ئیمەیلەی نووسیوتە زۆر کورتە.',
	'TOO_SHORT_EMAIL_CONFIRM'	=> 'ئەو ناونیشانی ئیمەیلی دڵنیابوونەی نووسیوتە زۆر کورتە.',
	'TOO_SHORT_WEBSITE'	=> 'ئەو ناونیشانی وێبگەیەی نووسیوتە زۆر کورتە.',
	'TOO_SHORT_YIM'	=> 'ئەو پەیامبەری یاهووەی نووسیوتە زۆر کورتە.',
	'TOPIC'	=> 'بابەت',
	'TOPICS'	=> 'بابەتەکان',
	'TOPICS_UNAPPROVED'	=> 'بە لانی کەمەوە بابەتێک لەم مەکۆیە پەسەند نەکراوە.',
	'TOPIC_ICON'	=> 'ئایکۆنی بابەت',
	'TOPIC_LOCKED'	=> 'ئەم بابەتە داخراوە، ناتوانیت دەستکاری پەیامەکان و وەڵامەکانی تر بکەیت.',
	'TOPIC_LOCKED_SHORT'	=> 'بابەت داخراوە',
	'TOPIC_MOVED'	=> 'بابەت گواستراوەتەوە',
	'TOPIC_REVIEW'	=> 'پیاچوونەوەی بابەت',
	'TOPIC_TITLE'	=> 'سەردێڕی بابەت',
	'TOPIC_UNAPPROVED'	=> 'ئەم بابەتە پەسەند نەکراوە',
	'TOTAL_ATTACHMENTS'	=> 'هاوپێچ(ەکان)',
	'TOTAL_LOG'	=> '1 لۆگ',
	'TOTAL_LOGS'	=> '%d لۆگ',
	'TOTAL_NO_PM'	=> '0 پەیامی تایبەت لە کۆی گشتی',
	'TOTAL_PM'	=> '1 پەیامی تایبەت لە کۆی گشتی',
	'TOTAL_PMS'	=> '%d پەیامی تایبەت لە کۆی گشتی',
	'TOTAL_POSTS'	=> 'سەرجەم پەیامەکان',
	'TOTAL_POSTS_OTHER'	=> 'سەرجەم پەیامەکان <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'	=> 'سەرجەم پەیامەکان <strong>0</strong>',
	'TOPIC_REPORTED'	=> 'ئەم بابەتە ڕاپۆرتکراوە',
	'TOTAL_TOPICS_OTHER'	=> 'سەرجەم بابەتەکان <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'	=> 'سەرجەم بابەتەکان <strong>0</strong>',
	'TOTAL_USERS_OTHER'	=> 'سەرجەم ئەندامان <strong>%d</strong>',
	'TOTAL_USERS_ZERO'	=> 'سەرجەم ئەندامان <strong>0</strong>',
	'TRACKED_PHP_ERROR'	=> 'Tracked PHP errors: %s',
	'UNABLE_GET_IMAGE_SIZE'	=> 'نەتوانرا دوورییەکانی وێنە بپێورێت.',
	'UNABLE_TO_DELIVER_FILE'	=> 'نەتوانرا پەڕگە بەدەست بگەیەنرێت.',
	'UNKNOWN_BROWSER'	=> 'وێبگەڕێکی نەزانراو',
	'UNMARK_ALL'	=> 'لابردنی نیشانەی هەمووی',
	'UNREAD_MESSAGES'	=> 'پەیامی نەخوێندراوە',
	'UNREAD_PM'	=> '<strong>%d</strong> پەیامی نەخوێندراوە',
	'UNREAD_PMS'	=> '<strong>%d</strong> پەیامی نەخوێندراوە',
	'UNWATCHED_FORUMS'	=> 'چیتر بەشدار نیت لە مەکۆ دیاریکراوەکاندا.',
	'UNWATCHED_TOPICS'	=> 'چیتر بەشدار نیت لە بابەتە دیاریکراوەکاندا.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'چیتر بەشدار نیت لە یەکە دیاریکراوەکاندا.',
	'UPDATE'	=> 'نوێکردنەوە',
	'UPLOAD_IN_PROGRESS'	=> 'بارکردن هەنووکە لە بەرەوپێش چووندایە',
	'URL_REDIRECT'	=> 'گەر وێبگەڕەکەت پاڵپشتی گواستنەوە ناکات %sتکایە کرتە لێرە بکە تا بگوازرێیتەوە%s.',
	'USERGROUPS'	=> 'گرووپەکان',
	'USERNAME'	=> 'ناوی بەکارهێنەر',
	'USERNAMES'	=> 'ناوی بەکارهێنەران',
	'USER_AVATAR'	=> 'وێنۆچکەی بەکارهێنەر',
	'USER_CANNOT_READ'	=> 'ناتوانیت پەیامەکانی ئەم مەکۆیە بخوێنیتەوە',
	'USER_POST'	=> '%d پەیام',
	'USER_POSTS'	=> '%d پەیام',
	'USERS'	=> 'بەکارهێنەران',
	'USE_PERMISSIONS'	=> 'دەسەڵاتەکانی بەکارهێنەر تاقی بکەوە',
	'USER_NEW_PERMISSION_DISALLOWED'	=> 'ببورە، ڕێت پێ نەداوە بۆ بەکارهێنانی ئەم تایبەتمەندییە. لەوانەیە تەنها خۆت تۆمار کردبێت لێرە و پێویستت بە بەشداری زۆرتر بێت تا بتوانیت ئەم تایبەتمەندییە بەکار ببەییت.',
	'VARIANT_DATE_SEPARATOR'	=> ' / ',
	'VIEWED'	=> 'بینرا',
	'VIEWING_FAQ'	=> 'بینینی پ هـ د',
	'VIEWING_MEMBERS'	=> 'بینینی وردەکارییەکانی ئەندام',
	'VIEWING_ONLINE'	=> 'بینینی ئەوانەی لەسەر هێڵن',
	'VIEWING_MCP'	=> 'بینینی کۆنترۆڵ پانێڵی چاودێر',
	'VIEWING_MEMBER_PROFILE'	=> 'بینینی پڕۆفایلی ئەندام',
	'VIEWING_PRIVATE_MESSAGES'	=> 'بینینی پەیامە تایبەتەکان',
	'VIEWING_REGISTER'	=> 'تۆمارکردنی هەژمار',
	'VIEWING_UCP'	=> 'بینینی کۆنترۆڵ پانێڵی بەکارهێنەر',
	'VIEWS'	=> 'بینینەکان',
	'VIEW_BOOKMARKS'	=> 'دڵخوازەکان ببینە',
	'VIEW_FORUM_LOGS'	=> 'لۆگەکان ببینە',
	'VIEW_LATEST_POST'	=> 'دواترین پەیام ببینە',
	'VIEW_NEWEST_POST'	=> 'یەکەم پەیامی نەخوێندراوە ببینە',
	'VIEW_NOTES'	=> 'سەرنجەکانی بەکارهێنەر ببینە',
	'VIEW_ONLINE_TIME'	=> 'لەسەر بنەمای ئەو بەکارهێنەرانی چالاک بوون لە %s خولەکی پێشوو',
	'VIEW_ONLINE_TIMES'	=> 'لەسەر بنەمای ئەو بەکارهێنەرانی چالاک بوون لە %s خولەکی پێشوو',
	'VIEW_TOPIC'	=> 'بینینی بابەت',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'ئاگاداریی',
	'VIEW_TOPIC_GLOBAL'	=> 'ئاگاداریی گشتی:',
	'VIEW_TOPIC_LOCKED'	=> 'داخراو:',
	'VIEW_TOPIC_LOGS'	=> 'لۆگەکان ببینە',
	'VIEW_TOPIC_MOVED'	=> 'گواستراوە',
	'VIEW_TOPIC_POLL'	=> 'ڕاپرسیی:',
	'VIEW_TOPIC_STICKY'	=> 'جێگیر:',
	'VISIT_WEBSITE'	=> 'سەردانی وێبگە بکە',
	'WARNINGS'	=> 'ئاگادارییەکان',
	'WARN_USER'	=> 'بەکارهێنەر ئاگادار بکەوە',
	'WELCOME_SUBJECT'	=> 'بەخێربێیت بۆ مەکۆکانی %s',
	'WEBSITE'	=> 'وێبگە',
	'WHOIS'	=> 'Whois',
	'WHO_IS_ONLINE'	=> 'ئەوانەی لەسەر هێڵن',
	'WRONG_PASSWORD'	=> 'تێپەڕەوشەیەکی هەڵەت لێدا.',
	'WRONG_DATA_ICQ'	=> 'ئەو ژمارەیەی لێتداوە ژمارەیەکی دروستی ICQ نییە.',
	'WRONG_DATA_JABBER'	=> 'ئەو ناوەی لێتداوەناوی هەژمارێکی دروستی جابەر نییە.',
	'WRONG_DATA_LANG'	=> 'ئەو زمانەی دیاریت کردووە گونجاو نییە',
	'WRONG_DATA_WEBSITE'	=> 'پێویستە ناونیشانی وێبگەکە URL ـێکی تەواو بێت، پرۆتۆکۆلەکەشی تیادا بێت. بۆ نموونە http://www.chawg.org/.',
	'WROTE'	=> 'نووسی',
	'YEAR'	=> 'ساڵ',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-DD)',
	'YES'	=> 'بەڵێ',
	'YIM'	=> 'YIM',
	'YOU_LAST_VISIT'	=> 'دوا سەردان: %s',
	'YOU_NEW_PM'	=> 'پەیامێکی تایبەتی نوێ چاوەڕێتە لە سندووقی هاتووەکان.',
	'YOU_NEW_PMS'	=> 'پەیامی تایبەتی نوێ چاوەڕێتن لە سندووقی هاتووەکان.',
	'YOU_NO_NEW_PM'	=> 'هیچ پەیامێکی تایبەتی نوێ چاوەڕێی نییە.',

	'datetime'	=> array(
		'TODAY'	=> 'ئەمڕۆ',
		'TOMORROW'	=> 'سبەی',
		'YESTERDAY'	=> 'دوێنێ',

		'AGO'	=> array(
			'0'	=> 'کەمتر لە خولەکێک پێشتر',
			'1'	=> '%d خولەک پێشتر',
			'2'	=> '%d خولەک پێشتر',
			'60'	=> '1 کاژێر پێشتر',
		),

		'Sunday'	=> 'یەک شەممە',
		'Monday'	=> 'دوو شەممە',
		'Tuesday'	=> 'سێ شەممە',
		'Wednesday'	=> 'چوار شەممە',
		'Thursday'	=> 'پێنج شەممە',
		'Friday'	=> 'هەینی',
		'Saturday'	=> 'شەممە',
		'Sun'	=> '1 شەم',
		'Mon'	=> '2 شەم',
		'Tue'	=> '3 شەم',
		'Wed'	=> '4 شەم',
		'Thu'	=> '5 شەم',
		'Fri'	=> 'هەینی',
		'Sat'	=> 'شەم',
		'January'	=> 'کانونی دووەم',
		'February'	=> 'شوبات',
		'March'	=> 'ئازار',
		'April'	=> 'نیسان',
		'May'	=> 'ئایار',
		'June'	=> 'حوزەیران',
		'July'	=> 'تەمموز',
		'August'	=> 'ئاب',
		'September'	=> 'ئەیلوول',
		'October'	=> 'تشرینی یەکەم',
		'November'	=> 'تشرینی دووەم',
		'December'	=> 'کانونی یەکەم',
		'Jan'	=> 'کانونی دووەم',
		'Feb'	=> 'شوبات',
		'Mar'	=> 'ئازار',
		'Apr'	=> 'نیسان',
		'May_short'	=> 'ئایار',
		'Jun'	=> 'حوزەیران',
		'Jul'	=> 'تەمموز',
		'Aug'	=> 'ئاب',
		'Sep'	=> 'ئەیلوول',
		'Oct'	=> 'تشرینی یەکەم',
		'Nov'	=> 'تشرینی دووەم',
		'Dec'	=> 'کانونی یەکەم',
	),


	'tz'	=> array(
		'-12'	=> 'UTC - 12 کاژێر',
		'-11'	=> 'UTC - 11 کاژێر',
		'-10'	=> 'UTC - 10 کاژێر',
		'-9.5'	=> 'UTC - 9:30 کاژێر',
		'-9'	=> 'UTC - 9 کاژێر',
		'-8'	=> 'UTC - 8 کاژێر',
		'-7'	=> 'UTC - 7 کاژێر',
		'-6'	=> 'UTC - 6 کاژێر',
		'-5'	=> 'UTC - 5 کاژێر',
		'-4.5'	=> 'UTC - 4:30 کاژێر',
		'-4'	=> 'UTC - 4 کاژێر',
		'-3.5'	=> 'UTC - 3:30 کاژێر',
		'-3'	=> 'UTC - 3 کاژێر',
		'-2'	=> 'UTC - 2 کاژێر',
		'-1'	=> 'UTC - 1 کاژێر',
		'0'	=> 'UTC',
		'1'	=> 'UTC + 1 کاژێر',
		'2'	=> 'UTC + 2 کاژێر',
		'3'	=> 'UTC + 3 کاژێر',
		'3.5'	=> 'UTC + 3:30 کاژێر',
		'4'	=> 'UTC + 4 کاژێر',
		'4.5'	=> 'UTC + 4:30 کاژێر',
		'5'	=> 'UTC + 5 کاژێر',
		'5.5'	=> 'UTC + 5:30 کاژێر',
		'5.75'	=> 'UTC + 5:45 کاژێر',
		'6'	=> 'UTC + 6 کاژێر',
		'6.5'	=> 'UTC + 6:30 کاژێر',
		'7'	=> 'UTC + 7 کاژێر',
		'8'	=> 'UTC + 8 کاژێر',
		'8.75'	=> 'UTC + 8:45 کاژێر',
		'9'	=> 'UTC + 9 کاژێر',
		'9.5'	=> 'UTC + 9:30 کاژێر',
		'10'	=> 'UTC + 10 کاژێر',
		'10.5'	=> 'UTC + 10:30 کاژێر',
		'11'	=> 'UTC + 11 کاژێر',
		'11.5'	=> 'UTC + 11:30 کاژێر',
		'12'	=> 'UTC + 12 کاژێر',
		'12.75'	=> 'UTC + 12:45 کاژێر',
		'13'	=> 'UTC + 13 کاژێر',
		'14'	=> 'UTC + 14 کاژێر',
		'dst'	=> '[ <abbr title="Daylight Saving Time">DST</abbr> ]',
	),


	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Baker Island Time',
		'-11'	=> '[UTC - 11] Niue Time, Samoa Standard Time',
		'-10'	=> '[UTC - 10] Hawaii-Aleutian Standard Time, Cook Island Time',
		'-9.5'	=> '[UTC - 9:30] Marquesas Islands Time',
		'-9'	=> '[UTC - 9] Alaska Standard Time, Gambier Island Time',
		'-8'	=> '[UTC - 8] Pacific Standard Time',
		'-7'	=> '[UTC - 7] Mountain Standard Time',
		'-6'	=> '[UTC - 6] کاتی ستانداردی ناوەند',
		'-5'	=> '[UTC - 5] کاتی ستانداردی ڕۆژهەڵات',
		'-4.5'	=> '[UTC - 4:30] Venezuelan Standard Time',
		'-4'	=> '[UTC - 4] کاتی ئەتڵەنتیک',
		'-3.5'	=> '[UTC - 3:30] Newfoundland Standard Time',
		'-3'	=> '[UTC - 3] کاتی ئەمەزۆن، کاتی Greenland ـی ناوەند',
		'-2'	=> '[UTC - 2] Fernando de Noronha Time, South Georgia &amp; the South Sandwich Islands Time',
		'-1'	=> '[UTC - 1] Azores Standard Time, Cape Verde Time, Eastern Greenland Time',
		'0'	=> '[UTC] کاتی ئەورووپای ڕۆژئاوا، Greenwich Mean Time',
		'1'	=> '[UTC + 1] کاتی ئەورووپای ناوەند، کاتی ڕۆژئاوای ئەفریقا',
		'2'	=> '[UTC + 2] کاتی ڕۆژهەڵاتی ئەورووپا، کاتی ئەفریقای ناوەند',
		'3'	=> '[UTC + 3] کاتی مۆسکۆ، کاتی ڕۆژهەڵاتی  ئەفریقا',
		'3.5'	=> '[UTC + 3:30] کاتی ئێران',
		'4'	=> '[UTC + 4] Gulf Standard Time, Samara Standard Time',
		'4.5'	=> '[UTC + 4:30] کاتی ئەفغانستان',
		'5'	=> '[UTC + 5] کاتی Yekaterinburg، کاتی پاکستان',
		'5.5'	=> '[UTC + 5:30] کاتی هندستان، کاتی سریلانکا',
		'5.75'	=> '[UTC + 5:45] کاتی ناپاڵ',
		'6'	=> 'کاتی بەنگلادش، کاتی Bhutan، کاتی Novosibirsk',
		'6.5'	=> '[UTC + 6:30] کاتی دوورگەکانی کۆکۆس، کاتی میانمار',
		'7'	=> '[UTC + 7] Indochina Time, Krasnoyarsk Standard Time',
		'8'	=> '[UTC + 8] Chinese Standard Time, Australian Western Standard Time, Irkutsk Standard Time',
		'8.75'	=> '[UTC + 8:45] کاتی باشوری ڕۆژهەڵاتی ئوستڕاڵیای ڕۆژئاوا',
		'9'	=> '[UTC + 9] کاتی کۆریا، کاتی ژاپۆن، کاتی Chita',
		'9.5'	=> '[UTC + 9:30] کاتی ناوەندی ئوستوڕاڵیا',
		'10'	=> '[UTC + 10] کاتی ڕۆژهەڵاتی ئوستوڕاڵیا، کاتی Vladivostok',
		'10.5'	=> '[UTC + 10:30] Lord Howe Standard Time',
		'11'	=> '[UTC + 11] Solomon Island Time, Magadan Standard Time',
		'11.5'	=> '[UTC + 11:30]  کاتی دوورگەی Norfolk',
		'12'	=> '[UTC + 12] کاتی نیوزلاند، کاتی Fiji، کاتی Kamchatka',
		'12.75'	=> '[UTC + 12:45] کاتی دوورگەکانی Chatham',
		'13'	=> '[UTC + 13] کاتی تۆنگا، کاتی دوورگەکانی فۆنیکس',
		'14'	=> '[UTC + 14] Line Island Time',
	),


	'dateformats'	=> array(
		'd M Y, H:i'	=> '01 Jan 2007, 13:37',
		'd M Y H:i'	=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'	=> 'Jan 1st, \'07, 13:37',
		'D M d, Y g:i a'	=> 'Mon Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'	=> 'January 1st, 2007, 1:37 pm',
		'|d M Y|, H:i'	=> 'Today, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'	=> 'Today, 1:37 pm / January 1st, 2007, 1:37 pm',
	),

	'default_dateformat'	=> 'D M d, Y g:i a',
));

?>
