/*
 * File.java
 *
 * Created on 26. Februar 2003, 10:38
 */
package com.sun.star.wizards.tutorial.executer.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Save the accesibilitiy tree from staroffice in a file.
 */
public class File {
    /**
     * Properties
     */
    private PrintWriter pWriter = null;

    /**
     * Create a new File.
     *
     * @param path path
     *
     * @throws IOException IOException
     */
    public File(String path) throws IOException {
        String filePath = null;

        if (path != null) {
            if (!path.equals("user.home") && !path.equals("user.dir")) {
                filePath = path;
            } else if (path.equals("user.home")) {
                String userhome = (String) System.getProperties().get("user.home");
                filePath = userhome + "/accesFile.txt";
            } else if (path.equals("user.dir")) {
                String userhome = (String) System.getProperties().get("user.dir");
                filePath = userhome + "/accesFile.txt";
            }

            pWriter = new PrintWriter(new BufferedWriter(new FileWriter(filePath)), true);
        }
    }

    /**
     * Print a string. If the argument is null then the string "null" is printed.
     * Otherwise,  the string's characters are converted into bytes according to the
     * platform's default  character encoding, and these bytes are written in exactly
     * the manner of the write(int) method.
     *
     * @param x String to be printed
     */
    public void println(String x) {
        pWriter.println(x);
    }

    /**
     * Close the stream.
     */
    public void close() {
        pWriter.close();
    }
}
