/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: IdentityTransformation.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:00:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "IdentityTransformation.hxx"
#include "macros.hxx"

using namespace ::com::sun::star;

using ::com::sun::star::uno::Sequence;
using ::com::sun::star::uno::RuntimeException;

namespace chart
{

IdentityTransformation::IdentityTransformation( sal_Int32 nDimension ) :
        m_nDim( nDimension )
{}

IdentityTransformation::~IdentityTransformation()
{}

// ____ XTransformation ____
Sequence< double > SAL_CALL IdentityTransformation::transform( const Sequence< double >& aValues )
    throw (RuntimeException,
           lang::IllegalArgumentException)
{
    if( aValues.getLength() != m_nDim )
    {
        lang::IllegalArgumentException aExc(
            C2U( "Dimension Missmatch" ),
            static_cast< ::cppu::OWeakObject * >( this ),
            0 );
        throw aExc;
    }
    return aValues;
}

sal_Int32 SAL_CALL IdentityTransformation::getSourceDimension()
    throw (RuntimeException)
{
    return m_nDim;
}

sal_Int32 SAL_CALL IdentityTransformation::getTargetDimension()
    throw (RuntimeException)
{
    return m_nDim;
}


}  // namespace chart
