/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_charmap.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:36:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include <stdio.h>

#define _SVX_CHARMAP_CXX_

// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif
// auto strip #ifndef _TOOLS_DEBUG_HXX
// auto strip #include <tools/debug.hxx>
// auto strip #endif
// auto strip #ifndef _SV_SOUND_HXX
// auto strip #include <vcl/sound.hxx>
// auto strip #endif
// auto strip #ifndef _SV_SVAPP_HXX
// auto strip #include <vcl/svapp.hxx>
// auto strip #endif
// auto strip #ifndef _SV_BUTTON_HXX
// auto strip #include <vcl/button.hxx>
// auto strip #endif
// auto strip #ifndef _SV_FIXED_HXX
// auto strip #include <vcl/fixed.hxx>
// auto strip #endif
// auto strip #ifndef _SV_LSTBOX_HXX
// auto strip #include <vcl/lstbox.hxx>
// auto strip #endif
#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif
#pragma hdrstop

// auto strip #ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
// auto strip #include <svtools/colorcfg.hxx>
// auto strip #endif

#include <rtl/textenc.h>
// auto strip #include <ucsubset.hxx>

#include "dialogs.hrc"
#include "charmap.hrc"

// auto strip #include "charmap.hxx"
// auto strip #include "dialmgr.hxx"

// auto strip #include "charmapacc.hxx"
// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTOBJECT_HPP_
// auto strip #include <com/sun/star/accessibility/AccessibleEventObject.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
// auto strip #include <com/sun/star/accessibility/AccessibleEventId.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
// auto strip #include <com/sun/star/accessibility/AccessibleStateType.hpp>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_TYPES_HXX_ 
// auto strip #include <comphelper/types.hxx>
// auto strip #endif
namespace binfilter {

//STRIP001 using namespace ::com::sun::star::accessibility;
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 // class SvxShowText =====================================================
//STRIP001 
//STRIP001 class SvxShowText : public Control
//STRIP001 {
//STRIP001 public:
//STRIP001                     SvxShowText( Window* pParent,
//STRIP001                                  const ResId& rResId,
//STRIP001                                  BOOL bCenter = FALSE );
//STRIP001                     ~SvxShowText();
//STRIP001 
//STRIP001     void            SetFont( const Font& rFont );
//STRIP001     void            SetText( const String& rText );
//STRIP001 
//STRIP001 protected:
//STRIP001     virtual void    Paint( const Rectangle& );
//STRIP001 
//STRIP001 private:
//STRIP001     long            mnY;
//STRIP001     BOOL            mbCenter;
//STRIP001 
//STRIP001 };
//STRIP001 
//STRIP001 // class SvxCharMapData ==================================================
//STRIP001 
//STRIP001 class SvxCharMapData
//STRIP001 {
//STRIP001 public:
//STRIP001                     SvxCharMapData( class SfxModalDialog* pDialog, BOOL bOne_ );
//STRIP001 
//STRIP001     void            SetCharFont( const Font& rFont );
//STRIP001 
//STRIP001 private:
//STRIP001 friend class SvxCharacterMap;
//STRIP001     SfxModalDialog* mpDialog;
//STRIP001 
//STRIP001     SvxShowCharSet  aShowSet;
//STRIP001 //    Edit            aShowText;
//STRIP001     SvxShowText     aShowText;
//STRIP001     OKButton        aOKBtn;
//STRIP001     CancelButton    aCancelBtn;
//STRIP001     HelpButton      aHelpBtn;
//STRIP001     PushButton      aDeleteBtn;
//STRIP001     FixedText       aFontText;
//STRIP001     ListBox         aFontLB;
//STRIP001     FixedText       aSubsetText;
//STRIP001     ListBox         aSubsetLB;
//STRIP001     FixedText       aSymbolText;
//STRIP001     SvxShowText     aShowChar;
//STRIP001     FixedText       aCharCodeText;
//STRIP001 
//STRIP001     Font            aFont;
//STRIP001     BOOL            bOne;
//STRIP001     const SubsetMap* pSubsetMap;
//STRIP001 
//STRIP001     DECL_LINK( OKHdl, OKButton* );
//STRIP001     DECL_LINK( FontSelectHdl, ListBox* );
//STRIP001     DECL_LINK( SubsetSelectHdl, ListBox* );
//STRIP001     DECL_LINK( CharDoubleClickHdl, Control* pControl );
//STRIP001     DECL_LINK( CharSelectHdl, Control* pControl );
//STRIP001     DECL_LINK( CharHighlightHdl, Control* pControl );
//STRIP001     DECL_LINK( CharPreSelectHdl, Control* pControl );
//STRIP001     DECL_LINK( DeleteHdl, PushButton* pBtn );
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 sal_Unicode& getSelectedChar()
//STRIP001 {
//STRIP001     static sal_Unicode cSelectedChar = ' '; // keeps selected character over app livetime
//STRIP001     return cSelectedChar;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 static int UnicodeToMapIndex( const FontCharMap& rMap, sal_UCS4 cChar )
//STRIP001 {
//STRIP001     int nIndex = 0;
//STRIP001     ULONG nRanges = rMap.GetRangeCount();
//STRIP001     for( ULONG i = 0; i < nRanges; ++i )
//STRIP001     {
//STRIP001         sal_UCS4 cFirst, cLast;
//STRIP001         rMap.GetRange( i, cFirst, cLast );
//STRIP001         if( cChar < cLast )
//STRIP001             if( cChar < cFirst )
//STRIP001                 break;
//STRIP001             else
//STRIP001                 return nIndex + (cChar - cFirst);
//STRIP001         nIndex += cLast - cFirst;
//STRIP001     }
//STRIP001 
//STRIP001     return -1;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 static sal_UCS4 MapIndexToUnicode( const FontCharMap& rMap, unsigned nIndex )
//STRIP001 {
//STRIP001     ULONG nRanges = rMap.GetRangeCount();
//STRIP001     for( ULONG i = 0; i < nRanges; ++i )
//STRIP001     {
//STRIP001         sal_UCS4 cFirst, cLast;
//STRIP001         rMap.GetRange( i, cFirst, cLast );
//STRIP001         if( nIndex < cLast - cFirst )
//STRIP001             return (cFirst + nIndex);
//STRIP001         nIndex -= cLast - cFirst;
//STRIP001     }
//STRIP001 
//STRIP001     // we should never get here
//STRIP001     return rMap.GetFirstChar();
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxShowCharSet ==================================================
//STRIP001 
//STRIP001 #define SBWIDTH 16
//STRIP001 
//STRIP001 SvxShowCharSet::SvxShowCharSet( Window* pParent, const ResId& rResId ) :
//STRIP001     Control( pParent, rResId )
//STRIP001     ,aVscrollSB( this, WB_VERT)
//STRIP001 	,m_pAccessible(NULL)
//STRIP001 {
//STRIP001     nSelectedIndex = -1;    // TODO: move into init list when it is no longer static
//STRIP001 
//STRIP001     aOrigSize = GetOutputSizePixel();
//STRIP001     aOrigPos = GetPosPixel();
//STRIP001 
//STRIP001     SetStyle( GetStyle() | WB_CLIPCHILDREN );
//STRIP001     aVscrollSB.SetScrollHdl( LINK( this, SvxShowCharSet, VscrollHdl ) );
//STRIP001     // other settings like aVscroll depend on selected font => see SetFont
//STRIP001 
//STRIP001     bDrag = FALSE;
//STRIP001     InitSettings( TRUE, TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::GetFocus()
//STRIP001 {
//STRIP001     Control::GetFocus();
//STRIP001     SelectIndex( nSelectedIndex, TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::LoseFocus()
//STRIP001 {
//STRIP001     Control::LoseFocus();
//STRIP001     SelectIndex( nSelectedIndex, FALSE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::StateChanged( StateChangedType nType )
//STRIP001 {
//STRIP001     if ( nType == STATE_CHANGE_CONTROLFOREGROUND )
//STRIP001         InitSettings( TRUE, FALSE );
//STRIP001     else if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
//STRIP001         InitSettings( FALSE, TRUE );
//STRIP001 
//STRIP001     Control::StateChanged( nType );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     if ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS )
//STRIP001       && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001         InitSettings( TRUE, TRUE );
//STRIP001     else
//STRIP001         Control::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     if ( rMEvt.IsLeft() )
//STRIP001     {
//STRIP001         if ( rMEvt.GetClicks() == 1 )
//STRIP001         {
//STRIP001             GrabFocus();
//STRIP001             bDrag = TRUE;
//STRIP001             CaptureMouse();
//STRIP001 
//STRIP001             int nIndex = PixelToMapIndex( rMEvt.GetPosPixel() );
//STRIP001             SelectIndex( nIndex );
//STRIP001         }
//STRIP001 
//STRIP001         if ( !(rMEvt.GetClicks() % 2) )
//STRIP001             aDoubleClkHdl.Call( this );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::MouseButtonUp( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     if ( bDrag && rMEvt.IsLeft() )
//STRIP001     {
//STRIP001         // released mouse over character map
//STRIP001         if ( Rectangle(Point(), GetOutputSize()).IsInside(rMEvt.GetPosPixel()))
//STRIP001             aSelectHdl.Call( this );
//STRIP001         ReleaseMouse();
//STRIP001         bDrag = FALSE;
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::MouseMove( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     if ( rMEvt.IsLeft() && bDrag )
//STRIP001     {
//STRIP001         Point aPos  = rMEvt.GetPosPixel();
//STRIP001         Size  aSize = GetSizePixel();
//STRIP001 
//STRIP001         if ( aPos.X() < 0 )
//STRIP001             aPos.X() = 0;
//STRIP001         else if ( aPos.X() > aSize.Width()-5 )
//STRIP001             aPos.X() = aSize.Width()-5;
//STRIP001         if ( aPos.Y() < 0 )
//STRIP001             aPos.Y() = 0;
//STRIP001         else if ( aPos.Y() > aSize.Height()-5 )
//STRIP001             aPos.Y() = aSize.Height()-5;
//STRIP001 
//STRIP001         int nIndex = PixelToMapIndex( aPos );
//STRIP001         SelectIndex( nIndex );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001     if( !HandleScrollCommand( rCEvt, 0, &aVscrollSB ) )
//STRIP001         Control::Command( rCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT SvxShowCharSet::GetRowPos(USHORT _nPos) const
//STRIP001 {
//STRIP001     return _nPos / COLUMN_COUNT ;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT SvxShowCharSet::GetColumnPos(USHORT _nPos) const
//STRIP001 {
//STRIP001     return _nPos % COLUMN_COUNT ;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxShowCharSet::FirstInView( void ) const
//STRIP001 {
//STRIP001     int nIndex = 0;
//STRIP001     if( aVscrollSB.IsVisible() )
//STRIP001         nIndex += aVscrollSB.GetThumbPos() * COLUMN_COUNT;
//STRIP001     return nIndex;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxShowCharSet::LastInView( void ) const
//STRIP001 {
//STRIP001     ULONG nIndex = FirstInView();
//STRIP001     nIndex += ROW_COUNT * COLUMN_COUNT;
//STRIP001     return Min( nIndex, maFontCharMap.GetCharCount() ) - 1;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 inline Point SvxShowCharSet::MapIndexToPixel( int nIndex ) const
//STRIP001 {
//STRIP001     const int nBase = FirstInView();
//STRIP001     int x = ((nIndex - nBase) % COLUMN_COUNT) * nX;
//STRIP001     int y = ((nIndex - nBase) / COLUMN_COUNT) * nY;
//STRIP001     return Point( x, y );
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxShowCharSet::PixelToMapIndex( const Point& point) const
//STRIP001 {
//STRIP001     int nBase = FirstInView();
//STRIP001     return (nBase + (point.X()/nX) + (point.Y()/nY) * COLUMN_COUNT);
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     KeyCode aCode = rKEvt.GetKeyCode();
//STRIP001 
//STRIP001     if( aCode.GetModifier() )
//STRIP001     {
//STRIP001         Control::KeyInput( rKEvt );
//STRIP001         return;
//STRIP001     }
//STRIP001 
//STRIP001     int tmpSelected = nSelectedIndex;
//STRIP001 
//STRIP001     switch ( aCode.GetCode() )
//STRIP001     {
//STRIP001         case KEY_SPACE:
//STRIP001             aSelectHdl.Call( this );
//STRIP001             break;
//STRIP001         case KEY_LEFT:
//STRIP001             --tmpSelected;
//STRIP001             break;
//STRIP001         case KEY_RIGHT:
//STRIP001             ++tmpSelected;
//STRIP001             break;
//STRIP001         case KEY_UP:
//STRIP001             tmpSelected -= COLUMN_COUNT;
//STRIP001             break;
//STRIP001         case KEY_DOWN:
//STRIP001             tmpSelected += COLUMN_COUNT;
//STRIP001             break;
//STRIP001         case KEY_PAGEUP:
//STRIP001             tmpSelected -= ROW_COUNT * COLUMN_COUNT;
//STRIP001             break;
//STRIP001         case KEY_PAGEDOWN:
//STRIP001             tmpSelected += ROW_COUNT * COLUMN_COUNT;
//STRIP001             break;
//STRIP001         case KEY_HOME:
//STRIP001             tmpSelected = 0;
//STRIP001             break;
//STRIP001         case KEY_END:
//STRIP001             tmpSelected = maFontCharMap.GetCharCount() - 1;
//STRIP001             break;
//STRIP001         case KEY_TAB:   // some fonts have a character at these unicode control codes
//STRIP001         case KEY_ESCAPE:
//STRIP001         case KEY_RETURN:
//STRIP001             Control::KeyInput( rKEvt );
//STRIP001             tmpSelected = - 1;  // mark as invalid
//STRIP001             break;
//STRIP001         default:
//STRIP001             {
//STRIP001                 sal_Unicode cChar = rKEvt.GetCharCode();
//STRIP001                 sal_Unicode cNext = maFontCharMap.GetNextChar( cChar - 1 );
//STRIP001                 tmpSelected = UnicodeToMapIndex( maFontCharMap, cNext );
//STRIP001                 if( tmpSelected < 0 || (cChar != cNext) )
//STRIP001                 {
//STRIP001                     Control::KeyInput( rKEvt );
//STRIP001                     tmpSelected = - 1;  // mark as invalid
//STRIP001                 }
//STRIP001             }
//STRIP001     }
//STRIP001 
//STRIP001     if ( tmpSelected >= 0 )
//STRIP001     {
//STRIP001         SelectIndex( tmpSelected, TRUE );
//STRIP001         aPreSelectHdl.Call( this );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::Paint( const Rectangle& )
//STRIP001 {
//STRIP001     DrawChars_Impl( FirstInView(), LastInView() );
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 void SvxShowCharSet::DeSelect()
//STRIP001 {
//STRIP001 	DrawChars_Impl(nSelectedIndex,nSelectedIndex);
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::DrawChars_Impl( int n1, int n2 )
//STRIP001 {
//STRIP001     if( n1 > LastInView() || n2 < FirstInView() )
//STRIP001         return;
//STRIP001 
//STRIP001     Size aOutputSize = GetOutputSizePixel();
//STRIP001     if( aVscrollSB.IsVisible() )
//STRIP001         aOutputSize.setWidth( aOutputSize.Width() - SBWIDTH );
//STRIP001 
//STRIP001     int i;
//STRIP001     for ( i = 1; i < COLUMN_COUNT; ++i )
//STRIP001         DrawLine( Point( nX * i, 0 ), Point( nX * i, aOutputSize.Height() ) );
//STRIP001     for ( i = 1; i < ROW_COUNT; ++i )
//STRIP001         DrawLine( Point( 0, nY * i ), Point( aOutputSize.Width(), nY * i ) );
//STRIP001 
//STRIP001     const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 	svtools::ColorConfig aColorConfig;
//STRIP001 	Color aWindowTextColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001 	Color aHighlightColor( rStyleSettings.GetHighlightColor() );
//STRIP001 	Color aHighlightTextColor( rStyleSettings.GetHighlightTextColor() );
//STRIP001 	Color aFaceColor( rStyleSettings.GetFaceColor() );
//STRIP001 	Color aLightColor( rStyleSettings.GetLightColor() );
//STRIP001 	Color aShadowColor( rStyleSettings.GetShadowColor() );
//STRIP001 
//STRIP001     int nTextHeight = GetTextHeight();
//STRIP001     Rectangle aBoundRect;
//STRIP001     for( i = n1; i <= n2; ++i )
//STRIP001     {
//STRIP001         Point pix = MapIndexToPixel( i );
//STRIP001         int x = pix.X();
//STRIP001         int y = pix.Y();
//STRIP001 
//STRIP001         sal_Unicode cChar = MapIndexToUnicode( maFontCharMap, i );
//STRIP001         String aCharStr( cChar );
//STRIP001         int nTextWidth = GetTextWidth(aCharStr);
//STRIP001         int tx = x + (nX - nTextWidth + 1) / 2;
//STRIP001         int ty = y + (nY - nTextHeight + 1) / 2;
//STRIP001         Point aPointTxTy( tx, ty );
//STRIP001 
//STRIP001         // adjust position before it gets out of bounds
//STRIP001         if( GetTextBoundRect( aBoundRect, aCharStr ) && !aBoundRect.IsEmpty() )
//STRIP001         {
//STRIP001             // zero advance width => use ink width to center glyph
//STRIP001             if( !nTextWidth )
//STRIP001             {
//STRIP001                 aPointTxTy.X() = x - aBoundRect.Left()
//STRIP001                                + (nX - aBoundRect.GetWidth() + 1) / 2;
//STRIP001             }
//STRIP001 
//STRIP001             aBoundRect += aPointTxTy;
//STRIP001 
//STRIP001             // shift back vertically if needed
//STRIP001             int nYLDelta = aBoundRect.Top() - y;
//STRIP001             int nYHDelta = (y + nY) - aBoundRect.Bottom();
//STRIP001             if( nYLDelta <= 0 )
//STRIP001                 aPointTxTy.Y() -= nYLDelta - 1;
//STRIP001             else if( nYHDelta <= 0 )
//STRIP001                 aPointTxTy.Y() += nYHDelta - 1;
//STRIP001 
//STRIP001             // shift back horizontally if needed
//STRIP001             int nXLDelta = aBoundRect.Left() - x;
//STRIP001             int nXHDelta = (x + nX) - aBoundRect.Right();
//STRIP001             if( nXLDelta <= 0 )
//STRIP001                 aPointTxTy.X() -= nXLDelta - 1;
//STRIP001             else if( nXHDelta <= 0 )
//STRIP001                 aPointTxTy.X() += nXHDelta - 1;
//STRIP001         }
//STRIP001 
//STRIP001         Color aTextCol = GetTextColor();
//STRIP001         if ( i != nSelectedIndex )
//STRIP001         {
//STRIP001             SetTextColor( aWindowTextColor );
//STRIP001             DrawText( aPointTxTy, aCharStr );
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             Color aLineCol = GetLineColor();
//STRIP001             Color aFillCol = GetFillColor();
//STRIP001             SetLineColor();
//STRIP001             Point aPointUL( x + 1, y + 1 );
//STRIP001             if( HasFocus() )
//STRIP001             {
//STRIP001                 SetFillColor( aHighlightColor );
//STRIP001                 DrawRect( Rectangle( aPointUL, Size(nX-1,nY-1) ) );
//STRIP001 
//STRIP001                 SetTextColor( aHighlightTextColor );
//STRIP001                 DrawText( aPointTxTy, aCharStr );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 SetFillColor( aFaceColor );
//STRIP001                 DrawRect( Rectangle( aPointUL, Size( nX-1, nY-1) ) );
//STRIP001 
//STRIP001                 SetLineColor( aLightColor );
//STRIP001                 DrawLine( aPointUL, Point( x+nX-1, y+1) );
//STRIP001                 DrawLine( aPointUL, Point( x+1, y+nY-1) );
//STRIP001 
//STRIP001                 SetLineColor( aShadowColor );
//STRIP001                 DrawLine( Point( x+1, y+nY-1), Point( x+nX-1, y+nY-1) );
//STRIP001                 DrawLine( Point( x+nX-1, y+nY-1), Point( x+nX-1, y+1) );
//STRIP001 
//STRIP001                 DrawText( aPointTxTy, aCharStr );
//STRIP001             }
//STRIP001             SetLineColor( aLineCol );
//STRIP001             SetFillColor( aFillCol );
//STRIP001         }
//STRIP001         SetTextColor( aTextCol );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::InitSettings( BOOL bForeground, BOOL bBackground )
//STRIP001 {
//STRIP001     const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 
//STRIP001     if ( bForeground )
//STRIP001     {
//STRIP001 		svtools::ColorConfig aColorConfig;
//STRIP001 		Color aTextColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001 
//STRIP001         if ( IsControlForeground() )
//STRIP001             aTextColor = GetControlForeground();
//STRIP001         SetTextColor( aTextColor );
//STRIP001     }
//STRIP001 
//STRIP001     if ( bBackground )
//STRIP001     {
//STRIP001         if ( IsControlBackground() )
//STRIP001             SetBackground( GetControlBackground() );
//STRIP001         else
//STRIP001             SetBackground( rStyleSettings.GetWindowColor() );
//STRIP001     }
//STRIP001 
//STRIP001     Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Unicode SvxShowCharSet::GetSelectCharacter() const
//STRIP001 {
//STRIP001     if( nSelectedIndex >= 0 )
//STRIP001         getSelectedChar() = MapIndexToUnicode( maFontCharMap, nSelectedIndex );
//STRIP001     return getSelectedChar();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::SetFont( const Font& rFont )
//STRIP001 {
//STRIP001     // save last selected unicode
//STRIP001     if( nSelectedIndex >= 0 )
//STRIP001         getSelectedChar() = MapIndexToUnicode( maFontCharMap, nSelectedIndex );
//STRIP001 
//STRIP001     Font aFont = rFont;
//STRIP001     aFont.SetWeight( WEIGHT_LIGHT );
//STRIP001     aFont.SetAlign( ALIGN_TOP );
//STRIP001     int nFontHeight = (aOrigSize.Height() - 5) * 2 / (3 * ROW_COUNT);
//STRIP001     aFont.SetSize( PixelToLogic( Size( 0, nFontHeight ) ) );
//STRIP001     aFont.SetTransparent( TRUE );
//STRIP001     Control::SetFont( aFont );
//STRIP001     GetFontCharMap( maFontCharMap );
//STRIP001 
//STRIP001     // hide scrollbar when there is nothing to scroll
//STRIP001     BOOL bNeedVscroll = (maFontCharMap.GetCharCount() > ROW_COUNT*COLUMN_COUNT);
//STRIP001 
//STRIP001     nX = (aOrigSize.Width() - (bNeedVscroll ? SBWIDTH : 0)) / COLUMN_COUNT;
//STRIP001     nY = aOrigSize.Height() / ROW_COUNT;
//STRIP001 
//STRIP001     if( bNeedVscroll)
//STRIP001     {
//STRIP001         aVscrollSB.SetPosSizePixel( nX * COLUMN_COUNT, 0, SBWIDTH, nY * ROW_COUNT );
//STRIP001         aVscrollSB.SetRangeMin( 0 );
//STRIP001         int nLastRow = (maFontCharMap.GetCharCount() - 1 + COLUMN_COUNT) / COLUMN_COUNT;
//STRIP001         aVscrollSB.SetRangeMax( nLastRow );
//STRIP001         aVscrollSB.SetPageSize( ROW_COUNT-1 );
//STRIP001         aVscrollSB.SetVisibleSize( ROW_COUNT );
//STRIP001     }
//STRIP001 
//STRIP001     // restore last selected unicode
//STRIP001     int nMapIndex = UnicodeToMapIndex( maFontCharMap, getSelectedChar() );
//STRIP001     SelectIndex( nMapIndex );
//STRIP001 
//STRIP001     // rearrange CharSet element in sync with nX- and nY-multiples
//STRIP001     Size aNewSize( nX * COLUMN_COUNT + (bNeedVscroll ? SBWIDTH : 0), nY * ROW_COUNT );
//STRIP001     Point aNewPos = aOrigPos + Point( (aOrigSize.Width() - aNewSize.Width()) / 2, 0 );
//STRIP001     SetPosPixel( aNewPos );
//STRIP001     SetOutputSizePixel( aNewSize );
//STRIP001 
//STRIP001     aVscrollSB.Show( bNeedVscroll );
//STRIP001     Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::SelectIndex( int nNewIndex, BOOL bFocus )
//STRIP001 {
//STRIP001     if( nNewIndex < 0 )
//STRIP001     {
//STRIP001         // need to scroll see closest unicode
//STRIP001         sal_Unicode cPrev = maFontCharMap.GetPrevChar( getSelectedChar() );
//STRIP001         int nMapIndex = UnicodeToMapIndex( maFontCharMap, cPrev );
//STRIP001         int nNewPos = nMapIndex / COLUMN_COUNT;
//STRIP001         aVscrollSB.SetThumbPos( nNewPos );
//STRIP001         nSelectedIndex = bFocus ? nMapIndex+1 : -1;
//STRIP001         Invalidate();
//STRIP001         Update();
//STRIP001     }
//STRIP001     else if( nNewIndex < FirstInView() )
//STRIP001     {
//STRIP001         // need to scroll up to see selected item
//STRIP001         int nOldPos = aVscrollSB.GetThumbPos();
//STRIP001         int nDelta = (FirstInView() - nNewIndex + COLUMN_COUNT-1) / COLUMN_COUNT;
//STRIP001         aVscrollSB.SetThumbPos( nOldPos - nDelta );
//STRIP001         nSelectedIndex = nNewIndex;
//STRIP001         Invalidate();
//STRIP001         if( nDelta )
//STRIP001             Update();
//STRIP001     }
//STRIP001     else if( nNewIndex > LastInView() )
//STRIP001     {
//STRIP001         // need to scroll down to see selected item
//STRIP001         int nOldPos = aVscrollSB.GetThumbPos();
//STRIP001         int nDelta = (nNewIndex - LastInView() + COLUMN_COUNT) / COLUMN_COUNT;
//STRIP001         aVscrollSB.SetThumbPos( nOldPos + nDelta );
//STRIP001         if( nNewIndex < maFontCharMap.GetCharCount() )
//STRIP001         {
//STRIP001             nSelectedIndex = nNewIndex;
//STRIP001             Invalidate();
//STRIP001         }
//STRIP001         if( nOldPos != aVscrollSB.GetThumbPos() )
//STRIP001         {
//STRIP001             Invalidate();
//STRIP001             Update();
//STRIP001         }
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         // remove highlighted view
//STRIP001         Color aLineCol = GetLineColor();
//STRIP001         Color aFillCol = GetFillColor();
//STRIP001         SetLineColor();
//STRIP001         SetFillColor( GetBackground().GetColor() );
//STRIP001 
//STRIP001         Point aOldPixel = MapIndexToPixel( nSelectedIndex );
//STRIP001         aOldPixel.Move( +1, +1);
//STRIP001         DrawRect( Rectangle( aOldPixel, Size( nX-1, nY-1 ) ) );
//STRIP001         SetLineColor( aLineCol );
//STRIP001         SetFillColor( aFillCol );
//STRIP001 
//STRIP001         int nOldIndex = nSelectedIndex;
//STRIP001         nSelectedIndex = nNewIndex;
//STRIP001         DrawChars_Impl( nOldIndex, nOldIndex );
//STRIP001         DrawChars_Impl( nNewIndex, nNewIndex );
//STRIP001     }
//STRIP001 
//STRIP001     if( nSelectedIndex >= 0 )
//STRIP001 	{
//STRIP001 	    getSelectedChar() = MapIndexToUnicode( maFontCharMap, nSelectedIndex );
//STRIP001 		if( m_pAccessible )
//STRIP001 		{
//STRIP001 			::svx::SvxShowCharSetItem* pItem = ImplGetItem(nSelectedIndex);
//STRIP001 			m_pAccessible->fireEvent( AccessibleEventId::ACTIVE_DESCENDANT_CHANGED, Any(), makeAny(pItem->GetAccessible()) ); // this call asures that m_pItem is set
//STRIP001 
//STRIP001 			OSL_ENSURE(pItem->m_pItem,"No accessible created!");
//STRIP001 			Any aOldAny, aNewAny;
//STRIP001 			aNewAny <<= AccessibleStateType::FOCUSED;
//STRIP001 			pItem->m_pItem->fireEvent( AccessibleEventId::STATE_CHANGED, aOldAny, aNewAny );
//STRIP001 
//STRIP001 			aNewAny <<= AccessibleStateType::SELECTED;
//STRIP001 			pItem->m_pItem->fireEvent( AccessibleEventId::STATE_CHANGED, aOldAny, aNewAny );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	
//STRIP001 
//STRIP001     aHighHdl.Call( this );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowCharSet::SelectCharacter( sal_Unicode cNew, BOOL bFocus )
//STRIP001 {
//STRIP001     // get next available char of current font
//STRIP001     sal_Unicode cNext = maFontCharMap.GetNextChar( cNew - 1 );
//STRIP001 
//STRIP001     int nMapIndex = UnicodeToMapIndex( maFontCharMap, cNext );
//STRIP001     SelectIndex( nMapIndex, bFocus );
//STRIP001     if( !bFocus )
//STRIP001     {
//STRIP001         // move selected item to top row if not in focus
//STRIP001         aVscrollSB.SetThumbPos( nMapIndex / COLUMN_COUNT );
//STRIP001         Invalidate();
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxShowCharSet, VscrollHdl, ScrollBar *, EMPTYARG )
//STRIP001 {
//STRIP001     if( nSelectedIndex < FirstInView() )
//STRIP001 	{
//STRIP001         SelectIndex( FirstInView() + (nSelectedIndex % COLUMN_COUNT) );
//STRIP001 	}
//STRIP001     else if( nSelectedIndex > LastInView() )
//STRIP001 	{
//STRIP001 		if( m_pAccessible )
//STRIP001 		{
//STRIP001 			::com::sun::star::uno::Any aOldAny, aNewAny;
//STRIP001 			sal_Int32 nLast = LastInView();
//STRIP001 			for ( ; nLast != nSelectedIndex; ++nLast)
//STRIP001 			{
//STRIP001 				aOldAny <<= ImplGetItem(nLast)->GetAccessible();
//STRIP001 				m_pAccessible ->fireEvent( AccessibleEventId::CHILD, aOldAny, aNewAny );
//STRIP001 			}
//STRIP001 		}
//STRIP001         SelectIndex( (LastInView() - COLUMN_COUNT + 1) + (nSelectedIndex % COLUMN_COUNT) );
//STRIP001 	}
//STRIP001 
//STRIP001     Invalidate();
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxShowCharSet::~SvxShowCharSet()
//STRIP001 {
//STRIP001 	if ( m_pAccessible )
//STRIP001 		ReleaseAccessible();
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 void SvxShowCharSet::ReleaseAccessible()
//STRIP001 {
//STRIP001 	m_aItems.clear();
//STRIP001 	m_pAccessible = NULL;
//STRIP001 	m_xAccessible = NULL;
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 ::com::sun::star::uno::Reference< XAccessible > SvxShowCharSet::CreateAccessible()
//STRIP001 {
//STRIP001 	OSL_ENSURE(!m_pAccessible,"Accessible already created!");
//STRIP001 	m_pAccessible = new ::svx::SvxShowCharSetVirtualAcc(this);
//STRIP001 	m_xAccessible = m_pAccessible;
//STRIP001 	return m_xAccessible;
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 ::svx::SvxShowCharSetItem* SvxShowCharSet::ImplGetItem( USHORT _nPos )
//STRIP001 {
//STRIP001 	ItemsMap::iterator aFind = m_aItems.find(_nPos);
//STRIP001 	if ( aFind == m_aItems.end() )
//STRIP001 	{
//STRIP001 		OSL_ENSURE(m_pAccessible,"Who wants to create a child of my table without a parent?");
//STRIP001 		aFind = m_aItems.insert(ItemsMap::value_type(_nPos,new ::svx::SvxShowCharSetItem(*this,m_pAccessible->getTable(),_nPos))).first;
//STRIP001 		aFind->second->maText = MapIndexToUnicode(maFontCharMap,_nPos);
//STRIP001 		Point pix = MapIndexToPixel( _nPos );
//STRIP001 		aFind->second->maRect = Rectangle( Point( pix.X() + 1, pix.Y() + 1 ), Size(nX-1,nY-1) );
//STRIP001 	}
//STRIP001 
//STRIP001 	return aFind->second;
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 void SvxShowCharSet::ImplFireAccessibleEvent( short nEventId, const ::com::sun::star::uno::Any& rOldValue, const ::com::sun::star::uno::Any& rNewValue )
//STRIP001 {
//STRIP001     if( m_pAccessible )
//STRIP001         m_pAccessible->fireEvent( nEventId, rOldValue, rNewValue );
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 ScrollBar* SvxShowCharSet::getScrollBar()
//STRIP001 {
//STRIP001 	return &aVscrollSB;
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 sal_Int32 SvxShowCharSet::getMaxCharCount() const
//STRIP001 {
//STRIP001     return maFontCharMap.GetCharCount();
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxShowText =====================================================
//STRIP001 
//STRIP001 SvxShowText::SvxShowText( Window* pParent, const ResId& rResId, BOOL bCenter )
//STRIP001 :   Control( pParent, rResId ),
//STRIP001     mbCenter( bCenter)
//STRIP001 {}
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowText::Paint( const Rectangle& )
//STRIP001 {
//STRIP001     Color aTextCol = GetTextColor();
//STRIP001    
//STRIP001     svtools::ColorConfig aColorConfig;
//STRIP001     Color aWindowTextColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001     SetTextColor( aWindowTextColor );
//STRIP001 
//STRIP001     const String aText = GetText();
//STRIP001     const Size aSize = GetOutputSizePixel();
//STRIP001     Point aPoint( 2, mnY );
//STRIP001 
//STRIP001     // adjust position using ink boundary if possible
//STRIP001     Rectangle aBoundRect;
//STRIP001     if( !GetTextBoundRect( aBoundRect, aText ) || aBoundRect.IsEmpty() )
//STRIP001         aPoint.X() = (aSize.Width() - GetTextWidth( aText )) / 2;
//STRIP001     else
//STRIP001     {
//STRIP001         // adjust position before it gets out of bounds
//STRIP001         aBoundRect += aPoint;
//STRIP001 
//STRIP001         // shift back vertically if needed
//STRIP001         int nYLDelta = aBoundRect.Top();
//STRIP001         int nYHDelta = aSize.Height() - aBoundRect.Bottom();
//STRIP001         if( nYLDelta <= 0 )
//STRIP001             aPoint.Y() -= nYLDelta - 1;
//STRIP001         else if( nYHDelta <= 0 )
//STRIP001             aPoint.Y() += nYHDelta - 1;
//STRIP001 
//STRIP001         if( mbCenter )
//STRIP001         {
//STRIP001             // move glyph to middle of cell
//STRIP001             aPoint.X() = -aBoundRect.Left()
//STRIP001                        + (aSize.Width() - aBoundRect.GetWidth()) / 2;
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             // shift back horizontally if needed
//STRIP001             int nXLDelta = aBoundRect.Left();
//STRIP001             int nXHDelta = aSize.Width() - aBoundRect.Right();
//STRIP001             if( nXLDelta <= 0 )
//STRIP001                 aPoint.X() -= nXLDelta - 1;
//STRIP001             else if( nXHDelta <= 0 )
//STRIP001                 aPoint.X() += nXHDelta - 1;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     DrawText( aPoint, aText );
//STRIP001     SetTextColor( aTextCol );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowText::SetFont( const Font& rFont )
//STRIP001 {
//STRIP001     long nWinHeight = GetOutputSizePixel().Height();
//STRIP001     Font aFont = rFont;
//STRIP001     aFont.SetWeight( WEIGHT_NORMAL );
//STRIP001     aFont.SetAlign( ALIGN_TOP );
//STRIP001     aFont.SetSize( PixelToLogic( Size( 0, nWinHeight/2 ) ) );
//STRIP001     aFont.SetTransparent( TRUE );
//STRIP001     Control::SetFont( aFont );
//STRIP001     mnY = ( nWinHeight - GetTextHeight() ) / 2;
//STRIP001 
//STRIP001     Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxShowText::SetText( const String& rText )
//STRIP001 {
//STRIP001     Control::SetText( rText );
//STRIP001     Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxShowText::~SvxShowText()
//STRIP001 {}
//STRIP001 
//STRIP001 // class SvxCharacterMap =================================================
//STRIP001 
//STRIP001 SvxCharacterMap::SvxCharacterMap( Window* pParent, BOOL bOne ) :
//STRIP001     SfxModalDialog( pParent, SVX_RES( RID_SVXDLG_CHARMAP ) ),
//STRIP001     mpCharMapData( new SvxCharMapData( this, bOne ) )
//STRIP001 {
//STRIP001     FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxCharacterMap::~SvxCharacterMap()
//STRIP001 {
//STRIP001     delete mpCharMapData;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 const Font& SvxCharacterMap::GetCharFont() const
//STRIP001 {
//STRIP001     return mpCharMapData->aFont;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharacterMap::SetChar( sal_Unicode c )
//STRIP001 {
//STRIP001     mpCharMapData->aShowSet.SelectCharacter( c );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Unicode SvxCharacterMap::GetChar() const
//STRIP001 {
//STRIP001     return mpCharMapData->aShowSet.GetSelectCharacter();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String SvxCharacterMap::GetCharacters() const
//STRIP001 {
//STRIP001     return mpCharMapData->aShowText.GetText();
//STRIP001 }
//STRIP001 
//STRIP001 // =======================================================================
//STRIP001 
//STRIP001 SvxCharMapData::SvxCharMapData( SfxModalDialog* pDialog, BOOL bOne_ )
//STRIP001 :   mpDialog( pDialog ),
//STRIP001     aShowSet        ( pDialog, ResId( CT_SHOWSET ) ),
//STRIP001     aFontText       ( pDialog, ResId( FT_FONT ) ),
//STRIP001     aFontLB         ( pDialog, ResId( LB_FONT ) ),
//STRIP001     aSubsetText     ( pDialog, ResId( FT_SUBSET ) ),
//STRIP001     aSubsetLB       ( pDialog, ResId( LB_SUBSET ) ),
//STRIP001     aSymbolText     ( pDialog, ResId( FT_SYMBOLE ) ),
//STRIP001     aShowText       ( pDialog, ResId( CT_SHOWTEXT ) ),
//STRIP001     aShowChar       ( pDialog, ResId( CT_SHOWCHAR ), TRUE ),
//STRIP001     aCharCodeText   ( pDialog, ResId( FT_CHARCODE ) ),
//STRIP001     aOKBtn          ( pDialog, ResId( BTN_CHAR_OK ) ),
//STRIP001     aCancelBtn      ( pDialog, ResId( BTN_CHAR_CANCEL ) ),
//STRIP001     aHelpBtn        ( pDialog, ResId( BTN_CHAR_HELP ) ),
//STRIP001     aDeleteBtn      ( pDialog, ResId( BTN_DELETE ) ),
//STRIP001     pSubsetMap( NULL ),
//STRIP001     bOne( bOne_ )
//STRIP001 {
//STRIP001     aFont = pDialog->GetFont();
//STRIP001     aFont.SetTransparent( TRUE );
//STRIP001     aFont.SetFamily( FAMILY_DONTKNOW );
//STRIP001     aFont.SetPitch( PITCH_DONTKNOW );
//STRIP001     aFont.SetCharSet( RTL_TEXTENCODING_DONTKNOW );
//STRIP001 
//STRIP001     if ( bOne )
//STRIP001     {
//STRIP001         Size aDlgSize = pDialog->GetSizePixel();
//STRIP001         pDialog->SetSizePixel( Size( aDlgSize.Width(),
//STRIP001             aDlgSize.Height()-aShowText.GetSizePixel().Height() ) );
//STRIP001         aSymbolText.Hide();
//STRIP001         aShowText.Hide();
//STRIP001         aDeleteBtn.Hide();
//STRIP001     }
//STRIP001 
//STRIP001     String aDefStr( aFont.GetName() );
//STRIP001     String aLastName;
//STRIP001     xub_StrLen i;
//STRIP001     xub_StrLen nCount = mpDialog->GetDevFontCount();
//STRIP001     for ( i = 0; i < nCount; i++ )
//STRIP001     {
//STRIP001         String aFontName( mpDialog->GetDevFont( i ).GetName() );
//STRIP001         if ( aFontName != aLastName )
//STRIP001         {
//STRIP001             aLastName = aFontName;
//STRIP001             USHORT nPos = aFontLB.InsertEntry( aFontName );
//STRIP001             aFontLB.SetEntryData( nPos, (void*)(ULONG)i );
//STRIP001         }
//STRIP001     }
//STRIP001     // the font may not be in the list =>
//STRIP001     // try to find a font name token in list and select found font,
//STRIP001     // else select topmost entry
//STRIP001     FASTBOOL bFound = (aFontLB.GetEntryPos( aDefStr ) == LISTBOX_ENTRY_NOTFOUND );
//STRIP001     if( !bFound )
//STRIP001     {
//STRIP001         for ( i = 0; i < aDefStr.GetTokenCount(); ++i )
//STRIP001         {
//STRIP001             String aToken = aDefStr.GetToken(i);
//STRIP001             if ( aFontLB.GetEntryPos( aToken ) != LISTBOX_ENTRY_NOTFOUND )
//STRIP001             {
//STRIP001                 aDefStr = aToken;
//STRIP001                 bFound = TRUE;
//STRIP001                 break;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     if ( bFound )
//STRIP001         aFontLB.SelectEntry( aDefStr );
//STRIP001     else if ( aFontLB.GetEntryCount() )
//STRIP001         aFontLB.SelectEntryPos(0);
//STRIP001     FontSelectHdl( &aFontLB );
//STRIP001 
//STRIP001     aOKBtn.SetClickHdl( LINK( this, SvxCharMapData, OKHdl ) );
//STRIP001     aFontLB.SetSelectHdl( LINK( this, SvxCharMapData, FontSelectHdl ) );
//STRIP001     aSubsetLB.SetSelectHdl( LINK( this, SvxCharMapData, SubsetSelectHdl ) );
//STRIP001     aShowSet.SetDoubleClickHdl( LINK( this, SvxCharMapData, CharDoubleClickHdl ) );
//STRIP001     aShowSet.SetSelectHdl( LINK( this, SvxCharMapData, CharSelectHdl ) );
//STRIP001     aShowSet.SetHighlightHdl( LINK( this, SvxCharMapData, CharHighlightHdl ) );
//STRIP001     aShowSet.SetPreSelectHdl( LINK( this, SvxCharMapData, CharPreSelectHdl ) );
//STRIP001     aDeleteBtn.SetClickHdl( LINK( this, SvxCharMapData, DeleteHdl ) );
//STRIP001 
//STRIP001     aOKBtn.Disable();
//STRIP001 
//STRIP001     // left align aShowText field
//STRIP001     int nLeftEdge = aSymbolText.GetPosPixel().X();
//STRIP001     nLeftEdge += aSymbolText.GetTextWidth( aSymbolText.GetText() );
//STRIP001     Size aNewSize = aShowText.GetOutputSizePixel();
//STRIP001     aShowText.SetPosPixel( Point( nLeftEdge+4, aShowText.GetPosPixel().Y() ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharacterMap::DisableFontSelection()
//STRIP001 {
//STRIP001     mpCharMapData->aFontText.Disable();
//STRIP001     mpCharMapData->aFontLB.Disable();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharMapData::SetCharFont( const Font& rFont )
//STRIP001 {
//STRIP001     // first get the underlying info in order to get font names
//STRIP001     // like "Times New Roman;Times" resolved
//STRIP001     Font aTmp( mpDialog->GetFontMetric( rFont ) );
//STRIP001 
//STRIP001     if ( aFontLB.GetEntryPos( aTmp.GetName() ) == LISTBOX_ENTRY_NOTFOUND )
//STRIP001         return;
//STRIP001 
//STRIP001     aFontLB.SelectEntry( aTmp.GetName() );
//STRIP001     aFont = aTmp;
//STRIP001     FontSelectHdl( &aFontLB );
//STRIP001 
//STRIP001     // for compatibility reasons
//STRIP001     mpDialog->ModalDialog::SetFont( aFont );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxCharacterMap::SetCharFont( const Font& rFont )
//STRIP001 {
//STRIP001     mpCharMapData->SetCharFont( rFont );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharMapData, OKHdl, OKButton *, EMPTYARG )
//STRIP001 {
//STRIP001     String aStr = aShowText.GetText();
//STRIP001 
//STRIP001     if ( !aStr.Len() )
//STRIP001     {
//STRIP001         if ( aShowSet.GetSelectCharacter() > 0 )
//STRIP001             aStr = aShowSet.GetSelectCharacter();
//STRIP001         aShowText.SetText( aStr );
//STRIP001     }
//STRIP001     mpDialog->EndDialog( TRUE );
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharMapData, FontSelectHdl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001     USHORT nPos = aFontLB.GetSelectEntryPos(),
//STRIP001         nFont = (USHORT)(ULONG)aFontLB.GetEntryData( nPos );
//STRIP001     aFont = mpDialog->GetDevFont( nFont );
//STRIP001 
//STRIP001     // notify children using this font
//STRIP001     aShowSet.SetFont( aFont );
//STRIP001     aShowChar.SetFont( aFont );
//STRIP001     aShowText.SetFont( aFont );
//STRIP001 
//STRIP001     // right align some fields to aShowSet
//STRIP001     int nRightEdge = aShowSet.GetPosPixel().X() + aShowSet.GetOutputSizePixel().Width();
//STRIP001     Size aNewSize = aSubsetLB.GetOutputSizePixel();
//STRIP001     aNewSize.setWidth( nRightEdge - aSubsetLB.GetPosPixel().X() );
//STRIP001     aSubsetLB.SetOutputSizePixel( aNewSize );
//STRIP001 
//STRIP001     // setup unicode subset listbar with font specific subsets,
//STRIP001     // hide unicode subset listbar for symbol fonts
//STRIP001     // TODO: get info from the Font once it provides it
//STRIP001     if( pSubsetMap)
//STRIP001         delete pSubsetMap;
//STRIP001     pSubsetMap = NULL;
//STRIP001 
//STRIP001     BOOL bNeedSubset = (aFont.GetCharSet() != RTL_TEXTENCODING_SYMBOL);
//STRIP001     if( bNeedSubset )
//STRIP001     {
//STRIP001         FontCharMap aFontCharMap;
//STRIP001         aShowSet.GetFontCharMap( aFontCharMap );
//STRIP001         pSubsetMap = new SubsetMap( &aFontCharMap );
//STRIP001 
//STRIP001         // update subset listbox for new font's unicode subsets
//STRIP001         aSubsetLB.Clear();
//STRIP001         // TODO: is it worth to improve the stupid linear search?
//STRIP001         bool bFirst = true;
//STRIP001         const Subset* s;
//STRIP001         while( NULL != (s = pSubsetMap->GetNextSubset( bFirst ))  )
//STRIP001         {
//STRIP001             USHORT nPos = aSubsetLB.InsertEntry( s->GetName() );
//STRIP001             aSubsetLB.SetEntryData( nPos, (void*)s );
//STRIP001             // NOTE: subset must live at least as long as the selected font
//STRIP001             if( bFirst )
//STRIP001                 aSubsetLB.SelectEntryPos( nPos );
//STRIP001             bFirst = false;
//STRIP001         }
//STRIP001         if( aSubsetLB.GetEntryCount() <= 1 )
//STRIP001             bNeedSubset = FALSE;
//STRIP001     }
//STRIP001 
//STRIP001     aSubsetText.Show( bNeedSubset);
//STRIP001     aSubsetLB.Show( bNeedSubset);
//STRIP001 
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharMapData, SubsetSelectHdl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001     USHORT nPos = aSubsetLB.GetSelectEntryPos();
//STRIP001     const Subset* pSubset = reinterpret_cast<const Subset*> (aSubsetLB.GetEntryData(nPos));
//STRIP001     if( pSubset )
//STRIP001     {
//STRIP001         sal_Unicode cFirst = pSubset->GetRangeMin();
//STRIP001         aShowSet.SelectCharacter( cFirst );
//STRIP001     }
//STRIP001     aSubsetLB.SelectEntryPos( nPos );
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharMapData, CharDoubleClickHdl, Control *, EMPTYARG )
//STRIP001 {
//STRIP001     mpDialog->EndDialog( TRUE );
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharMapData, CharSelectHdl, Control *, EMPTYARG )
//STRIP001 {
//STRIP001     if ( !bOne )
//STRIP001     {
//STRIP001         String aText = aShowText.GetText();
//STRIP001 
//STRIP001         if ( aText.Len() == CHARMAP_MAXLEN )
//STRIP001             Sound::Beep( SOUND_WARNING );
//STRIP001         else
//STRIP001         {
//STRIP001             if ( aShowSet.GetSelectCharacter() > 0 )
//STRIP001                 aText += aShowSet.GetSelectCharacter();
//STRIP001             aShowText.SetText( aText );
//STRIP001         }
//STRIP001 
//STRIP001     }
//STRIP001     aOKBtn.Enable();
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharMapData, CharHighlightHdl, Control *, EMPTYARG )
//STRIP001 {
//STRIP001     String aTemp;
//STRIP001     sal_Unicode c = aShowSet.GetSelectCharacter();
//STRIP001     sal_Bool bSelect = ( c > 0 );
//STRIP001     if ( bSelect )
//STRIP001     {
//STRIP001         aTemp = c;
//STRIP001         const Subset* pSubset = NULL;
//STRIP001         if( pSubsetMap )
//STRIP001             pSubset = pSubsetMap->GetSubsetByUnicode( c );
//STRIP001         if( pSubset )
//STRIP001             aSubsetLB.SelectEntry( pSubset->GetName() );
//STRIP001         else
//STRIP001             aSubsetLB.SetNoSelection();
//STRIP001     }
//STRIP001     aShowChar.SetText( aTemp );
//STRIP001     aShowChar.Update();
//STRIP001     if ( bSelect )
//STRIP001     {
//STRIP001         // no sprintf or hex-formatter around :-(
//STRIP001         char buf[16] = "U+0000";
//STRIP001         sal_Unicode c_Shifted = c;
//STRIP001         for( int i = 0; i < 4; ++i )
//STRIP001         {
//STRIP001             char h = c_Shifted & 0x0F;
//STRIP001             buf[5-i] = (h > 9) ? (h - 10 + 'A') : (h + '0');
//STRIP001             c_Shifted >>= 4;
//STRIP001         }
//STRIP001         if( c < 256 )
//STRIP001             snprintf( buf+6, 10, " (%d)", c );
//STRIP001         aTemp = String::CreateFromAscii( buf );
//STRIP001     }
//STRIP001     aCharCodeText.SetText( aTemp );
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharMapData, CharPreSelectHdl, Control *, EMPTYARG )
//STRIP001 {
//STRIP001     // adjust subset selection
//STRIP001     if( pSubsetMap )
//STRIP001     {
//STRIP001         sal_Unicode cChar = aShowSet.GetSelectCharacter();
//STRIP001         const Subset* pSubset = pSubsetMap->GetSubsetByUnicode( cChar );
//STRIP001         if( pSubset )
//STRIP001             aSubsetLB.SelectEntry( pSubset->GetName() );
//STRIP001     }
//STRIP001 
//STRIP001     aOKBtn.Enable();
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxCharMapData, DeleteHdl, PushButton *, EMPTYARG )
//STRIP001 {
//STRIP001     aShowText.SetText( String() );
//STRIP001     aOKBtn.Disable();
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // class SubsetMap =======================================================
//STRIP001 // TODO: should be moved into Font Attributes stuff
//STRIP001 // we let it mature here though because it is currently the only use
//STRIP001 
//STRIP001 SubsetMap::SubsetMap( const FontCharMap* pFontCharMap )
//STRIP001 :   Resource( ResId( SVX_RES(RID_SUBSETMAP) ) )
//STRIP001 {
//STRIP001     InitList();
//STRIP001     ApplyCharMap( pFontCharMap );
//STRIP001     FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 const Subset* SubsetMap::GetNextSubset( bool bFirst ) const
//STRIP001 {
//STRIP001     if( bFirst )
//STRIP001         maSubsetIterator = maSubsets.begin();
//STRIP001     if( maSubsetIterator == maSubsets.end() )
//STRIP001         return NULL;
//STRIP001     const Subset* s = &*(maSubsetIterator++);
//STRIP001     return s;
//STRIP001 }
//STRIP001 
//STRIP001 const Subset* SubsetMap::GetSubsetByUnicode( sal_Unicode cChar ) const
//STRIP001 {
//STRIP001     // TODO: is it worth to avoid a linear search?
//STRIP001     for( const Subset* s = GetNextSubset( true ); s; s = GetNextSubset( false ) )
//STRIP001         if( (s->GetRangeMin() <= cChar) && (cChar <= s->GetRangeMax()) )
//STRIP001             return s;
//STRIP001     return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 inline Subset::Subset( sal_Unicode nMin, sal_Unicode nMax, int resId)
//STRIP001 :   mnRangeMin(nMin), mnRangeMax(nMax), maRangeName( ResId(resId) )
//STRIP001 {}
//STRIP001 
//STRIP001 void SubsetMap::InitList()
//STRIP001 {
//STRIP001     static SubsetList aAllSubsets;
//STRIP001     static bool bInit = true;
//STRIP001     if( bInit )
//STRIP001     {
//STRIP001         bInit = false;
//STRIP001     
//STRIP001         // TODO: eventually merge or split unicode subranges
//STRIP001         //       a "native writer" should decide for his subsets
//STRIP001         aAllSubsets.push_back( Subset( 0x0020, 0x007F, RID_SUBSETSTR_BASIC_LATIN ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0080, 0x00FF, RID_SUBSETSTR_LATIN_1 ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0100, 0x017F, RID_SUBSETSTR_LATIN_EXTENDED_A ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0180, 0x024F, RID_SUBSETSTR_LATIN_EXTENDED_B ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0250, 0x02AF, RID_SUBSETSTR_IPA_EXTENSIONS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x02B0, 0x02FF, RID_SUBSETSTR_SPACING_MODIFIERS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0300, 0x036F, RID_SUBSETSTR_COMB_DIACRITICAL ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0370, 0x03FF, RID_SUBSETSTR_BASIC_GREEK ) );
//STRIP001     //  aAllSubsets.push_back( Subset( 0x03D0, 0x03F3, RID_SUBSETSTR_GREEK_SYMS_COPTIC ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0400, 0x04FF, RID_SUBSETSTR_CYRILLIC ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0530, 0x058F, RID_SUBSETSTR_ARMENIAN ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0590, 0x05FF, RID_SUBSETSTR_BASIC_HEBREW ) );
//STRIP001     //  aAllSubsets.push_back( Subset( 0x0591, 0x05C4, RID_SUBSETSTR_HEBREW_EXTENDED ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0600, 0x065F, RID_SUBSETSTR_BASIC_ARABIC ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0660, 0x06FF, RID_SUBSETSTR_ARABIC_EXTENDED ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0700, 0x074F, RID_SUBSETSTR_SYRIAC ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0780, 0x07BF, RID_SUBSETSTR_THAANA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0900, 0x097F, RID_SUBSETSTR_DEVANAGARI ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0980, 0x09FF, RID_SUBSETSTR_BENGALI ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0A00, 0x0A7F, RID_SUBSETSTR_GURMUKHI ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0A80, 0x0AFF, RID_SUBSETSTR_GUJARATI ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0B00, 0x0B7F, RID_SUBSETSTR_ORIYA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0B80, 0x0BFF, RID_SUBSETSTR_TAMIL ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0C00, 0x0C7F, RID_SUBSETSTR_TELUGU ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0C80, 0x0CFF, RID_SUBSETSTR_KANNADA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0D00, 0x0D7F, RID_SUBSETSTR_MALAYALAM ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0D80, 0x0DFF, RID_SUBSETSTR_SINHALA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0E00, 0x0E7F, RID_SUBSETSTR_THAI ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0E80, 0x0EFF, RID_SUBSETSTR_LAO ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x0F00, 0x0FBF, RID_SUBSETSTR_TIBETAN ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x1000, 0x109F, RID_SUBSETSTR_MYANMAR ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x10A0, 0x10FF, RID_SUBSETSTR_BASIC_GEORGIAN ) );
//STRIP001     //  aAllSubsets.push_back( Subset( 0x10A0, 0x10C5, RID_SUBSETSTR_GEORGIAN_EXTENDED ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x1100, 0x11FF, RID_SUBSETSTR_HANGUL_JAMO ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x1200, 0x137F, RID_SUBSETSTR_ETHIOPIC ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x13A0, 0x13FF, RID_SUBSETSTR_CHEROKEE ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x1400, 0x167F, RID_SUBSETSTR_CANADIAN_ABORIGINAL ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x1680, 0x169F, RID_SUBSETSTR_OGHAM ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x16A0, 0x16F0, RID_SUBSETSTR_RUNIC ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x1700, 0x171F, RID_SUBSETSTR_TAGALOG ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x1720, 0x173F, RID_SUBSETSTR_HANUNOO ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x1740, 0x175F, RID_SUBSETSTR_BUHID ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x1760, 0x177F, RID_SUBSETSTR_TAGBANWA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x1780, 0x17FF, RID_SUBSETSTR_KHMER ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x1800, 0x18AF, RID_SUBSETSTR_MONGOLIAN ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x1E00, 0x1EFF, RID_SUBSETSTR_LATIN_EXTENDED_ADDS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x1F00, 0x1FFF, RID_SUBSETSTR_GREEK_EXTENDED ) );
//STRIP001 
//STRIP001         aAllSubsets.push_back( Subset( 0x2000, 0x206F, RID_SUBSETSTR_GENERAL_PUNCTUATION ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2070, 0x209F, RID_SUBSETSTR_SUB_SUPER_SCRIPTS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x20A0, 0x20CF, RID_SUBSETSTR_CURRENCY_SYMBOLS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x20D0, 0x20FF, RID_SUBSETSTR_COMB_DIACRITIC_SYMS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2100, 0x214F, RID_SUBSETSTR_LETTERLIKE_SYMBOLS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2150, 0x218F, RID_SUBSETSTR_NUMBER_FORMS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2190, 0x21FF, RID_SUBSETSTR_ARROWS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2200, 0x22FF, RID_SUBSETSTR_MATH_OPERATORS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2300, 0x23FF, RID_SUBSETSTR_MISC_TECHNICAL ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2400, 0x243F, RID_SUBSETSTR_CONTROL_PICTURES ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2440, 0x245F, RID_SUBSETSTR_OPTICAL_CHAR_REC ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2460, 0x24FF, RID_SUBSETSTR_ENCLOSED_ALPHANUM ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2500, 0x257F, RID_SUBSETSTR_BOX_DRAWING ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2580, 0x259F, RID_SUBSETSTR_BLOCK_ELEMENTS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x25A0, 0x25FF, RID_SUBSETSTR_GEOMETRIC_SHAPES ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2600, 0x26FF, RID_SUBSETSTR_MISC_DINGBATS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2700, 0x27BF, RID_SUBSETSTR_DINGBATS ) );
//STRIP001 
//STRIP001         aAllSubsets.push_back( Subset( 0x27C0, 0x27FF, RID_SUBSETSTR_MISC_MATH_SYMS_A ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x27F0, 0x27FF, RID_SUBSETSTR_SUPPL_ARROWS_A ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2800, 0x28FF, RID_SUBSETSTR_BRAILLE_PATTERNS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2900, 0x297F, RID_SUBSETSTR_SUPPL_ARROWS_B ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2980, 0x29FF, RID_SUBSETSTR_MISC_MATH_SYMS_B ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2E80, 0x2EFF, RID_SUBSETSTR_CJK_RADICAL_SUPPL ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2F00, 0x2FDF, RID_SUBSETSTR_KANXI_RADICALS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x2FF0, 0x2FFF, RID_SUBSETSTR_IDEO_DESC_CHARS ) );
//STRIP001 
//STRIP001         aAllSubsets.push_back( Subset( 0x3000, 0x303F, RID_SUBSETSTR_CJK_SYMS_PUNCTUATION ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x3040, 0x309F, RID_SUBSETSTR_HIRAGANA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x30A0, 0x30FF, RID_SUBSETSTR_KATAKANA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x3100, 0x312F, RID_SUBSETSTR_BOPOMOFO ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x3130, 0x318F, RID_SUBSETSTR_HANGUL_COMPAT_JAMO ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x3190, 0x319F, RID_SUBSETSTR_KANBUN ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x31A0, 0x31BF, RID_SUBSETSTR_BOPOMOFO_EXTENDED ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x31C0, 0x31FF, RID_SUBSETSTR_KATAKANA_PHONETIC ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x3200, 0x32FF, RID_SUBSETSTR_ENCLOSED_CJK_LETTERS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x3300, 0x33FF, RID_SUBSETSTR_CJK_COMPATIBILITY ) );
//STRIP001 
//STRIP001         aAllSubsets.push_back( Subset( 0x3400, 0x4DFF, RID_SUBSETSTR_CJK_EXT_A_UNIFIED_IDGRAPH ) );
//STRIP001         aAllSubsets.push_back( Subset( 0x4E00, 0x9FA5, RID_SUBSETSTR_CJK_UNIFIED_IDGRAPH ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xA000, 0xA4CF, RID_SUBSETSTR_YI ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xAC00, 0xB097, RID_SUBSETSTR_HANGUL_GA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xB098, 0xB2E3, RID_SUBSETSTR_HANGUL_NA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xB2E4, 0xB77B, RID_SUBSETSTR_HANGUL_DA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xB77C, 0xB9C7, RID_SUBSETSTR_HANGUL_RA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xB9C8, 0xBC13, RID_SUBSETSTR_HANGUL_MA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xBC14, 0xC0AB, RID_SUBSETSTR_HANGUL_BA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xC0AC, 0xC543, RID_SUBSETSTR_HANGUL_SA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xC544, 0xC78F, RID_SUBSETSTR_HANGUL_AH ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xC790, 0xCC27, RID_SUBSETSTR_HANGUL_JA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xCC28, 0xCE73, RID_SUBSETSTR_HANGUL_CHA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xCE74, 0xD0BF, RID_SUBSETSTR_HANGUL_KA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xD0C0, 0xD30B, RID_SUBSETSTR_HANGUL_TA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xD30C, 0xD557, RID_SUBSETSTR_HANGUL_PA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xD558, 0xD7A3, RID_SUBSETSTR_HANGUL_HA ) );
//STRIP001     //  aAllSubsets.push_back( Subset( 0xAC00, 0xD7AF, RID_SUBSETSTR_HANGUL ) );
//STRIP001 
//STRIP001     //  aAllSubsets.push_back( Subset( 0xD800, 0xDFFF, RID_SUBSETSTR_SURROGATE ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xE000, 0xF8FF, RID_SUBSETSTR_PRIVATE_USE_AREA ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xF900, 0xFAFF, RID_SUBSETSTR_CJK_COMPAT_IDGRAPHS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xFB00, 0xFB4F, RID_SUBSETSTR_ALPHA_PRESENTATION ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xFB50, 0xFDFF, RID_SUBSETSTR_ARABIC_PRESENT_A ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xFE20, 0xFE2F, RID_SUBSETSTR_COMBINING_HALF_MARKS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xFE30, 0xFE4F, RID_SUBSETSTR_CJK_COMPAT_FORMS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xFE50, 0xFE6F, RID_SUBSETSTR_SMALL_FORM_VARIANTS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xFE70, 0xFEFF, RID_SUBSETSTR_ARABIC_PRESENT_B ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xFF00, 0xFFEF, RID_SUBSETSTR_HALFW_FULLW_FORMS ) );
//STRIP001         aAllSubsets.push_back( Subset( 0xFFF0, 0xFFFF, RID_SUBSETSTR_SPECIALS ) );
//STRIP001     }
//STRIP001 
//STRIP001     maSubsets = aAllSubsets;
//STRIP001 }
//STRIP001 
//STRIP001 void SubsetMap::ApplyCharMap( const FontCharMap* pFontCharMap )
//STRIP001 {
//STRIP001     if( !pFontCharMap )
//STRIP001         return;
//STRIP001 
//STRIP001     const int nRangeCount = pFontCharMap->GetRangeCount();
//STRIP001     sal_UCS4 cFirst, cLast = 0;
//STRIP001     int nRangeIndex = 0;
//STRIP001 
//STRIP001     // remove subsets that are not matched in any range
//STRIP001     // assuming subsetlist and fontcharmap are sorted
//STRIP001     SubsetList::iterator it = maSubsets.begin();
//STRIP001     while( (nRangeIndex < nRangeCount) && (it != maSubsets.end()) )
//STRIP001     {
//STRIP001         const Subset& rSubset = *it;
//STRIP001 
//STRIP001         if( cLast <= rSubset.GetRangeMin() )
//STRIP001         {
//STRIP001             // range too small for this subset => advance to next range
//STRIP001             pFontCharMap->GetRange( nRangeIndex++, cFirst, cLast );
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             SubsetList::iterator it_tmp = it++;
//STRIP001 
//STRIP001             // subset too big for this range => remove subset
//STRIP001             if( cFirst > rSubset.GetRangeMax()  )
//STRIP001                 maSubsets.erase( it_tmp );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     // remove subsets after highest cLast
//STRIP001     maSubsets.erase( it, maSubsets.end() );
//STRIP001 }
}
