/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_exchobj.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:25:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// includes *******************************************************************

#pragma hdrstop

#ifndef _FILELIST_HXX //autogen
#include <so3/filelist.hxx>
#endif
#include "exchobj.hxx"
namespace binfilter {

// globals ********************************************************************

#define EXCHANGEOBJ_OBJLIST_SIZE          5
#define EXCHANGEOBJ_OBJLIST_RESIZE        5
#define EXCHANGEOBJ_OBJLIST_DELEGATIONPOS 0

// rtti ***********************************************************************

//STRIP001 SO2_IMPL_BASIC_CLASS1( SfxExchangeObject, SvFactory,
//STRIP001 					   SvDataObject, SvGlobalName( 0x67493aa0, 0x8720, 0x11d0,
//STRIP001 												   0xa4, 0x1f, 0x44, 0x45,
//STRIP001 												   0x53, 0x54, 0x0, 0x0 ) );
//STRIP001 
//STRIP001 //*****************************************************************************
//STRIP001 // SfxExchangeObject
//STRIP001 //*****************************************************************************
//STRIP001 
//STRIP001 SfxExchangeObject::SfxExchangeObject()
//STRIP001 	: 	_pObjList( new SvDataObjectMemberList( EXCHANGEOBJ_OBJLIST_SIZE,
//STRIP001 											   EXCHANGEOBJ_OBJLIST_RESIZE ) ),
//STRIP001 		_pTypeList( NULL )
//STRIP001 /*
//STRIP001   [Beschreibung]
//STRIP001   Ueber diesen Ctor kann eine neues Objekt fuer einen neuen Datenaustausch
//STRIP001   angelegt werden.
//STRIP001 
//STRIP001   [Querverweise]
//STRIP001   <SfxExchangeObject::SfxExchangeObject( SvDataObject* )>
//STRIP001   */
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //*****************************************************************************
//STRIP001 
//STRIP001 SfxExchangeObject::SfxExchangeObject
//STRIP001 (
//STRIP001 	SvDataObject* pExternal    /* Datenobjekt, das keine Unterklasse der Klasse
//STRIP001 								  SfxExchangeObject ist */
//STRIP001 )
//STRIP001 	: _pObjList( new SvDataObjectMemberList( EXCHANGEOBJ_OBJLIST_SIZE,
//STRIP001 											 EXCHANGEOBJ_OBJLIST_RESIZE ) ),
//STRIP001 	  _pTypeList( NULL )
//STRIP001 
//STRIP001 /*
//STRIP001   [Beschreibung]
//STRIP001   Ueber diesen Ctor kann ein eine Instanz einer Unterklasse der Klasse
//STRIP001   <SvDataObject>, die nicht von <SfxExchangeObject> abgeleitet ist, wie selbige
//STRIP001   angesteuert werden.
//STRIP001   */
//STRIP001 {
//STRIP001 	DBG_ASSERT( pExternal, "SfxExchangeObject:ungueltiges Objekt" );
//STRIP001 	DBG_ASSERT( !SfxExchangeObjectRef( pExternal ).Is(),
//STRIP001 				"SfxExchangeObject:Objekt ist ein <SfxExchangeObject>" );
//STRIP001 	// Referenzanlage, da das Objekt u.U. nicht weiter verwendet wird
//STRIP001 	SvDataObjectRef xObj = pExternal;
//STRIP001 
//STRIP001 	// Pruefung, ob das Objekt eine Dateiliste enthaelt
//STRIP001 	const SvDataTypeList& rList = pExternal->GetTypeList();
//STRIP001 	if ( rList.Get( FORMAT_FILE_LIST ) )
//STRIP001 	{
//STRIP001 		// Erzeugung einzelner Eintraege, damit die Kunden der Klasse
//STRIP001 		// keine Sonderbehandlung machen muessen
//STRIP001 		SvData aData( FORMAT_FILE_LIST );
//STRIP001 		pExternal->GetData( &aData );
//STRIP001 		FileList* pFileList;
//STRIP001 		if ( aData.GetData( ( SvDataCopyStream** ) &pFileList,
//STRIP001 							FileList::StaticType(), TRANSFER_MOVE ) )
//STRIP001 		{
//STRIP001 			ULONG nPos = pFileList->Count();
//STRIP001 			DBG_ASSERT( nPos, "SfxExchangeObject:leere Dateiliste" );
//STRIP001 			while ( nPos-- )
//STRIP001 			{
//STRIP001 				SvDataMemberObjectRef xObject = new SvDataMemberObject();
//STRIP001 				SvData* pData = new SvData( FORMAT_FILE, MEDIUM_MEMORY );
//STRIP001 				pData->SetData( pFileList->GetFile( nPos ) );
//STRIP001 				xObject->Append( pData );
//STRIP001 				Insert( xObject );
//STRIP001 			}
//STRIP001 
//STRIP001 			delete pFileList;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Pruefung, ob eine Dateiliste aufgeloest wurde
//STRIP001 	if ( !_pObjList->Count() )
//STRIP001 	{
//STRIP001 		Insert( pExternal );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //*****************************************************************************
//STRIP001 
//STRIP001 SfxExchangeObject::~SfxExchangeObject()
//STRIP001 {
//STRIP001 	delete _pTypeList;
//STRIP001 	delete _pObjList;
//STRIP001 }
//STRIP001 
//STRIP001 //*****************************************************************************
//STRIP001 
//STRIP001 SfxExchangeObjectRef SfxExchangeObject::DetectObject_Impl
//STRIP001 (
//STRIP001 	SvDataObject* pObj    // zu pruefendes Objekt
//STRIP001 )
//STRIP001 /*
//STRIP001   [Beschreibung]
//STRIP001   Die statische Methode prueft, ob das spezifizierte Objekt eine Instanz der
//STRIP001   Klasse <SfxExchangeObject> ist. Ist dies nicht der Fall, so wird eine
//STRIP001   Instanz der Klasse <SfxExchangeObject> konstruiert, die alle Aufrufe auf das
//STRIP001   Objekt delegiert.
//STRIP001   */
//STRIP001 {
//STRIP001 	DBG_ASSERT( pObj, "SfxExchangeObject:ungueltiges Objekt" );
//STRIP001 
//STRIP001 	// Pruefung, ob es sich um eine Instanz der Klasse <SfxExchangeObject>
//STRIP001 	// handelt
//STRIP001 	SfxExchangeObjectRef xExchangeObj( pObj );
//STRIP001 	if ( !xExchangeObj.Is() )
//STRIP001 	{
//STRIP001 		// Erzeugung einer Instanz der Klasse <SfxExchangeObject>, die alle
//STRIP001 		// Aufrufe auf die Instanz delegiert
//STRIP001 		xExchangeObj = new SfxExchangeObject( pObj );
//STRIP001 	}
//STRIP001 	return xExchangeObj;
//STRIP001 }
//STRIP001 
//STRIP001 //*****************************************************************************
//STRIP001 
//STRIP001 BOOL SfxExchangeObject::SetFileList_Impl
//STRIP001 (
//STRIP001 	SvData* pData    // Objekt, an dem die Daten gesetzt werden sollen
//STRIP001 ) const
//STRIP001 /*
//STRIP001   [Beschreibung]
//STRIP001   Die Methode setzt an der spezifizierten Instanz eine Liste von Dateien.
//STRIP001 
//STRIP001   [Anmerkungen]
//STRIP001   Die Methode wird nur gerufen, wenn alle Objekte innerhalb der Instanz, das
//STRIP001   Format fuer Dateien unterstuetzt.
//STRIP001 
//STRIP001   [Rueckgabewert]
//STRIP001   FALSE, wenn die Aktion fehlgeschlagen ist
//STRIP001   ...
//STRIP001   */
//STRIP001 {
//STRIP001 	DBG_ASSERT( pData, "SfxExchangeObject:ungueltiges Objekt" );
//STRIP001 	DBG_ASSERT( pData->GetFormat() ==  FORMAT_FILE_LIST,
//STRIP001 				"SfxExchangeObject:falsches Format fuer SetFileList_Impl" );
//STRIP001 	DBG_ASSERT( _pTypeList && _pTypeList->Get( FORMAT_FILE_LIST ),
//STRIP001 				"SfxExchangeObject:Format wird nicht unterstuetzt" );
//STRIP001 
//STRIP001 	// Iteration ueber alle Objekte
//STRIP001 	FileList* pList = new FileList();
//STRIP001 	ULONG nPos = Count();
//STRIP001 	DBG_ASSERT( nPos,
//STRIP001 				"SfxExchangeObject:Dateiliste mit keinem Objekt" );
//STRIP001 	String aFilename;
//STRIP001 	SvData* pTempData = new SvData( FORMAT_FILE, MEDIUM_MEMORY );
//STRIP001 	while ( nPos-- )
//STRIP001 	{
//STRIP001 		// Bestimmung des Dateinamens
//STRIP001 		SvDataObject* pObj = GetObject( nPos );
//STRIP001 		BOOL bResult = pObj->GetData( pTempData );
//STRIP001 		if ( !bResult )
//STRIP001 		{
//STRIP001 			delete pList;
//STRIP001 			delete pTempData;
//STRIP001 			return FALSE;
//STRIP001 		}
//STRIP001 		bResult = pTempData->GetData( aFilename );
//STRIP001 		if ( !bResult )
//STRIP001 		{
//STRIP001 			delete pList;
//STRIP001 			delete pTempData;
//STRIP001 			return FALSE;
//STRIP001 		}
//STRIP001 		pList->AppendFile( aFilename );
//STRIP001 	}
//STRIP001 	// Setzung der Liste der Dateinamen am Zielobjekt
//STRIP001 	delete pTempData;
//STRIP001 	pData->SetData( pList, TRANSFER_MOVE );
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 //*****************************************************************************
//STRIP001 
//STRIP001 const SvDataTypeList& SfxExchangeObject::GetTypeList() const
//STRIP001 /*
//STRIP001   [Beschreibung]
//STRIP001   Die Methode wird gerufen, um zu bestimmen, welche Datenformate und Medien
//STRIP001   die Instanz unterstuetzt. Sie delegiert den Aufruf auf ein Objekt des
//STRIP001   Datenaustausches.
//STRIP001 
//STRIP001   [Anmerkungen]
//STRIP001   Das Standardinterface sollte nur aus dem externen Bereich verwendet werden.
//STRIP001   Ansonsten sollte immer direkt ein Objekt aus der Liste angesteuert werden.
//STRIP001 
//STRIP001   [Rueckgabewert]
//STRIP001   die Liste der Datenformate und Medien
//STRIP001 
//STRIP001   [Querverweise]
//STRIP001   <SfxExchangeObject::GetData( SvData* )>
//STRIP001   */
//STRIP001 {
//STRIP001 	DBG_ASSERT( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS < Count(),
//STRIP001 				"SfxExchangeObject:Objekt fuer Delegation fehlt" );
//STRIP001 
//STRIP001 	const SvDataTypeList& rList =
//STRIP001 		GetObject( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS )->GetTypeList();
//STRIP001 
//STRIP001 	// Pruefung, ob alle Datenobjekte das Format fuer Dateien unterstuetzen
//STRIP001 	if ( !rList.Get( FORMAT_FILE_LIST ) )
//STRIP001 	{
//STRIP001 		if ( !_pTypeList )
//STRIP001 		{
//STRIP001 			BOOL bSupport = TRUE;
//STRIP001 			USHORT nPos = Count();
//STRIP001 			while ( nPos-- )
//STRIP001 			{
//STRIP001 				SvDataObject* pObj = GetObject( nPos );
//STRIP001 				const SvDataTypeList& rObjList = pObj->GetTypeList();
//STRIP001 				if ( !rObjList.Get( FORMAT_FILE ) )
//STRIP001 				{
//STRIP001 					bSupport = FALSE;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			( ( SfxExchangeObject* )( this ) )->_pTypeList =
//STRIP001 				new SvDataTypeList( rList );
//STRIP001 			if ( bSupport )
//STRIP001 			{
//STRIP001 				( ( SfxExchangeObject* )( this ) )->_pTypeList->
//STRIP001 					Insert( SvDataType( FORMAT_FILE_LIST,
//STRIP001 										MEDIUM_MEMORY ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( _pTypeList )
//STRIP001 		{
//STRIP001 			return *_pTypeList;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return rList;
//STRIP001 }
//STRIP001 
//STRIP001 //*****************************************************************************
//STRIP001 
//STRIP001 const SvDataTypeList& SfxExchangeObject::GetSetDataTypeList() const
//STRIP001 /*
//STRIP001   [Beschreibung]
//STRIP001   Die Methode wird gerufen, um zu bestimmen, welche Datenformate und Medien
//STRIP001   an der Instanz gesetzt werden koennen. Sie delegiert den Aufruf auf ein
//STRIP001   Objekt des Datenaustausches.
//STRIP001 
//STRIP001   [Anmerkungen]
//STRIP001   Das Standardinterface sollte nur aus dem externen Bereich verwendet werden.
//STRIP001   Ansonsten sollte immer direkt ein Objekt aus der Liste angesteuert werden.
//STRIP001 
//STRIP001   [Rueckgabewert]
//STRIP001   die Liste der Datenformate und Medien
//STRIP001 
//STRIP001   [Querverweise]
//STRIP001   <SfxExchangeObject::SetData( SvData* )>
//STRIP001   */
//STRIP001 {
//STRIP001 	DBG_ASSERT( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS < Count(),
//STRIP001 				"SfxExchangeObject:Objekt fuer Delegation fehlt" );
//STRIP001 	return GetObject( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS )->
//STRIP001 		GetSetDataTypeList();
//STRIP001 }
//STRIP001 
//STRIP001 //*****************************************************************************
//STRIP001 
//STRIP001 BOOL SfxExchangeObject::SetData
//STRIP001 (
//STRIP001 	SvData* pData    // zu setzende Daten
//STRIP001 )
//STRIP001 /*
//STRIP001   [Beschreibung]
//STRIP001   Die Methode wird gerufen, um die spezifizierten Daten an der Instanz zu
//STRIP001   setzen. Sie delegiert den Aufruf auf ein Objekt des Datenaustausches.
//STRIP001 
//STRIP001   [Anmerkungen]
//STRIP001   Das Standardinterface sollte nur aus dem externen Bereich verwendet werden.
//STRIP001   Ansonsten sollte immer direkt ein Objekt aus der Liste angesteuert werden.
//STRIP001 
//STRIP001   [Rueckgabewert]
//STRIP001   FALSE, wenn die Aktion fehlgeschlagen ist
//STRIP001 
//STRIP001   [Querverweise]
//STRIP001   <SfxExchangeObject::GetData( SvData* )>
//STRIP001   <SfxExchangeObject::GetDataHere( SvData* )>
//STRIP001   */
//STRIP001 {
//STRIP001 	DBG_ASSERT( pData, "SfxExchangeObject:ungueltige Daten" );
//STRIP001 	DBG_ASSERT( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS < Count(),
//STRIP001 				"SfxExchangeObject:Objekt fuer Delegation fehlt" );
//STRIP001 	return GetObject( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS )->SetData( pData );
//STRIP001 }
//STRIP001 
//STRIP001 //*****************************************************************************
//STRIP001 
//STRIP001 BOOL SfxExchangeObject::GetData
//STRIP001 (
//STRIP001 	SvData* pData    // Objekt, an dem die Daten zu setzen sind
//STRIP001 )
//STRIP001 /*
//STRIP001   [Beschreibung]
//STRIP001   Die Methode wird gerufen, um die Daten der Instanz in dem spezifizierten
//STRIP001   Format in der spezifizierten Instanz abzulegen. Sie delegiert den Aufruf auf
//STRIP001   ein Objekt des Datenaustausches.
//STRIP001 
//STRIP001   [Anmerkungen]
//STRIP001   Das Standardinterface sollte nur aus dem externen Bereich verwendet werden.
//STRIP001   Ansonsten sollte immer direkt ein Objekt aus der Liste angesteuert werden.
//STRIP001 
//STRIP001   [Rueckgabewert]
//STRIP001   FALSE, wenn die Aktion fehlgeschlagen ist
//STRIP001 
//STRIP001   [Querverweise]
//STRIP001   <SfxExchangeObject::SetData( SvData* )>
//STRIP001   <SfxExchangeObject::GetDataHere( SvData* )>
//STRIP001   */
//STRIP001 {
//STRIP001 	DBG_ASSERT( pData, "SfxExchangeObject:ungueltige Daten" );
//STRIP001 	DBG_ASSERT( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS < Count(),
//STRIP001 				"SfxExchangeObject:Objekt fuer Delegation fehlt" );
//STRIP001 
//STRIP001 	// Pruefung, ob eine Liste von Dateinamen geliefert werden soll
//STRIP001 	if ( pData->GetFormat() == FORMAT_FILE_LIST && _pTypeList )
//STRIP001 	{
//STRIP001 		// Erzeugung der Liste der Dateienamen
//STRIP001 		return SetFileList_Impl( pData );
//STRIP001 	}
//STRIP001 	return GetObject( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS )->GetData( pData );
//STRIP001 }
//STRIP001 
//STRIP001 //*****************************************************************************
//STRIP001 
//STRIP001 BOOL SfxExchangeObject::GetDataHere
//STRIP001 (
//STRIP001 	SvData* pData    // Objekt, an dem die Daten zu setzen sind
//STRIP001 )
//STRIP001 /*
//STRIP001   [Beschreibung]
//STRIP001   Die Methode wird gerufen, um die Daten der Instanz in dem spezifizierten
//STRIP001   Format und ueber das spezifizierte Medium in der spezifizierten Instanz
//STRIP001   abzulegen. Sie delegiert den Aufruf auf ein Objekt des Datenaustausches.
//STRIP001 
//STRIP001   [Anmerkungen]
//STRIP001   Das Standardinterface sollte nur aus dem externen Bereich verwendet werden.
//STRIP001   Ansonsten sollte immer direkt ein Objekt aus der Liste angesteuert werden.
//STRIP001 
//STRIP001   [Rueckgabewert]
//STRIP001   FALSE, wenn die Aktion fehlgeschlagen ist
//STRIP001 
//STRIP001   [Querverweise]
//STRIP001   <SfxExchangeObject::SetData( SvData* )>
//STRIP001   <SfxExchangeObject::GetData( SvData* )>
//STRIP001   */
//STRIP001 {
//STRIP001 	DBG_ASSERT( pData, "SfxExchangeObject:ungueltige Daten" );
//STRIP001 	DBG_ASSERT( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS < Count(),
//STRIP001 				"SfxExchangeObject:Objekt fuer Delegation fehlt" );
//STRIP001 
//STRIP001 	// Pruefung, ob eine Liste von Dateinamen geliefert werden soll
//STRIP001 	if ( pData->GetFormat() == FORMAT_FILE_LIST && _pTypeList )
//STRIP001 	{
//STRIP001 		// Erzeugung der Liste der Dateienamen
//STRIP001 		return SetFileList_Impl( pData );
//STRIP001 	}
//STRIP001 	return GetObject( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS )->
//STRIP001 		GetDataHere( pData );
//STRIP001 }
//STRIP001 
//STRIP001 //*****************************************************************************
//STRIP001 
//STRIP001 BOOL SfxExchangeObject::QueryDataType
//STRIP001 (
//STRIP001 	SvDataType& rInOutType    // optimales Medium, optimales Format
//STRIP001 )
//STRIP001 /*
//STRIP001   [Beschreibung]
//STRIP001   Die Methode wird gerufen, um das beste Format und das beste Medium zu
//STRIP001   bestimmen Daten. Sie delegiert den Aufruf auf ein Objekt des
//STRIP001   Datenaustausches.
//STRIP001 
//STRIP001   [Anmerkungen]
//STRIP001   Das Standardinterface sollte nur aus dem externen Bereich verwendet werden.
//STRIP001   Ansonsten sollte immer direkt ein Objekt aus der Liste angesteuert werden.
//STRIP001 
//STRIP001   [Rueckgabewert]
//STRIP001   FALSE, wenn die Aktion fehlgeschlagen ist
//STRIP001 
//STRIP001   [Querverweise]
//STRIP001   <SfxExchangeObject::SetData( SvData* )>
//STRIP001   <SfxExchangeObject::GetData( SvData* )>
//STRIP001   <SfxExchangeObject::GetDataHere( SvData* )>
//STRIP001   */
//STRIP001 {
//STRIP001 	DBG_ASSERT( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS < Count(),
//STRIP001 				"SfxExchangeObject:Objekt fuer Delegation fehlt" );
//STRIP001 
//STRIP001 	// Pruefung, ob das Format fuer Dateilisten unterstuetzt wird
//STRIP001 	const SvDataType* pType;
//STRIP001 	if ( _pTypeList && ( pType = _pTypeList->Get( FORMAT_FILE_LIST ) ) )
//STRIP001 	{
//STRIP001 		// Format fuer Dateilisten als bevorzugtes Format
//STRIP001 		rInOutType = *pType;
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return GetObject( EXCHANGEOBJ_OBJLIST_DELEGATIONPOS )->
//STRIP001 		QueryDataType( rInOutType );
//STRIP001 }
//STRIP001 
//STRIP001 //*****************************************************************************
//STRIP001 
//STRIP001 SfxExchangeObjectRef SfxExchangeObject::PasteClipboard()
//STRIP001 /*
//STRIP001   [Beschreibung]
//STRIP001   Die statische Methode prueft, ob in der Zwischenablage eine Instanz der
//STRIP001   Klasse <SfxExchangeObject> steht. Ist dieses der Fall wird selbige geliefert.
//STRIP001   Ansonsten wird eine Instanz der Klasse <SfxExchangeObject> erstellt die
//STRIP001   alle Aufrufe auf die Instanz delegiert.
//STRIP001 
//STRIP001   [Rueckgabewert]
//STRIP001   NULL, wenn die Zwischenablage leer ist
//STRIP001   ...
//STRIP001   */
//STRIP001 {
//STRIP001 	SvDataObjectRef xObj = SvDataObject::PasteClipboard();
//STRIP001 	if ( !xObj.Is() )
//STRIP001 	{
//STRIP001 #ifndef MAC
//STRIP001 		return (SfxExchangeObjectRef)xObj;
//STRIP001 #else
//STRIP001 		return xObj;
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	// Bestimmung einer Instanz der Klasse <SfxExchangeObject>
//STRIP001 	return DetectObject_Impl( xObj );
//STRIP001 }
//STRIP001 
//STRIP001 //*****************************************************************************
//STRIP001 
//STRIP001 SfxExchangeObjectRef SfxExchangeObject::PasteDragServer
//STRIP001 (
//STRIP001 	const DropEvent& rEvt    // Ereignisdaten
//STRIP001 )
//STRIP001 /*
//STRIP001   [Beschreibung]
//STRIP001   Die statische Methode prueft, ob in beim D&D-Vorgang eine Instanz der Klasse
//STRIP001   <SfxExchangeObject> verwendet wird. Ist dieses der Fall wird selbige
//STRIP001   geliefert.  Ansonsten wird eine Instanz der Klasse <SfxExchangeObject>
//STRIP001   erstellt die alle Aufrufe auf die Instanz delegiert.
//STRIP001 
//STRIP001   [Rueckgabewert]
//STRIP001   NULL, wenn kein Objekt verfuegbar ist
//STRIP001   ...
//STRIP001   */
//STRIP001 {
//STRIP001 	SvDataObjectRef xObj = SvDataObject::PasteDragServer( rEvt );
//STRIP001 	if ( !xObj.Is() )
//STRIP001 	{
//STRIP001 #ifndef MAC
//STRIP001 		return (SfxExchangeObjectRef)xObj;
//STRIP001 #else
//STRIP001 		return xObj;
//STRIP001 #endif
//STRIP001 	}
//STRIP001 
//STRIP001 	// Bestimmung einer Instanz der Klasse <SfxExchangeObject>
//STRIP001 	return DetectObject_Impl( xObj );
//STRIP001 }


}
