/*************************************************************************
 *
 *  $RCSfile: sw3redln.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 14:20:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _DOC_HXX //autogen
#include <doc.hxx>
#endif
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif
#ifndef _REDLINE_HXX //autogen
#include <redline.hxx>
#endif

#ifndef _SVX_COLRITEM_HXX //autogen
#include <svx/colritem.hxx>
#endif
#ifndef _SVX_UDLNITEM_HXX //autogen
#include <svx/udlnitem.hxx>
#endif
#ifndef _SVX_CRSDITEM_HXX //autogen
#include <svx/crsditem.hxx>
#endif

#include "sw3marks.hxx"
#include "sw3imp.hxx"


// lokaler Record in SWG_REDLINES
#define SWG_REDLINE_LCL 'R'

// lokaler Record in SWG_REDLINE
#define SWG_REDLINEDATA_LCL 'D'

void Sw3StringPool::SetupRedlines( SwDoc& rDoc )
{
	const SwRedlineTbl& rRedlines = rDoc.GetRedlineTbl();
	for( USHORT i=0; i<rRedlines.Count(); i++ )
	{
		const SwRedline *pRedline = rRedlines[i];
		for( USHORT j=0; j<pRedline->GetStackCount(); j++ )
			Add( pRedline->GetAuthorString(j), USHRT_MAX );
	}
}

/*  */

// REDLINE:
// BYTE		Flags
// 			0x10 - visisble Flags
// UINT16	Anzahl REDLINEDATA
// REDLINEDTA*
//
// REDLINEDATA:
// BYTE		Flags
// BYTE		Redline-Typ
// UINT16	String-Pool-Index des Autors
// UINT32	Datum
// UINT32	Uhrzeit
// String	Kommentar

void Sw3IoImp::InRedline()
{
	OpenRec( SWG_REDLINE_LCL );

	BYTE cFlags = OpenFlagRec();

	UINT16 nCount;
	*pStrm >> nCount;

	CloseFlagRec();

	SwRedlineData *pData = 0;
	for( USHORT i=0; i<nCount; i++ )
	{
		OpenRec( SWG_REDLINEDATA_LCL );

		BYTE cDFlags = OpenFlagRec();

		BYTE cType;
		UINT16 nStrIdx;

		*pStrm 	>> cType
				>> nStrIdx;
		CloseFlagRec();

		UINT32 nDate, nTime;
		String aComment;
		*pStrm 	>> nDate
				>> nTime;
		InString( *pStrm, aComment );

		// Das oberste Element des Stack wurde als letztes geschrieben.
		USHORT nAuthorIdx;
		if( bNormal && !bInsert )
			nAuthorIdx = pDoc->InsertRedlineAuthor(aStringPool.Find(nStrIdx));
		else
			nAuthorIdx = pDoc->GetRedlineAuthor();

		pData =	new SwRedlineData( (SwRedlineType)cType, nAuthorIdx,
								   DateTime( nDate, nTime ), aComment,
								   pData );

		CloseRec( SWG_REDLINEDATA_LCL );
	}

	// Der PaM ist erstmal egal und wird erst spaeter gesetzt
	SwPosition aDummyPos( pDoc->GetNodes().GetEndOfExtras() );
	BOOL bVisible = (cFlags & 0x10) != 0;
	SwRedline *pRedline =
		new SwRedline( pData, aDummyPos, (cFlags & 0x10) != 0,
					   (cFlags & 0x20) != 0, (cFlags & 0x40) != 0 );

	// Weil der PaM noch nicht gueltig ist, merken wir uns die Redline
	// erstmal so und fuegen sie erst spaeter in das Dokument ein.
	if( !pRedlines )
		pRedlines = new Sw3Redlines;
	pRedlines->Insert( pRedline, pRedlines->Count() );

	CloseRec( SWG_REDLINE_LCL );
}


void Sw3IoImp::OutRedline( const SwRedline& rRedline )
{
	ASSERT( !IsSw31Or40Export(), "Redlines werden nicht exportiert!" );

	OpenRec( SWG_REDLINE_LCL );

	BYTE cFlags = 0x02;			// Count

	if( rRedline.IsVisible() )
		cFlags += 0x10;
	if( rRedline.IsDelLastPara() )
		cFlags += 0x20;
	if( rRedline.IsLastParaDelete() )
		cFlags += 0x40;

	USHORT i = rRedline.GetStackCount();

	*pStrm  << (BYTE)  cFlags
			<< (UINT16)i;

	// Die Redline-Data-Objekte werden von hinten nach vorne geschrieben,
	// das macht das Verketten beim Einlesen leichter.
	while( i )
	{
		i--;

		OpenRec( SWG_REDLINEDATA_LCL );

		cFlags = 0x03;	// Type + StrPool-Index des Autors
		UINT16 nStrIdx = aStringPool.Find( rRedline.GetAuthorString(i),
										   USHRT_MAX );
		*pStrm  << (BYTE)  cFlags
				<< (BYTE)  rRedline.GetType( i )
				<< (UINT16)nStrIdx;

		const DateTime& rDateTime = rRedline.GetTimeStamp( i );
		*pStrm  << (UINT32)rDateTime.GetDate()
				<< (UINT32)rDateTime.GetTime();
		OutString( *pStrm, rRedline.GetComment( i ) );

		CloseRec( SWG_REDLINEDATA_LCL );
	}

	CloseRec( SWG_REDLINE_LCL );
}

/*  */

// REDLINES:
// REDLINE*

void Sw3IoImp::InRedlines()
{
	if( pRedlines )
	{
		delete pRedlines;
		pRedlines = 0;
	}

	OpenRec( SWG_REDLINES );

	while( BytesLeft() )
		InRedline();

	CloseRec( SWG_REDLINES );
}

void Sw3IoImp::OutRedlines( BOOL bPageStyles )
{
	ASSERT( !IsSw31Or40Export(), "Redlines werden nicht exportiert!" );

	if( !pRedlines )
		return;

	ASSERT( !bBlock, "In Textbausteinen darf es keine Redlines geben!" );

	USHORT nArrLen = pRedlines->Count();
	if( nArrLen && bPageStyles )
	{
		ASSERT( nCntntRedlineStart <= nArrLen,
				"Mehr Redlines in Page-Styles als ueberhaupt vorhanden?" );
		nArrLen = nCntntRedlineStart;
	}
	ASSERT( bPageStyles || nCntntRedlineStart==0,
			"Wieso sind da noch Bookmarks aus Seitenvorlagen?" );
	if( !nArrLen )
		return;

	OpenRec( SWG_REDLINES );

	for( USHORT i = 0; i < nArrLen; i++ )
		OutRedline( *(*pRedlines)[i] );

	CloseRec( SWG_REDLINES );

	// Die Redlines eines Page-Styles muessen noch geloescht werden. Das
	// darf aber noch nicht hier passieren, weil wir die Redlines noch
	// beim rausschreiben der Markierungen brauchen.
}

/*  */

xub_StrLen lcl_sw3io_getNodeOff( const SwNodeIndex& rNdIdx, xub_StrLen nCntntIdx )
{
	// Hier tricksen wir ein wenig: Da Redlines auch auf Start- oder
	// Endnodes anfangen koennen, muessen wir die Positionen auch dann
	// Speichern, wenn Sections gespeichert werden. Um zu Unterscheiden,
	// ob der Start- oder der Endnode gemeint ist, nutzen wir die dann
	// unbenutzte Content-Position.
	const SwNode& rNode = rNdIdx.GetNode();
	if( rNode.IsCntntNode() )
	{
		if( nCntntIdx > STRING_MAXLEN52 )
			return STRING_MAXLEN52;
		else
			return nCntntIdx;
	}

	if( rNode.IsStartNode() )
		return 0;

	ASSERT( rNode.IsEndNode(), "Was ist denn das fuer ein Node?" );
	return USHRT_MAX;
}

void Sw3IoImp::CollectRedlines( SwPaM* pPaM, BOOL bPageOnly )
{
	ASSERT( !IsSw31Or40Export(), "Redlines werden nicht exportiert!" );

	delete pRedlines;
	pRedlines = new Sw3Redlines;
	nCntntRedlineStart = 0;

	const SwPosition *pPaMStart = pPaM ? pPaM->Start() : 0;
	const SwPosition *pPaMEnd = pPaM ? pPaM->End() : 0;
	ULONG nEndOfExtras = pDoc->GetNodes().GetEndOfExtras().GetIndex();

	const SwRedlineTbl& rRedlines = pDoc->GetRedlineTbl();
	for( USHORT i=0; i<rRedlines.Count(); i++ )
	{
		SwRedline *pRedline = rRedlines[i];
		const SwPosition *pPos = pRedline->Start();
		const SwPosition *pEndPos = pRedline->End();
		if( !pRedline->GetContentIdx() && *pPos == *pEndPos )
		{
			// "Leere" Redlines werden nicht gespeichert!
			ASSERT( !this, "Redline in leer" );
			continue;
		}

		// If the redline is within one node and starts behind the
		// last position that is possible within the 5.2 version,
		// it will be ignored.
		if( pPos->nContent.GetIndex() > STRING_MAXLEN52 &&
			pPos->nNode.GetIndex() == pEndPos->nNode.GetIndex() &&
			pEndPos->nContent.GetIndex() > STRING_MAXLEN52 )
			continue;

		if( pDoc->IsInHeaderFooter( pPos->nNode ) )
		{
			pRedlines->Insert( pRedline, nCntntRedlineStart );
			nCntntRedlineStart++;
		}
		else if( !bPageOnly )
		{
			// Bei gegebenen PaM alle Redlines mitnehmen, die in
			// Sonderbereichen liegen oder ganz oder teilweise im PaM.
			const SwPosition *pStart = pRedline->Start();
			SwComparePosition eCmp =
				bSaveAll || !pPaM || pStart->nNode.GetIndex() <= nEndOfExtras
						? POS_INSIDE
						: ComparePosition( *pStart, *pRedline->End(),
										   *pPaMStart, *pPaMEnd );
			if( POS_BEFORE != eCmp && POS_BEHIND != eCmp &&
				POS_COLLIDE_END != eCmp && POS_COLLIDE_START != eCmp )
				pRedlines->Insert( pRedline, pRedlines->Count() );
		}
	}

	if( !pRedlines->Count() )
	{
		// Keine Redlines? Dann nicht weiter.
		delete pRedlines;
		pRedlines = 0;
		return;
	}

	ASSERT( !bBlock, "In Textbausteinen darf es keine Redlines geben!" );

	Sw3Mark aMark;
	USHORT nArrLen = pRedlines->Count();

	if( !pRedlineMarks )
		pRedlineMarks = new Sw3Marks( 2*nArrLen, 2 );

	for( i = 0; i < nArrLen; i++ )
	{
		const SwRedline* pRedline = pRedlines->GetObject( i );

		if( i >= nCntntRedlineStart )
			aMark.SetId( i - nCntntRedlineStart );
		else
			aMark.SetId( i );

		// Bei gegebenen Redlines die Positionen auf den PaM reduzieren
		const SwPosition *pStart = pRedline->Start();
		const SwPosition *pEnd = pRedline->End();
		SwComparePosition eCmp =
			bSaveAll ||	!pPaM || pStart->nNode.GetIndex() <= nEndOfExtras
				? POS_INSIDE
				: ComparePosition( *pStart, *pEnd, *pPaMStart, *pPaMEnd );

		ASSERT( POS_BEFORE != eCmp && POS_BEHIND != eCmp &&
				POS_COLLIDE_END != eCmp && POS_COLLIDE_START != eCmp,
				"Redline mit ungeultigem Bereich" );

		if( POS_OUTSIDE == eCmp || POS_OVERLAP_BEFORE == eCmp )
			pStart = pPaMStart;
		if( POS_OUTSIDE == eCmp || POS_OVERLAP_BEHIND == eCmp )
			pEnd = pPaMEnd;

		aMark.SetType( SW3_REDLINE_START );
		aMark.SetNodePos( pStart->nNode.GetIndex() );
		aMark.SetNodeOff( lcl_sw3io_getNodeOff( pStart->nNode,
											pStart->nContent.GetIndex() ) );
		pRedlineMarks->Insert( new Sw3Mark(aMark) );

		if( pRedline->HasMark() )
		{
			// Wenn der PaM ein Mark besitzt, dann End die jeweils
			// andere Position.
			aMark.SetType( SW3_REDLINE_END );
			aMark.SetNodePos( pEnd->nNode.GetIndex() );
			aMark.SetNodeOff( lcl_sw3io_getNodeOff( pEnd->nNode,
											pEnd->nContent.GetIndex() ) );
			pRedlineMarks->Insert( new Sw3Mark(aMark) );
		}
	}
}

/*  */

// NODEREDLINE:
// BYTE		Flags
//			0x01 - End-Position einer Redline, sonst Start-Positiom
//			0x02 - Redline besitzt Section
// UINT16	Id der Redline (Array-Position)
// UINT16	Content-Position bzw. USHRT_MAX, wenn die Psoition dem zu
//			einem Start-Node gehoerenden ENd-Node bezeichnet.
// CONTENT?	Section (optional)

void Sw3IoImp::InNodeRedline( const SwNodeIndex& rNodeIdx, INT32& nCntntOff,
							  BYTE nInsFirstPara )
{
	OpenRec( SWG_NODEREDLINE );

	BYTE cFlags = OpenFlagRec();
	UINT16 nId, nNodeOff;
	*pStrm >> nId >> nNodeOff;
	CloseFlagRec();

	ASSERT( pRedlines && nId < pRedlines->Count(), "Ungueltige Redline-Id" );
	if( !pRedlines || nId >= pRedlines->Count() )
	{
		Error();
		CloseRec( SWG_NODEREDLINE );
		return;
	}

	SwRedline *pRedline = (*pRedlines)[nId];
	SwRedlineType eType = pRedline ? pRedline->GetType() : REDLINE_FLAG_MASK;
	if( REDLINE_INSERT != eType && REDLINE_DELETE != eType &&
		REDLINE_FORMAT != eType )
	{
		// Unbekannter oder noch nicht implementierter Redline-Typ:
		// Da ist es besser, wir ignorieren sie, denn wir koennen ja
		// sowieso nichts damit anfangen.
		ASSERT( !pRedline, "nicht implementierter Redline-Typ" );
		Warning();
		CloseRec( SWG_NODEREDLINE );
		return;
	}

	// Position setzen
	SwPosition *pPos;
	if( 0x10 & cFlags )
	{
		// bei End-Positionen Mark setzen
		pRedline->SetMark();
		pPos = pRedline->GetMark();
	}
	else
	{
		// sonst Point
		pPos = pRedline->GetPoint();
	}

	SwNode& rNode = rNodeIdx.GetNode();

	// Beim Einfuegen in den ersten Absatz sollten wir eine Content-Node
	// haben, in den wir an der uebergeben Position einfuegen.
	if( nInsFirstPara )
	{
		ASSERT( rNode.IsCntntNode(), "Content-Node beim Einf. erwartet" );
		ASSERT( USHRT_MAX==nNodeOff, "End-Node-Position beim Einf. erwartet" );
		nNodeOff = 0;	// Im IsCntntNode-Zweig gibts so die richtige Pos.
	}

	sal_Bool bInvalid = sal_False;
	// Positionen koennen auch auf Start- oder End-Nodes fallen.
	if( rNode.IsCntntNode() )
	{
		pPos->nNode = rNodeIdx;
		xub_StrLen nLen = rNode.GetCntntNode()->Len();
		xub_StrLen nIdx = static_cast< xub_StrLen >( nNodeOff+nCntntOff );
		ASSERT( nIdx>=0 && nIdx<=nLen, "ungueltiger Cntnt-Offset" );
		if( nIdx<0 || nIdx > nLen )
		{
			bInvalid = sal_True;
		}
		else
		{
			pPos->nContent.Assign( rNode.GetCntntNode(), nIdx );
		}
	}
	else
	{
		ASSERT( rNode.IsStartNode(), "Start-Node erwartet" );
		if( USHRT_MAX==nNodeOff )
		{
			pPos->nNode = rNode.EndOfSectionIndex();
		}
		else
		{
			pPos->nNode = rNodeIdx;

			ASSERT( 0==nNodeOff,
					"ungeueltige Content-Position fuer Start-Node" );
			if( 0 != nNodeOff )
				Warning();
		}
		pPos->nContent.Assign( 0, 0 );
	}

	if( cFlags & 0x20 )
	{
		if( (bNormal && bInsert) || bPageDescs )
		{
			if( REDLINE_INSERT == eType )
			{
				// Ein einefuegter Text wird nicht angezeigt. Dann muss der
				// eingefuegt Text an der entsprechenden Position eingfuegt
				// werden.
				if( !nInsFirstPara && !pPos->nNode.GetNode().IsCntntNode() &&
					pRedline->IsDelLastPara() )
				{
					// Wenn das DelLastPara-Flag gsetzt ist, wird
					// versucht in den Absatz davor einzufuegen, denn
					// der soll ja geloescht werden.
					pPos->nNode--;
					SwCntntNode *pCNd = pPos->nNode.GetNode().GetCntntNode();
					ASSERT( pCNd, "Kein Content-Node trotz DelLastPara" );
					if( pCNd )
						pPos->nContent.Assign( pCNd, pCNd->Len() );
					else
						pPos->nNode++;
				}
				const SwNode& rNewNode = pPos->nNode.GetNode();
				if( rNewNode.IsCntntNode() )
				{
					xub_StrLen nCntntIdx = pPos->nContent.GetIndex();

					InContents( pPos->nNode, nCntntIdx );

					// Den Offset noch an die Verschiebung der
					// Content-Position anpassen.
					nCntntOff += pPos->nContent.GetIndex();
					nCntntOff -= nCntntIdx;
				}
				else
				{
					InContents( pPos->nNode, 0, FALSE, 0, TRUE );
				}
			}
			else
				SkipRec();
		}
		else
		{
			SwNodeIndex aStart( pDoc->GetNodes().GetEndOfRedlines() );
			SwStartNode* pSttNd =
				pDoc->GetNodes().MakeEmptySection( aStart,SwNormalStartNode );
			aStart = *pSttNd->EndOfSectionNode();
			InContents( aStart, 0, FALSE );
			aStart = pSttNd->GetIndex();
			pRedline->SetContentIdx( &aStart );
			if( pSttNd->EndOfSectionIndex() - aStart.GetIndex() == 1 )
				bInvalid = sal_True;
			ASSERT( !bInvalid, "empty redline section imported" );
		}
	}

	const SwRedlineTbl& rRedlineTbl = pDoc->GetRedlineTbl();
	if( !bInvalid )
	{
		// Check for nested redlines.
		sal_Bool bHasMark = pRedline->HasMark() && 
							*pRedline->GetPoint() != *pRedline->GetMark();
		const SwPosition *pStt = bHasMark ? pRedline->Start() : 0;
		const SwPosition *pEnd = bHasMark ? pRedline->End() : 0;
		sal_uInt16 nCount = rRedlineTbl.Count();
		for( sal_uInt16 i=0; !bInvalid && i<nCount; i++ )
		{
			const SwRedline *pTest = rRedlineTbl[i];
			if( pTest != pRedline )
			{

				// Is the ineew position is inside an existing
				// redline then it is invalid.
				const SwPosition *pTestStt = pTest->Start();
				const SwPosition *pTestEnd = pTest->HasMark() ? pTest->End() : 0;
				bInvalid = pTestEnd != 0 && *pPos > *pTestStt && *pPos < *pTestEnd;

				// If the start or end of and existing redline is inside the
				// redline then the new redline is invalid as well;
				if( !bInvalid && bHasMark )
					bInvalid = *pTestStt > *pStt && *pTestStt < *pEnd;
				if( !bInvalid && bHasMark && pTestEnd != 0 )
					bInvalid = *pTestEnd > *pStt && *pTestEnd < *pEnd;

				ASSERT( !bInvalid, "overlapping redline" );
			}
		}
	}

	if( bNormal && !bInsert )
	{
		if( (0x10 & cFlags) == 0 )
		{
			// Die Redline darf jetzt eingefuegt werden. Das Redline-Objekt
			// geht in den Besitz des Dokuments ueber.

			if( !bInvalid )
				bInvalid = !const_cast< SwRedlineTbl& >(rRedlineTbl).Insert(
					pRedline, (BOOL)FALSE );
		}
		else if (bInvalid )
		{
			// The redline is is inserted already and has to be removed from the
			// table;

			sal_uInt16 nPos = rRedlineTbl.GetPos( pRedline );
			ASSERT( USHRT_MAX != nPos, "inserted invalid redline not found" );
			if( USHRT_MAX != nPos )
				const_cast< SwRedlineTbl& >(rRedlineTbl).Remove( nPos );
		}

		if( bInvalid )
		{
			// JP 18.5.2001: Bug 87222 - then delete this invalid redline
			delete pRedline;
			pRedlines->Replace( 0, nId );
			Warning();
		}
	}

	CloseRec( SWG_NODEREDLINE );
}

void Sw3IoImp::OutNodeRedlines( ULONG nIdx )
{
	ASSERT( !IsSw31Or40Export(), "Redlines werden nicht exportiert!" );

	if( pRedlineMarks )
	{
		for( USHORT nPos = 0; nPos < pRedlineMarks->Count(); ++nPos )
		{
			Sw3Mark *pMark = (*pRedlineMarks)[ nPos ];
			if( pMark->GetNodePos() == nIdx )
			{
				ASSERT( pMark->GetId() < pRedlines->Count(),
						"ungeuletige Redline-Id" );
				Sw3MarkType eMarkType = pMark->GetType();
				SwRedline *pRedline = (*pRedlines)[pMark->GetId()];
				const SwNodeIndex *pContentIdx = pRedline->GetContentIdx();

				OpenRec( SWG_NODEREDLINE );

				BYTE cFlags = 0x04;
				if( SW3_REDLINE_END == eMarkType )
					cFlags |= 0x10;
				else if( pContentIdx )
					cFlags |= 0x20;

				xub_StrLen nOffs = pMark->GetNodeOff();
				if( pDoc->GetNodes()[nIdx]->IsCntntNode() &&
					nOffs > STRING_MAXLEN52 )
					nOffs = STRING_MAXLEN52;
				*pStrm  << (BYTE)  cFlags
						<< (UINT16)pMark->GetId()
						<< (UINT16)nOffs;

				if( pContentIdx )
				{
					ASSERT( pContentIdx->GetNode().EndOfSectionIndex() -
						   	pContentIdx->GetIndex(),
							"empty redline section exported" );
					OutContents( *pContentIdx );
				}

				CloseRec( SWG_NODEREDLINE );

				pRedlineMarks->Remove( nPos-- );
				delete pMark;
				if( !pRedlineMarks->Count() )
				{
					delete pRedlineMarks;
					pRedlineMarks = NULL;
					break;
				}
			}
			else if( pMark->GetNodePos() > nIdx )
				break;
		}
	}
}

 /*  */
namespace
{
	void CorrRedline( SwRedline& rRedline, 
					  const SwPosition& rOldPos,
					  const SwPosition& rNewPos )
	{
		sal_uInt32 nOldNodeIdx = rOldPos.nNode.GetIndex();
		if( rRedline.GetPoint()->nNode.GetIndex() == nOldNodeIdx )
		{
			xub_StrLen nOffset = rRedline.GetPoint()->nContent.GetIndex() - 
								 rOldPos.nContent.GetIndex();
			rRedline.GetPoint()->nNode = rNewPos.nNode;
			rRedline.GetPoint()->nContent.Assign( 
								rNewPos.nNode.GetNode().GetCntntNode(),
								rNewPos.nContent.GetIndex() + nOffset );
		}
		if( rRedline.GetMark()->nNode.GetIndex() == nOldNodeIdx )
		{
			xub_StrLen nOffset = rRedline.GetMark()->nContent.GetIndex() - 
								 rOldPos.nContent.GetIndex();
			rRedline.GetMark()->nNode = rNewPos.nNode;
			rRedline.GetMark()->nContent.Assign( 
								rNewPos.nNode.GetNode().GetCntntNode(),
								rNewPos.nContent.GetIndex() + nOffset );
		}
	}
};

void Sw3IoImp::CleanupRedlines()
{
	if( !pRedlines || !pRedlines->Count() )
		return;

	// Bisher muss hier nur was beim Einfugen und Laden von Seiten-Vorlagen
	// passieren.
	if( (bNormal && bInsert) || bPageDescs )
	{
		// Alle geloeschten-Redlines, die angezeigt werden, muessen noch
		// geloescht werden.

		// In a first step, delete the redline objects that are not deletions.
		sal_uInt16 i=0;
		while( i < pRedlines->Count() )
		{
			SwRedline *pRedline = (*pRedlines)[i];
			if( pRedline )
			{
				if( REDLINE_DELETE != pRedline->GetType() ||
					pRedline->GetContentIdx() != 0 )
				{
					delete pRedline;
					pRedlines->Remove( i );
				}
				else
				{
					++i;
				}
			}
			else
			{
				pRedlines->Remove( i );
			}
		}

		// now process the remaining redlines
		sal_uInt16 nCount = pRedlines->Count();
		for( i=0; i<nCount; ++i )
		{
			SwRedline *pRedline = (*pRedlines)[i];
			ASSERT( REDLINE_DELETE == pRedline->GetType() &&
					!pRedline->GetContentIdx(), "wrong redline type" );
			SwRedlineMode eOld = pDoc->GetRedlineMode();
			pDoc->SetRedlineMode_intern( eOld & ~(REDLINE_ON | REDLINE_IGNORE) );
			{
				// If the end node of the redline is deleted (and not joined
				// with the next one), then we have to make sure that none of
				// the remaining redlines starts in that node.
				// The end node of the redline is deleted if the PaM's point
				// or if it is the PaM mark, but in this later case, the whole
				// last node has to be selected.
				const SwPosition& rPointPos = *pRedline->GetPoint();
				const SwPosition& rMarkPos = *pRedline->GetMark();
				if(	rPointPos.nNode.GetNode().IsCntntNode() &&
					rMarkPos.nNode.GetNode().IsCntntNode() &&
					( rPointPos.nNode.GetIndex() > rMarkPos.nNode.GetIndex() ||
					  (rMarkPos.nNode.GetIndex() > rPointPos.nNode.GetIndex() &&
					   rMarkPos.nContent.GetIndex() == rMarkPos.nNode.GetNode().GetCntntNode()->Len()) ) )
				{
					for( sal_uInt16 j= i+1; j < nCount; ++j )
					{
						SwRedline *pTestRedline = (*pRedlines)[j];
						CorrRedline( *pTestRedline, *pRedline->End(),
							   		 *pRedline->Start()	);
					}
				}
				pDoc->DeleteAndJoin( *pRedline );
				pDoc->SetRedlineMode_intern( eOld );
			}
			delete pRedline;
		}
		// Das Array wird zwar auch im CloseStreams geloscht, da wir
		// die Objekte aber schon geloescht haben, ist es besser, das
		// Array gleich zu loeschen.
		pRedlines->Remove( 0, pRedlines->Count() );
		delete pRedlines; pRedlines = 0;
	}
}


