/*************************************************************************
 *
 *  $RCSfile: jvmapp.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/12 09:15:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _TOOLS_INTN_HXX
#include <tools/intn.hxx>
#endif

#ifndef _TOOLS_RESMGR_HXX
#include <tools/resmgr.hxx>
#endif

#ifndef _TOOLS_RC_HXX
#include <tools/rc.hxx>
#endif

#include <vcl/svapp.hxx>
#include "sicustom.hxx"

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _VOS_SECURITY_HXX_
#include <vos/security.hxx>
#endif

#ifndef _SV_CONFIG_HXX //autogen
#include <tools/config.hxx>
#endif

#include <sal/main.h>

#include "environ.hxx"


#ifdef UNX
#include <unistd.h>
#include <limits.h>
#define _MAX_PATH PATH_MAX
#endif

#include <com/sun/star/uno/XComponentContext.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#include <cppuhelper/bootstrap.hxx>

using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::cppu;
using namespace vos;
using namespace rtl;
using namespace osl;

#include <stdio.h>
extern "C"
{
	BOOL _SV_CALL CustomInit( SiSetupFnc* pSetupFunction, SiCustomFnc* pCustomFunction );
};

/*************************************************************************/

#ifdef _USE_NAMESPACE
using namespace vos;
using namespace rtl;
#endif

/*************************************************************************/


class MySiCustomEnvironment: public SiCustomEnvironment
{
	UniString m_aProductName;
public:
	MySiCustomEnvironment(ByteString& srcpath, ByteString& destpath);
	virtual UniString getProductName() const;
};

String MySiCustomEnvironment::getProductName() const
{
	return m_aProductName;
}

MySiCustomEnvironment::MySiCustomEnvironment(ByteString& srcpath, ByteString& destpath)
{
	SetResponse( FALSE );

	SiDirEntry aCWD( srcpath );
	aCWD.SetCWD();

	SetStartPath( srcpath );
	SetSourcePath( srcpath );

	SiDirEntry aBootstrapfile(".");
	aBootstrapfile.ToAbs();
#ifdef UNX
	aBootstrapfile += UniString::CreateFromAscii("bootstraprc");
#else
	aBootstrapfile += UniString::CreateFromAscii("bootstrap.ini");
#endif

	if( aBootstrapfile.Exists() )
	{
		Config aCfg( aBootstrapfile.GetFullUni() );
		aCfg.SetGroup( "Bootstrap" );
		ByteString aProductKey = aCfg.ReadKey( "ProductKey" );
		if( aProductKey.Len() )
		{
			// #95866#
			if (GetBigEnv())
			{
				m_aProductName = UniString( GetBigEnv()->GetSingleProductName(), osl_getThreadTextEncoding() );
			}
			else
			{
				m_aProductName = UniString( aProductKey, osl_getThreadTextEncoding() );
			}
			
			NAMESPACE_VOS(OSecurity) aSecurity;
			::rtl::OUString aConfigDir;
			aSecurity.getConfigDir(aConfigDir);
			::rtl::OString oStrConfigDir = ::rtl::OUStringToOString( aConfigDir, osl_getThreadTextEncoding() );

			SiDirEntry aVersionfile(oStrConfigDir);
#ifdef UNX
			aVersionfile += UniString::CreateFromAscii(".sversionrc");
#else
			aVersionfile += UniString::CreateFromAscii("sversion.ini");
#endif
			
			Config aVCfg( aVersionfile.GetFullUni() );
			aVCfg.SetGroup( "Versions" );
			ByteString aProductInstallPath = aVCfg.ReadKey( aProductKey );
			if( destpath != aProductInstallPath )
				destpath = aProductInstallPath;
		}
	}

        OUString aTempSrc = UniString( destpath, osl_getThreadTextEncoding() );
        OUString aTemp;
        FileBase::getSystemPathFromFileURL( aTempSrc, aTemp );
        destpath = ByteString( UniString(aTemp), osl_getThreadTextEncoding() );

	SetInstalledPath( destpath );
	SetDestPath( destpath );
}

void Main();

SAL_IMPLEMENT_MAIN()
{
    USHORT nParams = Application::GetCommandLineParamCount();
    if (nParams > 1
        || (nParams == 1
            && !rtl::OUString(Application::GetCommandLineParam(0)).
                   equalsIgnoreAsciiCaseAsciiL(RTL_CONSTASCII_STRINGPARAM(
                                                   "--shared"))))
    {
        printf("Usage: jvmsetup [--shared]\n"
               "  With no arguments, jvmsetup changes the settings for a single"
                   " user.\n"
               "  In a network installation, with --shared, jvmsetup changes"
                   " the settings\n  for all users.\n");
        return 0;
    }

	// Create an initial UNO context
	Reference<XComponentContext> xComponentContext = defaultBootstrap_InitialComponentContext();
	Reference<XMultiServiceFactory> xMS(xComponentContext->getServiceManager(), UNO_QUERY);
    
    // 102829 we have to set a generic process factory so VCLUnoHelper::CreateToolkit() finds one
    comphelper::setProcessServiceFactory(xMS);

	// init vcl
	InitVCL( xMS );

	SiSetupFnc		setupFunction;
	SiCustomFnc		customFunction;

	setupFunction.nVersion = SICUSTOM_VERSION;
	customFunction.fncMain = 0;

	ByteString aFileName = OUStringToOString( Application::GetAppFileName(), osl_getThreadTextEncoding() );

#ifdef UNX
	const char* searchChar = "/";
#else
	const char* searchChar = "\\";
#endif

	USHORT nStartIndex = aFileName.SearchCharBackward( searchChar );
	ByteString aSrcPath = aFileName.Erase(nStartIndex, aFileName.Len() - nStartIndex);
	nStartIndex = aFileName.SearchCharBackward( searchChar, nStartIndex );

	ByteString aDestPath = aFileName.Erase(nStartIndex, aFileName.Len() - nStartIndex);

	if( CustomInit( &setupFunction, &customFunction ) )
	{
		if( customFunction.fncMain != 0 )
		{
			MySiCustomEnvironment env( aSrcPath, aDestPath );

			( *customFunction.fncMain )( &env, 0 );
		}
	}

	_exit( 0 );
//	DeInitVCL();

	return 0;
}


