/*************************************************************************
 *
 *  $RCSfile: uninstit.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:46:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SCH_UNINSTIT_HXX
#define _SCH_UNINSTIT_HXX

#include "schundo.hxx"

/*************************************************************************
|*
|* Undo fuer Titel einfuegen
|*
\************************************************************************/

class SchUndoInsertTitle : public SchUndoAction
{
private:
	BOOL bOldShowMainTitle;
	String aOldMainTitle;
	BOOL bOldShowSubTitle;
	String aOldSubTitle;
	BOOL bOldShowXAxisTitle;
	String aOldXAxisTitle;
	BOOL bOldShowYAxisTitle;
	String aOldYAxisTitle;
	BOOL bOldShowZAxisTitle;
	String aOldZAxisTitle;

	BOOL bNewShowMainTitle;
	String aNewMainTitle;
	BOOL bNewShowSubTitle;
	String aNewSubTitle;
	BOOL bNewShowXAxisTitle;
	String aNewXAxisTitle;
	BOOL bNewShowYAxisTitle;
	String aNewYAxisTitle;
	BOOL bNewShowZAxisTitle;
	String aNewZAxisTitle;

public:
	TYPEINFO();

	SchUndoInsertTitle(ChartModel& rChDoc,
					   BOOL bOldShowMain, const String& rOldMain,
					   BOOL bOldShowSub, const String& rOldSub,
					   BOOL bOldShowXAxis, const String& rOldXAxis,
					   BOOL bOldShowYAxis, const String& rOldYAxis,
					   BOOL bOldShowZAxis, const String& rOldZAxis,
					   BOOL bNewShowMain, const String& rNewMain,
					   BOOL bNewShowSub, const String& rNewSub,
					   BOOL bNewShowXAxis, const String& rNewXAxis,
					   BOOL bNewShowYAxis, const String& rNewYAxis,
					   BOOL bNewShowZAxis, const String& rNewZAxis) :
		SchUndoAction(rChDoc),
		bOldShowMainTitle(bOldShowMain),
		aOldMainTitle(rOldMain),
		bOldShowSubTitle(bOldShowSub),
		aOldSubTitle(rOldSub),
		bOldShowXAxisTitle(bOldShowXAxis),
		aOldXAxisTitle(rOldXAxis),
		bOldShowYAxisTitle(bOldShowYAxis),
		aOldYAxisTitle(rOldYAxis),
		bOldShowZAxisTitle(bOldShowZAxis),
		aOldZAxisTitle(rOldZAxis),
		bNewShowMainTitle(bNewShowMain),
		aNewMainTitle(rNewMain),
		bNewShowSubTitle(bNewShowSub),
		aNewSubTitle(rNewSub),
		bNewShowXAxisTitle(bNewShowXAxis),
		aNewXAxisTitle(rNewXAxis),
		bNewShowYAxisTitle(bNewShowYAxis),
		aNewYAxisTitle(rNewYAxis),
		bNewShowZAxisTitle(bNewShowZAxis),
		aNewZAxisTitle(rNewZAxis) {}

	virtual void Undo();
	virtual void Redo();

	virtual BOOL CanRepeat(SfxRepeatTarget& rView) const;
};

#endif	// _SCH_UNINSTIT_HXX

