/*************************************************************************
 *
 *  $RCSfile: profile.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifdef __cplusplus
extern "C" {
#endif

#include <string.h>
#include <stdlib.h>

#include <windows.h>

#include <osl/diagnose.h>
#include <osl/profile.h>
#include <osl/process.h>

#define STR_INI_EXTENSION   ".ini"
#define STR_INI_BOOLYES     "yes"
#define STR_INI_BOOLON      "on"
#define STR_INI_BOOLONE     "1"
#define STR_INI_BOOLNO      "no"
#define STR_INI_BOOLOFF     "off"
#define STR_INI_BOOLZERO    "0"

/*
	Profile-data structure hidden behind oslProfile:    
*/
typedef struct profile_t
{
	sal_Char	mszFileName[_MAX_PATH + 1];
} PROFILE;

static sal_Bool getFullPath(const sal_Char* pszFileName, sal_Char* pszPath, sal_uInt32 MaxLen)
{
	return (sal_Bool)(_fullpath(pszPath, pszFileName, MaxLen) != NULL);
}


oslProfile SAL_CALL osl_openProfile(const sal_Char *pszProfileName, sal_uInt32 Flags)
{
	PROFILE *pProfile = (PROFILE *)malloc(sizeof(PROFILE));

	if (pProfile)
		getFullPath(pszProfileName, pProfile->mszFileName, _MAX_PATH);
	
	return (oslProfile)pProfile;
}

sal_Bool SAL_CALL osl_closeProfile(oslProfile Profile)
{
	if (Profile)
	{
		free((PROFILE *)Profile);
		return sal_True;
	}
	else
		return sal_False;
}

sal_Bool SAL_CALL osl_readProfileString(oslProfile Profile, 
							  const sal_Char* pszSection, const sal_Char* pszEntry, 
							  sal_Char* pszString, sal_uInt32 MaxLen, 
							  const sal_Char* pszDefault)
{
	PROFILE *pProfile = (PROFILE *)Profile;

	if (pProfile)
	{	
		GetPrivateProfileString(pszSection, pszEntry, pszDefault, pszString, MaxLen, pProfile->mszFileName);
		return sal_True;
	}
	else
		return sal_False;
}   


sal_Bool SAL_CALL osl_readProfileBool(oslProfile Profile, const sal_Char* pszSection, const sal_Char* pszEntry, sal_Bool Default)
{
	sal_Char Line[32];

	if (osl_readProfileString(Profile, pszSection, pszEntry, Line, sizeof(Line), ""))
	{
		if ((stricmp(Line, STR_INI_BOOLYES) == 0) ||
			(stricmp(Line, STR_INI_BOOLON)  == 0) ||
			(stricmp(Line, STR_INI_BOOLONE) == 0))
			Default = sal_True;
		else
			if ((stricmp(Line, STR_INI_BOOLNO)   == 0) ||
				(stricmp(Line, STR_INI_BOOLOFF)  == 0) ||
				(stricmp(Line, STR_INI_BOOLZERO) == 0))
				Default = sal_False;
	}
				
	return (Default);        
}


sal_uInt32 SAL_CALL osl_readProfileIdent(oslProfile Profile, 
							  const sal_Char* pszSection, const sal_Char* pszEntry, 
							  sal_uInt32 FirstId, const sal_Char* Strings[],
							  sal_uInt32 Default)
{
	sal_uInt32    i;
	sal_Char        Line[256];

	if (osl_readProfileString(Profile, pszSection, pszEntry, Line, sizeof(Line), ""))
	{
		i = 0;
		while (Strings[i] != NULL)
		{
			if (stricmp(Line, Strings[i]) == 0)
			{
				Default = i + FirstId;
				break;
			}
			i++;
		}
	}

	return (Default);
}


sal_Bool SAL_CALL osl_writeProfileString(oslProfile Profile,
							   const sal_Char* pszSection, const sal_Char* pszEntry, 
							   const sal_Char* pszString)
{
	PROFILE *pProfile = (PROFILE *)Profile;

	if (pProfile)
	{
		WritePrivateProfileString(pszSection, pszEntry, pszString, pProfile->mszFileName);
		return sal_True;
	}
	else
		return sal_False;
}


sal_Bool SAL_CALL osl_writeProfileBool(oslProfile Profile,
							 const sal_Char* pszSection, const sal_Char* pszEntry, 
							 sal_Bool Value)
{
	if (Value)
		return (osl_writeProfileString(Profile, pszSection, pszEntry, STR_INI_BOOLONE));
	else
		return (osl_writeProfileString(Profile, pszSection, pszEntry, STR_INI_BOOLZERO));
}


sal_Bool SAL_CALL osl_writeProfileIdent(oslProfile Profile,
							  const sal_Char* pszSection, const sal_Char* pszEntry, 
							  sal_uInt32 FirstId, const sal_Char* Strings[], 
							  sal_uInt32 Value)
{
	int i, n;
	
	for (n = 0; Strings[n] != NULL; n++);
		
	if ((i = Value - FirstId) >= n)
		return (sal_False);
	else        
		return (osl_writeProfileString(Profile, pszSection, pszEntry, Strings[i]));
}


sal_Bool SAL_CALL osl_removeProfileEntry(oslProfile Profile, 
							   const sal_Char *pszSection, const sal_Char *pszEntry)
{
	PROFILE *pProfile = (PROFILE *)Profile;

	WritePrivateProfileString(pszSection, pszEntry, NULL, pProfile->mszFileName);

	return sal_True;
}


sal_uInt32 SAL_CALL osl_getProfileSectionEntries(oslProfile Profile, const sal_Char *pszSection,
	   							    sal_Char* pszBuffer, sal_uInt32 MaxLen)
{
	PROFILE *pProfile = (PROFILE *)Profile;

	return GetPrivateProfileString(pszSection, NULL, NULL, pszBuffer, MaxLen, pProfile->mszFileName);
}

sal_uInt32 SAL_CALL osl_getProfileSections(oslProfile Profile, sal_Char* pszBuffer, sal_uInt32 MaxLen)
{													
	PROFILE *pProfile = (PROFILE *)Profile;

//	return GetPrivateProfileSectionNames(pszBuffer, MaxLen, pProfile->mszFileName);
	return 0;
}

sal_Bool SAL_CALL osl_getProfileName(const sal_Char* pszPath, const sal_Char* pszName,
						   sal_Char* pszBuffer, sal_uInt32 MaxLen)
{
	int   n;
	sal_Char* pStr;
	sal_Char  File[_MAX_PATH];

	/* build directory path */  
	if (pszPath)
	{   
		OSL_ASSERT(strlen(pszPath) <= _MAX_DIR);
		strcpy(File, pszPath);          
	}
	else
		OSL_VERIFY(GetWindowsDirectory(File, _MAX_DIR) > 0);

	n = strlen(File);

	if (File[n - 1] != '\\')
	{
		File[n]     = '\\';
		File[n + 1] = '\0';
	}

	/* append file name */
	if (pszName)
	{
		strcat(File, pszName);

		/* add default extensiom */
		if (strchr(pszName, '.') == NULL)
			strcat(File, STR_INI_EXTENSION);
	}
	else
	{
		sal_Char ProgName[_MAX_PATH];

		OSL_VERIFY(osl_getExecutableFile(ProgName, sizeof(ProgName)) == osl_Process_E_None);

		/* remove path from filename */
		if ((pStr = strrchr(ProgName, '\\')) == NULL)
			if ((pStr = strrchr(ProgName, ':')) == NULL)
				pStr = ProgName;
			else
				pStr++;
		else
			pStr++;

		strcat(File, pStr);

		if ((pStr = strrchr(File, '.')) != NULL)
			*pStr = '\0';

		strcat(File, STR_INI_EXTENSION);
	}       

	/* copy filename */
	strncpy(pszBuffer, File, MaxLen);
	pszBuffer[MaxLen - 1] = '\0';

	return (strlen(File) < MaxLen);
}


#ifdef __cplusplus
}
#endif

	

