/*************************************************************************
 *
 *  $RCSfile: sdb.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <address.hxx>

#ifndef __STARDIV_ONE_UTIL_CANCEL_HXX__ //autogen wg. XCancellable
#include <stardiv/one/util/cancel.hxx>
#endif

#ifndef _VOS_CONDITN_HXX_ //autogen wg. OCondition
#include <vos/conditn.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace vos;
using namespace usr;
#endif


struct OAddressBookSourceSimpleDatabaseData : public OPropertyObject
{
	static void fillClassInfo(
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps );

	UString                                               m_Table;
	UString                                               m_Name;
	UString                                               m_ServiceName;
	Sequence<PropertyValue>                               m_ConnectionParameters;
	Sequence<AddressBookSourceSimpleDatabaseSchemaDefinition> m_Schemata;

	const AddressBookSourceSimpleDatabaseSchemaDefinition* getSchemaDefinition( 
		const UString& rName );
};

class OAddressBookSourceSimpleDatabase : 
	public OAddressBookSourceSimpleDatabaseData, public OPropertySet, 
	public XAddressBookJobFactorySupplier,
	public XJobFactory
{
public:
	SMART_UNO_DECLARATION( OAddressBookSourceSimpleDatabaseData, OPropertySet );
	OAddressBookSourceSimpleDatabase( const XMultiServiceFactoryRef& xSrv );
	
	static XInterfaceRef create( const XMultiServiceFactoryRef& xMgr ) 	{
		return *new OAddressBookSourceSimpleDatabase( xMgr ); }

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

	virtual XJobFactoryRef getJobFactory();
	virtual XInterfaceRef createJob( 
		const UString& rType, const Sequence<UsrAny>& rArgs );

	OAddressBookSourceSimpleDatabaseData getData() { 
		OGuard aGuard( m_aMutex ); return *this; }
	const XDatabaseConnectionRef getConnection();
	const XAddressBookRecordContainerRef& getRecordContainer();

	static UsrAny getAnyFromProperty( 
		const UString& rSchemaName,
		const AddressBookSourceSimpleDatabaseFieldMapping& rMap, 
		const AddressBookParameteredValue& rValue );
	static UsrAny getPropertyFromAny( 
		const UString& rSchemaName,
		const AddressBookSourceSimpleDatabaseFieldMapping& rMap,
		const UsrAny& rValue );
	

protected:
	void setFastPropertyValue_NoBroadcast( 
		INT32 nHandle, const UsrAny& rValue ) THROWS( (Exception) );
private:

	OMutex                                                m_aMutex;
	XMultiServiceFactoryRef                               m_xMgr;
	XJobFactoryRef                                        m_xJobFactory;
	OWeakRef                                              m_aConnection;
	XAddressBookRecordContainerRef                        m_xRecordContainer;
};

USR_DECLIMPL_OBJECT_REF( OAddressBookSourceSimpleDatabase );

class OAddressBookSourceSimpleDatabaseSynchronJob :
	public UsrObject, public XSynchronJob
{
public:
	SMART_UNO_DECLARATION( OAddressBookSourceSimpleDatabaseSynchronJob, UsrObject );
	OAddressBookSourceSimpleDatabaseSynchronJob( 
		const XMultiServiceFactoryRef& xMgr, 
		const OAddressBookSourceSimpleDatabaseRef& xSource, 
		const UString& rType, const Sequence<UsrAny>& rArgs );
	
	
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	// XCancelable
	virtual void cancel();
	virtual void suspend(){}
	virtual void resume(){}

	virtual UsrAny executeSynchron();

private:
	void updateRecord( 
		const XDatabaseCursorRef& xCursor, 
		const AddressBookSourceSimpleDatabaseSchemaDefinition& rSchema, 
		const Sequence<AddressBookParameteredPropertyValue>& rValues );

	friend class OAddressBookLDAPConnection;
	OAddressBookSourceSimpleDatabaseRef m_xSource;
	XMultiServiceFactoryRef m_xMgr;
	XDatabaseStatementRef   m_xStatement;
	UString                 m_aType;
	Sequence<UsrAny> m_aArgs;
};


class OAddressBookSourceSimpleDatabaseQueryJob :
	public UsrObject, public XAsynchronJob
{
public:
	SMART_UNO_DECLARATION( OAddressBookSourceSimpleDatabaseJob, UsrObject );
	OAddressBookSourceSimpleDatabaseQueryJob( 
		const XMultiServiceFactoryRef& xMgr, 
		const OAddressBookSourceSimpleDatabaseRef& xSource, 
		const UString& rType, const Sequence<UsrAny>& rArgs );
	
	
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	// XCancelable
	virtual void cancel();
	virtual void suspend(){}
	virtual void resume(){}

	virtual void executeAsynchron( const XJobListenerRef& xCallback );

private:
	UString getQueryStringFromAny( const UsrAny& rAny );
	void buildQuery( 
		const AddressBookSourceSimpleDatabaseSchemaDefinition& rDef,
		UniString& rQuery, const UString& rField, const AddressBookQueryTerm& aTerm );
	void buildQueries( 
		const AddressBookSourceSimpleDatabaseSchemaDefinition& rDef,
		UniString& rQuery, const AddressBookQueryTerm& aTerm );
	friend class OAddressBookLDAPConnection;
	OAddressBookSourceSimpleDatabaseRef m_xSource;
	XMultiServiceFactoryRef m_xMgr;
	BOOL                    m_bCanceled;
	UString                 m_aType;
	XDatabaseStatementRef   m_xStatement;
	Sequence<UsrAny> m_aArgs;
};
