#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.13 $
#
#   last change: $Author: rt $ $Date: 2003/06/12 08:03:20 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

PRJNAME	= accessibility
PRJ		= ..$/..$/..$/..$/..
TARGET	= java_accessibility
PACKAGE	= org$/openoffice$/java$/accessibility

USE_JAVAVER:=TRUE

# --- Settings -----------------------------------------------------

.INCLUDE :  settings.mk

.IF "$(JAVANUMVER:s/.//)" >= "000100040000" 

JAVADIR = $(OUT)$/misc$/java
JARFILES = sandbox.jar jurt.jar unoil.jar ridl.jar
JAVAFILES = \
	logging$/XAccessibleEventLog.java \
	logging$/XAccessibleTextLog.java \
	AbstractButton.java \
	AccessibleActionImpl.java \
	AccessibleComponentImpl.java \
	AccessibleEditableTextImpl.java \
	AccessibleExtendedState.java \
	AccessibleHypertextImpl.java \
	AccessibleIconImpl.java \
	AccessibleKeyBinding.java \
	AccessibleObjectFactory.java \
	AccessibleRoleAdapter.java \
	AccessibleSelectionImpl.java \
	AccessibleTextImpl.java \
	AccessibleValueImpl.java \
	Application.java \
	Button.java \
	CheckBox.java \
	ComboBox.java \
	Component.java \
	Container.java \
	DescendantManager.java \
	Dialog.java \
	FocusTraversalPolicy.java \
	Frame.java \
	Icon.java \
	Label.java \
	List.java \
	Menu.java \
	MenuItem.java \
	NativeFrame.java \
	Paragraph.java \
	RadioButton.java \
	ScrollBar.java \
	Separator.java \
	Table.java \
	TextComponent.java \
	ToggleButton.java \
	ToolTip.java \
	Tree.java \
	Window.java

JAVACLASSFILES = $(foreach,i,$(JAVAFILES) $(CLASSDIR)$/$(PACKAGE)$/$(i:b).class) $(CLASSDIR)$/$(PACKAGE)$/Build.class

JARTARGET               = $(TARGET).jar
JARCOMPRESS             = TRUE
JARCLASSDIRS            = $(PACKAGE)

.ENDIF			# "$(JAVANUMVER:s/.//)" >= "000100040000" 

# --- Targets ------------------------------------------------------

.INCLUDE :  target.mk

# Enable logging in non-product only
.IF "$(PRODUCT)"!=""
DEBUGSWITCH = false
PRODUCTSWITCH = true
.ELSE
PRODUCTSWITCH = false
DEBUGSWITCH = true
.ENDIF

.IF "$(GUI)"=="UNX" || "$(USE_SHELL)" != "4nt"
$(JAVADIR)$/$(PACKAGE)$/%.java: makefile.mk
	@-+$(MKDIRHIER) $(JAVADIR)$/$(PACKAGE) >& $(NULLDEV) 
	@-+echo package org.openoffice.java.accessibility\; > $@
	@-+echo public class Build { >> $@
	@-+echo public static final boolean DEBUG = $(DEBUGSWITCH)\; >> $@
	@-+echo public static final boolean PRODUCT = $(PRODUCTSWITCH)\; >> $@
	@-+echo } >> $@
.ELSE
$(JAVADIR)$/$(PACKAGE)$/%.java: makefile.mk
	@-+$(MKDIRHIER) $(JAVADIR)$/$(PACKAGE) >& $(NULLDEV) 
	@-+echo package org.openoffice.java.accessibility; > $@
	@-+echo public class Build { >> $@
	@-+echo public static final boolean DEBUG = $(DEBUGSWITCH); >> $@
	@-+echo public static final boolean PRODUCT = $(PRODUCTSWITCH); >> $@
	@-+echo } >> $@
.ENDIF


$(CLASSDIR)$/$(PACKAGE)$/Build.class : $(JAVADIR)$/$(PACKAGE)$/Build.java
	-+$(JAVAC) -d $(CLASSDIR) $(JAVADIR)$/$(PACKAGE)$/Build.java

