/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AreaCategoryItemRenderer;
import com.jrefinery.chart.AreaXYItemRenderer;
import com.jrefinery.chart.CandlestickRenderer;
import com.jrefinery.chart.HighLowRenderer;
import com.jrefinery.chart.HorizontalBarRenderer;
import com.jrefinery.chart.HorizontalBarRenderer3D;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.HorizontalCategoryPlot;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.HorizontalIntervalBarRenderer;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalNumberAxis3D;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.LineAndShapeRenderer;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.Pie3DPlot;
import com.jrefinery.chart.PiePlot;
import com.jrefinery.chart.SignalRenderer;
import com.jrefinery.chart.StackedAreaCategoryItemRenderer;
import com.jrefinery.chart.StackedHorizontalBarRenderer;
import com.jrefinery.chart.StackedVerticalBarRenderer;
import com.jrefinery.chart.StackedVerticalBarRenderer3D;
import com.jrefinery.chart.StandardXYItemRenderer;
import com.jrefinery.chart.VerticalBarRenderer;
import com.jrefinery.chart.VerticalBarRenderer3D;
import com.jrefinery.chart.VerticalCategoryAxis;
import com.jrefinery.chart.VerticalCategoryPlot;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalNumberAxis3D;
import com.jrefinery.chart.VerticalXYBarRenderer;
import com.jrefinery.chart.WindItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.XYStepRenderer;
import com.jrefinery.chart.tooltips.HighLowToolTipGenerator;
import com.jrefinery.chart.tooltips.IntervalCategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardPieToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardXYToolTipGenerator;
import com.jrefinery.chart.tooltips.TimeSeriesToolTipGenerator;
import com.jrefinery.chart.urls.StandardCategoryURLGenerator;
import com.jrefinery.chart.urls.StandardPieURLGenerator;
import com.jrefinery.chart.urls.StandardXYURLGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.IntervalCategoryDataset;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.PieDataset;
import com.jrefinery.data.SignalsDataset;
import com.jrefinery.data.WindDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Insets;
import java.text.DateFormat;

public class ChartFactory {
    public static JFreeChart createPieChart(String string, PieDataset pieDataset, boolean bl) {
        return ChartFactory.createPieChart(string, pieDataset, bl, true, false);
    }

    public static JFreeChart createPieChart(String string, PieDataset pieDataset, boolean bl, boolean bl2, boolean bl3) {
        PiePlot piePlot = new PiePlot(pieDataset);
        piePlot.setInsets(new Insets(0, 5, 5, 5));
        StandardPieToolTipGenerator standardPieToolTipGenerator = null;
        if (bl2) {
            standardPieToolTipGenerator = new StandardPieToolTipGenerator();
        }
        StandardPieURLGenerator standardPieURLGenerator = null;
        if (bl3) {
            standardPieURLGenerator = new StandardPieURLGenerator();
        }
        piePlot.setToolTipGenerator(standardPieToolTipGenerator);
        piePlot.setURLGenerator(standardPieURLGenerator);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, piePlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createPieChart(String string, CategoryDataset categoryDataset, boolean bl) {
        return ChartFactory.createPieChart(string, categoryDataset, bl, true, false);
    }

    public static JFreeChart createPieChart(String string, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        PiePlot piePlot = new PiePlot(categoryDataset);
        piePlot.setInsets(new Insets(0, 5, 5, 5));
        StandardPieToolTipGenerator standardPieToolTipGenerator = null;
        if (bl2) {
            standardPieToolTipGenerator = new StandardPieToolTipGenerator();
        }
        StandardPieURLGenerator standardPieURLGenerator = null;
        if (bl3) {
            standardPieURLGenerator = new StandardPieURLGenerator();
        }
        piePlot.setToolTipGenerator(standardPieToolTipGenerator);
        piePlot.setURLGenerator(standardPieURLGenerator);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, piePlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createPie3DChart(String string, PieDataset pieDataset, boolean bl) {
        Pie3DPlot pie3DPlot = new Pie3DPlot(pieDataset);
        pie3DPlot.setInsets(new Insets(0, 5, 5, 5));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, pie3DPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createVerticalBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl) {
        return ChartFactory.createVerticalBarChart(string, string2, string3, categoryDataset, bl, true, false);
    }

    public static JFreeChart createVerticalBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        VerticalBarRenderer verticalBarRenderer = new VerticalBarRenderer(standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis, verticalBarRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createVerticalBarChart3D(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        VerticalNumberAxis3D verticalNumberAxis3D = new VerticalNumberAxis3D(string3);
        VerticalBarRenderer3D verticalBarRenderer3D = new VerticalBarRenderer3D();
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis3D, verticalBarRenderer3D);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createStackedVerticalBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        StackedVerticalBarRenderer stackedVerticalBarRenderer = new StackedVerticalBarRenderer();
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis, stackedVerticalBarRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createStackedVerticalBarChart3D(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        VerticalNumberAxis3D verticalNumberAxis3D = new VerticalNumberAxis3D(string3);
        StackedVerticalBarRenderer3D stackedVerticalBarRenderer3D = new StackedVerticalBarRenderer3D();
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis3D, stackedVerticalBarRenderer3D);
        verticalCategoryPlot.setInsets(new Insets(20, 2, 2, 2));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createHorizontalBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl) {
        return ChartFactory.createHorizontalBarChart(string, string2, string3, categoryDataset, bl, true, false);
    }

    public static JFreeChart createHorizontalBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        VerticalCategoryAxis verticalCategoryAxis = new VerticalCategoryAxis(string2);
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        HorizontalBarRenderer horizontalBarRenderer = new HorizontalBarRenderer(standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        HorizontalCategoryPlot horizontalCategoryPlot = new HorizontalCategoryPlot(categoryDataset, verticalCategoryAxis, horizontalNumberAxis, horizontalBarRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, horizontalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createHorizontalBarChart3D(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl) {
        return ChartFactory.createHorizontalBarChart3D(string, string2, string3, categoryDataset, bl, true, false);
    }

    public static JFreeChart createHorizontalBarChart3D(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        VerticalCategoryAxis verticalCategoryAxis = new VerticalCategoryAxis(string2);
        HorizontalNumberAxis3D horizontalNumberAxis3D = new HorizontalNumberAxis3D(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        HorizontalBarRenderer3D horizontalBarRenderer3D = new HorizontalBarRenderer3D(10.0, standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        HorizontalCategoryPlot horizontalCategoryPlot = new HorizontalCategoryPlot(categoryDataset, verticalCategoryAxis, horizontalNumberAxis3D, horizontalBarRenderer3D);
        horizontalCategoryPlot.setForegroundAlpha(0.75f);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, horizontalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createStackedHorizontalBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl) {
        VerticalCategoryAxis verticalCategoryAxis = new VerticalCategoryAxis(string2);
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string3);
        StackedHorizontalBarRenderer stackedHorizontalBarRenderer = new StackedHorizontalBarRenderer();
        HorizontalCategoryPlot horizontalCategoryPlot = new HorizontalCategoryPlot(categoryDataset, verticalCategoryAxis, horizontalNumberAxis, stackedHorizontalBarRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, horizontalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createLineChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl) {
        return ChartFactory.createLineChart(string, string2, string3, categoryDataset, bl, true, false);
    }

    public static JFreeChart createLineChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer(2, 1, standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis, lineAndShapeRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createAreaChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl) {
        return ChartFactory.createAreaChart(string, string2, string3, categoryDataset, bl, true, false);
    }

    public static JFreeChart createAreaChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        AreaCategoryItemRenderer areaCategoryItemRenderer = new AreaCategoryItemRenderer(standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis, areaCategoryItemRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createStackedAreaChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        StackedAreaCategoryItemRenderer stackedAreaCategoryItemRenderer = new StackedAreaCategoryItemRenderer();
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis, stackedAreaCategoryItemRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createGanttChart(String string, String string2, String string3, IntervalCategoryDataset intervalCategoryDataset, boolean bl) {
        return ChartFactory.createGanttChart(string, string2, string3, intervalCategoryDataset, bl, true, false);
    }

    public static JFreeChart createGanttChart(String string, String string2, String string3, IntervalCategoryDataset intervalCategoryDataset, boolean bl, boolean bl2, boolean bl3) {
        VerticalCategoryAxis verticalCategoryAxis = new VerticalCategoryAxis(string2);
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string3);
        IntervalCategoryToolTipGenerator intervalCategoryToolTipGenerator = null;
        if (bl2) {
            intervalCategoryToolTipGenerator = new IntervalCategoryToolTipGenerator(DateFormat.getDateInstance());
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        HorizontalIntervalBarRenderer horizontalIntervalBarRenderer = new HorizontalIntervalBarRenderer(intervalCategoryToolTipGenerator, standardCategoryURLGenerator);
        HorizontalCategoryPlot horizontalCategoryPlot = new HorizontalCategoryPlot(intervalCategoryDataset, verticalCategoryAxis, horizontalDateAxis, horizontalIntervalBarRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, horizontalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createLineXYChart(String string, String string2, String string3, XYDataset xYDataset, boolean bl) {
        return ChartFactory.createLineXYChart(string, string2, string3, xYDataset, bl, true, false);
    }

    public static JFreeChart createLineXYChart(String string, String string2, String string3, XYDataset xYDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string2);
        horizontalNumberAxis.setAutoRangeIncludesZero(false);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        XYPlot xYPlot = new XYPlot(xYDataset, horizontalNumberAxis, verticalNumberAxis);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        xYPlot.setRenderer(new StandardXYItemRenderer(2, standardXYToolTipGenerator, standardXYURLGenerator));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createAreaXYChart(String string, String string2, String string3, XYDataset xYDataset, boolean bl) {
        return ChartFactory.createAreaXYChart(string, string2, string3, xYDataset, bl, true, false);
    }

    public static JFreeChart createAreaXYChart(String string, String string2, String string3, XYDataset xYDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string2);
        horizontalNumberAxis.setAutoRangeIncludesZero(false);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        XYPlot xYPlot = new XYPlot(xYDataset, horizontalNumberAxis, verticalNumberAxis);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        xYPlot.setRenderer(new AreaXYItemRenderer(4, standardXYToolTipGenerator, standardXYURLGenerator));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createScatterPlot(String string, String string2, String string3, XYDataset xYDataset, boolean bl) {
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string2);
        horizontalNumberAxis.setAutoRangeIncludesZero(false);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        verticalNumberAxis.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYDataset, horizontalNumberAxis, verticalNumberAxis);
        xYPlot.setRenderer(new StandardXYItemRenderer(1));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createWindPlot(String string, String string2, String string3, WindDataset windDataset, boolean bl) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        verticalNumberAxis.setMaximumAxisValue(12.0);
        verticalNumberAxis.setMinimumAxisValue(-12.0);
        XYPlot xYPlot = new XYPlot(windDataset, horizontalDateAxis, verticalNumberAxis);
        xYPlot.setRenderer(new WindItemRenderer());
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createTimeSeriesChart(String string, String string2, String string3, XYDataset xYDataset, boolean bl) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        verticalNumberAxis.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYDataset, horizontalDateAxis, verticalNumberAxis);
        xYPlot.setRenderer(new StandardXYItemRenderer(2, new TimeSeriesToolTipGenerator()));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createVerticalXYBarChart(String string, String string2, String string3, IntervalXYDataset intervalXYDataset, boolean bl) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        XYPlot xYPlot = new XYPlot(intervalXYDataset, horizontalDateAxis, verticalNumberAxis);
        xYPlot.setRenderer(new VerticalXYBarRenderer());
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createHighLowChart(String string, String string2, String string3, HighLowDataset highLowDataset, boolean bl) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        XYPlot xYPlot = new XYPlot(highLowDataset, horizontalDateAxis, verticalNumberAxis);
        xYPlot.setRenderer(new HighLowRenderer(new HighLowToolTipGenerator()));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createCandlestickChart(String string, String string2, String string3, HighLowDataset highLowDataset, boolean bl) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        XYPlot xYPlot = new XYPlot(highLowDataset, horizontalDateAxis, verticalNumberAxis);
        xYPlot.setRenderer(new CandlestickRenderer());
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createSignalChart(String string, String string2, String string3, SignalsDataset signalsDataset, boolean bl) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        XYPlot xYPlot = new XYPlot(signalsDataset, horizontalDateAxis, verticalNumberAxis);
        xYPlot.setRenderer(new SignalRenderer());
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createXYStepChart(String string, String string2, String string3, XYDataset xYDataset, boolean bl) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        horizontalDateAxis.setCrosshairVisible(false);
        verticalNumberAxis.setCrosshairVisible(false);
        verticalNumberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYPlot xYPlot = new XYPlot(xYDataset, horizontalDateAxis, verticalNumberAxis);
        xYPlot.setRenderer(new XYStepRenderer());
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createXYChart(String string, String string2, String string3, XYDataset xYDataset, boolean bl) {
        return ChartFactory.createLineXYChart(string, string2, string3, xYDataset, bl);
    }
}

