%%%
%%% Author:
%%%   Thorsten Brunklaus <bruni@ps.uni-sb.de>
%%%
%%% Copyright:
%%%   Thorsten Brunklaus, 2001
%%%
%%% Last Change:
%%%   $Date: 2001/07/26 12:47:27 $ by $Author: duchier $
%%%   $Revision: 1.1.2.1 $
%%%
%%% This file is part of Mozart, an implementation of Oz 3:
%%%   http://www.mozart-oz.org
%%%
%%% See the file "LICENSE" or
%%%   http://www.mozart-oz.org/LICENSE.html
%%% for information on usage and redistribution
%%% of this file, and for a DISCLAIMER OF ALL
%%% WARRANTIES.
%%%

functor $
import
export
   tokens        : Tokens
   toString      : ToString
   toAtom        : ToAtom
   checkPrefix   : CheckPrefix
   stripPrefix   : StripPrefix
   cutPrefix     : CutPrefix
   translateName : TranslateName
   firstLower    : FirstLower
   indent        : Indent
define
   %%
   %% Tokenizer
   %%
   
   local
      fun {DoTokens AllTs CurTs Ls Ts}
	 case Ls
	 of nil  then
	    if CurTs == nil
	    then {Reverse AllTs}
	    else {Reverse {Reverse CurTs}|AllTs}
	    end
	 [] L|Lr then
	    if {Member L Ts}
	    then
	       if CurTs == nil
	       then {DoTokens AllTs CurTs Lr Ts}
	       else {DoTokens {Reverse CurTs}|AllTs nil Lr Ts}
	       end
	    else {DoTokens AllTs L|CurTs Lr Ts}
	    end
	 end
      end
   in
      fun {Tokens Ls Ts}
	 {DoTokens nil nil Ls Ts}
      end
   end

   %%
   %% Conversion Stuff
   %%

   fun {ToString V}
      {VirtualString.toString V}
   end
   
   fun {ToAtom V}
      {String.toAtom {ToString V}}
   end

   %%
   %% Prefix Stuff
   %%
   
   fun {CheckPrefix Xs Ys}
      case Xs
      of X|Xr then
	 case Ys
	 of Y|Yr then X == Y andthen {CheckPrefix Xr Yr}
	 [] _    then false
	 end
      [] nil then true
      end
   end
   
   fun {StripPrefix V}
      case V
      of &_|Vr then Vr
      [] V     then V
      end
   end

   fun {CutPrefix Xs Ys}
      case Xs
      of X|Xr then
	 case Ys
	 of Y|Yr then if {Char.toUpper X} == {Char.toUpper Y} then {CutPrefix Xr Yr} else Ys end
	 [] nil  then nil
	 end
      [] nil  then Ys
      end
   end
   
   %%
   %% Name Translation gtk_sample_fun -> gtkSampleFun
   %%
   
   local
      fun {ToUpper Ss}
	 case Ss
	 of S|Sr then {Char.toUpper S}|Sr
	 [] S    then S
	 end
      end
      fun {DoTranslate Ss}
	 case Ss
	 of S|Sr then {ToUpper S}#{DoTranslate Sr}
	 [] nil  then nil
	 end
      end
   in
      fun {TranslateName N}
	 Ss = {Tokens {ToString N} [&_]}
      in
	 case Ss
	 of S|Sr then {ToString {FirstLower S}#{DoTranslate Sr}}
	 [] S    then S
	 end
      end
   end

   fun {FirstLower Vs}
      case Vs
      of V|Vr then {Char.toLower V}|Vr
      [] V    then V
      end
   end

   %%
   %% Indentation
   %%

   fun {Indent N}
      if N == 0 then "" else "   "#{Indent (N - 1)} end
   end
end
