/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPopupMenu;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.gui.JFontChooser;

public class FontChooserHandler
extends AbstractSelectedAction
implements PropertyChangeListener {
    protected AttributeKey<Font> key;
    protected JFontChooser fontChooser;
    protected JPopupMenu popupMenu;
    protected int isUpdating;

    public FontChooserHandler(DrawingEditor drawingEditor, AttributeKey<Font> attributeKey, JFontChooser jFontChooser, JPopupMenu jPopupMenu) {
        super(drawingEditor);
        this.key = attributeKey;
        this.fontChooser = jFontChooser;
        this.popupMenu = jPopupMenu;
        jFontChooser.addActionListener(this);
        jFontChooser.addPropertyChangeListener(this);
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "ApproveSelection") {
            this.applySelectedFontToFigures();
        } else if (actionEvent.getActionCommand() == "CancelSelection") {
            // empty if block
        }
        this.popupMenu.setVisible(false);
    }

    protected void applySelectedFontToFigures() {
        Serializable serializable2;
        final ArrayList<Figure> arrayList = new ArrayList<Figure>(this.getView().getSelectedFigures());
        final ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
        for (Serializable serializable2 : arrayList) {
            arrayList2.add(serializable2.getAttributesRestoreData());
            serializable2.willChange();
            serializable2.set(this.key, this.fontChooser.getSelectedFont());
            serializable2.changed();
        }
        this.getEditor().setDefaultAttribute(this.key, this.fontChooser.getSelectedFont());
        final Font font = this.fontChooser.getSelectedFont();
        serializable2 = new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return AttributeKeys.FONT_FACE.getPresentationName();
            }

            @Override
            public void undo() {
                super.undo();
                Iterator iterator = arrayList2.iterator();
                for (Figure figure : arrayList) {
                    figure.willChange();
                    figure.restoreAttributesTo(iterator.next());
                    figure.changed();
                }
            }

            @Override
            public void redo() {
                super.redo();
                for (Figure figure : arrayList) {
                    arrayList2.add(figure.getAttributesRestoreData());
                    figure.willChange();
                    figure.set(FontChooserHandler.this.key, font);
                    figure.changed();
                }
            }
        };
        this.fireUndoableEditHappened((UndoableEdit)((Object)serializable2));
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getEditor().isEnabled());
        if (this.getView() != null && this.fontChooser != null && this.popupMenu != null) {
            this.fontChooser.setEnabled(this.getView().getSelectionCount() > 0);
            this.popupMenu.setEnabled(this.getView().getSelectionCount() > 0);
            ++this.isUpdating;
            if (this.getView().getSelectionCount() > 0) {
                for (Figure figure : this.getView().getSelectedFigures()) {
                    if (!(figure instanceof TextHolderFigure)) continue;
                    TextHolderFigure textHolderFigure = (TextHolderFigure)figure;
                    this.fontChooser.setSelectedFont(textHolderFigure.getFont());
                    break;
                }
            }
            --this.isUpdating;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.isUpdating++ == 0 && propertyChangeEvent.getPropertyName() == "selectedFont") {
            this.applySelectedFontToFigures();
        }
        --this.isUpdating;
    }
}

