/*!******************************************************************************

  @file         hsp78.h

  ------------------------------------------------------------------------------

  @author       

  @brief        date_time_formatting

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif

********************************************************************************/

#ifndef HSP78_H
#define HSP78_H


/*===========================================================================*
 *     RefType: Both                                                         *
 *===========================================================================*/

/*===========================================================================*
 *     MD5: '\xe2\x76\x13\x82\xc8\x62\x04\xbf\xd9\xcb\x71\x57\x0c\xd5\x99\xe3'
 *===========================================================================*/


/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gsp00.h"
#include "vsp006.h"


/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externPascal void s78dict_next_msgno (
    tsp00_Int2            VAR_VALUE_REF  msgno,
    pasbool               VAR_VALUE_REF  done);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78dict_insert_row (
    tsp6_dictionary       VAR_VALUE_REF  dictionary,
    tsp00_MoveObjPtr                     bufptr,
    tsp00_Int4                           buf_len,
    pasbool               VAR_VALUE_REF  is_ok);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78lang_spell_init (
    tsp6_dictionary       VAR_VALUE_REF  dictionary,
    tsp00_MoveObjPtr                     bufptr,
    tsp00_Int4                           buf_len,
    integer                              dict_kind,
    integer               VAR_VALUE_REF  i,
    pasbool               VAR_VALUE_REF  is_ok);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78language (
    tsp6_dictionaries     VAR_VALUE_REF  dictionaries,
    tsp00_C3              VAR_ARRAY_REF  language_name,
    tsp6_language         VAR_VALUE_REF  language_no,
    pasbool                              for_init,
    pasbool               VAR_VALUE_REF  is_ok);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78df_analyze (
    tsp00_MoveObjPtr                     format_addr,
    tsp00_Int2                           format_len,
    tsp00_MoveObjPtr                     dest_addr,
    tsp00_Int2            VAR_VALUE_REF  dest_len,
    pasbool                              to_date_format,
    tsp6_date_error       VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78df_default (
    tsp00_MoveObjPtr                     dest_addr,
    tsp00_Int2            VAR_VALUE_REF  dest_len,
    tsp6_date_error       VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78df_len1 (
    tsp00_MoveObjPtr                     format_addr,
    tsp00_Int2                           format_len,
    tsp6_date_fmt_elem    VAR_VALUE_REF  df_elem,
    tsp6_date_error       VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78df_clear (
    tsp6_dictionary       VAR_VALUE_REF  dictionary,
    tsp00_MoveObjPtr                     format_addr,
    integer                              format_len,
    tsp00_MoveObjPtr                     dest_addr,
    integer                              dest_size);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78d2c_to_char (
    tsp6_dictionary       VAR_VALUE_REF  dictionary,
    tsp00_MoveObjPtr                     ts_addr,
    tsp00_MoveObjPtr                     format_addr,
    integer                              format_len,
    integer                              dest_size,
    tsp00_MoveObjPtr                     dest_addr,
    integer               VAR_VALUE_REF  dest_pos,
    integer                              dest_len,
    tsp6_date_error       VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78c2d_to_date (
    tsp6_dictionary       VAR_VALUE_REF  dictionary,
    tsp00_MoveObjPtr                     curr_date,
    tsp00_MoveObjPtr                     fmt_addr,
    tsp00_Int4                           fmt_len,
    tsp00_MoveObjPtr                     src_addr,
    tsp00_Int4                           src_len,
    tsp00_MoveObjPtr                     dest_addr,
    tsp00_Int4            VAR_VALUE_REF  dest_pos,
    tsp6_date_error       VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78ints_from_buf (
    void                  *  buf,
    tsp00_Int4                           pos,
    tsp6_timestamp_array  VAR_ARRAY_REF  timestamp,
    tsp6_date_error       VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78ints_to_buf (
    void                  *  buf,
    tsp00_Int4                           pos,
    tsp6_timestamp_array  VAR_ARRAY_REF  timestamp);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78time_from_buf (
    void                  *  buf,
    tsp00_Int4                           timepos,
    integer                              timelen,
    integer               VAR_VALUE_REF  hour,
    integer               VAR_VALUE_REF  min,
    integer               VAR_VALUE_REF  sec,
    tsp6_date_error       VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78val_from_buf (
    void                  *  buf,
    tsp00_Int4                           pos,
    integer               VAR_VALUE_REF  year_hour,
    integer               VAR_VALUE_REF  month_min,
    integer               VAR_VALUE_REF  day_sec,
    tsp6_date_error_Param                 ret_error,
    tsp6_date_error       VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78val_to_buf (
    void                  *  buf,
    tsp00_Int4                           pos,
    integer                              year_hour,
    integer                              month_min,
    integer                              day_sec);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78year_month_day (
    void                  *  datbuf,
    tsp00_Int4                           datpos,
    integer               VAR_VALUE_REF  year,
    integer               VAR_VALUE_REF  month,
    integer               VAR_VALUE_REF  day,
    tsp6_date_error       VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78week_and_day (
    void                  *  datbuf,
    tsp00_Int4                           datpos,
    integer               VAR_VALUE_REF  week,
    integer               VAR_VALUE_REF  day_of_week,
    tsp6_date_error       VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal void s78year_and_day (
    void                  *  datbuf,
    tsp00_Int4                           datpos,
    integer               VAR_VALUE_REF  year,
    integer               VAR_VALUE_REF  day,
    tsp6_date_error       VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal integer s78day_sec (
    void                  *  datbuf,
    tsp00_Int4                           datpos,
    tsp6_date_error       VAR_VALUE_REF  e);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal integer s78days_of_month (
    integer                              year,
    integer                              month);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int2 s78t_dest_len_date_format (
    void                  *  format,
    tsp00_Int4                           fmt_pos,
    tsp00_Int4                           fmt_len);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal pasbool s78is_leap_year (
    integer                              year);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal integer s78days_of_year (
    integer                              year);

/* Don't edit this file by hand, it is generated by ptocProto.py */

externPascal tsp00_Int4 s78diff_year_day (
    integer                              year1,
    integer                              day1,
    integer                              year2,
    integer                              day2);

/* Don't edit this file by hand, it is generated by ptocProto.py */


#endif

