/****************************************************************************/
/*!

  @file        SysView_BackupThreads.cpp

  -------------------------------------------------------------------------

  @author      ElkeZ

  @ingroup     SystemViews
  @brief       This module implements the "BackupThreads" view class.

  @see        

*/
/*-------------------------------------------------------------------------

  copyright:    (c) 2002-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "SystemViews/SysView_Defines.hpp"
#include "SystemViews/SysView_ITableObj.hpp"
#include "SystemViews/SysView_BackupThreads.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS  (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

void SysView_BackupThreads::Create()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_BackupThreads::Create", SysView_Trace, 5);

	m_Table->AppendCol (ITOCT_FIXED ,SV_THREADID, 10);
	m_Table->AppendCol (ITOCT_CHAR ,SV_THREADNAME, 16);
	m_Table->AppendCol (ITOCT_CHAR ,SV_IODIRECTION, 6);
	m_Table->AppendCol (ITOCT_FIXED ,SV_IOCOUNT, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_IOPAGECOUNT, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_IOTIME, 20);
	m_Table->AppendCol (ITOCT_FIXED ,SV_PENDINGIOCOUNT, 5);
	m_Table->AppendCol (ITOCT_FIXED ,SV_MAXQUEUELENGTHMAXPENDINGIOCOUNT, 5);
	m_Table->AppendCol (ITOCT_CHAR ,SV_PATH, 256);

}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_BackupThreads::GetColCount()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_BackupThreads::GetColCount", SysView_Trace, 5);

    return SV_CC_BACKUPTHREADS;
}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_BackupThreads::EstimateRows()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_BackupThreads::EstimateRows", SysView_Trace, 5);

    return SV_ER_BACKUPTHREADS;
}

/*---------------------------------------------------------------------------*/

void SysView_BackupThreads::Execute()
{
    SAPDBTRACE_METHOD_DEBUG ("SysView_BackupThreads::Execute", SysView_Trace, 5);

    m_Context.ThrowError (e_not_implemented, 1);
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
