/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.CallableStatementSapDB;
import com.sap.dbtech.jdbc.DatabaseMetaDataMaxDB;
import com.sap.dbtech.jdbc.DatabaseMetaDataSapDB;
import com.sap.dbtech.jdbc.DbsCache;
import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.InternalStatementSapDB;
import com.sap.dbtech.jdbc.NameHandling;
import com.sap.dbtech.jdbc.Parseinfo;
import com.sap.dbtech.jdbc.ParseinfoCache;
import com.sap.dbtech.jdbc.SavepointSapDB;
import com.sap.dbtech.jdbc.StatementSapDB;
import com.sap.dbtech.jdbc.exceptions.ConnectionException;
import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.jdbc.exceptions.ObjectIsClosedException;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.TimeoutException;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.ReplyPacketUnicode;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.packet.RequestPacketUnicode;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.GarbageCursor;
import com.sap.dbtech.util.GarbageParseid;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.UniqueID;
import com.sap.dbtech.util.VersionInfo;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class ConnectionSapDB
implements Connection {
    public static final int GC_ALLOWED = 1;
    public static final int GC_DELAYED = 2;
    public static final int GC_NONE = 3;
    JdbcCommunication session;
    boolean autocommit = true;
    private boolean inTransaction = false;
    Stack packetPool = new Stack();
    private boolean isUnicode = false;
    private SQLWarning warningList;
    private Properties connectProperties;
    private UniqueID UniqueID = new UniqueID();
    private Map typeMap;
    private Object executingObject = null;
    private boolean inReconnect = false;
    private GarbageParseid garbageParseids = null;
    private GarbageCursor garbageCursors = null;
    ArrayList statementContainer = null;
    private boolean keepGarbage = false;
    private int isolationLevel = 2;
    private int resultSetHoldability = 1;
    ParseinfoCache parseCache = null;
    DbsCache dbsCache = null;
    int sessionID = -1;
    boolean isSQLModeOracle = false;
    boolean isSpaceoptionSet = false;
    private DatabaseMetaData DatabaseMetaData = null;
    private String cursorPrefix = "JDBC_CURSOR_";
    private static final String syncObj = "";
    private int nonRecyclingExecutions = 0;
    private String applID = null;
    private int kernelversion;
    private static final byte[] defaultFeatureSet = new byte[]{1, 0, 2, 0, 3, 0, 4, 0, 5, 0};
    private byte[] kernelFeatures = new byte[defaultFeatureSet.length];

    public ConnectionSapDB(JdbcCommunication jdbcCommunication, Properties properties) throws SQLException {
        this.session = jdbcCommunication;
        this.connectProperties = (Properties)properties.clone();
        this.isSQLModeOracle = this.getConnectProperty("sqlmode").equalsIgnoreCase("oracle");
        this.isUnicode = DriverSapDB.getBooleanProperty(this.connectProperties, "unicode", false);
        this.isSpaceoptionSet = DriverSapDB.getBooleanProperty(this.connectProperties, "spaceoption", false);
        if (this.isSpaceoptionSet) {
            this.isUnicode = true;
        }
        this.doConnect(this.connectProperties);
        this.statementContainer = new ArrayList();
    }

    final void addWarning(SQLWarning sQLWarning) {
        if (this.warningList == null) {
            this.warningList = sQLWarning;
        } else {
            this.warningList.setNextWarning(sQLWarning);
        }
    }

    protected void assertOpen() throws ObjectIsClosedException {
        if (this.session == null) {
            throw new ObjectIsClosedException(this);
        }
    }

    public final void cancel(Object object) throws SQLException {
        if (this.executingObject == object) {
            this.session.cancel();
        }
    }

    public final void clearWarnings() throws SQLException {
        this.warningList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        block8: {
            if (this.session != null) {
                try {
                    try {
                        if (this.garbageCursors != null) {
                            this.garbageCursors.emptyCan();
                        }
                        if (this.garbageParseids != null) {
                            this.garbageParseids.emptyCan();
                        }
                        this.executeSQLString("ROLLBACK WORK RELEASE", 3);
                    }
                    catch (SQLException sQLException) {
                        TimeoutException.println("IGNORING EXCEPTION CLOSE:" + sQLException.toString());
                        Object var3_2 = null;
                        this.session.release();
                        this.session = null;
                        this.DatabaseMetaData = null;
                        break block8;
                    }
                    catch (RuntimeException runtimeException) {
                        TimeoutException.println("IGNORING EXCEPTION CLOSE:" + runtimeException.toString());
                        Object var3_3 = null;
                        this.session.release();
                        this.session = null;
                        this.DatabaseMetaData = null;
                    }
                    Object var3_1 = null;
                    this.session.release();
                    this.session = null;
                    this.DatabaseMetaData = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.session.release();
                    this.session = null;
                    this.DatabaseMetaData = null;
                    throw throwable;
                }
            }
        }
    }

    public synchronized void commit() throws SQLException {
        this.assertOpen();
        boolean bl = false;
        int n = this.statementContainer.size();
        for (int i = 0; i < n; ++i) {
            StatementSapDB statementSapDB = (StatementSapDB)((WeakReference)this.statementContainer.get(i)).get();
            if (statementSapDB == null) continue;
            ResultSet resultSet = statementSapDB.currentResultSet;
            if (statementSapDB.getResultSetHoldability() != 2 || resultSet == null) continue;
            bl = true;
            resultSet.close();
        }
        this.statementContainer.clear();
        if (bl && this.garbageCursors != null) {
            this.garbageCursors.forceGarbageCollection();
        }
        this.executeSQLString("COMMIT WORK", 1);
        this.inTransaction = false;
    }

    public Statement createStatement() throws SQLException {
        this.assertOpen();
        return new StatementSapDB(this);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.assertOpen();
        return new StatementSapDB(this, n, n2, 1);
    }

    protected void doConnect(Properties properties) throws SQLException {
        byte[] byArray;
        String string;
        String string2 = properties.getProperty("user");
        if (string2 == null) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.nouser"));
        }
        char c = string2.charAt(0);
        char c2 = string2.charAt(string2.length() - 1);
        if (c != '\"' || c2 != '\"') {
            string2 = string2.toUpperCase();
            properties.put("user", string2);
        }
        if ((string = properties.getProperty("password")) == null) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.nopassword"));
        }
        String string3 = properties.getProperty("sqlmode", "INTERNAL");
        String string4 = properties.getProperty("cachelimit");
        String string5 = properties.getProperty("timeout");
        String string6 = properties.getProperty("isolation");
        String string7 = "              java";
        RequestPacket requestPacket = this.getRequestPacket();
        String string8 = "Connect " + string2 + " identified by :PW " + "SQLMODE " + string3;
        if (string5 != null) {
            string8 = string8 + " TIMEOUT " + string5;
        }
        if (string6 != null) {
            this.isolationLevel = DriverSapDB.isolevelString2Jdbc(string6);
            string8 = string8 + " ISOLATION LEVEL " + DriverSapDB.isolevelJdbc2native(this.isolationLevel);
        }
        if (string4 != null) {
            string8 = string8 + " CACHELIMIT " + string4;
        }
        if (this.isSpaceoptionSet) {
            string8 = string8 + " SPACE OPTION ";
            this.setKernelFeatureRequest(2);
        }
        requestPacket.initDbsCommand(false, string8, 1003);
        requestPacket.newPart(5);
        try {
            byArray = NameHandling.mangle(string, this.isUnicode);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.invalidpassword"));
        }
        requestPacket.addDataBytes(byArray);
        requestPacket.addDataString(string7);
        requestPacket.incrPartArguments();
        System.arraycopy(defaultFeatureSet, 0, this.kernelFeatures, 0, defaultFeatureSet.length);
        this.setKernelFeatureRequest(1);
        this.setKernelFeatureRequest(5);
        requestPacket.addFeatureRequestPart(this.kernelFeatures);
        ReplyPacket replyPacket = this.execute(requestPacket, this, 2);
        this.sessionID = replyPacket.getSessionID();
        VersionInfo versionInfo = new VersionInfo(replyPacket.getKernelMajorVersion(), replyPacket.getKernelMinorVersion(), replyPacket.getKernelCorrectionLevel(), 0, null);
        this.DatabaseMetaData = versionInfo.getMajorVersion() >= 7 && versionInfo.getMinorVersion() >= 6 ? new DatabaseMetaDataMaxDB(this, versionInfo) : new DatabaseMetaDataSapDB(this, versionInfo);
        this.kernelversion = versionInfo.getMajorVersion() * 10000 + 100 * versionInfo.getMinorVersion() + versionInfo.getMinorMinorVersion();
        byte[] byArray2 = replyPacket.getFeatures();
        if (byArray2 != null) {
            this.kernelFeatures = byArray2;
        } else {
            System.arraycopy(defaultFeatureSet, 0, this.kernelFeatures, 0, defaultFeatureSet.length);
        }
        this.autocommit = DriverSapDB.getBooleanProperty(properties, "autocommit", this.autocommit);
        if (properties.containsKey("cache")) {
            this.parseCache = new ParseinfoCache(properties);
        }
    }

    public ReplyPacket execute(RequestPacket requestPacket, Object object, int n) throws SQLException {
        return this.execute(requestPacket, false, false, object, n);
    }

    public ReplyPacket sendStreamErrorPacket(SQLException sQLException) {
        try {
            RequestPacket requestPacket = this.getRequestPacket();
            requestPacket.initDbs(this.autocommit, 1003);
            if (sQLException.getMessage() == null || sQLException.getMessage().length() == 0) {
                requestPacket.addErrorTextPart(MessageTranslator.translate("error.message.notavailable"));
            } else {
                requestPacket.addErrorTextPart(sQLException.getMessage());
            }
            if (sQLException.getErrorCode() == 0) {
                requestPacket.setErrorCode(-9999);
                requestPacket.setSQLState("S9999");
            } else {
                requestPacket.setErrorCode(sQLException.getErrorCode());
                requestPacket.setSQLState(sQLException.getSQLState());
            }
            return this.execute(requestPacket, this, 3);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReplyPacket execute(RequestPacket requestPacket, boolean bl, boolean bl2, Object object, int n) throws SQLException {
        ReplyPacket replyPacket = null;
        int n2 = 0;
        this.assertOpen();
        if (n == 1) {
            boolean bl3 = true;
            if (this.garbageCursors != null && this.garbageCursors.isPending()) {
                bl3 = this.garbageCursors.emptyCan(requestPacket);
            }
            if (bl3 && this.garbageParseids != null && this.garbageParseids.isPending()) {
                this.garbageParseids.emptyCan(requestPacket);
            }
        } else if (this.garbageParseids != null && this.garbageParseids.isPending()) {
            ++this.nonRecyclingExecutions;
        }
        requestPacket.closePacket();
        int n3 = requestPacket.length();
        if (Tracer.isOn(5)) {
            Tracer.traceObject(null, requestPacket, 6);
        }
        try {
            this.executingObject = object;
            replyPacket = this.isUnicode ? new ReplyPacketUnicode(this.session.execute(requestPacket.getBase(), n3)) : new ReplyPacket(this.session.execute(requestPacket.getBase(), n3));
            replyPacket.firstSegment();
            n2 = replyPacket.weakReturnCode();
            if (n2 != -8) {
                this.freeRequestPacket(requestPacket);
            }
            if (!this.autocommit && !bl2) {
                this.inTransaction = true;
            }
            if (n != 3) {
                if (this.garbageCursors != null && this.garbageCursors.isPending() && n2 == 0) {
                    this.garbageCursors.emptyCan(this);
                }
                if (this.nonRecyclingExecutions > 20 && n2 == 0) {
                    this.nonRecyclingExecutions = 0;
                    if (this.garbageParseids != null && this.garbageParseids.isPending()) {
                        this.garbageParseids.emptyCan(this);
                    }
                    this.nonRecyclingExecutions = 0;
                }
            }
        }
        catch (RTEException rTEException) {
            if (!DriverSapDB.getBooleanProperty(this.connectProperties, "reconnect", true) || this.inReconnect || this.inTransaction) {
                throw new ConnectionException(rTEException);
            }
            this.tryReconnect(rTEException);
            this.inTransaction = false;
        }
        finally {
            this.executingObject = null;
        }
        if (Tracer.isOn(5)) {
            Tracer.traceObject(null, replyPacket, 6);
        }
        if (!bl && n2 != 0) {
            this.throwSQLError(replyPacket);
        }
        return replyPacket;
    }

    private void executeSQLString(String string, int n) throws SQLException {
        RequestPacket requestPacket = this.getRequestPacket();
        requestPacket.initDbs(this.autocommit, 1003);
        requestPacket.addString(string);
        try {
            this.execute(requestPacket, this, n);
        }
        catch (TimeoutException timeoutException) {
            TimeoutException.println(this.toString() + " Inner Timeout " + timeoutException.toString());
        }
    }

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.finalize();
    }

    public void freeRequestPacket(RequestPacket requestPacket) {
        requestPacket.setAvailability(false);
        this.packetPool.push(requestPacket);
    }

    public final boolean getAutoCommit() throws SQLException {
        return this.autocommit;
    }

    public final String getCatalog() throws SQLException {
        return null;
    }

    final String getConnectProperty(String string) {
        return this.connectProperties.getProperty(string, syncObj);
    }

    public final DatabaseMetaData getMetaData() throws SQLException {
        this.assertOpen();
        return this.DatabaseMetaData;
    }

    public final synchronized RequestPacket getRequestPacket() throws SQLException {
        RequestPacket requestPacket;
        String string = this.connectProperties.getProperty("application", null);
        String string2 = this.connectProperties.getProperty("appversion", null);
        if (this.packetPool.isEmpty()) {
            try {
                if (this.isUnicode) {
                    requestPacket = new RequestPacketUnicode(this.session.getRequestPacket(), string, string2);
                }
                requestPacket = new RequestPacket(this.session.getRequestPacket(), 0, string, string2);
            }
            catch (RTEException rTEException) {
                throw new SQLExceptionSapDB(rTEException.toString());
            }
        } else {
            requestPacket = (RequestPacket)this.packetPool.pop();
        }
        requestPacket.setAvailability(true);
        return requestPacket;
    }

    public final int getTransactionIsolation() throws SQLException {
        return this.isolationLevel;
    }

    public final Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.warningList;
    }

    public boolean isClosed() throws SQLException {
        if (this.session == null) {
            return true;
        }
        try {
            RequestPacket requestPacket = this.getRequestPacket();
            requestPacket.initHello();
            this.execute(requestPacket, this, 1);
        }
        catch (TimeoutException timeoutException) {
            TimeoutException.println(this.toString() + " Inner Timeout " + timeoutException.toString());
        }
        catch (SQLException sQLException) {
            TimeoutException.println(this.toString() + " Inner SQLException " + sQLException.toString());
            try {
                this.session.release();
            }
            catch (Exception exception) {
                TimeoutException.println(this + sQLException.toString());
            }
            this.session = null;
            this.DatabaseMetaData = null;
            return true;
        }
        return this.session == null;
    }

    public final boolean isReadOnly() throws SQLException {
        return false;
    }

    boolean isInTransaction() {
        return !this.autocommit && this.inTransaction;
    }

    final synchronized int maxStatementLength() throws SQLException {
        RequestPacket requestPacket = this.getRequestPacket();
        int n = requestPacket.size();
        int n2 = n - 32 - 40 - 16;
        this.freeRequestPacket(requestPacket);
        return n2;
    }

    public final String nativeSQL(String string) throws SQLException {
        return string;
    }

    final String nextCursorName() {
        return this.UniqueID.getNextID(this.cursorPrefix);
    }

    protected final void setCursorPrefix(String string) {
        this.cursorPrefix = string;
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        this.assertOpen();
        return new CallableStatementSapDB(this, string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.assertOpen();
        return new CallableStatementSapDB(this, string, n, n2, 1);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.assertOpen();
        return new CallableStatementSapDB(this, string);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.assertOpen();
        return new CallableStatementSapDB(this, string, n, n2, 1);
    }

    public void rollback() throws SQLException {
        this.assertOpen();
        this.executeSQLString("ROLLBACK WORK", 1);
        this.inTransaction = false;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.assertOpen();
        this.autocommit = bl;
    }

    public final void setCatalog(String string) throws SQLException {
    }

    public final void setReadOnly(boolean bl) throws SQLException {
        this.assertOpen();
    }

    public final void setTransactionIsolation(int n) throws SQLException {
        if (this.isolationLevel != n) {
            String string = DriverSapDB.isolevelJdbc2native(n);
            this.assertOpen();
            String string2 = "SET ISOLATION LEVEL " + string;
            InternalStatementSapDB internalStatementSapDB = new InternalStatementSapDB(this);
            internalStatementSapDB.executeUpdate(string2);
            this.isolationLevel = n;
        }
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    final void throwBatchException(ReplyPacket replyPacket, int[] nArray, int n) throws BatchUpdateException {
        String string = replyPacket.sqlState();
        int n2 = replyPacket.returnCode();
        String string2 = replyPacket.getErrorMsg();
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        throw new BatchUpdateException(string2, string, n2, nArray2);
    }

    private final void throwSQLError(ReplyPacket replyPacket) throws SQLExceptionSapDB {
        DatabaseException databaseException = replyPacket.createException();
        throw databaseException;
    }

    protected void tryReconnect(RTEException rTEException) throws SQLException {
        Object object;
        Object object2 = object = TimeoutException.extendedTrace == null ? syncObj : TimeoutException.extendedTrace;
        synchronized (object2) {
            TimeoutException timeoutException = new TimeoutException(rTEException);
            if (this.parseCache != null) {
                this.parseCache.clear();
            }
            if (this.dbsCache != null) {
                this.dbsCache.clear();
            }
            this.packetPool.setSize(0);
            this.inReconnect = true;
            try {
                this.session.reconnect();
                this.doConnect(this.connectProperties);
                TimeoutException.println("+++ connected again +++");
            }
            catch (RTEException rTEException2) {
                TimeoutException.println("--- reconnect failed: " + rTEException2.getMessage() + " ---");
                throw new ConnectionException(rTEException2);
            }
            finally {
                this.inReconnect = false;
            }
            throw timeoutException;
        }
    }

    public final void dropParseid(byte[] byArray) {
        if (!this.keepGarbage) {
            if (byArray == null) {
                return;
            }
            if (this.garbageParseids == null) {
                this.garbageParseids = new GarbageParseid(this.isKernelFeaturesupported(1));
            }
            this.garbageParseids.throwIntoGarbageCan(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropCursor(String string) {
        ConnectionSapDB connectionSapDB = this;
        synchronized (connectionSapDB) {
            if (this.garbageCursors == null) {
                this.garbageCursors = new GarbageCursor();
            }
            this.garbageCursors.throwIntoGarbageCan(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean restoreCursor(String string) {
        ConnectionSapDB connectionSapDB = this;
        synchronized (connectionSapDB) {
            if (this.garbageCursors != null) {
                return this.garbageCursors.restoreFromGarbageCan(string);
            }
            return false;
        }
    }

    public void printCacheStats(PrintStream printStream) {
        if (this.parseCache == null) {
            printStream.println("no cache available");
        } else {
            this.parseCache.dumpStats(printStream);
        }
    }

    public void printCacheStats(PrintWriter printWriter) {
        if (this.parseCache == null) {
            printWriter.println("no cache available");
        } else {
            this.parseCache.dumpStats(printWriter);
        }
    }

    public boolean isSQLModeOracle() {
        return this.isSQLModeOracle;
    }

    public void setHoldability(int n) throws SQLException {
        this.resultSetHoldability = n;
    }

    public int getHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.autocommit"));
        }
        return SavepointSapDB.setSavepoint(this);
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.autocommit"));
        }
        return SavepointSapDB.setSavepoint(string, this);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.connection.autocommit"));
        }
        SavepointSapDB.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        SavepointSapDB.releaseSavepoint(savepoint);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.assertOpen();
        return new StatementSapDB(this, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.assertOpen();
        return new CallableStatementSapDB(this, string, n, n2, n3);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.assertOpen();
        return new CallableStatementSapDB(this, string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.preparestatement.notimplemented"));
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.preparestatement.notimplemented"));
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.preparestatement.notimplemented"));
    }

    public void reinitialize() throws SQLException {
        int n;
        Object object;
        if (this.parseCache != null) {
            object = this.parseCache.clearAll();
            for (n = 0; n < ((Object[])object).length; ++n) {
                ((Parseinfo)object[n]).dropParseIDs();
            }
        }
        int n2 = n = (object = this.connectProperties.getProperty("isolation")) == null ? 2 : DriverSapDB.isolevelString2Jdbc((String)object);
        if (n != this.getTransactionIsolation()) {
            this.setTransactionIsolation(n);
        }
        this.setAutoCommit(DriverSapDB.getBooleanProperty(this.connectProperties, "autocommit", true));
        this.resultSetHoldability = 1;
        this.typeMap = null;
    }

    int getKernelVersion() {
        return this.kernelversion;
    }

    private void setKernelFeatureRequest(int n) {
        this.kernelFeatures[2 * (n - 1) + 1] = 1;
    }

    boolean isKernelFeaturesupported(int n) {
        boolean bl = this.kernelFeatures[2 * (n - 1) + 1] == 1;
        return bl;
    }
}

