/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001 Michael Goffioul <goffioul@imec.be>
 *
 *  $Id: kminstancepage.h,v 1.2 2001/03/24 07:27:49 waba Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 **/

#ifndef KMINSTANCEPAGE_H
#define KMINSTANCEPAGE_H

#include <kmainwindow.h>
#include "kmprinterpage.h"

class KListBox;
class KMPrinter;
class KActionCollection;
class KToolBar;

class KMInstancePage : public QWidget, public KMPrinterPage
{
	Q_OBJECT
public:
	KMInstancePage(QWidget *parent = 0, const char *name = 0);
	~KMInstancePage();

	void setPrinter(KMPrinter*);

protected slots:
	void slotNew();
	void slotCopy();
	void slotRemove();
	void slotDefault();
	void slotTest();
	void slotSettings();

protected:
	void initActions();

private:
	KListBox		*m_view;
	KActionCollection	*m_actions;
	KToolBar		*m_toolbar;
	KMPrinter		*m_printer;
};

#endif
