/* bindingcommon.c generated by valac 0.40.8, the Vala compiler
 * generated from bindingcommon.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2018 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2018 Takao Fujwiara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */
/* This file depends on keybindingmanager.vala */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BINDING_COMMON (binding_common_get_type ())
#define BINDING_COMMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BINDING_COMMON, BindingCommon))
#define BINDING_COMMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BINDING_COMMON, BindingCommonClass))
#define IS_BINDING_COMMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BINDING_COMMON))
#define IS_BINDING_COMMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BINDING_COMMON))
#define BINDING_COMMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BINDING_COMMON, BindingCommonClass))

typedef struct _BindingCommon BindingCommon;
typedef struct _BindingCommonClass BindingCommonClass;
typedef struct _BindingCommonPrivate BindingCommonPrivate;

#define BINDING_COMMON_TYPE_KEY_EVENT_FUNC_TYPE (binding_common_key_event_func_type_get_type ())

#define TYPE_KEYBINDING_MANAGER (keybinding_manager_get_type ())
#define KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManager))
#define KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))
#define IS_KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYBINDING_MANAGER))
#define IS_KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYBINDING_MANAGER))
#define KEYBINDING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))

typedef struct _KeybindingManager KeybindingManager;
typedef struct _KeybindingManagerClass KeybindingManagerClass;

#define BINDING_COMMON_TYPE_KEYBINDING (binding_common_keybinding_get_type ())
#define BINDING_COMMON_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybinding))
#define BINDING_COMMON_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybindingClass))
#define BINDING_COMMON_IS_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BINDING_COMMON_TYPE_KEYBINDING))
#define BINDING_COMMON_IS_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BINDING_COMMON_TYPE_KEYBINDING))
#define BINDING_COMMON_KEYBINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybindingClass))

typedef struct _BindingCommonKeybinding BindingCommonKeybinding;
typedef struct _BindingCommonKeybindingClass BindingCommonKeybindingClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _BindingCommonKeybindingPrivate BindingCommonKeybindingPrivate;
enum  {
	BINDING_COMMON_KEYBINDING_0_PROPERTY,
	BINDING_COMMON_KEYBINDING_KEYSYM_PROPERTY,
	BINDING_COMMON_KEYBINDING_MODIFIERS_PROPERTY,
	BINDING_COMMON_KEYBINDING_REVERSE_PROPERTY,
	BINDING_COMMON_KEYBINDING_FTYPE_PROPERTY,
	BINDING_COMMON_KEYBINDING_NUM_PROPERTIES
};
static GParamSpec* binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_NUM_PROPERTIES];
typedef struct _ParamSpecBindingCommon ParamSpecBindingCommon;

struct _BindingCommon {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BindingCommonPrivate * priv;
};

struct _BindingCommonClass {
	GTypeClass parent_class;
	void (*finalize) (BindingCommon *self);
};

typedef enum  {
	BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY,
	BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER,
	BINDING_COMMON_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING
} BindingCommonKeyEventFuncType;

typedef void (*KeybindingManagerKeybindingHandlerFunc) (GdkEvent* event, gpointer user_data);
struct _BindingCommonKeybinding {
	GObject parent_instance;
	BindingCommonKeybindingPrivate * priv;
};

struct _BindingCommonKeybindingClass {
	GObjectClass parent_class;
};

struct _BindingCommonKeybindingPrivate {
	guint _keysym;
	GdkModifierType _modifiers;
	gboolean _reverse;
	BindingCommonKeyEventFuncType _ftype;
};

typedef void (*BindingCommonKeybindingFuncHandlerFunc) (GdkEvent* event, gpointer user_data);
struct _ParamSpecBindingCommon {
	GParamSpec parent_instance;
};


static gpointer binding_common_parent_class = NULL;
static gpointer binding_common_keybinding_parent_class = NULL;

gpointer binding_common_ref (gpointer instance);
void binding_common_unref (gpointer instance);
GParamSpec* param_spec_binding_common (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_binding_common (GValue* value,
                               gpointer v_object);
void value_take_binding_common (GValue* value,
                                gpointer v_object);
gpointer value_get_binding_common (const GValue* value);
GType binding_common_get_type (void) G_GNUC_CONST;
GType binding_common_key_event_func_type_get_type (void) G_GNUC_CONST;
GType keybinding_manager_get_type (void) G_GNUC_CONST;
GType binding_common_keybinding_get_type (void) G_GNUC_CONST;
void binding_common_keybinding_manager_bind (KeybindingManager* keybinding_manager,
                                             GList* * keybindings,
                                             const gchar* accelerator,
                                             BindingCommonKeyEventFuncType ftype,
                                             KeybindingManagerKeybindingHandlerFunc handler_normal,
                                             gpointer handler_normal_target,
                                             KeybindingManagerKeybindingHandlerFunc handler_reverse,
                                             gpointer handler_reverse_target);
BindingCommonKeybinding* binding_common_keybinding_new (guint keysym,
                                                        GdkModifierType modifiers,
                                                        gboolean reverse,
                                                        BindingCommonKeyEventFuncType ftype);
BindingCommonKeybinding* binding_common_keybinding_construct (GType object_type,
                                                              guint keysym,
                                                              GdkModifierType modifiers,
                                                              gboolean reverse,
                                                              BindingCommonKeyEventFuncType ftype);
gboolean keybinding_manager_bind (KeybindingManager* self,
                                  guint keysym,
                                  GdkModifierType modifiers,
                                  KeybindingManagerKeybindingHandlerFunc handler,
                                  gpointer handler_target);
void binding_common_unbind_switch_shortcut (BindingCommonKeyEventFuncType ftype,
                                            GList* keybindings);
KeybindingManager* keybinding_manager_get_instance (void);
BindingCommonKeyEventFuncType binding_common_keybinding_get_ftype (BindingCommonKeybinding* self);
void keybinding_manager_unbind (KeybindingManager* self,
                                guint keysym,
                                GdkModifierType modifiers);
guint binding_common_keybinding_get_keysym (BindingCommonKeybinding* self);
GdkModifierType binding_common_keybinding_get_modifiers (BindingCommonKeybinding* self);
void binding_common_set_custom_font (GSettings* settings_panel,
                                     GSettings* settings_emoji,
                                     GtkCssProvider* * css_provider);
void ibus_emojier_set_emoji_font (const gchar* emoji_font);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
BindingCommon* binding_common_new (void);
BindingCommon* binding_common_construct (GType object_type);
#define BINDING_COMMON_KEYBINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybindingPrivate))
void binding_common_keybinding_set_keysym (BindingCommonKeybinding* self,
                                           guint value);
void binding_common_keybinding_set_modifiers (BindingCommonKeybinding* self,
                                              GdkModifierType value);
void binding_common_keybinding_set_reverse (BindingCommonKeybinding* self,
                                            gboolean value);
void binding_common_keybinding_set_ftype (BindingCommonKeybinding* self,
                                          BindingCommonKeyEventFuncType value);
gboolean binding_common_keybinding_get_reverse (BindingCommonKeybinding* self);
static void binding_common_keybinding_finalize (GObject * obj);
static void _vala_binding_common_keybinding_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_binding_common_keybinding_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void binding_common_finalize (BindingCommon * obj);


GType
binding_common_key_event_func_type_get_type (void)
{
	static volatile gsize binding_common_key_event_func_type_type_id__volatile = 0;
	if (g_once_init_enter (&binding_common_key_event_func_type_type_id__volatile)) {
		static const GEnumValue values[] = {{BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY, "BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY", "any"}, {BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER, "BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER", "ime-switcher"}, {BINDING_COMMON_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING, "BINDING_COMMON_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING", "emoji-typing"}, {0, NULL, NULL}};
		GType binding_common_key_event_func_type_type_id;
		binding_common_key_event_func_type_type_id = g_enum_register_static ("BindingCommonKeyEventFuncType", values);
		g_once_init_leave (&binding_common_key_event_func_type_type_id__volatile, binding_common_key_event_func_type_type_id);
	}
	return binding_common_key_event_func_type_type_id__volatile;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
binding_common_keybinding_manager_bind (KeybindingManager* keybinding_manager,
                                        GList* * keybindings,
                                        const gchar* accelerator,
                                        BindingCommonKeyEventFuncType ftype,
                                        KeybindingManagerKeybindingHandlerFunc handler_normal,
                                        gpointer handler_normal_target,
                                        KeybindingManagerKeybindingHandlerFunc handler_reverse,
                                        gpointer handler_reverse_target)
{
	guint switch_keysym = 0U;
	GdkModifierType switch_modifiers = 0;
	GdkModifierType reverse_modifier = 0;
	BindingCommonKeybinding* keybinding = NULL;
	guint _tmp0_ = 0U;
	GdkModifierType _tmp1_ = 0;
	static const GdkModifierType VIRTUAL_MODIFIERS = (GDK_SUPER_MASK | GDK_HYPER_MASK) | GDK_META_MASK;
	GdkModifierType _tmp2_;
	gboolean _tmp5_ = FALSE;
	guint _tmp6_;
	guint _tmp8_;
	GdkModifierType _tmp9_;
	BindingCommonKeybinding* _tmp10_;
	BindingCommonKeybinding* _tmp11_;
	BindingCommonKeybinding* _tmp12_;
	guint _tmp13_;
	GdkModifierType _tmp14_;
	GdkModifierType _tmp15_;
	GdkModifierType _tmp16_;
	GdkModifierType _tmp17_;
	GdkModifierType _tmp18_;
	guint _tmp19_;
	GdkModifierType _tmp20_;
	BindingCommonKeybinding* _tmp21_;
	BindingCommonKeybinding* _tmp22_;
	BindingCommonKeybinding* _tmp23_;
	g_return_if_fail (keybinding_manager != NULL);
	switch_keysym = (guint) 0;
	switch_modifiers = 0;
	reverse_modifier = GDK_SHIFT_MASK;
	gtk_accelerator_parse (accelerator, &_tmp0_, &_tmp1_);
	switch_keysym = _tmp0_;
	switch_modifiers = _tmp1_;
	_tmp2_ = switch_modifiers;
	if ((_tmp2_ & VIRTUAL_MODIFIERS) != 0) {
		GdkKeymap* _tmp3_;
		GdkModifierType _tmp4_;
		_tmp3_ = gdk_keymap_get_default ();
		gdk_keymap_map_virtual_modifiers (_tmp3_, &switch_modifiers);
		_tmp4_ = switch_modifiers;
		switch_modifiers = _tmp4_ & (~VIRTUAL_MODIFIERS);
	}
	_tmp6_ = switch_keysym;
	if (_tmp6_ == ((guint) 0)) {
		GdkModifierType _tmp7_;
		_tmp7_ = switch_modifiers;
		_tmp5_ = _tmp7_ == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		g_warning ("bindingcommon.vala:90: Parse accelerator '%s' failed!", accelerator);
		_g_object_unref0 (keybinding);
		return;
	}
	_tmp8_ = switch_keysym;
	_tmp9_ = switch_modifiers;
	_tmp10_ = binding_common_keybinding_new (_tmp8_, _tmp9_, FALSE, ftype);
	_g_object_unref0 (keybinding);
	keybinding = _tmp10_;
	_tmp11_ = keybinding;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	*keybindings = g_list_append (*keybindings, _tmp12_);
	_tmp13_ = switch_keysym;
	_tmp14_ = switch_modifiers;
	keybinding_manager_bind (keybinding_manager, _tmp13_, _tmp14_, handler_normal, handler_normal_target);
	if (ftype == BINDING_COMMON_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING) {
		_g_object_unref0 (keybinding);
		return;
	}
	_tmp15_ = switch_modifiers;
	_tmp16_ = reverse_modifier;
	if ((_tmp15_ & _tmp16_) != 0) {
		_g_object_unref0 (keybinding);
		return;
	}
	_tmp17_ = switch_modifiers;
	_tmp18_ = reverse_modifier;
	switch_modifiers = _tmp17_ | _tmp18_;
	_tmp19_ = switch_keysym;
	_tmp20_ = switch_modifiers;
	_tmp21_ = binding_common_keybinding_new (_tmp19_, _tmp20_, TRUE, ftype);
	_g_object_unref0 (keybinding);
	keybinding = _tmp21_;
	_tmp22_ = keybinding;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	*keybindings = g_list_append (*keybindings, _tmp23_);
	if (ftype == BINDING_COMMON_KEY_EVENT_FUNC_TYPE_IME_SWITCHER) {
		guint _tmp24_;
		GdkModifierType _tmp25_;
		_tmp24_ = switch_keysym;
		_tmp25_ = switch_modifiers;
		keybinding_manager_bind (keybinding_manager, _tmp24_, _tmp25_, handler_reverse, handler_reverse_target);
	}
	_g_object_unref0 (keybinding);
	return;
}


void
binding_common_unbind_switch_shortcut (BindingCommonKeyEventFuncType ftype,
                                       GList* keybindings)
{
	KeybindingManager* keybinding_manager = NULL;
	KeybindingManager* _tmp0_;
	_tmp0_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp0_;
	while (TRUE) {
		BindingCommonKeybinding* keybinding = NULL;
		gconstpointer _tmp1_;
		BindingCommonKeybinding* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GList* _tmp14_;
		if (!(keybindings != NULL)) {
			break;
		}
		_tmp1_ = keybindings->data;
		_tmp2_ = _g_object_ref0 ((BindingCommonKeybinding*) _tmp1_);
		keybinding = _tmp2_;
		if (ftype == BINDING_COMMON_KEY_EVENT_FUNC_TYPE_ANY) {
			_tmp3_ = TRUE;
		} else {
			BindingCommonKeybinding* _tmp4_;
			BindingCommonKeyEventFuncType _tmp5_;
			BindingCommonKeyEventFuncType _tmp6_;
			_tmp4_ = keybinding;
			_tmp5_ = binding_common_keybinding_get_ftype (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp3_ = ftype == _tmp6_;
		}
		if (_tmp3_) {
			KeybindingManager* _tmp7_;
			BindingCommonKeybinding* _tmp8_;
			guint _tmp9_;
			guint _tmp10_;
			BindingCommonKeybinding* _tmp11_;
			GdkModifierType _tmp12_;
			GdkModifierType _tmp13_;
			_tmp7_ = keybinding_manager;
			_tmp8_ = keybinding;
			_tmp9_ = binding_common_keybinding_get_keysym (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = keybinding;
			_tmp12_ = binding_common_keybinding_get_modifiers (_tmp11_);
			_tmp13_ = _tmp12_;
			keybinding_manager_unbind (_tmp7_, _tmp10_, _tmp13_);
		}
		_tmp14_ = keybindings->next;
		keybindings = _tmp14_;
		_g_object_unref0 (keybinding);
	}
	_g_object_unref0 (keybinding_manager);
}


static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}


void
binding_common_set_custom_font (GSettings* settings_panel,
                                GSettings* settings_emoji,
                                GtkCssProvider* * css_provider)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkScreen* _tmp2_ = NULL;
	GdkDisplay* _tmp3_;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp6_;
	GdkScreen* _tmp7_;
	gboolean use_custom_font = FALSE;
	gboolean _tmp12_;
	gchar* custom_font = NULL;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	PangoFontDescription* font_desc = NULL;
	const gchar* _tmp15_;
	PangoFontDescription* _tmp16_;
	gchar* font_family = NULL;
	PangoFontDescription* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gint font_size = 0;
	PangoFontDescription* _tmp20_;
	gchar* data = NULL;
	gboolean _tmp21_ = FALSE;
	GtkCssProvider* _tmp28_;
	GdkScreen* _tmp33_;
	GError * _inner_error_ = NULL;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp3_ = display;
	if (_tmp3_ != NULL) {
		GdkDisplay* _tmp4_;
		GdkScreen* _tmp5_;
		_tmp4_ = display;
		_tmp5_ = gdk_display_get_default_screen (_tmp4_);
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp2_);
	screen = _tmp6_;
	_tmp7_ = screen;
	if (_tmp7_ == NULL) {
		g_warning ("bindingcommon.vala:152: Could not open display.");
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	if (settings_emoji != NULL) {
		gchar* emoji_font = NULL;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = g_settings_get_string (settings_emoji, "font");
		emoji_font = _tmp8_;
		_tmp9_ = emoji_font;
		if (_tmp9_ == NULL) {
			g_warning ("bindingcommon.vala:159: No config emoji:font.");
			_g_free0 (emoji_font);
			_g_object_unref0 (screen);
			_g_object_unref0 (display);
			return;
		}
		_tmp10_ = emoji_font;
		ibus_emojier_set_emoji_font (_tmp10_);
		_g_free0 (emoji_font);
	}
	if (settings_panel == NULL) {
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	use_custom_font = g_settings_get_boolean (settings_panel, "use-custom-font");
	if ((*css_provider) != NULL) {
		GdkScreen* _tmp11_;
		_tmp11_ = screen;
		gtk_style_context_remove_provider_for_screen (_tmp11_, (GtkStyleProvider*) (*css_provider));
		_g_object_unref0 (*css_provider);
		*css_provider = NULL;
	}
	_tmp12_ = use_custom_font;
	if (_tmp12_ == FALSE) {
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp13_ = g_settings_get_string (settings_panel, "custom-font");
	custom_font = _tmp13_;
	_tmp14_ = custom_font;
	if (_tmp14_ == NULL) {
		g_warning ("bindingcommon.vala:182: No config panel:custom-font.");
		_g_free0 (custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp15_ = custom_font;
	_tmp16_ = pango_font_description_from_string (_tmp15_);
	font_desc = _tmp16_;
	_tmp17_ = font_desc;
	_tmp18_ = pango_font_description_get_family (_tmp17_);
	_tmp19_ = g_strdup (_tmp18_);
	font_family = _tmp19_;
	_tmp20_ = font_desc;
	font_size = pango_font_description_get_size (_tmp20_) / PANGO_SCALE;
	if (GTK_MAJOR_VERSION < 3) {
		_tmp21_ = TRUE;
	} else {
		gboolean _tmp22_ = FALSE;
		if (GTK_MAJOR_VERSION == 3) {
			_tmp22_ = GTK_MINOR_VERSION < 20;
		} else {
			_tmp22_ = FALSE;
		}
		_tmp21_ = _tmp22_;
	}
	if (_tmp21_) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp23_ = custom_font;
		_tmp24_ = g_strdup_printf ("GtkLabel { font: %s; }", _tmp23_);
		_g_free0 (data);
		data = _tmp24_;
	} else {
		const gchar* _tmp25_;
		gint _tmp26_;
		gchar* _tmp27_;
		_tmp25_ = font_family;
		_tmp26_ = font_size;
		_tmp27_ = g_strdup_printf ("label { font-family: %s; font-size: %dpt; }", _tmp25_, _tmp26_);
		_g_free0 (data);
		data = _tmp27_;
	}
	_tmp28_ = gtk_css_provider_new ();
	_g_object_unref0 (*css_provider);
	*css_provider = _tmp28_;
	{
		const gchar* _tmp29_;
		_tmp29_ = data;
		gtk_css_provider_load_from_data (*css_provider, _tmp29_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = custom_font;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		g_warning ("bindingcommon.vala:205: Failed css_provider_from_data: %s: %s", _tmp30_, _tmp32_);
		_g_error_free0 (e);
		_g_free0 (data);
		_g_free0 (font_family);
		__vala_PangoFontDescription_free0 (font_desc);
		_g_free0 (custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (data);
		_g_free0 (font_family);
		__vala_PangoFontDescription_free0 (font_desc);
		_g_free0 (custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp33_ = screen;
	gtk_style_context_add_provider_for_screen (_tmp33_, (GtkStyleProvider*) (*css_provider), (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_free0 (data);
	_g_free0 (font_family);
	__vala_PangoFontDescription_free0 (font_desc);
	_g_free0 (custom_font);
	_g_object_unref0 (screen);
	_g_object_unref0 (display);
}


BindingCommon*
binding_common_construct (GType object_type)
{
	BindingCommon* self = NULL;
	self = (BindingCommon*) g_type_create_instance (object_type);
	return self;
}


BindingCommon*
binding_common_new (void)
{
	return binding_common_construct (TYPE_BINDING_COMMON);
}


BindingCommonKeybinding*
binding_common_keybinding_construct (GType object_type,
                                     guint keysym,
                                     GdkModifierType modifiers,
                                     gboolean reverse,
                                     BindingCommonKeyEventFuncType ftype)
{
	BindingCommonKeybinding * self = NULL;
	self = (BindingCommonKeybinding*) g_object_new (object_type, NULL);
	binding_common_keybinding_set_keysym (self, keysym);
	binding_common_keybinding_set_modifiers (self, modifiers);
	binding_common_keybinding_set_reverse (self, reverse);
	binding_common_keybinding_set_ftype (self, ftype);
	return self;
}


BindingCommonKeybinding*
binding_common_keybinding_new (guint keysym,
                               GdkModifierType modifiers,
                               gboolean reverse,
                               BindingCommonKeyEventFuncType ftype)
{
	return binding_common_keybinding_construct (BINDING_COMMON_TYPE_KEYBINDING, keysym, modifiers, reverse, ftype);
}


guint
binding_common_keybinding_get_keysym (BindingCommonKeybinding* self)
{
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_keysym;
	result = _tmp0_;
	return result;
}


void
binding_common_keybinding_set_keysym (BindingCommonKeybinding* self,
                                      guint value)
{
	g_return_if_fail (self != NULL);
	if (binding_common_keybinding_get_keysym (self) != value) {
		self->priv->_keysym = value;
		g_object_notify_by_pspec ((GObject *) self, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_KEYSYM_PROPERTY]);
	}
}


GdkModifierType
binding_common_keybinding_get_modifiers (BindingCommonKeybinding* self)
{
	GdkModifierType result;
	GdkModifierType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_modifiers;
	result = _tmp0_;
	return result;
}


void
binding_common_keybinding_set_modifiers (BindingCommonKeybinding* self,
                                         GdkModifierType value)
{
	g_return_if_fail (self != NULL);
	if (binding_common_keybinding_get_modifiers (self) != value) {
		self->priv->_modifiers = value;
		g_object_notify_by_pspec ((GObject *) self, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_MODIFIERS_PROPERTY]);
	}
}


gboolean
binding_common_keybinding_get_reverse (BindingCommonKeybinding* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_reverse;
	result = _tmp0_;
	return result;
}


void
binding_common_keybinding_set_reverse (BindingCommonKeybinding* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	if (binding_common_keybinding_get_reverse (self) != value) {
		self->priv->_reverse = value;
		g_object_notify_by_pspec ((GObject *) self, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_REVERSE_PROPERTY]);
	}
}


BindingCommonKeyEventFuncType
binding_common_keybinding_get_ftype (BindingCommonKeybinding* self)
{
	BindingCommonKeyEventFuncType result;
	BindingCommonKeyEventFuncType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_ftype;
	result = _tmp0_;
	return result;
}


void
binding_common_keybinding_set_ftype (BindingCommonKeybinding* self,
                                     BindingCommonKeyEventFuncType value)
{
	g_return_if_fail (self != NULL);
	if (binding_common_keybinding_get_ftype (self) != value) {
		self->priv->_ftype = value;
		g_object_notify_by_pspec ((GObject *) self, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_FTYPE_PROPERTY]);
	}
}


static void
binding_common_keybinding_class_init (BindingCommonKeybindingClass * klass)
{
	binding_common_keybinding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BindingCommonKeybindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_binding_common_keybinding_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_binding_common_keybinding_set_property;
	G_OBJECT_CLASS (klass)->finalize = binding_common_keybinding_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BINDING_COMMON_KEYBINDING_KEYSYM_PROPERTY, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_KEYSYM_PROPERTY] = g_param_spec_uint ("keysym", "keysym", "keysym", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BINDING_COMMON_KEYBINDING_MODIFIERS_PROPERTY, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_MODIFIERS_PROPERTY] = g_param_spec_flags ("modifiers", "modifiers", "modifiers", gdk_modifier_type_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BINDING_COMMON_KEYBINDING_REVERSE_PROPERTY, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_REVERSE_PROPERTY] = g_param_spec_boolean ("reverse", "reverse", "reverse", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BINDING_COMMON_KEYBINDING_FTYPE_PROPERTY, binding_common_keybinding_properties[BINDING_COMMON_KEYBINDING_FTYPE_PROPERTY] = g_param_spec_enum ("ftype", "ftype", "ftype", BINDING_COMMON_TYPE_KEY_EVENT_FUNC_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
binding_common_keybinding_instance_init (BindingCommonKeybinding * self)
{
	self->priv = BINDING_COMMON_KEYBINDING_GET_PRIVATE (self);
}


static void
binding_common_keybinding_finalize (GObject * obj)
{
	BindingCommonKeybinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybinding);
	G_OBJECT_CLASS (binding_common_keybinding_parent_class)->finalize (obj);
}


GType
binding_common_keybinding_get_type (void)
{
	static volatile gsize binding_common_keybinding_type_id__volatile = 0;
	if (g_once_init_enter (&binding_common_keybinding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BindingCommonKeybindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) binding_common_keybinding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BindingCommonKeybinding), 0, (GInstanceInitFunc) binding_common_keybinding_instance_init, NULL };
		GType binding_common_keybinding_type_id;
		binding_common_keybinding_type_id = g_type_register_static (G_TYPE_OBJECT, "BindingCommonKeybinding", &g_define_type_info, 0);
		g_once_init_leave (&binding_common_keybinding_type_id__volatile, binding_common_keybinding_type_id);
	}
	return binding_common_keybinding_type_id__volatile;
}


static void
_vala_binding_common_keybinding_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	BindingCommonKeybinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybinding);
	switch (property_id) {
		case BINDING_COMMON_KEYBINDING_KEYSYM_PROPERTY:
		g_value_set_uint (value, binding_common_keybinding_get_keysym (self));
		break;
		case BINDING_COMMON_KEYBINDING_MODIFIERS_PROPERTY:
		g_value_set_flags (value, binding_common_keybinding_get_modifiers (self));
		break;
		case BINDING_COMMON_KEYBINDING_REVERSE_PROPERTY:
		g_value_set_boolean (value, binding_common_keybinding_get_reverse (self));
		break;
		case BINDING_COMMON_KEYBINDING_FTYPE_PROPERTY:
		g_value_set_enum (value, binding_common_keybinding_get_ftype (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_binding_common_keybinding_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	BindingCommonKeybinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BINDING_COMMON_TYPE_KEYBINDING, BindingCommonKeybinding);
	switch (property_id) {
		case BINDING_COMMON_KEYBINDING_KEYSYM_PROPERTY:
		binding_common_keybinding_set_keysym (self, g_value_get_uint (value));
		break;
		case BINDING_COMMON_KEYBINDING_MODIFIERS_PROPERTY:
		binding_common_keybinding_set_modifiers (self, g_value_get_flags (value));
		break;
		case BINDING_COMMON_KEYBINDING_REVERSE_PROPERTY:
		binding_common_keybinding_set_reverse (self, g_value_get_boolean (value));
		break;
		case BINDING_COMMON_KEYBINDING_FTYPE_PROPERTY:
		binding_common_keybinding_set_ftype (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
value_binding_common_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
value_binding_common_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		binding_common_unref (value->data[0].v_pointer);
	}
}


static void
value_binding_common_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = binding_common_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
value_binding_common_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
value_binding_common_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BindingCommon * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = binding_common_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
value_binding_common_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	BindingCommon ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = binding_common_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
param_spec_binding_common (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecBindingCommon* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BINDING_COMMON), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
value_get_binding_common (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BINDING_COMMON), NULL);
	return value->data[0].v_pointer;
}


void
value_set_binding_common (GValue* value,
                          gpointer v_object)
{
	BindingCommon * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BINDING_COMMON));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BINDING_COMMON));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		binding_common_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		binding_common_unref (old);
	}
}


void
value_take_binding_common (GValue* value,
                           gpointer v_object)
{
	BindingCommon * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BINDING_COMMON));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BINDING_COMMON));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		binding_common_unref (old);
	}
}


static void
binding_common_class_init (BindingCommonClass * klass)
{
	binding_common_parent_class = g_type_class_peek_parent (klass);
	((BindingCommonClass *) klass)->finalize = binding_common_finalize;
}


static void
binding_common_instance_init (BindingCommon * self)
{
	self->ref_count = 1;
}


static void
binding_common_finalize (BindingCommon * obj)
{
	BindingCommon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BINDING_COMMON, BindingCommon);
	g_signal_handlers_destroy (self);
}


GType
binding_common_get_type (void)
{
	static volatile gsize binding_common_type_id__volatile = 0;
	if (g_once_init_enter (&binding_common_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_binding_common_init, value_binding_common_free_value, value_binding_common_copy_value, value_binding_common_peek_pointer, "p", value_binding_common_collect_value, "p", value_binding_common_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BindingCommonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) binding_common_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BindingCommon), 0, (GInstanceInitFunc) binding_common_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType binding_common_type_id;
		binding_common_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BindingCommon", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&binding_common_type_id__volatile, binding_common_type_id);
	}
	return binding_common_type_id__volatile;
}


gpointer
binding_common_ref (gpointer instance)
{
	BindingCommon * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
binding_common_unref (gpointer instance)
{
	BindingCommon * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BINDING_COMMON_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



