/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: basesurf.h,v 1.3.34.1 2004/07/09 01:58:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _BASESURF_H_
#define _BASESURF_H_

#include "hxvctrl.h"
#include "baseroot.h"
#include "coloracc.h"
#include "region.h"
#include "hxmap.h"
#include "hxwin.h"

#if !defined(_GOLD) && 0
#include "timestmp.h"    
#endif

//Bliting modes
#define HX_NO_BLT          -1
#define HX_BASIC_BLT       0
#define HX_OVERLAY_BLT     1
#define HX_BLT_YUV_STRETCH 2

//defines for device caps
#define HX_OVERLAY             (1<<0)  //Supports overlays of some type
#define HX_OVERLAY_STRETCH     (1<<1)  //Supports stretchable overlays
#define HX_BLTFOURCC           (1<<2)  //Supports color conversion in blts

#define HX_OVER_KEYDEST    1
#define HX_OVER_HIDE       2
#define HX_OVER_SHOW       4  
#define HX_OVER_BOB        8
#define OVERLAY_NOT_VISIBLE 0

//XXXgfw just to clean up the code. We still *REALLY* need to clean
//this up in colormap.
#ifdef _WIN32
#define GETBITMAPCOLOR(x) GetBitmapColor( (LPBITMAPINFO)(x) )
#else
#define GETBITMAPCOLOR(x) GetBitmapColor( (HXBitmapInfo*)(x))
#endif
#ifdef _WIN32
#define GETBITMAPPITCH(x) GetBitmapPitch( (LPBITMAPINFO)(x) )
#else
#define GETBITMAPPITCH(x) GetBitmapPitch( (HXBitmapInfo*)(x))
#endif

//Forward declarations
class CHXBaseSite;
class CBaseRootSurface;
class CYUVInputFormatMngr;
class CHWMemObj;

//Just used to optimize YUV alphablending
struct Image
{
    UCHAR*              pucImage;
    HXBitmapInfoHeader bmiImage;
};

struct ImageBlock
{
    Image*       pImage;    //Image to draw
    HXxRect      rect;      //Where to draw it, site rel coords.
    CHXBaseSite* pSrcSite;  //The ARGB site this came from.
    INT32        startX;    //Where this rect starts
    INT32        startY;    //Where this rect starts
};

class CBaseSurface :
public IHXSubRectVideoSurface,
public IHXVideoControl,
public IHXOverlayResponse
{
public:
    friend class CHXBaseSite;
   
#ifdef _MACINTOSH
    friend class CHXMacSite;
#endif
   
    //Creation...
    static CBaseSurface* Create(IUnknown* pContext, CHXBaseSite* pSite);

    //IUnknown methods
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)(THIS);
    STDMETHOD_(ULONG32,Release)(THIS);

    //IHXVideoSurface methods usually called by renderers to Draw on
    //the surface
    STDMETHOD(Blt)(THIS_
                   UCHAR*               pImageData,
                   HXBitmapInfoHeader* pBitmapInfo,
                   REF(HXxRect)         rDestRect,
                   REF(HXxRect)         rSrcRect);

    STDMETHOD(BeginOptimizedBlt)(THIS_ HXBitmapInfoHeader* pBitmapInfo);
    STDMETHOD(OptimizedBlt)     (THIS_
                                 UCHAR*      pImageBits,
                                 REF(HXxRect) rDestRect,
                                 REF(HXxRect) rSrcRect
                                 );
    STDMETHOD(EndOptimizedBlt)  (THIS);
    STDMETHOD(GetOptimizedFormat)(THIS_ REF(HX_COMPRESSION_TYPE) /*OUT*/ ulType);
    STDMETHOD(GetPreferredFormat)(THIS_ REF(HX_COMPRESSION_TYPE) /*OUT*/ ulType);
    
    //IHXSubRectVideoSurface method.
    STDMETHOD(BltSubRects)( THIS_
                            UCHAR*               /*IN*/  pImageBits,
                            HXBitmapInfoHeader* /*IN*/  pBitmapInfo,
                            HXxBoxRegion*          /*IN*/  rDestRects,
                            HXxBoxRegion*          /*IN*/  rSrcRects,
                            float                        fScaleFactorX,
                            float                        fScaleFactorY
                            );
   
    //IHXVideoControls methods
    STDMETHOD_(float, GetBrightness)(THIS);
    STDMETHOD(SetBrightness)        (THIS_ float Brightness);
    STDMETHOD_(float, GetContrast)  (THIS);
    STDMETHOD(SetContrast)          (THIS_ float Contrast);
    STDMETHOD_(float, GetSaturation)(THIS);
    STDMETHOD(SetSaturation)        (THIS_ float Saturation);
    STDMETHOD_(float, GetHue)       (THIS);
    STDMETHOD(SetHue)               (THIS_ float Hue);
    STDMETHOD_(float, GetSharpness) (THIS);
    STDMETHOD(SetSharpness)         (THIS_ float Sharpness);
    STDMETHOD(SetModeSharpness)     (THIS_ UINT16 dFlag);

    /*
     * IHXOverlayResponse methods
     */
    STDMETHOD(OverlayGranted) (THIS);
    STDMETHOD(OverlayRevoked) (THIS);

    // helper methods
    virtual void SetRootSurface( CBaseRootSurface* pSurface);
    HXxRect ComputeIntersection(HXxRect* pRect, HXxRect* newDestRect);
    
    //Overlay support.
    void TryCreateOverlay(BOOL bOverlay);
    void TryCreateOffScreenBuffer();
    HX_RESULT CreateOverlay(BOOL, int cid, int x, int y);
    virtual HX_RESULT ByPassCompositionSurface( UCHAR*               pImageData,
                                        HXBitmapInfoHeader* pBitmapInfo,
                                        HXxRect&             rDestRect,
                                        HXxRect&             rSrcRect,
                                        UCHAR*               pSurface,
                                        LONG32               nSurfPitch 
                                        );
    HX_RESULT UpdateOverlay( REF(HXxRect) rDestRect,
                             REF(HXxRect) rSrcRect,
                             int x=0, int y=0  );
    void      FillColorKey();
    void      FillColorKey(HXxDC hdc);
    INT32     GetOverlayColor();
    void      UpdateDestRect(int x=0, int y=0);
    void      DestroySurfaces();
    virtual void ReInitSurfaces();
    BOOL      ForceGDIMode(BOOL);
    void      ResetUpdateOverlay();
    HX_RESULT BltToPrimary(REF(HXxRect) rDestRect, REF(HXxRect) rSrcRect);

    void      DrawTransitionBorders( HXBitmapInfoHeader* pBitmapInfo,
                                     INT32                width,
                                     ULONG32              color,
                                     BOOL                 bBlendedBorders
                                     );
    void      SetColorspacePriorities(int* pList, int nEntries, int cid);
    void      RestoreColorspacePriorities(int cid);
    void      LinkOverlay(CHXBaseSite* pSite);
    void      AddLinkedSite(CHXBaseSite* pSite);
    virtual HX_RESULT RelinquishOverlay();
    virtual HX_RESULT AcquireOverlay();
    void      UpdateBltStats(HXxRect* pRect);
    
    void      DisableColorControls(float &fBrightness,
                                   float &fContrast,
                                   float &fSaturation,
                                   float &fHue);

    void      EnableColorControls(float fBrightness,
                                  float fContrast,
                                  float fSaturation,
                                  float fHue);

    virtual BOOL _IsDisplaySurfaceYuv();

    HXxSize* GetSurfaceSize()   {return &m_surfaceSize;}

private:
   
    CBaseSurface();
    CBaseSurface( const CBaseSurface& it );
    CBaseSurface& operator=(const CBaseSurface& rhs );
   
protected:
    void _FillColorKey();
    CBaseSurface(IUnknown* pContext, CHXBaseSite* pSite);
    virtual ~CBaseSurface();
    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME
      
    //Converts window coordinates into device coordinates
    //if needed. This is used on Windows at least because
    //its overlays use screen coords instead of window coords.
    //This is a noop on unix as its overlays are in window coords.
    virtual void _GetWindowDeviceCords(HXxRect* rect )=0;
   
    LONG32    m_lRefCount;
    IUnknown* m_pContext;
    IHXOverlayManager* m_pOverlayManager; 
    BOOL   m_bNeedColorKeyFilled;
    BOOL   m_bOffBecauseofShinking;
    float  m_Brightness;
    float  m_Contrast;
    float  m_Saturation;
    float  m_Hue;
    float  m_Sharpness;
    UINT16 m_ModeSharpness;
    float  m_PrevBrightness;
    float  m_PrevContrast;
    float  m_PrevSaturation;
    float  m_PrevHue;
    float  m_PrevSharpness;

    CHXBaseSite*         m_pSite;
    CBaseRootSurface*    m_pRootSurface;
    HXBitmapInfoHeader* m_pOptimizedFormat;
    UINT32               m_oldOverlayColorDepth;
    UINT32               m_convertedOverlayColor;
    
    //Overlay Support
    UINT32  m_nSrcCID;
    UINT32  m_nSurfaceCID;
    HXxSize m_surfaceSize;

public:
    INT32   m_nBltMode;
protected:
    INT32   m_nOldBltMode;
    INT32   m_nOldBltMode2;
    BOOL    m_bBackGroundDirty;
    BOOL    m_bUseOverlays;
    BOOL    m_bDisableFillColorKey;
    BOOL    m_bMultipleOverlay;
    HXxRect m_lastSrcRect;
    BOOL    m_bSpamUpdateOverlay;
    BOOL    m_bFlipOverlay;
    int     m_nBackBufferCount;
    int     m_nMaxBackBuffers;
    int     m_nOverlayFailureCount;       
    int     m_nDDSurfaceSize;
    int     m_nUpdateOverlayByPassCount;
    HXxRect m_lastUpdateDestRect;
    HXxRect m_lastUpdateSrcRect;
    CBaseSurface* m_pLinkedOverlay;
    BOOL    m_bAllowOverlayLinking;
    BOOL    m_bLostHWAcceleration;

#if !defined(_GOLD) && 0
    CTimeSample m_TimeStamps;
#endif

    HXBitmapInfoHeader m_bmi;

    typedef struct tagFrameElement
    {
        int      nIndex;
        INT32    lTimeStamp;
        double   dTimeAvailable;
        INT32    nBltMode;
        UINT32   ulFlags;
        UINT32   dwDDFlags;
        UCHAR    *pImageData;
        BOOL     bAlpha;
        HXxRect  rcSrc;
        HXxRect  rcDst;
        HXBitmapInfoHeader bmi;
        INT32    count;
        AlphaStruct* pAlphaList;
    } tFrameElement;

    //Color Access Functions/
    ColorFuncAccess*        zm_pColorAcc;
    CYUVInputFormatMngr*    m_pyuvInputMngr;
    CHWMemObj*              m_pHwMemObj;

    //Scroll bar support
    double        m_fScrollBarZoom;

    //Support for Alpha Blending.....
    UCHAR*              m_pucLastImage;
    HXBitmapInfoHeader m_bmiLastImage;
    HXBitmapInfoHeader m_bmiLastBlt;
    UINT32              m_ulLastBlendTime;

public:    

    CHXMapPtrToPtr m_YUVAImageList; //Maps site to YUVA image.
    CHXSimpleList  m_imageBlocks;   //List of YUV blended images to paint.

    CHXBaseSite* GetSite()  {return m_pSite;}
protected:
    CHXSimpleList  m_LinkedSites;   
    HXREGION*        m_pAdditionalColorKey;
    BOOL           m_bYUVBlending;
    BOOL           m_bVideoSurface2;
    BOOL           m_bOptimalVideoScheduler;
    
    //XXXgfw I am assuming now that I can use the below scaling for
    //XXXgfw my YUV optimized alphablending...
    double m_scaleFactorX;
    double m_scaleFactorY;
    
    HXxRect* m_paSrcRects;
    HXxRect* m_paDestRects;
    
    //paSrcRects and paDestRects need to be HX_FREEed when you are done
    //with them. internally a realloc is done so don't free then until
    //you are sure you are done or want to reclaim the memory.
    void _ConstructRects(HXxRect&  rSrcRectCopy,
                         HXxRect&  rDestRectCopy,
                         BOOL      bDoAlpha,
                         int&      nNumRects,
                         HXxRect** paSrcRects, 
                         HXxRect** paDestRects,
                         HXREGION*   pAdditionalRegion = NULL
                         );
    //This determines what is the best way to ask for system memory to
    //be filled in by rvrend under VidSurf2.  You must delete the
    //returned region.
    HXREGION* _DetermineBestRegion();

public:    
    //Returns if any blending is going to happen or not.
    BOOL _SetUpBlendRects( HXBitmapInfoHeader* pBitmapInfo = NULL,
                           UCHAR* pImageData = NULL);
protected:    
    BOOL _RecursiveYUVBlend( Image* pImage,
                             HXxRect boundingRect,
                             CBaseSurface* pSurface,
                             INT32 lXOffset,
                             INT32 lYOffset);
        
    //blends the rects and put the results into m_imageBlocks.
    BOOL _BlendYUVRects( AlphaStruct* pList, int nCount, UINT32 ulDestFourCC);
    BOOL _DoYUVRectsIntersect();
    
    void _RemoveYUVImageLists();
    CHXBaseSite* _SearchForYUV(CHXBaseSite* pSite);

    BOOL _AlphaSetupAndBlending(HXBitmapInfoHeader* pBitmapInfo,
                                UCHAR*               pImageData,
                                HXxRect&             rSrcRect,
                                HXxRect&             rDestRect
                                );
   
    void _AlphaBlend( HXREGION*              pRegionToBlend,    //window coords 
                      UCHAR*               pBottomImage,
                      HXBitmapInfoHeader* pbmiBottomImageInfo,
                      HXxPoint*            pBottomPosition,   //window coords
                      UCHAR*               pTopImage,
                      HXBitmapInfoHeader* pbmiTopImageInfo,
                      HXxPoint*            pTopPosition      //window coords
                      );
   
    //Returns whether or not this graphics device allows the shrinking of
    //overlays.
    virtual BOOL _AllowsOverlayShrinking();
    virtual void _WaitForFlush();
    BOOL m_bImageBlocksGood;

    void         AlignRect(HXxRect *pRect, int nMaxWidth, int nMaxHeight);

    virtual void CreateColorAccess(IUnknown* pUnk) {zm_pColorAcc = new ColorFuncAccess(pUnk);}
    virtual void CreateYuvInputMngr();

    BOOL    m_bAllocHook;   // Are we tracing mem allocs
   
public:
   
    //To test if a pixel is transparent or not.
    BOOL IsPixelTransparent(HXxPoint& point, INT32 alpha );

    HXBitmapInfo* GetLastBMI() { return (HXBitmapInfo*)&m_bmiLastBlt; }

    void InitSurface(IUnknown* pUnk);
      
    //Virtual Functions which must me implemented by each OS.

    /************************************************************************
     *  Method:
     *      _ReleaseSurface
     *  Purpose:
     *      Destroys pSurface
     */
    virtual void      _ReleaseSurface(CBaseRootSurface* pSurface) = 0;

    /************************************************************************
     *  Method:
     *      _DrawBlack
     *  Purpose:
     *      Fill the entire region with black
     */
    virtual void      _DrawBlack(void* pWindow) = 0;

    /************************************************************************
     *  Method:
     *      _BltToPrimary
     *  Purpose:
     *      Transfer data from offscreen memory to the primary surface.
     *      This may not be applicable on some platforms.
     */
    virtual HX_RESULT _BltToPrimary(REF(HXxRect) rDestRect, REF(HXxRect) rSrcRect) = 0;

    /************************************************************************
     *  Method:
     *      _CreateBuffer
     *  Purpose:
     *      Create an offscreen (non-overlay) video buffer.  This is used
     *      when overlay is not available .
     *      This may not be applicable on some platforms.
     */
    virtual void      _CreateBuffer() = 0;

    /************************************************************************
     *  Method:
     *      _GetCaps
     *  Purpose:
     *      Query the current display device's drawing capabilities.  See
     *      the list of display caps at the top of this file.
     */
    virtual HX_RESULT _GetCaps(UINT32 *pfSurfaceCaps) = 0;

    /************************************************************************
     *  Method:
     *      _CreateOverlay
     *  Purpose:
     *      Create a video surface of type cid at dimenstions x,y.  If
     *      bOverlay is TRUE, the surface must be overlay.
     */
    virtual HX_RESULT _CreateOverlay(BOOL bOverlay, int cid, int x, int y) = 0; 

    /************************************************************************
     *  Method:
     *      _LockInternalSurface
     *  Purpose:
     *      Obtain a writable pointer to the allocated video surface and
     *      prepare to write to it.
     */
    virtual HX_RESULT _LockInternalSurface(UCHAR** ppSurfPtr, LONG32* pnSurfPitch, REF(HXxSize) srcSize) = 0;

    /************************************************************************
     *  Method:
     *      _UnlockInternalSurface
     *  Purpose:
     *      Inform the video surface that you are finished writing to it.
     */
    virtual HX_RESULT _UnlockInternalSurface(UCHAR* pSurfPtr) = 0;

    
    /************************************************************************
     *  Method:
     *      _SetupDCObjects
     *  Purpose:
     *      Set the current display context with a specific brush and pen.
     *      This may not be applicable on some platforms.
     */
    virtual void      _SetupDCObjects(HXxDC hxxDC,
                                      void** phOldBrush,
                                      void** phOldPen) = 0;
    /************************************************************************
     *  Method:
     *      _FillRectangle
     *  Purpose:
     *      Fill the specified rectangle with the current brush.
     */
    virtual void      _FillRectangle(HXxDC hxxDC,
                                     UINT32 left,
                                     UINT32 top,
                                     UINT32 right,
                                     UINT32 bottom) = 0;
    
    /************************************************************************
     *  Method:
     *      _RestoreDCObjects
     *  Purpose:
     *      Restore the default pen and brush of the display context.
     *      This may not be applicable on some platforms.
     */
    virtual void  _RestoreDCObjects(HXxDC hxxDC, void* hOldBrush, void* hOldPen) = 0;

    /************************************************************************
     *  Method:
     *      _GetCompositionSurfaceHXxDC
     *  Purpose:
     *      Get the display context of the composition surface.
     *      This may not be applicable on some platforms.
     */
    virtual void  _GetCompositionSurfaceHXxDC(HXxDC *hdc) = 0;

    /************************************************************************
     *  Method:
     *      _ReleaseCompositionSurfaceHXxDC
     *  Purpose:
     *      Release the display context of the composition surface.
     *      This may not be applicable on some platforms.
     */
    virtual void  _ReleaseCompositionSurfaceHXxDC(HXxDC hdc) = 0;

    /************************************************************************
     *  Method:
     *      _InsureColorMatch
     *  Purpose:
     *      Match inColor with that of the current display device.
     *      This may not be applicable on some platforms.
     */
    virtual INT32 _InsureColorMatch(INT32 InColor) = 0;

    /************************************************************************
     *  Method:
     *      _SetColorKey
     *  Purpose:
     *      Set the color of the overlay's colorkey.
     *      This may not be applicable on some platforms.
     */
    virtual void  _SetColorKey(INT32 nColorSpaceLowValue, INT32 nColorSpaceHighValue) = 0;


    /************************************************************************
     *  Method:
     *      _UpdateOverlay
     *  Purpose:
     *      Update the position, size, and mode of the overaly.
     *      This may not be applicable on some platforms.
     */
    virtual void  _UpdateOverlay(HXxRect* src, HXxRect* dest, INT32 inFlags) = 0;

    /************************************************************************
     *  Method:
     *      _IsSurfaceVisible
     *  Purpose:
     *      Is the current video surface visible.
     */
    virtual BOOL  _IsSurfaceVisible() = 0;

    /************************************************************************
     *  Method:
     *      _ReleaseSurface
     *  Purpose:
     *      Destroys the allocated video surface
     */
    virtual void  _ReleaseSurface() = 0;

    /************************************************************************
     *  Method:
     *      _GetDC
     *  Purpose:
     *      Get the display context for the site that owns this surface.
     *      This may not be applicable on some platforms.
     */
    virtual HXxDC _GetDC(HXxWindow*) = 0;

    /************************************************************************
     *  Method:
     *      _ReleaseDC
     *  Purpose:
     *      Release the display context for the site that owns this surface.
     *      This may not be applicable on some platforms.
     */
    virtual void  _ReleaseDC(HXxWindow*, HXxDC) = 0;
    
    virtual void  _ColorWindows();
    virtual BOOL  UsingOverlay();

    virtual void _LockBlitter() {};
    virtual void _UnlockBlitter() {};
    virtual void _FlushSurfaces() {};
    virtual void _WaitForQueuedFrames() {};

    virtual HX_RESULT _ScheduleFrameForDisplay(void* pOsData,
                                               tFrameElement* pItem,
                                               UINT32 nResolution);
    virtual void CreateHWMemObj(int cid) {};
};

#endif  /* _BASESURF_H_ */
