/* GSAMBAD, an easy to use GTK+ frontend for the SAMBA file and print server.
 * Copyright (C) 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "allocate.h"
#include "chars_are_digits.h"
#include "populate_server_settings.h"
#include "commented.h"
#include "get_option_pos.h"
#include "show_info.h"



void populate_server_settings(struct w *widgets)
{
    /* Lists the values in the server tab */
    FILE *fp;
    int val = 0, global_section_found = 0;
    int is_user = 0, is_bdc = 0;
    long conf_size, opt_pos;
    char *line, *new_buffer;
    gchar *info, *utf8 = NULL;


    if((fp=fopen(SAMBA_CONF, "r"))==NULL)
    {
	info = g_strdup_printf(_("Cant open smb.conf here:\n%s\n"), SAMBA_CONF);
	show_info(info);
	g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);
    new_buffer = allocate(conf_size+1);

    /* First determine if security is "user", set as: is_user */
    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	/* Break at any share definition */
	if( strstr(line, "[") && ! strstr(line, "[global]") && ! commented(line) )
	  break;
	
	/* Security is user */
	if( strstr(line, "security = ") && (strstr(line, "user") || strstr(line, "User"))
	&& ! commented(line) ) 
	  is_user = 1;
    }
    rewind(fp);

    /* We know that security is user, now see if its a BDC, set as: is_bdc */    
    if( is_user && conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	/* Break at any share definition */
	if( strstr(line, "[") && ! strstr(line, "[global]") && ! commented(line) )
	  break;
	
	/* If domain logons is specified its a BDC */
	if( strstr(line, "domain logons = ") && (strstr(line, "true") || strstr(line, "yes"))
	&& ! commented(line) ) 
	  is_bdc = 1;
    }
    rewind(fp);



    /* First scroll to the global section */
    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( strstr(line, "[global]") && ! commented(line) )
	{
	    global_section_found = 1;
	    break;
	}
    }

    if( ! global_section_found )
    {
	info = g_strdup_printf(_("Can not find the [global] section in %s\nNo changes made.\n"), SAMBA_CONF);
	show_info(info);
	g_free(info);
	fclose(fp);
	free(line);
	free(new_buffer);
        return;
    }

    
    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	/* Break at any share definition "[" and collect them in the next while loop */
	if( strstr(line, "[") && ! commented(line) )
	   break;

	/* Entries... */

	/* Change matching server directives otherwise just gather them */
	if( strstr(line, "netbios name") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line); /* positions are at: "="+1 */
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[0]), utf8);
	}
	else
	if( strstr(line, "server string") && ! commented(line) )
    	{          	
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[1]), utf8);
	}
	else
	if( strstr(line, "workgroup") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[2]), utf8);
	}
	else
	if( strstr(line, "hosts allow") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[3]), utf8);
	}
	else
	if( strstr(line, "interfaces") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[4]), utf8);
	}
	else
	if( strstr(line, "remote announce") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[5]), utf8);
	}
	else
	if( strstr(line, "remote browse sync") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[6]), utf8);
	}
	else
	if( strstr(line, "printcap name") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[7]), utf8);
	}
	else
	if( strstr(line, "guest account") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[8]), utf8);
	}
	else
	if( strstr(line, "log file") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[9]), utf8);
	}
	else
	if( strstr(line, "username map") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[11]), utf8);
	}
	else
	if( strstr(line, "add user script") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[12]), utf8);
	}
	else
	if( strstr(line, "smb passwd file") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[13]), utf8);
	}
	else
	if( strstr(line, "passwd program") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[14]), utf8);
	}
	else
	if( strstr(line, "passwd chat") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[15]), utf8);
	}
	else
	if( strstr(line, "socket options") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[16]), utf8);
	}
	else
	if( strstr(line, "logon drive") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[17]), utf8);
	}
	else
	if( strstr(line, "logon home") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[18]), utf8);
	}
	else
	if( strstr(line, "logon path") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[19]), utf8);
	}
	else
	if( strstr(line, "logon script") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[20]), utf8);
	}
	else
	if( strstr(line, "name resolve order") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[21]), utf8);
	}
	else
	if( strstr(line, "wins server") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[22]), utf8);
	}
	else
	if( strstr(line, "idmap uid") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[23]), utf8);
	}
	else
	if( strstr(line, "idmap gid") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[24]), utf8);
	}
	else
	if( strstr(line, "template shell") && ! commented(line) )
	{
	    opt_pos = get_option_pos(line);
	    sprintf(new_buffer, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[25]), utf8);
	}
	else


	/* Combos... */

	
	/* Security level */
    	if( strstr(line, "security") && ! commented(line) )
	{
	    /* User */
	    if( ! is_bdc && (strstr(line, "User") || strstr(line, "user")) )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 0);
	    else /* BDC */
	    if( is_bdc && (strstr(line, "User") || strstr(line, "user")) ) 
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 1);
	    else
	    if( strstr(line, "Domain") || strstr(line, "domain") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 2);
	    else /* ADS */
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 3);
	}
	else
    	if( strstr(line, "load printers") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 1);
	}
	else
    	if( strstr(line, "cups options") && ! commented(line) )
	{
	    if( strstr(line, "raw") || strstr(line, "Raw") || strstr(line, "RAW") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[2]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[2]), 1);
	}
	else
    	if( strstr(line, "null passwords") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 1);
	}
	else
	if( strstr(line, "encrypt passwords") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[4]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[4]), 1);
	}
	else
    	if( strstr(line, "unix password sync") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[5]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[5]), 1);
	}
	else
    	if( strstr(line, "local master") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[6]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[6]), 1);
	}
	else
    	if( strstr(line, "domain master") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[7]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[7]), 1);
	}
	else
    	if( strstr(line, "preferred master") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[8]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[8]), 1);
	}
	else
    	if( strstr(line, "time server") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[9]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[9]), 1);
	}
	else
    	if( strstr(line, "domain logons") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[10]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[10]), 1);
	}
	else
    	if( strstr(line, "wins support") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[11]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[11]), 1);
	}
	else
    	if( strstr(line, "wins proxy") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[12]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[12]), 1);
	}
	else
    	if( strstr(line, "dns proxy") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[13]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[13]), 1);
	}
	else
    	if( strstr(line, "preserve case") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[14]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[14]), 1);
	}
	else
    	if( strstr(line, "winbind use default domain") && ! commented(line) )
	{
	    if( strstr(line, "yes") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[15]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[15]), 1);
	}
	else


	/* Spinbuttons... */


    	if( strstr(line, "max log size") && ! commented(line) )
	{
	    new_buffer[0]='\0';
	    sscanf(line, "%*s %*s %*s %*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[0]), val);
	    }

	}
	else
    	if( strstr(line, "username level") && ! commented(line) )
	{
	    new_buffer[0]='\0';
	    sscanf(line, "%*s %*s %*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[1]), val);
	    }
	}
	else
    	if( strstr(line, "password level") && ! commented(line) )
	{
	    new_buffer[0]='\0';
	    sscanf(line, "%*s %*s %*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[2]), val);
	    }
	}
	else
    	if( strstr(line, "os level") && ! commented(line) )
	{
	    new_buffer[0]='\0';
	    sscanf(line, "%*s %*s %*s %s", new_buffer);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[3]), val);
	    }
	}
    }
    fclose(fp);
    free(line);
    free(new_buffer);

    if( utf8!=NULL )
    g_free(utf8);

    gtk_widget_show_all(widgets->main_window);
}
