/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- March 1998
 */

/*
 * ImportFilter.h : filter the imported files before importing
 */

#if !defined(AFX_IMPORTFILTER_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_IMPORTFILTER_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <vector>
#include "TextBinary.h"
#include "CPStr.h"
#include "FileTraversal.h"

#ifdef _MSC_VER
	using namespace std;
#endif

// include a type (like *.c or ChangeLog) + several informations
// like : if several files of this type are conflicting (i.e. are
// binary AND text), if it is a binary or text type...
class ReportConflict
{
public:
	ReportConflict(int mac_type, int mac_creator);
	~ReportConflict();

	ReportConflict *next;

	enum
	{
		noConflict =				0x0000,
		hasConflict =				0x0001,
		hasExtension =				0x0002,
		isBinary =					0x0004,
		forceBinary =				0x0008,
		forceText =					0x0010,
		hasIgnore =					0x0020,
		hasTypeCreatorConflict =	0x0040, /* mac only */
		forceNoKeywords =			0x0080,
		isUnicode =					0x0100,
		forceUnicode =				0x0200,
		userFlags =		forceText | forceBinary | forceUnicode | hasIgnore | forceNoKeywords
	};

	void AddPattern(const char *newpat, kFileType fileType, bool isExtension, const char *sample);
	void SetConflict(const char *sample);
	void SetTypeCreatorConflict(const char *sample); /* mac only */
	bool Match(const char *pat);

	inline bool HasConflict(void) const
	{
		return (status & hasConflict) != 0;
	}
	inline bool HasTypeCreatorConflict(void) const /* mac only */
	{
		return (status & hasTypeCreatorConflict) != 0;
	} 
	inline bool IsBinary(void) const
	{
		return (status & isBinary) != 0;
	}
	inline bool IsUnicode(void) const
	{
		return (status & isUnicode) != 0;
	}
	inline bool IsExtension(void) const
	{
		return (status & hasExtension) != 0;
	}
	inline const char *GetPattern(void) const
	{
		return pattern;
	}
	inline int GetMacType(void) const /* mac only */
	{
		return ftype;
	}
	inline int GetMacCreator(void) const /* mac only */
	{
		return fcreator;
	} 

	inline void ForceBinary(void)
	{
		status &= ~(int)userFlags;
		status |= (int)forceBinary;
	}
	inline void ForceText(void)
	{
		status &= ~(int)userFlags;
		status |= (int)forceText;
	}
	inline void ForceUnicode(void)
	{
		status &= ~(int)userFlags;
		status |= (int)forceUnicode;
	}
	inline void Ignore(void)
	{
		status &= ~(int)userFlags;
		status |= (int)hasIgnore;
	}
	inline void ForceNoKeywords(void)
	{
		status &= ~(int)userFlags;
		status |= (int)forceNoKeywords;
	}
	inline bool HasForceBinary(void) const
	{
		return (status & forceBinary) != 0;
	}
	inline bool HasForceText(void) const
	{
		return (status & forceText) != 0;
	}
	inline bool HasForceUnicode(void) const
	{
		return (status & forceUnicode) != 0;
	}
	inline bool HasIgnore(void) const
	{
		return (status & hasIgnore) != 0;
	}
	inline bool HasForceNoKeywords(void) const
	{
		return (status & forceNoKeywords) != 0;
	}
	inline void DisableUserSettings(void)
	{
		status &= ~(int)userFlags;
	}

	void PrintOut(CStr & out) const;
#if qCvsDebug
	void PrintOut(void) const;
#endif /* qCvsDebug */

protected:
	int status;

	CStr pattern;
		// an extension or a whole name (hasExtension)
	CStr sample1;
		// a sample for this entry
	CStr sample2;
		// another sample (if hasConflict)
	
	int ftype, fcreator; /* mac only */
};

// a warning contains a kind of warning (i.e. wrong line feed,
// has escape characters...) + a set of files which illustrates
// this warning.

class ReportWarning
{
public:
	ReportWarning(kTextBinTYPE akind);
	~ReportWarning();

	ReportWarning *next;
	static const size_t maxWarnings;

	void AddWarning(const char *sample);
	inline kTextBinTYPE Kind(void) const {return kind;}

	void PrintOut(CStr & out) const;
#if qCvsDebug
	void PrintOut(void) const;
#endif /* qCvsDebug */

protected:
	kTextBinTYPE kind;

	std::vector<CStr> samples;
	bool tooMuchWarnings;
};

kTraversal list_all_types_recur(const char *path, ReportWarning *& warnings,
						 ReportConflict *& conflicts);
void free_list_types(ReportWarning * warnings, ReportConflict * conflicts);

#if qCvsDebug
	bool list_all_types(const char *path);
#endif /* qCvsDebug */

#endif // !defined(AFX_IMPORTFILTER_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
