/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_I2C_H
#define GATOS_I2C_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef GATOS_I2C_C
#define WHERE
#else
#define WHERE	extern
#endif

/* Number of I2C Driver Interfaces */
#define MAXI2CDRIVER	5

#ifdef USE_DELAY_S
#include "delay.h"
#define I2C_SLEEP	udelay(5)
#else
#define I2C_SLEEP	i2c_delay(5)
#endif

WHERE int i2c_ddelay ;

/* I2C function declarations */

int	i2c_init(void) ;
#ifndef USE_DELAY_S
void	i2c_delay(u32) ;
#endif
u8	i2c_read(u8) ;
int	i2c_readn(u8, u8*, int) ;
int	i2c_write(u8, u8*, int) ;
u8	i2c_readreg8(u8, u8) ;
int	i2c_writereg8(u8, u8, u8) ;
int	i2c_device(u8) ;
char*	i2c_ident(u8) ;
char*	i2c_name(u8) ;
void	i2c_info(void) ;
void	i2c_register(u8, char*, char*) ;

#ifdef GATOS_I2C_C

/* Hardware initialization and debugging */
static int	i2c_init_hw(void) ;
static void	i2c_alarm(int) ;

/* Low-level (software driver) routines */
static void	i2c_start(void) ;
static void	i2c_stop(void) ;
static u8	i2c_readbyte(int) ;
static int	i2c_sendbyte(u8) ;

/* Hardware routines for I2C modes A, B and LG (DAC+GEN_TEST or GP_IO) */
static void	reg_scldir(int) ;
static void	reg_sdadir(int) ;
static void	reg_setscl(int) ;
static void	reg_setsda(int) ;
static int	reg_getscl(void) ;
static int	reg_getsda(void) ;

/* Hardware routines for I2C mode C (Rage PRO) */
static void	pro_scldir(int) ;
static void	pro_sdadir(int) ;
static void	pro_setscl(int) ;
static void	pro_setsda(int) ;
static int	pro_getscl(void) ;
static int	pro_getsda(void) ;

/* Hardware routines for I2C mode TB (ImpacTV) */
static void	itv_scldir(int) ;
static void	itv_sdadir(int) ;
static void	itv_setscl(int) ;
static void	itv_setsda(int) ;
static int	itv_getscl(void) ;
static int	itv_getsda(void) ;

/* Hardware routines for I2C mode R128 (Rage 128 Hardware) */
static int	r128_wait_ack(void) ;
static void	r128_reset(void) ;
static int	r128_go(int, int, u32) ;

#endif

#ifdef __cplusplus
}
#endif

#undef WHERE
#endif
