"""

Interface to lame (mp3 encoder)

"""

from tools import which
from log4py import Logger, LOGLEVEL_NORMAL
from string import find

class lame:

    def __init__(self, loglevel = LOGLEVEL_NORMAL):
        self.__lame_logger = Logger().get_instance(self)
        self.__lame_logger.set_loglevel(loglevel)
        self.__lame_command = which("lame")
        if (self.__lame_command == ""):
            self.__lame_logger.debug("Lame executable not found.")
        self.__lame_source = None
        self.__lame_target = None
        self.__lame_bitrate = 128

    def available(self):
        return (self.__lame_command != "")

    def set_source(self, filename):
        self.__lame_source = filename
        if (find(self.__lame_source, " ") != -1):
            self.__lame_source = "\"%s\"" % self.__lame_source

    def set_target(self, filename):
        self.__lame_target = filename
        if (find(self.__lame_target, " ") != -1):
            self.__lame_target = "\"%s\"" % self.__lame_target

    def set_bitrate(self, bitrate):
        self.__lame_bitrate = bitrate

    def command_line(self):
        if (self.__lame_source == None) or (self.__lame_target == None):
            return None
        else:
            command_line = self.__lame_command
            if (self.__lame_bitrate != 128):
                command_line = "%s -b %d" % (command_line, self.__lame_bitrate)
            command_line = "%s %s" % (command_line, self.__lame_source)
            command_line = "%s %s" % (command_line, self.__lame_target)
            return command_line

def test():
    lame_test = lame()
    print lame_test.available()
    lame_test.set_source("-")
    lame_test.set_target("/tmp/output.mp3")
    lame_test.set_bitrate(192)
    print lame_test.command_line()

if (__name__ == "__main__"):
    test()
