/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"aliases.h"
#include	"courier.h"

//
// MAXRECSIZE is the median GDBM record size makealiases creates.  The actual
// record size may be +/- 50%
//

#define	MAXRECSIZE	512

//
// In each record, you have addresses separated by newlines.  Search for
// a specific address, and return an offset to it, or -1 if not found.
//

int AliasRecord::search(const char *p)
{
int	l=strlen(p);
const char *q=list;

	while (q && *q)
	{
		if (strncmp(q, p, l) == 0 && (q[l] == '\n' || q[l] == '\0'))
			return (q-(const char *)list);
		while (*q)
			if (*q++ == '\n')
				break;
	}
	return (-1);
}

//
// Add a list of addresses to this alias.  They are added only if they
// do not exist.  Optionally, addresses which are already in the alias
// are removed from the list, so upon exit the list contains only those
// addresses which were added.
//

void AliasRecord::Add(CStringList &addlist, int removedeleted)
{
POSITION pos;
CString	s;
CStringList	mylist;
CStringList	*listptr= &addlist;

	// If we want DON'T want to remove dupes, make a copy of the list.

	if (!removedeleted)
	{
		for (pos=addlist.GetHeadPosition(); pos; )
			mylist.AddTail(addlist.GetNext(pos));
		listptr= &mylist;
	}

	// Go through all the records in this alias, removing duplicates.

	if ( Init() == 0)
	{
		do
		{
			for (pos=listptr->GetHeadPosition(); pos; )
			{
			POSITION prevpos=pos;

				s=listptr->GetNext(pos);
				if (search(s) >= 0)
				{
					listptr->RemoveAt(prevpos);
					break;
				}
			}
			++recnum;
		} while (fetch(1) == 0);
		--recnum;
	}

	if (listptr->IsEmpty())	return;

	// Now, append the new addresses.

	for (pos=listptr->GetHeadPosition(); pos; )
	{
		s=listptr->GetNext(pos);
		if (list.GetLength() && list.GetLength() + s.GetLength()
						>= MAXRECSIZE)
		{
			update();
			++recnum;
			list="";
		}
		list += s;
		list += '\n';
	}
	update();
}

//
// When building the alias list, sometimes it may be necessary to remove
// an address from an alias if the address itself represents an alias.
//

void AliasRecord::Delete(const char *addr)
{
int	l=strlen(addr);

	if (Init())	return;	// Doesn't exist

	do
	{
	int	pos=search(addr);

		if (pos >= 0)
		{
		char	*p=list.GetBuffer(-1)+pos;

			if (p[l])	l++;	// newline also deleted
			while ((*p=p[l]) != 0)	p++;
			list.ReleaseBuffer(-1);
			if (list.GetLength() >= MAXRECSIZE/2)
			{
				update();
				return;
			}

			// Try to merge small blocks which are left.

		CString	save_list(list);
		int	save_recnum=recnum;
		CString	save_recname(recname);

			do
			{
				save_recname=recname;
				++recnum;
			} while (fetch(1) == 0);

			if (--recnum == save_recnum)
			{
				// Deleted last record.

				if (recnum == 0)
				{
					// Only record, so just update it.
					update();
					return;
				}

				// Just copy the last record into the previous
				// one.

				save_recnum= --recnum;
				fetch(1);
			}

			list += save_list;
			gdbm->Delete(save_recname, save_recname.GetLength());
			recnum=save_recnum;
			update();
			return;
		}
		++recnum;
	} while ( fetch(1) == 0);
	--recnum;
}

void AliasRecord::update()
{
	if (!list.GetLength())	return;

	mkrecname();
	if (gdbm && gdbm->Store(recname, recname.GetLength(),
		list, list.GetLength(), "R"))
		clog_msg_errno();
}
