/*
** Copyright 1998 - 2001 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"cdpendelinfo.h"
#include	"cddlvrhost.h"
#include	"cddelinfo.h"
#include	"cddrvinfo.h"
#include	"cdrcptinfo.h"
#include	"cdmsgq.h"

#include	"mydirent.h"
#include	"maxlongsize.h"
#include	"comqueuename.h"
#include	"comctlfile.h"
#include	"comstrinode.h"
#include	"comstrtimestamp.h"
#include	"comstrtotime.h"
#include	"courier.h"
#include	"localstatedir.h"
#include	"rw.h"
#include	"rfc822.h"
#include	<ctype.h>
#include	<errno.h>
#include	<stdlib.h>
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#if HAVE_SYS_STAT_H
#include	<sys/stat.h>
#endif
#if HAVE_FCNTL_H
#include	<fcntl.h>
#endif
#include	<time.h>
#include	<utime.h>
#include	"numlib/numlib.h"

CArray<msgq, const msgq &> msgq::queue;
CArray<msgq *, msgq *> msgq::queuehashfirst;
CArray<msgq *, msgq *> msgq::queuehashlast;
msgq *msgq::queuehead, *msgq::queuetail, *msgq::queuefree;
unsigned msgq::queuedelivering, msgq::queuewaiting, msgq::inprogress;
drvinfo *msgq::backup_relay_driver;
CString msgq::backup_relay;

extern time_t flushtime;
extern time_t delaytime;

msgq::msgq() : cancelled(0), next(0), prev(0), nexthash(0) {}
msgq::~msgq()	{}

void msgq::init(unsigned qs)
{
	queue.SetSize(qs);
	queuehashfirst.SetSize(qs);
	queuehashlast.SetSize(qs);

	queuehead=0;
	queuetail=0;
	queuefree=0;
	queuedelivering=0;
	queuewaiting=0;
	inprogress=0;
	backup_relay_driver=0;

char *filename=config_search("backuprelay");
char *buf=config_read1l(filename);

	free(filename);
	if (buf)
	{
	char *h=strtok(buf, " \t\r\n");

		if (h)
		{
			backup_relay=h;
			h=strtok(0, " \t\r\n");
			if (!h)	h="esmtp";

		struct rw_transport *t=rw_search_transport(h);

			if (!t)
			{
				clog_msg_start_err();
				clog_msg_str("BACKUP RELAY DRIVER NOT FOUND: ");
				clog_msg_str(h);
				clog_msg_send();
				exit(1);
			}
			backup_relay_driver=(drvinfo *)t->udata;
		}
	}

unsigned	i;

	for (i=0; i<qs; i++)
	{
		queue[i].next=queuefree;
		queuefree=&queue[i];
		queuehashfirst[i]=0;
		queuehashlast[i]=0;
	}
}

msgq *msgq::findq(ino_t inum)
{
msgq	*qp=queuehashfirst[ inum % queuehashfirst.GetSize() ];

	while (qp && qp->msgnum != inum)
		qp=qp->nexthash;
	return (qp);
}

static time_t	current_time;

/////////////////////////////////////////////////////////////////////////
//
// Scan TMPDIR for new messages to add to the queue.  When we find a
// message that's ready to be submitted, put it into msgs/msgq.
//
/////////////////////////////////////////////////////////////////////////

int msgq::tmpscan()
{
int	found=0;

	time(&current_time);

DIR *tmpdir=opendir(TMPDIR);

	if (!tmpdir)	clog_msg_errno();

struct dirent *de;
CString	subdir;
CString	ctlfile, datfile, newctlfile, newdatfile;
struct	stat stat_buf;
CString	qdir, qname;

	while ((de=readdir(tmpdir)) != 0)
	{
	const char *p;

		for (p=de->d_name; *p; p++)
			if (!isdigit((int)(unsigned char)*p))	break;
		if (*p)	continue;	// Subdirs must be named all digits

		subdir=TMPDIR "/";
		subdir += de->d_name;

	DIR *subde=opendir(subdir);

		while ((de=readdir(subde)) != 0 && found < 100)
		{
			if (strcmp(de->d_name, ".") == 0 ||
				strcmp(de->d_name, "..") == 0)	continue;

			ctlfile=subdir;
			ctlfile += '/';
			ctlfile += de->d_name;

		int	i;

			if (stat(ctlfile, &stat_buf))	continue;

		ino_t	inum=stat_buf.st_ino;

			if (stat_buf.st_mtime < current_time - 48 * 60 * 60)
			{
				if (de->d_name[0] == 'D')
				{
					datfile=ctlfile;
					datfile[datfile.ReverseFind('/')+1]='C';
					if (stat(datfile, &stat_buf) == 0)
						continue;
						// Wait until the C file is
						// purged

				// Be carefull with Cnnnn.x files, because
				// Cnnnn.1 is used to hold submission of all
				// of them.  A race condition can leave
				// Cnnnn.1 in a submittable state, so if it
				// is removed, other copies of this message
				// can become submittable, during a very small
				// window.

				} else if (de->d_name[0] == 'C' &&
					(i=ctlfile.Find('.')) >= 0)
				{

				// This race condition is handled simply
				// by not removing Cxxxxx.n if Cxxxxx.n+1
				// exists.

				char	nbuf[NUMBUFSIZE];

					datfile=ctlfile.Left(i);

				size_t	n=atoi( (const char *)ctlfile+i+1);

					++n;

					datfile += '.';
					datfile += str_size_t(n, nbuf);

					if (stat(datfile, &stat_buf) == 0)
						continue;
						// Wait until the C.1 file is
						// purged

					unlink(ctlfile);
					ctlfile[0]='D';
					/* FALLTHRU */
				}
				unlink(ctlfile);
				continue;
			}

			if (de->d_name[0] != 'C')	continue;
			if ((i=ctlfile.Find('.')) >= 0)
			{
				datfile=ctlfile.Left(i);
				datfile += ".1";

				if (ctlfile == datfile || stat(
					datfile, &stat_buf) == 0)
						continue;
			}

			datfile=ctlfile;
			datfile[datfile.ReverseFind('/')+1]='D';

			newdatfile=qmsgsdatname(inum);
			newctlfile=qmsgsctlname(inum);

		struct	ctlfile ctf;

			if ((access(datfile, 0) == 0 &&
				access(newdatfile, 0) == 0) ||
				access(newctlfile, 0) == 0 ||
				ctlfile_openfn(ctlfile, &ctf, 0, 0))
			{
				clog_msg_start_err();
				clog_msg_str("QUEUE FILE CORRUPTION: inode ");
				clog_msg_uint(inum);
				clog_msg_send();
				utime(ctlfile, 0);	// Keep it around
				continue;
			}

		time_t	nextattempt=current_time+delaytime;

			if ((i=ctlfile_searchfirst(&ctf,
				COMCTLFILE_SUBMITDELAY)) >= 0)
				nextattempt=current_time+
					atoi(ctf.lines[i]+1);

			qname=qmsgqname(inum, nextattempt);

			ctlfile_nextattempt(&ctf, nextattempt);

			if (link(ctlfile, qname))
			{
				mkdir(qmsgqdir(current_time),0755);
				if (link(ctlfile, qname) && errno != EEXIST)
					clog_msg_errno();
			}

			if (rename(datfile, newdatfile))
			{
				mkdir(qmsgsdir(inum), 0755);
					// We may need to create this dir
				rename(datfile, newdatfile);
			}

			if (rename(ctlfile, newctlfile))
				clog_msg_errno();

			i=qname.ReverseFind('/');

			qdir=qname.Left(i);
			qname=qname.Mid(i+1);
			++found;
			ctlfile_close(&ctf);

			queuescan3(qdir, qname, de->d_name);
		}
		closedir(subde);

		if (stat(subdir, &stat_buf) == 0 &&
			stat_buf.st_mtime < current_time - 2 * 60 * 60)
			rmdir(subdir);	// Just give it a try
	}
	closedir(tmpdir);
	return (found);
}

////////////////////////////////////////////////////////////////////////////
//
// Add more messages from MSGQDIR to msgq::queue
//
////////////////////////////////////////////////////////////////////////////

static ino_t strtoino(const char *p)
{
ino_t	n=0;

	while (isdigit((int)(unsigned char)*p))
	{
		n *= 10;
		n += *p++ - '0';
	}
	return (n);
}

void msgq::queuescan()
{
static	int queuescan_flag=0;

	if (queuescan_flag)	return;
		// Recursive invocation if message just pulled into queue
		// has been delivered to all of its recipients.

#if 0
clog_msg_start_info();
clog_msg_str("queue scan");
clog_msg_send();
#endif

	try
	{
	CStringList subdirlist;
	DIR *tmpdir=opendir(MSGQDIR);
	struct dirent *de;
	CString	s;

		queuescan_flag=1;
		if (!tmpdir)	clog_msg_errno();

		time(&current_time);

		while ((de=readdir(tmpdir)) != 0)
		{
		const char *p;
		time_t	n;

			for (p=de->d_name; *p; p++)
				if (!isdigit((int)(unsigned char)*p))	break;

			if (*p)	continue;	// Subdirs must be named all digits
			p=de->d_name;
			n=strtotime(p);

		POSITION pos;

			for (pos=subdirlist.GetHeadPosition(); pos; )
			{
			POSITION	savepos=pos;

				p=subdirlist.GetNext(pos);
				if (strtotime(p) > n)
				{
					pos=savepos;
					break;
				}
			}

			s=de->d_name;

			if (pos)
				subdirlist.InsertBefore(pos, s);
			else
				subdirlist.AddTail(s);
		}
		closedir(tmpdir);

		while (!subdirlist.IsEmpty())
		{
			s=MSGQDIR "/";
			s += subdirlist.RemoveHead();
			if (queuescan2(s) <= 0)	break;
				// Stop if we can't add any more msgs
		}
		queuescan_flag=0;
	}
	catch (...)
	{
		queuescan_flag=0;
		throw;
	}
}

static int sort_by_qtime( CString **a, CString **b)
{
const char *pa=strchr(**a, '.')+1;
const char *pb=strchr(**b, '.')+1;
time_t ta=strtotime(pa);
time_t tb=strtotime(pb);

	return (ta < tb ? -1:ta > tb ? 1:0);
}

///////////////////////////////////////////////////////////////////////////
//
// Read all control files in this subdirectory, sort them by scheduled
// delivery time, attempt to add them to the queue.
//
// Returns: -1 - error, 0 - no msgs were added, >0 - msgs were added
//
///////////////////////////////////////////////////////////////////////////

int msgq::queuescan2(CString s)
{
DIR *tmpdir=opendir(s);
struct dirent *de;
CStringList	filename_list;

	if (!tmpdir)	clog_msg_errno();

	while ((de=readdir(tmpdir)) != 0)
	{
	const char *p=de->d_name;

		if (*p++ != 'C')	continue;

	ino_t	inum=strtoino(p);

		// Perhaps this one's in the queue already

		if (findq(inum))	continue;	// Already in msgq

		while (isdigit(*p))	p++;
		if (*p++ != '.')	continue;

		while (isdigit(*p))
			++p;

		if (*p)	continue;

		filename_list.AddTail(de->d_name);
	}
	closedir(tmpdir);

	if (filename_list.GetCount() == 0)
		return (1);	// Pretend we added something, so keep going

CArray<CString *, CString *> filename_array;

	filename_array.SetSize(filename_list.GetCount());

size_t	i;
POSITION pos;
int	rc;
int	flag=0;

	for (i=0, pos=filename_list.GetHeadPosition(); pos; i++)
		filename_array[i] = &filename_list.GetNext(pos);


	qsort(filename_array.GetData(), filename_list.GetCount(),
		sizeof(CString *),
		(int (*)(const void *, const void *))sort_by_qtime);

	for (i=0; i<filename_list.GetCount(); i++)
	{
		rc=queuescan3(s, *filename_array[i], 0);
		if (rc < 0)
			return (-1);
		if (rc)	break;
		flag=1;
	}
	return (flag);
}

void msgq::removewq()
{
	--queuewaiting;
	if (prev)	prev->next=next;
	else	queuehead=next;
	if (next)	next->prev=prev;
	else	queuetail=prev;
}

//////////////////////////////////////////////////////////////////////////////
//
// Deallocate a msgq structure.  This can happen after all deliveries have
// been complete, or if we want to make room in a full queue for a message
// with an earlier scheduled delivery time.  Therefore, we examine
// the message's pending pointer, and deallocate them if they are set.
// Serious corruption will result if the message has any deliveries in
// progress.
//
//////////////////////////////////////////////////////////////////////////////

void msgq::removeq()
{
int	i;
rcptinfo *ri;

	for (i=0, ri=rcptinfo_list.GetData();
		i<rcptinfo_list.GetSize(); i++, ri++)
	{
	pendelinfo *pi=ri->pending;

		if (!pi)	continue;

		pi->receipient_list.RemoveAt(ri->pendingpos);
		if (!pi->receipient_list.IsEmpty()) continue;
		if (pi->hostp)
			pi->hostp->pending_list=0;
		pi->drvp->pendelinfo_list.RemoveAt(pi->pos);
	}

ino_t	hashbucket=msgnum % queuehashfirst.GetSize();

	if (prevhash) prevhash->nexthash=nexthash;
	else queuehashfirst[hashbucket]=nexthash;
	if (nexthash) nexthash->prevhash=prevhash;
	else queuehashlast[hashbucket]=prevhash;
	next=queuefree;
	queuefree=this;
	--queuedelivering;
}

//////////////////////////////////////////////////////////////////////////////
//
// Attempt to add this control file to the queue.  We've already verified that
// this control file is not already in the queue.
//
//////////////////////////////////////////////////////////////////////////////

int msgq::queuescan3(CString subdir, CString name, const char *isnewmsg)
{
struct ctlfile	ctlinfo;
ino_t	inum;
time_t	deltime, delsendtime;
const char *p=name;
struct	stat	stat_buf;

	++p;
	inum=strtoino(p);
	while (isdigit(*p))	p++;
	++p;
	deltime=strtotime(p);
	name= subdir + '/' + name;
	if (ctlfile_openfn(name, &ctlinfo, 0, 1))
	{
		if (errno)
		{
			clog_msg_start_err();
			clog_msg_str("Cannot read ");
			clog_msg_str(name);
			clog_msg_send();
			clog_msg_prerrno();
		}
		return (0);
	}
	delsendtime=deltime;
	if (flushtime && ctlinfo.mtime < flushtime && flushtime < deltime)
		delsendtime=flushtime;

	if (!queuefree)
	{
	msgq	*p;

//
// msgq array is full.  See if we can remove the last message from the
// pending queue.

		p=queuetail;
		if (p && p->nextsenddel > delsendtime)
		{

#if 0
clog_msg_start_info();
clog_msg_str("Removing ");
clog_msg_uint(p->msgnum);
clog_msg_str(" to make room for this message.");
clog_msg_send();
#endif

			p->removewq();
			p->removeq();
		}
	}

msgq	*newq=queuefree;

	if (!newq)
	{
		ctlfile_close(&ctlinfo);
		return (1);
	}

	const char *cn=qmsgsctlname(inum);

	if ( stat(cn, &stat_buf) == -1 )
	{
		unlink(cn);
		ctlfile_close(&ctlinfo);
		return (0);
	}


#if 0
clog_msg_start_info();
clog_msg_str("Adding ");
clog_msg_uint(inum);
clog_msg_str(" to queue.");
clog_msg_send();
#endif

	queuefree=newq->next;
	++queuedelivering;

ino_t	hashbucket=inum % queuehashfirst.GetSize();

	if (queuehashfirst[hashbucket])
		queuehashfirst[hashbucket]->prevhash=newq;
	else
		queuehashlast[hashbucket]=newq;

	newq->nexthash=queuehashfirst[hashbucket];
	newq->prevhash=0;
	queuehashfirst[hashbucket]=newq;

	newq->nksize= (unsigned long)stat_buf.st_size;
	ctlinfo.starttime=stat_buf.st_mtime;

int	k=ctlfile_searchfirst(&ctlinfo, COMCTLFILE_MSGID);

	newq->msgid= k < 0 ? "": ctlinfo.lines[k]+1;

	newq->msgnum=inum;
	newq->nextdel=deltime;
	newq->nextsenddel=delsendtime;
	newq->rcptinfo_list.SetSize(0);
	newq->rcptcount=0;
	newq->cancelled=ctlinfo.cancelled;

	if (isnewmsg)
	{
		clog_msg_start_info();
		clog_msg_str("newmsg,id=");
		logmsgid(newq);
		clog_msg_send();
	}

unsigned	i, j;
CString host, addr;

	k=ctlfile_searchfirst(&ctlinfo, COMCTLFILE_SENDER);

struct rfc822t *sendert=rw_rewrite_tokenize(k < 0 ? "":ctlinfo.lines[k]+1);
CString	errmsg;

	for (i=0; i<ctlinfo.nreceipients; i++)
	{
		for (j=0; ctlinfo.lines[j]; j++)
		{
			switch (ctlinfo.lines[j][0])	{
			case COMCTLFILE_DELSUCCESS:
			case COMCTLFILE_DELFAIL:
				if ((unsigned)atoi(ctlinfo.lines[j]+1) == i)
					break;
				// This one has been delivered
			default:
				continue;
			}
			break;
		}
		if (ctlinfo.lines[j])	continue;

	drvinfo *module=getdelinfo(sendert->tokens,
			ctlinfo.receipients[i], host, addr, errmsg);

		if (!module)
		{
			ctlfile_append_reply(&ctlinfo, i, errmsg,
				SMTPREPLY_TYPE(errmsg), 0);
			continue;
		}

		/* Check if it's time to move the message to a backup relay */

		if (backup_relay_driver &&
			ctlfile_searchfirst(&ctlinfo, COMCTLFILE_WARNINGSENT)
			>= 0)
		{
			module=backup_relay_driver;
			host=backup_relay;
		}

		/* Group all recipients for the same driver and host together */

		for (j=0; j<newq->rcptcount; j++)
			if (strcmp(module->module->name,
				newq->rcptinfo_list[j].delmodule->
				module->name) == 0 &&
				newq->rcptinfo_list[j].delhost == host &&
				newq->rcptinfo_list[j].addresses.GetSize()
					< (int)module->maxrcpt )
				break;
		if (j == newq->rcptcount)
		{
#if 0
clog_msg_start_info();
clog_msg_str("id=");
logmsgid(newq);
clog_msg_str(",new rcpt list - module=");
clog_msg_str(module->module->name);
clog_msg_str(", host=");
clog_msg_str(host);
clog_msg_send();
#endif
			newq->rcptinfo_list.SetSize(++newq->rcptcount);

		struct	rw_info_rewrite rwir;
		struct	rw_info	rwi;

			rwir.buf=0;
			rwir.errmsg=0;
			rw_info_init(&rwi, sendert->tokens, rw_err_func);
			rwi.sender=0;
			rwi.mode=RW_OUTPUT|RW_ENVSENDER;
			rwi.udata= (void *)&rwir;
			rw_rewrite_module(module->module, &rwi,
				rw_rewrite_chksyn_print);

		char *address=((struct rw_info_rewrite *)rwi.udata)->buf;
		char *errmsg= ((struct rw_info_rewrite *)rwi.udata)->errmsg;

			if (!address)
			{
				ctlfile_append_reply(&ctlinfo, i, errmsg,
					SMTPREPLY_TYPE(errmsg), 0);
				newq->rcptinfo_list.SetSize(--newq->rcptcount);
				free(errmsg);
				continue;
			}

			if (errmsg)	free(errmsg);
			newq->rcptinfo_list[j].init(newq, module, host, address);
			free(address);
		}
#if 0
clog_msg_start_info();
clog_msg_str("id=");
logmsgid(newq);
clog_msg_str(",module=");
clog_msg_str(module->module->name);
clog_msg_str(", host=");
clog_msg_str(host);
clog_msg_str(", addr=<");
clog_msg_str(addr);
clog_msg_str(">");
clog_msg_send();
#endif

		newq->rcptinfo_list[j].addresses.Add(addr);
		newq->rcptinfo_list[j].addressesidx.Add(i);
	}
	rfc822t_free(sendert);
	ctlfile_close(&ctlinfo);

	if (newq->nextsenddel <= current_time ||

/*
** If there are no more recipients, we want to call done() via
** start_message.  HOWEVER, if DSN injection FAILED, we want to respect
** the rescheduled delivery attempt time.  We can detect that if isnewmsg == 0
*/
		(newq->rcptinfo_list.GetSize() == 0 && isnewmsg))
	{
		newq->start_message();
		return (0);
	}

msgq	*qp, *qprev;

	for (qprev=queuetail, qp=0; qprev; qp=qprev, qprev=qp->prev)
		if (qprev->nextsenddel < newq->nextsenddel)
			break;

	newq->next=qp;
	newq->prev=qprev;

	if (qprev)	qprev->next=newq;
	else		queuehead=newq;

	if (qp)	qp->prev=newq;
	else	queuetail=newq;
	++queuewaiting;
	return (0);
}

void msgq::start_message()
{
//
// Schedule deliveries for this message.
//

rcptinfo *ri;
int	i;

#if 0
clog_msg_start_info();
clog_msg_str("Start message ");
logmsgid(this);
clog_msg_send();
#endif

	if (rcptinfo_list.GetSize() == 0)
	{
		done(this, 0);
		return;
	}

int nrcpts=rcptinfo_list.GetSize();

	for (i=0, ri=rcptinfo_list.GetData(); i<nrcpts; i++, ri++)
	{
	drvinfo *drvp=ri->delmodule;
	dlvrhost *hostp, *freehostp=0;

//
// Check if the same host has any deliveries in progress, or pending.
// Search the hdlvrpfree/hdlvrplast link list for this host.
//
		for (hostp=drvp->hdlvrplast; hostp; hostp=hostp->prev)
		{
			if (hostp->hostname == ri->delhost)
{
#if 0
clog_msg_start_info();
clog_msg_str("Found host ");
clog_msg_str(ri->delhost);
clog_msg_str(", # of deliveries=");
clog_msg_uint(hostp->dlvrcount);
clog_msg_send();
#endif
				break;
}

//
// Just in case we don't find it, remember the last host at the end of the
// MRU list which does not have any deliveries in progress.
//
			if (!freehostp &&
				drvp->hdlvrpfree == 0 && hostp->dlvrcount == 0)
				freehostp=hostp;
				// Recycle a host struct used longest ago
		}
		if (!hostp)
		{
//
// Did not find this host.
//
			if (drvp->hdlvrpfree)
			{
//
// There's an unused host structure, take it.
//
				hostp=drvp->hdlvrpfree;
				drvp->hdlvrpfree=hostp->next;
			}
			else if (freehostp)
			{
//
// Recycle a host structure for a host without any current deliveries,
// remove it from the MRU list.
//
				hostp=freehostp;
				if (hostp->next)
					hostp->next->prev=hostp->prev;
				else
					drvp->hdlvrplast=hostp->prev;
				if (hostp->prev)
					hostp->prev->next=hostp->next;
				else
					drvp->hdlvrpfirst=hostp->next;
			}

			if (hostp)
			{
//
// Ok, initialize this host, and stick it at the end of the MRU list.
//
				hostp->hostname=ri->delhost;
				hostp->dlvrcount=0;
				hostp->next=0;
				if ((hostp->prev=drvp->hdlvrplast) != 0)
					drvp->hdlvrplast->next=hostp;
				else
					drvp->hdlvrpfirst=hostp;
				drvp->hdlvrplast=hostp;
				if (hostp->pending_list)
					hostp->pending_list->hostp=0;
				hostp->pending_list=0;
			}
		}
//
// Determine if we can start a new delivery.  The conditions are:
// A) We found an unused host structure, and the number of deliveries in
// progress to this host is less than the maximum set for the module,
//
// AND
//
// B) The total number of current deliveries to this host is less than
// the maximum set for this module (there's an available delivery slot
// structure)
//
		if (hostp && hostp->dlvrcount < drvp->maxhost &&
			drvp->delpfreefirst)
		{
		delinfo *newdi=drvp->delpfreefirst;

			drvp->delpfreefirst=newdi->freenext;
			newdi->dlvrphost=hostp;
			newdi->rcptlist=ri;

			ri->pending=0;
			hostp->dlvrcount++;
			startdelivery(drvp, newdi);
			continue;
		}
//
// We are unable to start the delivery at this time.  At the recipient list
// to the list of pending deliveries for this host.
//
// The first thing is to make sure that this host structure has the pending
// list structure allocated.
//

	pendelinfo *pi;

		if (hostp)
		{
			if ((pi=hostp->pending_list) == 0)
			{
			POSITION pos=drvp->pendelinfo_list.AddTail(
					pendelinfo());

				pi=&drvp->pendelinfo_list.GetAt(pos);
				pi->pos=pos;
				pi->drvp=drvp;
				pi->hostname=ri->delhost;
				pi->hostp=hostp;
				hostp->pending_list=pi;
			}
		}
		else
		{
		POSITION pos;
//
// We don't even have a host structure.
// That's ok, search the pendelinfo_list of this module anyway.
//
			pi=0;
			for (pos=drvp->pendelinfo_list.GetHeadPosition();
				pos; )
			{
				pi=&drvp->pendelinfo_list.GetNext(pos);
				if (pi->hostname == ri->delhost) break;
				pi=0;
			}
			if (!pi)
			{
				pos=drvp->pendelinfo_list.AddTail(
						pendelinfo());

				pi=&drvp->pendelinfo_list.GetAt(pos);
				pi->pos=pos;
				pi->drvp=drvp;
				pi->hostname=ri->delhost;
				pi->hostp=0;
			}
		}

		ri->pending=pi;
		ri->pendingpos=pi->receipient_list.AddTail(ri);
	}
}
