// Copyright (c) 2006-2008 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "base/base_drag_source.h"

///////////////////////////////////////////////////////////////////////////////
// BaseDragSource, public:

BaseDragSource::BaseDragSource() : cancel_drag_(false) {
}

///////////////////////////////////////////////////////////////////////////////
// BaseDragSource, IDropSource implementation:

HRESULT BaseDragSource::QueryContinueDrag(BOOL escape_pressed,
                                          DWORD key_state) {
  if (cancel_drag_)
    return DRAGDROP_S_CANCEL;

  if (escape_pressed) {
    OnDragSourceCancel();
    return DRAGDROP_S_CANCEL;
  }

  if (!(key_state & MK_LBUTTON)) {
    OnDragSourceDrop();
    return DRAGDROP_S_DROP;
  }

  OnDragSourceMove();
  return S_OK;
}

HRESULT BaseDragSource::GiveFeedback(DWORD effect) {
  return DRAGDROP_S_USEDEFAULTCURSORS;
}

///////////////////////////////////////////////////////////////////////////////
// BaseDragSource, IUnknown implementation:

HRESULT BaseDragSource::QueryInterface(const IID& iid, void** object) {
  *object = NULL;
  if (IsEqualIID(iid, IID_IUnknown) || IsEqualIID(iid, IID_IDropSource)) {
    *object = this;
  } else {
    return E_NOINTERFACE;
  }
  AddRef();
  return S_OK;
}

ULONG BaseDragSource::AddRef() {
  base::RefCountedThreadSafe<BaseDragSource>::AddRef();
  return 0;
}

ULONG BaseDragSource::Release() {
  base::RefCountedThreadSafe<BaseDragSource>::Release();
  return 0;
}
