/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/



/***************************************************************************
                          saver_raw.cpp  -  description
                             -------------------
    begin                : Thu Jan 24 2002
    copyright            : (C) 2002 by calvin french
    email                : red@server
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "saver_raw.h"





int Saver_Raw::save(const char *p_filename) {


	return UNKNOWN_TYPE;
}
int Saver_Raw::save_sample(const char *p_filename,int p_sample_index) {
	
	string fname=p_filename,ext;
	Sample *smp;
	ext=fname.substr(fname.length()-4,4);
	
	if ((fname.length()<5) || ((fname.substr(fname.length()-4,4)!=".raw") && (fname.substr(fname.length()-4,4)!=".RAW")) ) return UNKNOWN_TYPE;
	
	smp=song->get_sample(p_sample_index);
	
	if (!smp->in_use) return SAVE_ERROR;
	
	
	if (writer.open(p_filename)) return SAVE_ERROR;
	
	writer.store_byte_array( (Uint8*)smp->data.get_data_16() , smp->data.get_size()*(smp->data.is_16bit()?2:1) );
	
	writer.close();

	return SAVE_OK;
}

int Saver_Raw::save_instrument(const char *p_filename,int p_instrument_index) {


	return UNKNOWN_TYPE;
}


Saver_Raw::Saver_Raw(){
}
Saver_Raw::~Saver_Raw(){
}

