#!/bin/bash

# A common configuration mistake is to leave "PidFile /var/run/apache.pid"
# in the configuration file.  Abort if we see this.

if [ -f /etc/apache-perl/httpd.conf ]; then
  if grep '^PidFile /var/run/apache\.pid' /etc/apache-perl/httpd.conf >/dev/null 2>/dev/null; then
    echo 'apache-perl: Incorrect PidFile in /etc/apache-perl/httpd.conf.'
    exit 0
  fi
fi

