#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Test whitespace.
#
# $Id: whitespace.py,v 1.8 2003/01/24 11:34:31 andrewm Exp $

import unittest
import albatross
import albatross_test

class WhitespaceCase(albatross_test.AlbatrossTestCase):
    template_dir = "whitespace"

    def check_default_ws(self):
        self.html_test("default-ws.html", "123")

    def check_strip(self):
        self.html_test("strip.html", "123")

    def check_indent(self):
        self.html_test("indent.html", "1  2  3")

    def check_newline(self):
        self.html_test("newline.html", "1\n2\n3")

    def check_all(self):
        self.html_test("all.html", "1\n       2\n    \t3")

    def check_bogus(self):
        self.assertRaises(albatross.ApplicationError, self.html_test, "bogus.html", "(none)")

class WhitespaceSuite(unittest.TestSuite):
    test_list = (
        "check_default_ws",
        "check_strip",
        "check_indent",
        "check_newline",
        "check_all",
        "check_bogus",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(WhitespaceCase, self.test_list))

def suite():
    return WhitespaceSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
