/*
 *  Copyright (C) 1998-99 Luca Deri <deri@unipi.it>
 *                      
 *		  	  Centro SERRA, University of Pisa
 *		 	  http://www-serra.unipi.it/
 *  					
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "ntop.h"


static int sqlSocket = -1;
static char sqlBuf[1514];

struct sockaddr_in dest;

extern HostTraffic* hash_hostTraffic[HASHNAMESIZE];

extern char* formatBytes(TrafficCounter numBytes, short encodeString);
extern char* formatTime(time_t *theTime, short encodeString);
extern char* intoa(struct in_addr addr);
extern char* getVendorInfo(u_char* ethAddress, short encodeString);
extern u_int checkSessionIdx(u_int idx);
extern u_int32_t inet_addr (const char*);

/* **************************************** */

void openSQLsocket(char* dstHost, int dstPort) {
  struct hostent *hostAddr = gethostbyname(dstHost);
  
  if(hostAddr == NULL) {
    printf("Unable to resolve address '%s'\n", dstHost);
    exit(-1);
  }

  dest.sin_addr.s_addr = inet_addr(dstHost);
  dest.sin_family      = AF_INET;
  dest.sin_port        = (int)htons(dstPort);
	
  memcpy(&dest.sin_addr.s_addr, hostAddr->h_addr_list[0],
	 hostAddr->h_length);

  sqlSocket = socket (AF_INET, SOCK_DGRAM, 0);
  
  if(sqlSocket <= 0) {
    printf("Unable to open SQLsocket\n");
      exit(-1);
  } else {
      printf("Open channel with ntop SQL client running @ %s:%d\n", dstHost, dstPort);
  }
}

/* **************************************** */

void closeSQLsocket() {
#ifndef WIN32
  close(sqlSocket);
#else
  closesocket(sqlSocket);
#endif     
}

/* **************************************** */

void updateHostNameInfo(unsigned long numeric, char* symbolic) {
  char *hostName;
  struct in_addr addr;

  if(sqlSocket == -1)
    return;

  addr.s_addr = numeric;

  hostName = intoa(addr);

  if(strcmp(hostName, symbolic) != 0) {  
    /* [1] Delete */
    sprintf(sqlBuf, "DELETE * FROM NameMapper WHERE IPaddress = '%s'", hostName);
    sendto(sqlSocket, sqlBuf, strlen(sqlBuf), 0, (struct sockaddr *)&dest, sizeof(dest));

    /* [2] Insert */
    sprintf(sqlBuf, "INSERT INTO NameMapper (IPaddress, Name)"
	    " VALUES ('%s', '%s')", hostName, symbolic);    
    sendto(sqlSocket, sqlBuf, strlen(sqlBuf), 0, (struct sockaddr *)&dest, sizeof(dest));
  }
}

/* **************************************** */

void updateHostTraffic(HostTraffic *el) {
  char theDate[32];

  if((sqlSocket == -1)
     || (el->broadcastHost)
     || (el->hostNumIpAddress[0] == '\0'))
    return;

  strftime(theDate, 32, "%d/%m/%Y %H:%M:%S", localtime(&el->lastSeen));


  /* ****************************** */

  sprintf(sqlBuf, "UPDATE Hosts SET "
	  "PktSent = %lu, "
	  "PktRcvd = %lu, "
	  "PktMulticastSent = %lu, "
	  "PktBroadcastSent = %lu, "
 	  "DataSent = %lu, "
	  "DataRcvd = %lu, "
	  "DataMulticastSent = %lu, "
	  "DataBroadcastSent = %lu, "
	  "LastSeen = '%s'"
	  " WHERE IPaddress = '%s'",
	  (unsigned long)(el->pktSent),
	  (unsigned long)(el->pktReceived),
	  (unsigned long)(el->pktMulticastSent),
	  (unsigned long)(el->pktBroadcastSent),
	  (unsigned long)(el->bytesSent),
	  (unsigned long)(el->bytesReceived),
	  (unsigned long)(el->bytesMulticastSent),
	  (unsigned long)(el->bytesBroadcastSent),
	  theDate,
	  el->hostNumIpAddress);

  sendto(sqlSocket, sqlBuf, strlen(sqlBuf), 0, (struct sockaddr *)&dest, sizeof(dest));

  
  /* ****************************** */

  sprintf(sqlBuf, "UPDATE IPtraffic SET "
	  "TCPSentLocally = %lu, "
	  "TCPSentRemotely = %lu, "
	  "TCPrcvdLocally = %lu, "
	  "TCPrcvdFromRemote = %lu, "
	  "UDPSentLocally = %lu, "
	  "UDPSentRemotely = %lu, "
	  "UDPrcvdLocally = %lu, "
	  "UDPrcvdFromRemote = %lu, "
	  "ICMPsent = %lu, "
	  "ICMPrcvd = %lu, "
 	  "OSPFsent = %lu, "
	  "OSPFrcvd = %lu, "
	  "IGMPsent = %lu, "
	  "IGMPrcvd = %lu "
	  " WHERE IPaddress = '%s'",
	  (unsigned long)(el->tcpSentLocally),
	  (unsigned long)(el->tcpSentRemotely),
	  (unsigned long)(el->tcpReceivedLocally),
	  (unsigned long)(el->tcpReceivedFromRemote),
	  (unsigned long)(el->udpSentLocally),
	  (unsigned long)(el->udpSentRemotely),
	  (unsigned long)(el->udpReceivedLocally),
	  (unsigned long)(el->udpReceivedFromRemote),
	  (unsigned long)(el->icmpSent),
	  (unsigned long)(el->icmpReceived),
	  (unsigned long)(el->ospfSent),
	  (unsigned long)(el->ospfReceived),
	  (unsigned long)(el->igmpSent),
	  (unsigned long)(el->igmpReceived),
	  el->hostNumIpAddress);

  sendto(sqlSocket, sqlBuf, strlen(sqlBuf), 0, (struct sockaddr *)&dest, sizeof(dest));

  /* ****************************** */

  sprintf(sqlBuf, "UPDATE NonIpTraffic SET "
	  "IPXsent = %lu, "
	  "IPXrcvd = %lu, "
 	  "OSIsent = %lu, "
	  "OSIrcvd = %lu, "
	  "DLCsent = %lu, "
	  "DLCrcvd = %lu, "
 	  "ARPsent = %lu, "
	  "ARPrcvd = %lu, "
	  "DECNETsent = %lu, "
	  "DECNETrcvd = %lu, "
 	  "ATALKsent = %lu, "
	  "ATALKrcvd = %lu, "
	  "NBIOSsent = %lu, "
	  "NBIOSrcvd = %lu, "
 	  "OtherSent = %lu, "
	  "OtherRcvd = %lu "
	  " WHERE IPaddress = '%s'",
	  (unsigned long)(el->ipxSent),
	  (unsigned long)(el->ipxReceived),
	  (unsigned long)(el->osiSent),
	  (unsigned long)(el->osiReceived),
	  (unsigned long)(el->dlcSent),
	  (unsigned long)(el->dlcReceived),
	  (unsigned long)(el->arp_rarpSent),
	  (unsigned long)(el->arp_rarpReceived),
	  (unsigned long)(el->decnetSent),
	  (unsigned long)(el->decnetReceived),
	  (unsigned long)(el->appletalkSent),
	  (unsigned long)(el->appletalkReceived),
	  (unsigned long)(el->netbiosSent),
	  (unsigned long)(el->netbiosReceived),
	  (unsigned long)(el->otherSent),
	  (unsigned long)(el->otherReceived),
	  el->hostNumIpAddress);

  sendto(sqlSocket, sqlBuf, strlen(sqlBuf), 0, (struct sockaddr *)&dest, sizeof(dest));
}

/* **************************************** */

void notifyHostCreation(HostTraffic *el) {

  if((sqlSocket == -1) || (el->broadcastHost))
    return;

  /* [1] Delete */

  if(el->hostNumIpAddress[0] != '\0')
    sprintf(sqlBuf, "DELETE * FROM Hosts WHERE IPaddress = '%s'", el->hostNumIpAddress);
  else
    sprintf(sqlBuf, "DELETE * FROM Hosts WHERE MACaddress = '%s'", el->ethAddressString);
  sendto(sqlSocket, sqlBuf, strlen(sqlBuf), 0, (struct sockaddr *)&dest, sizeof(dest));
  
  /* [2] Insert */
  sprintf(sqlBuf, "INSERT INTO Hosts (IPaddress, MACaddress, NICvendor)"
	  " VALUES ('%s', '%s', '%s')",
	  el->hostNumIpAddress,
	  el->ethAddressString,
	  getVendorInfo(el->ethAddress, 0));

  sendto(sqlSocket, sqlBuf, strlen(sqlBuf), 0, (struct sockaddr *)&dest, sizeof(dest));

  if(el->hostNumIpAddress[0] != '\0') {
    sprintf(sqlBuf, "DELETE * FROM NonIPtraffic WHERE IPaddress = '%s'", el->hostNumIpAddress);
    sendto(sqlSocket, sqlBuf, strlen(sqlBuf), 0, (struct sockaddr *)&dest, sizeof(dest));

    sprintf(sqlBuf, "INSERT INTO NonIPtraffic (IPaddress) VALUES ('%s')", el->hostNumIpAddress);
    sendto(sqlSocket, sqlBuf, strlen(sqlBuf), 0, (struct sockaddr *)&dest, sizeof(dest));

    sprintf(sqlBuf, "DELETE * FROM IPtraffic WHERE IPaddress = '%s'", el->hostNumIpAddress);
    sendto(sqlSocket, sqlBuf, strlen(sqlBuf), 0, (struct sockaddr *)&dest, sizeof(dest));

    sprintf(sqlBuf, "INSERT INTO IPtraffic (IPaddress) VALUES ('%s')", el->hostNumIpAddress);
    sendto(sqlSocket, sqlBuf, strlen(sqlBuf), 0, (struct sockaddr *)&dest, sizeof(dest));
  }

  /* printf("%s\n", buf); */

}

/* **************************************** */

void notifyTCPSession(IPSession *session) {
  HostTraffic *server, *client;

  if((sqlSocket == -1) 
     || (session->initiatorIdx == NO_PEER)
     || (session->remotePeerIdx == NO_PEER))
    return;

  client = hash_hostTraffic[checkSessionIdx(session->initiatorIdx)];
  server = hash_hostTraffic[checkSessionIdx(session->remotePeerIdx)];

  sprintf(sqlBuf, "INSERT INTO TCPsessions (Client, Server, ClientPort, "
	  "ServerPort, DataSent, DataRcvd, FirstSeen, LastSeen)"
	  " VALUES ('%s', '%s', '%d', '%d', '%lu', '%lu', '%s', '%s')",
	  client->hostNumIpAddress,
	  server->hostNumIpAddress,
	  session->sport,
	  session->dport,
	  (unsigned long)(session->bytesSent), 
	  (unsigned long)(session->bytesReceived),
	  formatTime(&(session->firstSeen), 0),
	  formatTime(&(session->lastSeen), 0)
	  );

  /* printf("%s\n", sqlBuf); */

  sendto(sqlSocket, sqlBuf, strlen(sqlBuf), 0, (struct sockaddr *)&dest, sizeof(dest));
}

/* **************************************** */

void updateDBOSname(HostTraffic *el) {
  if((sqlSocket == -1) 
     || (el->osName == NULL)
     || (el->osName[0] == '\0'))
    return;
  
  /* printf("%s@%s\n", el->osName, el->hostNumIpAddress); */

  sprintf(sqlBuf, "UPDATE Hosts SET "
	  "OsName = '%s' WHERE IPaddress = '%s'",
	  el->osName, el->hostNumIpAddress);
  
  sendto(sqlSocket, sqlBuf, strlen(sqlBuf), 0, (struct sockaddr *)&dest, sizeof(dest));
}

