/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int pos;

    public PushbackInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.buf = new byte[n];
        this.pos = n;
    }

    public PushbackInputStream(InputStream inputStream) {
        this(inputStream, 1);
    }

    public int read() throws IOException {
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        return super.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this.buf.length - this.pos;
        if (n3 > 0) {
            if (n2 < n3) {
                n3 = n2;
            }
            System.arraycopy(this.buf, this.pos, byArray, n, n3);
            this.pos += n3;
            n += n3;
            n2 -= n3;
        }
        if (n2 > 0) {
            if ((n2 = super.read(byArray, n, n2)) == -1) {
                if (n3 == 0) {
                    return -1;
                }
                return n3;
            }
            return n3 + n2;
        }
        return n3;
    }

    public void unread(int n) throws IOException {
        if (this.pos == 0) {
            throw new IOException("Push back buffer is full");
        }
        this.buf[--this.pos] = (byte)n;
    }

    public void unread(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > this.pos) {
            throw new IOException("Push back buffer is full");
        }
        this.pos -= n2;
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
    }

    public void unread(byte[] byArray) throws IOException {
        this.unread(byArray, 0, byArray.length);
    }

    public int available() throws IOException {
        return this.pos + super.available();
    }

    public boolean markSupported() {
        return false;
    }
}

