# Copyright (C) 1993-1998 Ken'ichi Fukamachi
#          All rights reserved. 
#               1993-1996 fukachan@phys.titech.ac.jp
#               1996-1998 fukachan@sapporo.iij.ad.jp
# 
# FML is free software; you can redistribute it and/or modify
# it under the terms of GNU General Public License.
# See the file COPYING for more details.
#
# $Id: libfop.pl,v 2.5 1999/01/29 15:08:30 fukachan Exp $;

# local scope in this
local($CurrentMode);

# Aliases
# sub SendFileMajority  { &SendFile('#dummy', @_);}
# sub SendFile2Majority { &SendFile('#dummy', @_);}
sub SendFileMajority  { &SendFile2Majority(@_);}

# ($subject, $file, 0, @to);
sub SendFile2Majority 
{ 
    local($subject, $file, @to) = @_;
    local(@files) = $file;

    &NeonSendFile(*to, *subject, *files); #(*to, *subject, *files);
}


&use('utils');

# Parameters:
# $tmpf     : a temporary file
# $mode     : mode 
# $file     : filename of encode e.g. uuencode , ish ...
# @filelist : filelist of packing and encodeing. !REQUIRE push(@here,$file)!
#
# INSIDE VARIABLES:
# *conf : input 
# *r    : output
# *misc : output as an additional
sub DraftGenerate
{
    local(*conf, *r, *misc);
    local($prog, $proc);
    local($tmpf, $mode, $file, @conf) = @_; # attention! *conf above
    $conf = $tmpf;
    $r    = $file;
    $conf{'total'} = 0;

    &Debug("DraftGenerate ($tmpf, $mode, $file, @conf)") if $debug;

    &InitDraftGenerate;

    # INCLUDE
    require $_fp{'inc', $mode} if $_fp{'inc', $mode};

    foreach $proc ( # order 
		   'hdr',
		   'cnstr', 
		   'retrieve',
		   'encode',
		   'split',
		   'encode_as',
		   'destr'
		   ) {

	$prog = $_fp{$proc, $mode};
	if ($debug) {
	    print STDERR "Call [$proc]\t";
	    print STDERR "$prog(*conf, *r, *misc);" if $prog;
	    print STDERR "\n";
	}
	$CurrentMode = $mode;
	&$prog(*conf, *r, *misc) if $prog;
    }

    undef %conf;

    $r{'total'};
}


# Initialization of msending interface. 
# return NONE
sub InitDraftGenerate
{
    ### 2.1B test ###
    $FOP_HACK = 1;
    ### 2.1B test end ###

    &MSendModeSet;

    # PLAIN TEXT with UNIX FROM
    $_fp{'cnstr',    'uf'} = 'Cnstr_uf';
    $_fp{'retrieve', 'uf'} = 'f_RetrieveFile';
    $_fp{'split',    'uf'} = '';
    $_fp{'destr',    'uf'} = '';

    # PLAINTEXT by RFC934
    $_fp{'cnstr',    'rfc934'}  = 'Cnstr_rfc934';
    $_fp{'retrieve', 'rfc934'}  = 'f_RetrieveFile';
    $_fp{'destr',    'rfc934'}  = 'Destr_rfc934';

    # PLAINTEXT by RFC1153
    $_fp{'cnstr',    'rfc1153'} = 'Cnstr_rfc1153';
    $_fp{'retrieve', 'rfc1153'} = 'f_RetrieveFile';

    # PLAINTEXT by MIME/Multipart
    $_fp{'cnstr',    'mp'} = 'Cnstr_mp';
    $_fp{'retrieve', 'mp'} = 'f_RetrieveFile';

    ### encoding ###

    # UUENCODE ONLY
    $_fp{'retrieve', 'uu'}     = 'f_uu';
    $_fp{'split',    'uu'}     = 'f_SplitFile';

    # Base64 Encode Only
    $_fp{'cnstr',    'base64'} = 'Cnstr_message_partial';
    $_fp{'retrieve', 'base64'} = 'f_RetrieveFile';
    $_fp{'encode',   'base64'} = 'f_base64';
    $_fp{'split',    'base64'} = 'f_SplitFile';
    $_fp{'encode_as','base64'} = 'Cnstr_message_partial';

    ### compression + encoding ###

    # Gzipped UNIX FROM
    $_fp{'cnstr',    'gz'} = 'Cnstr_gz';
    $_fp{'retrieve', 'gz'} = 'f_gz';
    $_fp{'encode',   'gz'} = 'f_gz_encode';
    $_fp{'split',    'gz'} = 'f_SplitFile';

    # PACK: TAR + GZIP
    $_fp{'cnstr',    'tgz'} = 'Cnstr_tgz';
    $_fp{'retrieve', 'tgz'} = 'f_tgz';
    $_fp{'encode',   'tgz'} = 'f_gz_encode';
    $_fp{'split',    'tgz'} = 'f_SplitFile';

    # PACK: TAR + GZIP
    $_fp{'cnstr',    'zip'} = 'Cnstr_message_partial';
    $_fp{'retrieve', 'zip'} = 'f_zip';
    $_fp{'encode',   'zip'} = 'f_base64';
    $_fp{'split',    'zip'} = 'f_SplitFile';

    # PACK: LHA + ISH
    $_fp{'cnstr',    'lhaish'} = '';
    $_fp{'retrieve', 'lhaish'} = 'f_Lha';
    $_fp{'encode',   'lhaish'} = 'f_lha_encode';
    $_fp{'split',    'lhaish'} = 'f_SplitFile';

    # PACK: LHA + UUENCODE
    $_fp{'cnstr',    'lhauu'}  = '';
    $_fp{'retrieve', 'lhauu'}  = 'f_Lha';
    $_fp{'encode',   'lhauu'}  = 'f_lha_encode';
    $_fp{'split',    'lhauu'}  = 'f_SplitFile';
}


########### CONSTRUCTORS ##########


sub Cnstr_uf
{
    local(*conf, *r, *misc) = @_;

    $conf{'plain'} = 1;
    $conf{'total'} = 1;
    $conf{'delimiter'} = "From $MAINTAINER $MailDate\n";
    $conf{'preamble'} = '';
    $conf{'trailer'}  = '';

    $conf{'MimeDecodable'} = 1;
}


sub Cnstr_rfc1153
{
    local(*conf, *r, *misc) = @_;
    local($mode) = 'rfc1153';

    $conf{'plain'} = 1;
    $conf{'total'} = 1;
    $conf{'delimiter'} = "\n\n".('-' x 30)."\n\n";

    &use('rfc1153');
    local($preamble, $trailer) = &Rfc1153Custom($mode, *conf);

    &Debug("preamble $preamble\ntrailer $trailer") if $debug;

    $conf{'rfhook'}   = &Rfc1153ReadFileHook;
    $conf{'preamble'} = $preamble;
    $conf{'trailer'}  = $trailer;

    # set Destructor used in MSendv4.pl 
    # to increment the issue count of the digest
    $_cf{'Destr'} .= "&Rfc1153Destructer;\n";

    $conf{'MimeDecodable'} = 1;
}


sub Cnstr_rfc934
{
    local(*conf, *r, *misc) = @_;

    $conf{'plain'} = 1;
    $conf{'total'} = 1;
    $conf{'delimiter'} = "\n------- Forwarded Message\n\n";
    $conf{'preamble'} = '';
    $conf{'trailer'}  = '';

    $conf{'rfhook'} = q#
	s/^-/- -/;
    #;
}


sub Destr_rfc934
{
    local(*conf, *r, *misc) = @_;

    undef $conf{'rfhook'};
}


# patched by mikami@saturn.hcs.ts.fujitsu.co.jp
# Posted:  Tue, 16 May 1995 23:20:32 JST
# fml-supoort ML: 00363
# Following this fix, modify
# $ORG_MIME_MULTIPART_BOUNDARY -> $MIME_MULTIPART_BOUNDARY
# $MIME_MULTIPART_BOUNDARY     -> $MIME_MULTIPART_DELIMITER
#
sub Cnstr_mp
{
    local(*conf, *r, *misc) = @_;
    local($boundary) = "--$MailDate--";
    $boundary =~ s/,//g; $boundary =~ s/\s+JST//g; $boundary =~ s/ /_/g;

    # MIME CONFIGURATION
    $MIME_VERSION              = $MIME_VERSION || '1.0';
    $MIME_CONTENT_TYPE         = $MIME_CONTENT_TYPE || 'multipart/mixed;';
    $MIME_MULTIPART_BOUNDARY   = $MIME_MULTIPART_BOUNDARY || $boundary;
    $MIME_MULTIPART_DELIMITER  = $MIME_MULTIPART_BOUNDARY;
    $MIME_MULTIPART_DELIMITER .= "\nContent-Type: message/rfc822\n";
    $MIME_MULTIPART_CLOSE_DELIMITER = $MIME_MULTIPART_BOUNDARY;

    # configurations 
    $conf{'plain'}     = 1;
    $conf{'total'}     = 1;
    $conf{'delimiter'} = "\n--$MIME_MULTIPART_DELIMITER\n";
    $conf{'preamble'}  = $MIME_MULTIPART_PREAMBLE if $MIME_MULTIPART_PREAMBLE;
    $conf{'trailer'}   = "\n--$MIME_MULTIPART_CLOSE_DELIMITER--\n";
    $conf{'trailer'}  .= $MIME_MULTIPART_TRAILER if $MIME_MULTIPART_TRAILER;

    # make MIME Header
    undef $Envelope{'GH:Mime-Version:'};
    undef $Envelope{'GH:Content-Type:'};
    $Envelope{'GH:Mime-Version:'} = $MIME_VERSION;
    $Envelope{'GH:Content-Type:'} = 
	"$MIME_CONTENT_TYPE\n\tboundary=\"$MIME_MULTIPART_BOUNDARY\"";
}


sub Cnstr_gz
{
    local(*conf, *r, *misc) = @_;

    $conf{'total'} = 0;
    $conf{'delimiter'} = "From $MAINTAINER $MailDate\n";
    $conf{'preamble'} = '';
    $conf{'trailer'}  = '';
}


sub Cnstr_tgz
{
    local(*conf, *r, *misc) = @_;

    $conf{'total'} = 0;
    $conf{'delimiter'} = "From $MAINTAINER $MailDate\n";
    $conf{'preamble'} = '';
    $conf{'trailer'}  = '';
}


# DEBUG OPTION: 
# $debug_rf (RF == Retrive File)?
sub f_RetrieveFile
{
    local(*conf, *r, *misc) = @_;
    local($tmpf) = $conf;
    local($file, $lines, $linecounter, $total, $new_p);
    local($total) = $conf{'total'};

    # OPEN
    &OpenStream($tmpf, 0, 0, $total) || (return 0);
    &Debug("OpenStream($tmpf, 0, 0, $total), success") if $debug; 
    
    # PREAMBLE
    if ($conf{'preamble'}) {
	print OUT $conf{'preamble'};
	# $new_p++; # not increment against separator-only-file
    }

    # Retrieve files
    local($s);
    local($curhf); # alloc special variable for rfhook

    for $file (@conf) {
	$lines = &WC($file);
	
	# open the next file
	&Debug("open(FILE, $file) || next;") if $debug_rf; 
	open(FILE, $file) || next; 
	print OUT $conf{'delimiter'} if $conf{'delimiter'};

 	if ($conf{'rfhook'}) {
	    # rfhook is evaluated after (1 .. /^$/) condition
	    # since eval() influences this $. check?
	    $s = qq#
		while (<FILE>) { 
		    if (1 .. /^\$/) {
			if (\$FOP_HACK && \$USE_MIME &&
			    \$conf{'MimeDecodable'} && 
			    /=\\?ISO\\-2022\\-JP\\?/io) {
			    &use('MIME');
			    \$_ = &DecodeMimeStrings(\$_);
			}
		    }

		    $conf{'rfhook'};

		    print OUT \$_; 
		    \$linecounter++;
		}
	    #;

	    &Debug(">>$s<<") if $debug;
	    &eval($s, 'Retrieve file hook');
	}
	else {
	    while (<FILE>) {
		if (1 .. /^$/) {
		    if ($FOP_HACK && $USE_MIME &&
			$conf{'MimeDecodable'} && /=\?ISO\-2022\-JP\?/io) {
			&use('MIME');
			$_ = &DecodeMimeStrings($_);
		    }
		}
		
		print OUT $_; 
		$linecounter++;
	    }
	}
	&Debug("close(FILE) [total=$total];") if  $debug_rf; 
	close(FILE);
	
	print OUT "\n"; $linecounter++;
	$new_p++;	# the number of files
	
	# If PLAIN TEXT, reset!
	if ($conf{'plain'} && ($linecounter + $lines) > $MAIL_LENGTH_LIMIT) {
	    # e.g. in the format of RFC1153, 
	    # each mail is perfect format is appropriate?
	    print OUT $conf{'trailer'} if $conf{'trailer'};

	    # Close Output
	    &CloseStream;

	    # Reconfig
	    $total++;
	    $linecounter = 0;

	    # Open new file(OUTPUT)
	    &OpenStream($tmpf, 0, 0, $total) || (return 0);

	    # if preamble only, not need to deliver, so new_p = 0
	    print OUT $conf{'preamble'} if $conf{'preamble'}; 
	    $new_p = 0;
	}
    }

    # TRAILER
    if ($new_p && $conf{'trailer'}) { # already wirte at least one file 
	print OUT $conf{'trailer'};
	# $new_p++; # not increment against separator-only-file
    }

    # CLOSE
    &CloseStream;

    # if write filesize=0, decrement total.
    # decrement the seq and should unlink it(size=0)
    if (! $new_p) {
	unlink "$tmpf.$total" if -z "$tmpf.$total"; # if size = 0;
	$total--;
    }

    $r{'total'} = $total;
}


sub f_Lha
{
    local(*conf, *r, *misc) = @_;
    &Lha($conf, $r, @conf); # input:$conf;
}


sub f_gz
{
    local(*conf, *r, *misc) = @_;
    local($tmpf) = $conf;

    &f_RetrieveFile(*conf, *r, *misc);
    # &system("$COMPRESS $tmpf.0|$UUENCODE $r", $tmpf);
    &system("$COMPRESS $tmpf.0", $tmpf);
}


sub f_tgz
{
    local(*conf, *r, *misc) = @_;
    local($tmpf) = $conf;

    # &system("$TAR ".join(" ", @conf)."|$COMPRESS|$UUENCODE $r", $tmpf);
    &system("$TAR ".join(" ", @conf)."|$COMPRESS", $tmpf);
}


sub f_gz_encode
{
    local(*conf, *r, *misc) = @_;
    local($tmpf) = $conf;

    # splitfile uses "$tmpf" as a mster.
    rename($tmpf, "$tmpf.1");

    &system("$UUENCODE $r", $tmpf, "$tmpf.1");
}


sub f_zip
{
    local(*conf, *r, *misc) = @_;
    local($tmpf) = $conf;
    local($t)    = "msend.zip";

    $ZIP = $ZIP || "/usr/local/bin/zip";

    if (!-x $ZIP) {
	&Log("f_zip: cannot find zip executable");
	return;
    }

    &system("$ZIP $t @conf");
    rename($t, "$tmpf.0") || &Log("cannot rename $t $tmpf.0");

    $Envelope{"GH:Content-Type:"} .= "\n\tname=\"msend.zip\";";
}


sub f_uu_conf_gabble
{
    local($out, *conf) = @_;

    open(OUT, "> $out") || return;
    select(OUT); $| = 1; select(STDOUT);

    for (@conf) {
	&Debug("   f_uu_conf_gabble::open($_)\n") if $debug;
	if (open(F, $_)) { 
	    while (<F>) { print OUT $_;};
	    close(F);
	}
    }

    close(OUT);
}


sub f_uu
{
    local(*conf, *r, *misc) = @_;
    local($f, $dir, $name, $output, $input);
    local($tmpf) = $conf;
    local($tmpr) = $r;

    # answer: cat @conf | uuencode msend.uu > $tmpf, isnt it?
    if (@conf) {
	$output = $tmpf;
	$input  = "$TMP_DIR/msend.uu";
	$name   = $r;
	&f_uu_conf_gabble($input, *conf);
    }
    # Example: $r=old/100.tar.gz $old=old $f=100.tar.gz if @conf == 1;
    else {
	$tmpr   =~ s#(\S+)/(\S+)#$dir=$1, $f=$2#e;
	$name   = $f;
	$dir    = $dir || '.';
	$f      = $f || $tmpr;
	$input  = "$dir/$f";
	$output = $tmpf;
    }

    # filename to use in uudecofing
    $name =~ s#^.*/(.*)#$1#;

    if ($debug) {
	&Debug("\n   f_uu_conf_gabble::($input @conf)");
	&Debug("   f_uu::conf=$conf r=$r misc=$misc name=$name");
	&Debug("   f_uu::system(uuencode < $input > $tmpf)");
	&Debug("   system($UUENCODE $name, $output, $input);");
    }

    # uuencode soure-file file-label
    # &system("chdir $dir; $UUENCODE $f $f", $tmpf);
    # &system("$UUENCODE $dir/$f $f", $tmpf); 
    # system($s, $out, $in, $read, $write)
    &system("$UUENCODE $name", $output, $input); 
    unlink "$TMP_DIR/msend.uu" if -f "$TMP_DIR/msend.uu";
}


sub Cnstr_message_partial
{
    local($id) = &GenMessageId;

    $MIME_VERSION              = $MIME_VERSION || '1.0';

    $Envelope{'GH:Mime-Version:'} = $MIME_VERSION;
    $Envelope{'GH:Content-Type:'} = 
	"message/partial;\n\tnumber=1; total=1;\n\tid=\"$id\";";
    $Envelope{'GH:Content-Transfer-Encoding:'} = "base64";
}


sub f_base64
{
    local(*conf, *r, *misc) = @_;
    local($tmpf) = $conf;
    local($encode, $libdir);

    $encode = &SearchFileInLIBDIR("bin/base64encode.pl");
    $libdir = join(":", @LIBDIR);
    $BASE64_ENCODE = $BASE64_ENCODE || "$encode -I $libdir";

    open(IN, "$tmpf.0") || &Log("f_base64: cannot open $tmpf");
    open(BASE64, "|$BASE64_ENCODE > $tmpf.1") ||
	&Log("f_base64: cannot open $tmpf.1");
    select(BASE64); $| = 1; select(STDOUT);
    binmode(IN);
    while (<IN>) {
	print BASE64 $_;
    }
    close(IN);
    close(BASE64);

    &Debug("rename($tmpf.1, $tmpf);") if $debug;
    rename("$tmpf.1", $tmpf) || &Log("f_base64: cannot rename $tmpf.1 $tmpf");
}


sub f_gzuu
{
    local(*conf, *r, *misc) = @_;
    local($tmpf) = $conf;

    &system("$COMPRESS $tmpf.0|$UUENCODE $r", $tmpf);
}


sub f_SplitFile
{
    local(*conf, *r, *misc) = @_;
    local($tmpf) = $conf;
    local($total) = $r{'total'};

    &Debug("f_SplitFile: $r => $tmpf") if $debug;

    local($totallines) = &WC($tmpf);
    $total = int($totallines/$MAIL_LENGTH_LIMIT + 1);
    &Debug("f_SplitFile: $total <= $totallines/$MAIL_LENGTH_LIMIT") if $debug;

    if ($total > 1) {
	local($s) = &SplitFiles($tmpf, $totallines, $total);
	if ($s == 0) {
	    &Log("f_SplitFile: Cannot split $tmpf");
	    return 0;
	}
    }
    elsif (1 == $total) {# a trick for &SendingBackInOrder;
	&Debug("f_SplitFile: rename($tmpf, $tmpf.1)") if $debug; 
	rename($tmpf, "$tmpf.1") || &Log("cannot rename $tmpf $tmpf.1"); 
    }

    $r{'total'} = $total;
}
##############################


# Open FILEHANDLE 'OUT'.
# packp is backward compatibility since 
# packp is always 0!
# return 1 if succeed;
sub OpenStream_OUT { &OpenStream(@_);}
sub OpenStream
{
    local($where, $packp, $file, $total) = @_;

    &Debug("OpenStream: open OUT > $where.$total;") if $debug;
    open(OUT, "> $where.$total") || do { 
	&Log("OpenStream: cannot open $where.$total");
	return $NULL;
    };
    select(OUT); $| = 1; select(STDOUT);

    1;
}


# Aliases for symmetry. close FILEHANDLE 'OUT'
sub CloseStream     { close(OUT);}
sub CloseStream_OUT { close(OUT);}


# Word Counting of the gigen file
# return lines
sub WC
{
    local($f) = @_;
    local($lines) = 0;

    open(TMP, $f) || return 0;
    while (<TMP>) { 
	$lines++;
    }
    close(TMP);

    $lines;
}


# Split files and unlink the original
# $file - split -> $file.1 .. $file.$total files 
# return the number of splitted files
sub SplitFiles
{
    local($file, $totallines, $total) = @_;
    local($unit)  = int($totallines/$total); # equal lines in each file
    local($lines) = 0;
    local($i)     = 1;		# split to (1 .. $total)

    open(BUFFER,"< $file")    || do { &Log($!); return 0;};
    open(OUT,   "> $file.$i") || do { &Log($!); exit 1;};
    select(OUT); $| = 1; select(STDOUT);

    while (<BUFFER>) {
	print OUT $_; $lines++;

	# Reset
	if ($lines > $unit) { 
	    $lines = 0; 
	    close OUT; 
	    $i++;

	    &Debug("open(OUT, > $file.$i)") if $debug;

	    # Next file
	    open(OUT, "> $file.$i") || do { &Log($!); return 0;};
	    select(OUT); $| = 1; select(STDOUT);
	}
    }# WHILE;

    close(OUT);

    # delete original source
    unlink $file unless $_cf{'splitfile', 'NOT unlink'}; 
    &Debug("SplitFiles:unlink $file") if $debug;

    $i;
}


# Making files encoded and compressed for the given @filelist
# if PACK_P >0(PACKING),
# packed one is > "$where.0"
# $file is an finally encoded name 
# if plain,
# $where.1 -> $where.$total(>=1) that is .1, .2, .3...
# return $total
sub MakeFilesWithUnixFrom { &DraftGenerate(@_);}
sub MakeFileWithUnixFrom  { &DraftGenerate(@_);}

# Lha + uuencode for $file
# &Lha..( inputfile, encode-name, @list ) ;
# return ENCODED_FILENAME
# sub LhaAndEncode2Ish
sub Lha
{
    local($input, $name, @filelist) = @_;
    local($tmpout, @unlink);
    local($compress, $uuencode);

    &Debug("Lha($input, $name, @filelist)") if $debug;

    # SJIS ENCODING
    if ($USE_SJIS_in_ISH || $USE_SJIS_IN_ISH) {
	require 'jcode.pl';
	@filelist = &Convert2Sjis(*filelist); # reset 
	push(@unlink, @filelist);
	&Debug("LhaAndEncode2Ish($input, $name, @filelist)") if $debug;
    }

    # Variable setting
    $name     =~ s#(\S+)/(\S+)#$2.lzh#;
    $name     =~ s/\.gz$//i;
    $name     =~ s/\.lzh$//i;
    $tmpout   = "$TMP_DIR/$name.lzh";
    push(@unlink, $tmpout);	# unlink

    $LHA      = $LHA || "$LIBDIR/bin/lha";

    $compress = "$LHA a $tmpout @filelist ";

    # against unremoved left files;
    unlink $tmpout if -f $tmpout; 

    &system($compress);

    $misc{'name'}   = $name;
    $misc{'input'}  = $input;
    $misc{'tmpout'} = $tmpout;
    $misc{'unlink'} = join(" ", @unlink);
}


sub f_lha_encode
{
    local(*conf, *r, *misc) = @_;
    local($name, $input, $tmpout, @unlink);

    $name   = $misc{'name'};
    $input  = $misc{'input'};
    $tmpout = $misc{'tmpout'};

    if ($CurrentMode =~ /uu/) {
	&system("$UUENCODE $name.lzh", $input, $tmpout);
    }
    elsif ($CurrentMode =~ /ish/) {
	$ISH      = $ISH || "$LIBDIR/bin/ish";
	$tmpish   = "$TMP_DIR/$name.ish";

	# FIX for 'aish' when NOT "aish -d"
	($ISH =~ /aish/) && ($ISH !~ /\s+\-d\s+/) && ($ISH .= " -d ");

	$uuencode = "$ISH -s7 $name.lzh"; # since in $TMP_DIR
	#OLD: $uuencode = "$ISH -s7 -o $input $tmpout";

	# ish cannot understand ">tmp/*.lzh.ish"
	if ($INSECURE_SYSTEM) {
	    system("(cd $TMP_DIR; $uuencode)");
	}
	else {
	    &use('utils');

	    local($pwd);
	    chop($pwd = `pwd`);
	    (chdir $TMP_DIR) ? 
		&system($uuencode) :
		    &Log("f_lha_encode: cannot chdir $TMP_DIR");
	    chdir $pwd || &Log("f_lha_encode: cannot chdir $pwd");
	}

	unlink $tmpout if -f $tmpout; # lha
	rename($tmpish, $input) || &Log("canot rename $tmpish $input");
    }

    # temporary files to remove
    @unlink = split(/\s+/, $misc{'unlink'});

    if ($debug) { 
	print STDERR "   Unlink @unlink \n";
    }
    else { 
	unlink @unlink if @unlink;
    }

    $input;
}


# Convert @filelist -> 
# return filelist(may be != given filelist e.g. spool -> tmp/spool)
# &system 's parameter is ($cmd , $out, $in)
# 
sub Convert2Sjis
{
    local(*f) = @_;
    local(*r, $tmp, $tmpf);

    $tmp  = $TMP_DIR;
    $tmpf = "$tmp/$$";
    $tmp  =~ s/^\.\///; # $SPOOL_DIR/,  tmp/, ...;

    # temporary directory
    -d "$TMP_DIR/spool" || &Mkdir("$TMP_DIR/spool");

    # GO!
    foreach $r (@f) { 
	$r =~ s/^\.\///; # $SPOOL_DIR/, tmp/, ...;

	&Debug("file2sjis($r, $tmpf)") if $debug;
	&file2sjis($r, $tmpf) || next;

	if ($r =~ /^$SPOOL_DIR/) {
	    rename($tmpf, "$TMP_DIR/$r") || 
		&Log("cannot rename $tmf $TMP_DIR/$r");
	    push(@r, "$TMP_DIR/$r");
	}
	elsif ($r =~ /^$tmp/) {
	    rename($tmpf, $r) || &Log("cannot rename $tmf $r");
	    push(@r, $r);
	}
	else {
	    ### SPECIAL EFFECT: for SendFileBySplit to send ONE FILE;
	    $r = $name;
	    $r =~ s#(\S+)/(\S+)#$tmp/$2#;
	    rename($tmpf, $r) || &Log("cannot rename $tmpf $r");
	    push(@r, $r);	
	}
    }

    @r;	# return;
}


# using jcode.pl and add ^M and ^Z
# return 1 if succeed
sub file2sjis 
{
    local($in, $out) = @_;
    local($line);

    open(IN, $in)       || (&Log("file2sjis < $in: $!"),  return $NULL);
    open(OUT, "> $out") || (&Log("file2sjis > $out: $!"), return $NULL);
    select(OUT); $| = 1; select(STDOUT);

    while (<IN>) {
	&jcode'convert(*_, 'sjis');#';
	s/\012$/\015\012/; # ^M^J
	print OUT $_;
    }

    print OUT "\032\012";	# ^Z
    close(IN);
    close(OUT);

    1;
}


sub SendingBackInOrderTimeOut 
{ 
    &SocketTimeOut;
    $SendingBackInOrderTimeOut = 1;
}

# Sending files back, Orderly is [a], not [ad] _o_
# $returnfile not include $DIR PATH
# return NONE
sub SendingBackInOrder { &SendBackInOrder(@_);}
sub SendingBackOrderly { &SendBackInOrder(@_);}
sub SendBackInOrder
{
    local($returnfile, $total, $subj, $sleeptime, @to) = @_;
    local($file, @files, $timeout, $evid, $evidk, $evidk0, %mib);

    # reset timeout flag;
    undef $SendingBackInOrderTimeOut;

    # sleep time;
    $sleeptime = $sleeptime ? $sleeptime : 3;

    # set the final remove event (the case "$total == 0" is possible???)
    $evidk0 = &SetEvent((60 + $sleeptime)*($total+1), 'TimeOut') if $HAS_ALARM;

    for $now (1..$total) {
	if ($SendingBackInOrderTimeOut) { # time out 
	    $now-- if $now > 1;
	    &Log("SendingBackInOrder::TimeOut, give up to send $now<=>$total");
	    last;
	}

	# timeout: dead timeout and socket timeout
	$evidk = &SetEvent($sleeptime + 120, 'TimeOut') if $HAS_ALARM;
	$evid  = &SetEvent($sleeptime + 60, 'SendingBackInOrderTimeOut');

	if ($COMPAT_ARCH eq 'WINDOWS_NT4') {
	    $file = "$returnfile.$now";
	}
	else {
	    $file = ($returnfile =~ m%^/% ? "" : $DIR)."/$returnfile.$now";
	}
	
	$0 = "$FML: SendingBackInOrder $now/$total";
	&Log("SendBackInOrder[$$] $now/$total $to");

        # subject is reset anytime;
	%template_cf = ("_PART_",  "($now/$total)",
			"_ML_FN_", $ML_FN);
	$subject = &SubstituteTemplate($subj, *template_cf);

	# message/partial
	if ($Envelope{'GH:Content-Type:'} =~ /partial/) {
	    $mib{'number'} = $now;
	    $mib{'total'}  = $total;
	    &MIMESubstitute('message/partial', *mib);
	}

	@files = ($file);
	&NeonSendFile(*to, *subject, *files); #(*to, *subject, *files);
	#    &SendFile2Majority("$subj ($now/$total) $ML_FN", $file, @to);
	# -> &NeonSendFile(*to, *subject, *files); #(*to, *subject, *files);
		 
	unlink $file unless $debug;

	$0 = "$FML: SendingBackInOrder sleep($sleeptime) cur=$now/$total";

	# remove event handler
	&ClearEvent($evid)  if $evid;  $evid  = 0;
	&ClearEvent($evidk) if $evidk; $evidk = 0;

	sleep(($total == $now) ? 1 : $sleeptime); # no wait when ends;
    }

    &Debug("SBO:unlink $returnfile $returnfile.[0-9]*") if $debug;
    unlink $returnfile if ((! $_cf{'splitfile', 'NOT unlink'}) && (! $debug));
    unlink "$returnfile.0" unless $debug; # a trick for MakeFileWithUnixFrom

    # for example, msend.pl uses this routine several times.
    # We should clean up all events.
    &ClearEvent($evid)   if $evid;
    &ClearEvent($evidk)  if $evidk;
    &ClearEvent($evidk0) if $evidk0;

    # Destructor; 
    &ClearMimeHdr;
}


sub DelaySendFileDividedly
{
    # for unique tmp file
    $DSFD_Counter++;

    local($f, $mode, $enc, @to) = @_;
    local($total, $s, $target);
    local($sleep) = ($SLEEPTIME || 3);
    local($tmp)   = "$TMP_DIR/sfbs:${DSFD_Counter}:$$";

    $0 = "$FML: split and send back $f to $to <$LOCKFILE>";
    $s = $enc || $DEFAULT_MGET_SUBJECT;

    ### IF MIME mode, you are afraid of a lot ...
    if ($mode ne 'uf') {
	&Log("DelaySendFileDividedly: accept only 'uf' mode");
	return $NULL;
    }

    ##### SAME AS "SendFileDividedly" #####
    $total = &DraftGenerate($tmp, $mode, $f, $f);

    # Hmm, O.K. In some case
    # back to the first filename for the use of SplitFiles
    local($lc) = &WC("$tmp.1");
    if ($lc > $MAIL_LENGTH_LIMIT && $total == 1) {
	rename("$tmp.1", $tmp) || &Log("cannot rename $tmp.1 $tmp");
	$total = &SplitFiles($tmp, $lc, int($lc/$MAIL_LENGTH_LIMIT) + 1);
    }

    if ($total) {
	$SFD_MIB{"$DSFD_Counter:tmp"}   = $tmp;
	$SFD_MIB{"$DSFD_Counter:total"} = $total;
	$SFD_MIB{"$DSFD_Counter:s"}     = $s;
	$SFD_MIB{"$DSFD_Counter:sleep"} = $sleep;
	$SFD_MIB{"$DSFD_Counter:\@to"}  = join(" ", @to);

	$FmlExitHook{'DelaySendFileDividedly'} = q#;
	&GoDelaySendFileDividedly;
	#;
    }
    else {
	&Log("DelaySendFileDividedly: error \$total=0");
    }
}


sub GoDelaySendFileDividedly
{
    local($i) = 0;

    for $i (1 .. $DSFD_Counter) {
	next unless $SFD_MIB{"$i:total"};

	# &SendingBackInOrder($tmp, $total, $s, $sleep, @to);
	&SendingBackInOrder(
			    $SFD_MIB{"$i:tmp"},
			    $SFD_MIB{"$i:total"},
			    $SFD_MIB{"$i:s"},
			    $SFD_MIB{"$i:sleep"},
			    $SFD_MIB{"$i:\@to"}
			    );
    }
}


# GIVEN "ONE FILE"(hence DraftGenerate always total=1)
# Split the given file and send back them
# ($f, $mode, $subject, @to)
# $f          the target file
# $mode
# $subject
# @to 
# return NONE
sub SendFilebySplit { &SendFileDividedly(@_);}
sub SendFileDividedly
{
    # for unique tmp file
    $SFD_Counter++;
    
    local($f, $mode, $enc, @to) = @_;
    local($total, $s, $target);
    local($sleep) = ($SLEEPTIME || 3);
    local($tmp)   = "$TMP_DIR/sfbs:${SFD_Counter}:$$";

    $0 = "$FML: split and send back $f to $to <$LOCKFILE>";
    $s = $enc || $DEFAULT_MGET_SUBJECT;

    if ($mode eq 'mp') {
	local($lc, @f, $tmpmp);
	$tmpmp = "$TMP_DIR/sfbs:mp:$$";
	$lc = &WC($f);
	if ($lc > $MAIL_LENGTH_LIMIT) {
	    &Copy($f, $tmpmp);
	    $total = &SplitFiles($tmpmp, $lc, int($lc/$MAIL_LENGTH_LIMIT) + 1);
	    # prepare an array of temporary files
	    for (1 .. $total) { push(@f, "$tmpmp.$_");}
	    $total = &DraftGenerate($tmp, $mode, $f, @f);
	    for ($tmpmp, @f) { unlink $_;}
	}
	else {
	    $total = &DraftGenerate($tmp, $mode, $f, $f);
	}
    }
    else {
	# local($tmpf, $mode, $file, @conf)
	# $tmpf     : a temporary file 
	# $mode     : mode 
	# $file     : filename of encode e.g. uuencode , ish ...
	&Debug("SendFilebySplit::DraftGenerate($tmp, $mode, $f, $f)") 
	    if $debug;
	$total = &DraftGenerate($tmp, $mode, $f, $f);

	# Hmm, O.K. In some case
	# back to the first filename for the use of SplitFiles
	local($lc) = &WC("$tmp.1");
	if ($lc > $MAIL_LENGTH_LIMIT && $total == 1) {
	    rename("$tmp.1", $tmp) || &Log("cannot rename $tmp.1 $tmp");
	    $total = &SplitFiles($tmp, $lc, int($lc/$MAIL_LENGTH_LIMIT) + 1);
	}
    }


    if ($debug) {
	&Debug("&SplitFiles($tmp, $lc, int($lc/$MAIL_LENGTH_LIMIT));");
	&Debug("SendFilebySplit::($tmp, $total, $s, $sleep, @to)");
    }

    if ($total) {
	&SendingBackInOrder($tmp, $total, $s, $sleep, @to);
    }

    # Destructor; 
    &ClearMimeHdr;
}


sub ClearMimeHdr
{
    undef $Envelope{'GH:Mime-Version:'};
    undef $Envelope{'GH:Content-Type:'};
    undef $Envelope{'GH:Content-Transfer-Encoding:'};
}

1;
