/* Nessus
 * Copyright (C) 1998-1999 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Plugins Inter Communication
 * -   -   -     -
 *
 * This set of functions just read what the plugin writes on its pipe,
 * and put it in an arglist
 */ 
 
#include <includes.h>
#include "piic.h"

/*
 * Returns whether a port in a port list is closed or not
 */
int
get_closed_ports(data, keys, ports)
   struct arglist * data;
   struct arglist * keys;
   struct arglist * ports;
{
  arg_add_value(data, "key", ARG_ARGLIST, -1, keys);
  if(!ports || !data)return -1;
  else while(ports && ports->next)
  {
    if(ports->type == ARG_INT)
    {
#ifdef DEBUG_NEED_FOR_SPEED    
      printf("host_get_port_state(%d) : %d\n", 
	  	ports->value,
	  	host_get_port_state(data, (int)ports->value));
#endif		
    if(host_get_port_state(data, (int)ports->value))return (int)ports->value;
    }
    else {
     char * asc_port = arg_get_value(keys, ports->value);
     if(asc_port)
     {
      int iport = atoi(asc_port);
#ifdef DEBUG_NEED_FOR_SPEED      
      printf("host_get_port_state(%d) : %d\n", 
	  			iport, host_get_port_state(data, iport));
#endif				
      if(host_get_port_state(data, iport))return iport;
     }
#ifdef DEBUG_NEED_FOR_SPEED     
     else printf("%s - key not found\n", ports->value);
#endif     
    }
    ports = ports->next;
  }
  return 0; /* found nothing */
}


/*
 * Returns the set of required ports
 */
struct arglist *
get_required_ports(plugin)
   struct arglist * plugin;
{
  struct arglist * args = arg_get_value(plugin, "plugin_args");
  if(args)return arg_get_value(args, "required_ports");
  else return NULL;
}

/*
 * Returns the set of required keys
 */
struct arglist *
get_required_keys(plugin)
 struct arglist * plugin;
{
 struct arglist * args = arg_get_value(plugin, "plugin_args");
 if(args)return arg_get_value(args, "required_keys");
 else return NULL;
}


/*
 * Returns the set of excluded keys
 */
struct arglist *
get_excluded_keys(plugin)
 struct arglist * plugin;
{
 struct arglist * args = arg_get_value(plugin, "plugin_args");
 if(args)return arg_get_value(args, "excluded_keys");
 else return NULL;
}

/*
 * Returns the name of the first key that is not in the
 * keyring. We are dealing with the KB keys, not the
 * cipher layer
 */
char * 
key_missing(keyring, keys)
  struct arglist * keyring;
  struct arglist * keys;
{
 if(!keyring || !keys)return NULL;
 else {
   while(keys && keys->next)
   {
     if(!arg_get_value(keyring, keys->value))return keys->value;
     keys = keys->next;
   }
 }
 return NULL;
}

/*
 * The opposite of the previous function
 */
char * key_present(keyring, keys)
 struct arglist * keyring;
 struct arglist * keys;
{
 if(!keyring || !keys)return NULL;
 else {
 while(keys && keys->next)
 {
  if(arg_get_value(keyring, keys->value))return keys->value;
  keys = keys->next;
 }
 return NULL;
 }
}
void 
piic_parse(args, pip, buf)
 struct arglist * args;
 int pip;
 char * buf;
{
 char * t;
 int type;
 char *c;
 
 if(buf[strlen(buf)-1]=='\n')buf[strlen(buf)-1]=0;
 c = strrchr(buf, ';');
 if(c)c[0] = 0;
 t = strchr(buf, ' ');
 if(!t)return;
 t[0] = 0;
 type = atoi(buf);
 t[0] = ' ';
 if(type != ARG_ARGLIST){
  char * value = strrchr(buf, '=');
  char * copy;
  if(!value)return;
  value[0]=0;value+=sizeof(char);
  if(type==ARG_STRING)
   {
   copy = estrdup(value);
#ifdef DEBUG
   printf("%s -> %s\n", t+sizeof(char), copy);
#endif   
   arg_add_value(args, t+sizeof(char), ARG_STRING, strlen(copy), copy);
   }
  if(type==ARG_INT)
   arg_add_value(args, t+sizeof(char), ARG_INT, sizeof(int), (void *)atoi(value));
  }
 else piic_arglist(args, pip, buf);
}

int piic_read_socket(args, soc)
 struct arglist * args;
 int soc;
{
 char buf[2048];
 fd_set rd;
 struct timeval tv;
 
 tv.tv_sec = 0;
 tv.tv_usec = 500;
 FD_ZERO(&rd);
 FD_SET(soc, &rd);
 if((select(soc+1, &rd, NULL, NULL, &tv))>0)
 {
  bzero(buf, 2048);
  recv_line(soc, buf, 2047);
  piic_parse(args, soc, buf);
  return 1;
 }
 else return 0;
}


void
piic_arglist(args, pip, buf)
 struct arglist * args;
 int pip;
 char * buf;
{
/*
 char * end = strrchr(buf, '/');
 struct arglist * arglist = emalloc(sizeof(struct arglist));
 int finished = 0;

 if(!end)return;
 end[0] = 0;
 while(!finished)
 {
  char * buffer = emalloc(255);
  recv_line(pip, buffer, 255);
  finished = (strstr(buffer, "/END_AL"))?1:0;
  piic_parse(arglist, pip, buffer);
  efree(&buffer);
 }
 arg_add_value(args, buf, ARG_ARGLIST, -1, arglist);
 */
 printf("error. piic_arglist called\n");
}
