/* Nessus
 * Copyright (C) 1998 - 1999 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * Attack.c : 
 *  launch the plugins, and manages the multithreading 
 *
 */
 
#include <includes.h>
#include "attack.h"
#include "log.h"
#include "hosts_gatherer.h"
#include "sighand.h"
#include "rules.h"
#include "auth.h"
#include "threads.h"
#include "comm.h" 
#include "utils.h"
#include "preferences.h"
#include "plugs_deps.h"
#include "ntp.h"
#include "pluginload.h"
#include "piic.h"
#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif

#ifdef ENABLE_CRYPTO_LAYER
#include "peks/peks.h"
#endif



int
is_client_online(globals)
 struct arglist * globals;
{
 int soc = (int)arg_get_value(globals, "global_socket");
 int n;

 if((n = send(soc, NULL, 0, 0))<0)
   {
    log_write("Connection closed by the client\n");
    return 1;
   }
  return(0);
}     

/*
 * Setup an arglist from a given hostname
 */
struct arglist * 
attack_init_hostinfos(hostname, ip)
     char * hostname;
    struct in_addr * ip;
{
  struct arglist * hostinfos;
  struct arglist * ports;
  
  hostinfos = emalloc(sizeof(struct arglist));
  arg_add_value(hostinfos, "FQDN", ARG_STRING, strlen(hostname), hostname);
  arg_add_value(hostinfos, "IP", ARG_PTR, sizeof(struct in_addr), ip);
  ports = emalloc(sizeof(struct arglist));
  arg_add_value(hostinfos, "PORTS", ARG_ARGLIST, sizeof(struct arglist), ports);
  return(hostinfos);
}


/*
 * This function attacks *one* host
 */
void 
attack_host_thread(globals, hostinfos, plugins, hostname, port_range, hosts_list)
     struct arglist * globals;
     struct arglist * hostinfos;
     struct arglist * plugins;
     char * hostname;
     char * port_range;
     struct arglist * hosts_list;
{ 
  int num_plugs = 0;
  int cur_plug = 1;
  struct arglist * new_args;
  struct arglist * preferences = arg_get_value(globals,"preferences");
  struct arglist * key = emalloc(sizeof(struct arglist));
  struct arglist * portsinfos = emalloc(sizeof(struct arglist));
  ext_library_t ptr;
  int t = 0;
  plugin_run_t f_run = NULL;
  char * optimize_asc =  arg_get_value(preferences, "optimize_test");
  int optimize = 1;
  
  if(!optimize_asc)optimize = 1;
  else if(!strcmp(optimize_asc, "no"))optimize = 0;
  
  
  arg_add_value(key, "hosts", ARG_ARGLIST, -1, hosts_list);
  num_plugs = get_active_plugins_number(plugins);
 
  arg_add_value(portsinfos, "ports", ARG_PTR, -1, arg_get_value(globals,"ports"));
  arg_add_value(portsinfos, "ports_num", ARG_INT, -1, arg_get_value(globals,
  								"ports_num"));
  arg_add_value(portsinfos, "key", ARG_ARGLIST, -1, key);
  /* launch the plugins */
  
  while(plugins && plugins->next)
    {
      struct arglist * args;
      char * name = arg_get_value(plugins->value, "full_name");
      nthread_t current_plugin;
  
      if(is_client_online(globals))return;
    
      if(plug_get_launch(plugins->value)) /* can we launch it ? */
	{
	 char * missing = NULL;
	 char * present = NULL;
	 
	 pl_class_t * cl_ptr = arg_get_value(plugins->value, "PLUGIN_CLASS");
	 comm_send_status(globals, hostname, "attack", cur_plug++, num_plugs);
	 if(!optimize || get_closed_ports(portsinfos, key,
	 		      get_required_ports(plugins->value)))
	 {		      
	 if(!optimize || !(missing = key_missing(key, get_required_keys(plugins->value))))
	 {
	 
	 if(!optimize || !(present = key_present(key, get_excluded_keys(plugins->value))))
	 {
	 log_write("user %s : launching %s against %s\n", 
	 				(char *)arg_get_value(globals, "user"),
					plugins->name, hostname);
					
#ifdef ENABLE_CRYPTO_LAYER_currently_disabled
 	 log_user_cookie (globals, "attack", plugins->name, hostname) ;
#endif /* ENABLE_CRYPTO_LAYER */
#ifdef ENABLE_CRYPTO_LAYER
#ifdef ENABLE_PID_STAMP_DEBUGGING
 	 {
	   char pidf [128], pidpath [256];
	   int soc, fd = -1;
	   if ((soc = (int)arg_get_value(globals, "global_socket")) >= 0) {
	     struct timeval tv; 
	     static initialized = 0 ;
	     gettimeofday (&tv, 0);
	     if (!initialized) {
	       initialized = tv.tv_sec ;
	       mkdir ("/tmp/nessus-ps",        0700);
	       mkdir ("/tmp/nessus-ps/active", 0700);
	       mkdir ("/tmp/nessus-ps/removed", 0700);
	     }
	     tv.tv_sec  -= initialized ;
	     tv.tv_usec /= 1000 ;
	     /* create a pid stamp, one for each cipher channel */
	     sprintf (pidf, "%04u.%03u-%u-%u-%d-x-%s",
		      tv.tv_sec, tv.tv_usec, getpid (), getppid (), soc,
		      plugins->name);
	     sprintf (pidpath, "/tmp/nessus-ps/active/%s", pidf);
	     if ((fd = creat (pidpath, 0)) >= 0)
	       close (fd);
	   }
#endif /* ENABLE_PID_STAMP_DEBUGGING */
#endif /* ENABLE_CRYPTO_LAYER */
	 (*cl_ptr->pl_launch)(globals, plugins->value, hostinfos,
	 		      preferences,key,name);
#ifdef ENABLE_CRYPTO_LAYER
#ifdef ENABLE_PID_STAMP_DEBUGGING
	   if (fd >= 0) {
	     char newp [256] ;
	     /* unlink (pidpath); */
	     sprintf (newp, "/tmp/nessus-ps/removed/%s", pidf);
	     rename (pidpath, newp);
	   }
	 }
#endif /* ENABLE_PID_STAMP_DEBUGGING */
#endif /* ENABLE_CRYPTO_LAYER */
	 /*
	  * Stop the test if the host is 'dead'
	  */	 
        if(arg_get_value(key, "Host/dead")){
	 		log_write("The remote host (%s) is dead\n", hostname);
			return;
			}
	 
	 }
	 else {
	  log_write("Not launching %s against %s because the key %s is present (this is not an error)\n",
	       			plugins->name, hostname, present);
	  }
	  }			
	 else {
	   log_write("Not launching %s against %s because the key %s is missing (this is not an error)\n",
	       			plugins->name, hostname, missing);
	 }
	}
	else {
	  log_write("Not launching %s against %s because none of the required ports were open (this is not an error)\n",
	  			plugins->name, hostname);
	  }			
	}
      plugins = plugins->next;
    }

#ifdef DEBUG_LOG
  log_write("debug: <- attack_host_thread\n");
#endif
}

/* 
 * Start an attack : set up the host infos and launch the
 * attack thread
 */
void
attack_start(args)
  struct arglist * args;
{
 struct arglist * globals = arg_get_value(args, "globals");
 char * hostname = arg_get_value(args, "hostname");
 struct arglist * plugs = arg_get_value(args, "plugins");
 char * port_range = arg_get_value(args, "port_range");
 struct in_addr * hostip = arg_get_value(args, "hostip");
 struct arglist * hosts_list = arg_get_value(args, "hosts_list");
 struct arglist * hostinfos;
#ifdef ENABLE_CRYPTO_LAYER
 int soc = (int)arg_get_value(globals, "global_socket") ;
#endif
 struct arglist * preferences = arg_get_value(globals,"preferences");
  

 /*arg_free(args);*/
 if(!(hostinfos = attack_init_hostinfos(hostname,hostip)))
   auth_printf(globals, "SERVER <|> ERROR <|> %s : host unknown <|> SERVER\n", 
	       hostname);
 else
   {
    struct arglist * new_plugs = NULL;
    char * show = arg_get_value(preferences, "ntp_opt_show_end");
#ifndef USE_FORK_THREADS
    new_plugs = emalloc(sizeof(struct arglist));
    arg_dup(new_plugs, plugs);
#else
    new_plugs = plugs;
#endif
    attack_host_thread(globals, hostinfos, new_plugs, hostname, port_range, hosts_list);
    if(show && !strcmp(show, "yes"))
    	auth_printf(globals, "SERVER <|> FINISHED <|> %s <|> SERVER\n",
				hostname);
   }
}

/*
 * This is the main function for attacking
 * a whole network
 */
int 
attack_host(globals)
    struct arglist * globals;
{
  int max_threads;
  struct arglist * tplugs;
  int num_tested = 0;
  int host_pending;
  int num_threads = 0;
  char * hostname;
  struct in_addr host_ip;
  char * port_range;
  int max_hosts;
  int hg_flags;
  struct hg_globals * hg_globals;
  int global_socket = (int)arg_get_value(globals, "global_socket");
  struct arglist * preferences = arg_get_value(globals, "preferences");
  struct arglist * plugins = arg_get_value(globals, "plugins");
  struct arglist * hosts_list = emalloc(sizeof(struct arglist));
  ntp_caps* caps = arg_get_value(globals, "ntp_caps");
  struct nessusd_threads * threads;
  struct nessus_rules *rules = arg_get_value(globals, "rules");
  struct arglist * tested_hosts = 0;
  char * t;
  unsigned short * ports;

#ifdef DEBUG_RULES
  rules_dump(rules);
#endif  
  hostname = arg_get_value(preferences, "TARGET");
  log_write("user %s starts an attack against %s\n",
			 (char *)arg_get_value(globals, "user"), hostname);
  max_hosts = atoi(arg_get_value(preferences, "max_hosts"));
  if(!max_hosts)
  {
   log_write("user %s attempted to set max_hosts to 0, which is a non-sense. Using 'unlimited' instead",(char *)arg_get_value(globals, "user"));
   max_hosts = -1;
  }
  port_range = arg_get_value(preferences, "port_range");
  if(!port_range)port_range = "1-15000";
  if(port_range && strlen(port_range) && strcmp(port_range, "-1"))
  {
   int num = 0;
   int i = 0;
   ports = (unsigned short*)getpts(port_range);
   for(i=0;ports[i];i++,num++);
   if(arg_get_value(globals, "ports"))
    arg_set_value(globals, "ports", -1, ports);
   else
    arg_add_value(globals, "ports", ARG_PTR,-1, ports);
    
   if(arg_get_value(globals, "ports_num"))
    arg_set_value(globals, "ports_num", sizeof(int),  (void*)num);
   else
    arg_add_value(globals, "ports_num", ARG_INT, sizeof(int), (void*)num);
  }
  /*
   * Initialization of the attack
   */
  tplugs = sort_plugins_by_type(plugins); /* sort the plugins by category   */
  
  
  if(caps->ntp_11) send_plugin_order(globals, tplugs);
  hg_flags = preferences_get_host_expansion(preferences);

  /* 
   * Initialize the hosts_gatherer library 
   */
  hg_globals = hg_init(hostname, hg_flags); 
  hostname = hg_next_host(hg_globals,&host_ip);
 
  if(hostname)
  {
   max_threads = get_max_thread_number(preferences);
   log_write("user %s starts a new attack against %s, with max_threads = %d\n",
			 (char *)arg_get_value(globals, "user"), hostname,
			 max_threads);
   threads = nessusd_threads_init();
   arg_add_value(globals, "threads", ARG_PTR, -1, threads);
  
   tested_hosts = emalloc(sizeof(struct arglist));
  /*
   * Start the attack !
   */
   while(hostname && (num_tested != max_hosts))
    {
      nthread_t pid;
      if(is_client_online(globals))return;
      host_pending = 0 ;
      if(CAN_TEST(get_host_rules(rules, host_ip,32))) /* do we have the right to test this host ? */ 
      {
          t = estrdup(hostname);
  	  arg_add_value(tested_hosts, "", ARG_STRING, strlen(t), t);
	  if(num_threads < max_threads)
	    {
             struct arglist * arglist = emalloc(sizeof(struct arglist));
	     struct in_addr * ia = emalloc(sizeof(ia));
             arg_add_value(hosts_list, t, ARG_INT, -1, (void *)1);
             arg_add_value(arglist, "globals", ARG_ARGLIST, -1, globals);
             arg_add_value(arglist, "hostname", ARG_STRING, -1, t);
	     ia->s_addr = host_ip.s_addr;
	     arg_add_value(arglist, "hostip", ARG_PTR, -1, ia); 
             arg_add_value(arglist, "plugins", ARG_ARGLIST, -1, tplugs);
             arg_add_value(arglist, "port_range", ARG_STRING, -1, port_range);
             arg_add_value(arglist, "hosts_list", ARG_ARGLIST, -1, hosts_list);      
	     pid = create_thread(attack_start, arglist, globals);   
	     nessusd_thread_register(&threads, t, pid);
             arg_set_value(globals, "threads", -1, threads);
             num_threads++;
	     log_write("user %s : testing %s\n", (char *)arg_get_value(globals, "user"), hostname);
	    }
	  else 
	    {
              /* 
               * There are too many threads at this time... We
               * have to wait until one of them finishes
               */
	      host_pending = 1; /* means that we must NOT update the hostname */
             
	      while(num_threads >= max_threads)
                {
		usleep(200);
                if((check_client_input(globals))<0)return;
                threads = arg_get_value(globals, "threads");
		num_threads = wait_for_a_thread(&threads);
                arg_set_value(globals, "threads", -1, threads);
                }
	    }
	} else log_write("User %s : rejected attempt to scan %s", 
			(char *)arg_get_value(globals, "user"), hostname);
			
			
      if(!host_pending){
        /*
         * since hg_get_next_host() may take a little time, 
         * we set up a thread dedicated to listenning to our 
         * socket so that we can catch the user input...
         */
        nthread_t check_client_thread = create_thread(check_client_input_thread, globals, 0);
        num_tested++;
       	hostname = hg_next_host(hg_globals, &host_ip);
        TERMINATE_THREAD(check_client_thread); 
        wait_for_a_thread(&threads);
        arg_set_value(globals, "threads", -1, threads);
      }
    }
  /*
   * Every host is being tested... We have to wait for the threads
   * to terminate
   */
  
  
  while(wait_for_a_thread(&threads)){
  	usleep(200);
        arg_set_value(globals, "threads", -1, threads);
     	if((check_client_input(globals))<0)return;
        threads = arg_get_value(globals, "threads");
        }
  	
 
  /*
   * Clean up the temporary plugin list in memory
   */
  arg_free(tplugs);
  
  
  /*
   * XXX
   * At this very moment, external programs
   * may be called using the string 
   * created by the function : hosts_arglist_to_string(tested_hosts)
   * which returns the list of hosts that shall be tested
   */
   
   /*
    * some_function(hosts_arglist_to_string(tested_hosts));
    */
    
    
  /*
   * Free memory here.
   */
  }
   else
   auth_printf(globals, "SERVER <|> ERROR <|> \
None of the hosts that you selected \
answered to our ping queries. Try to \
deselect the 'ping hosts' option and \
try again");
	
  hg_cleanup(hg_globals);
  arg_free(tested_hosts);
  return(0);
}

   
 
