/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */
 

#include <includes.h>

#ifdef USE_GTK 
#include <gtk/gtk.h>

#include "xstuff.h"
#include "globals.h"

/*
 * plugin_info_window_setup 
 *
 * This function draws the window
 * which contains informations about a plugin
 */
void 
plugin_info_window_setup(struct arglist* res, char * pluginname)
{
 GtkWidget * window;
 GtkWidget * box;
 GtkWidget * hbox;
 GtkWidget * subbox;
 GtkWidget * label;
 GtkWidget * text;
 GtkWidget * button;
 GtkWidget * separator;  
 GtkStyle *style;
 GtkAdjustment * vadj;
 GtkWidget * vsb;
 GtkWidget * table;
 
 

 char * category;
 char * buf;
 struct arglist * plugin;
 
 plugin = arg_get_value(res, pluginname);
 if(!plugin)
 {
#ifdef DEBUG
  fprintf(stderr, "Error ! Plugin selected not found ?!\n");
#endif
  return;
 }
 buf = emalloc(4095);
 window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize(window, 400,500);
 gtk_container_border_width(GTK_CONTAINER(window),10);
 gtk_window_set_title(GTK_WINDOW(window), pluginname);
 
 box = gtk_vbox_new(FALSE,3);
 gtk_container_add(GTK_CONTAINER(window), box);
 
 
 hbox = gtk_hbox_new(FALSE,10);
 gtk_box_pack_start(GTK_BOX(box), hbox, FALSE,FALSE,0);
 gtk_widget_show(hbox);
 
 
 
 separator = gtk_hseparator_new();
 gtk_box_pack_start(GTK_BOX(box), separator, FALSE, FALSE,0);
 gtk_widget_show(separator);
 
 
 sprintf(buf, "Family : %s", plug_get_family(plugin));
 label = gtk_label_new(buf);
 gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE,0);
 gtk_widget_show(label);
 
 separator = gtk_hseparator_new();
 gtk_box_pack_start(GTK_BOX(box), separator, FALSE, FALSE,0);
 gtk_widget_show(separator);
 
 label = gtk_label_new("What is shown if the attack is successful : ");
 gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE,0);
 gtk_widget_show(label);
 
 
 vadj = GTK_ADJUSTMENT (gtk_adjustment_new (0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
 vsb = gtk_vscrollbar_new (vadj);
 table = gtk_table_new(1,2,FALSE);
 gtk_box_pack_start(GTK_BOX(box), table, TRUE,TRUE,0);
 gtk_widget_show(table);
 
 text = gtk_text_new(NULL,vadj);
 gtk_table_attach (GTK_TABLE (table), vsb, 1, 2, 0, 1,
                    0, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
 gtk_table_attach (GTK_TABLE (table), text, 0, 1, 0, 1,
                   GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                    GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0); 
 gtk_container_border_width (GTK_CONTAINER (table), 2);  
 gtk_widget_show(vsb);
  
 gtk_widget_realize (text);  
 gtk_text_set_editable(GTK_TEXT(text), FALSE);
 gtk_text_set_word_wrap(GTK_TEXT(text), TRUE);
 if(arg_get_value(plugin, "DESCRIPTION"))
 gtk_text_insert(GTK_TEXT(text), NULL,NULL,NULL, arg_get_value(plugin, "DESCRIPTION"),
 	-1);
 gtk_widget_show(text);
 
 separator = gtk_hseparator_new();
 gtk_box_pack_start(GTK_BOX(box), separator, FALSE, FALSE,0);
 gtk_widget_show(separator);
 
 button = gtk_button_new_with_label("Close");
 gtk_signal_connect(GTK_OBJECT(button), "clicked",GTK_SIGNAL_FUNC(close_window), window);
 gtk_box_pack_end(GTK_BOX(box), button, FALSE, FALSE,0);
 gtk_widget_show(button);
 
 gtk_widget_realize(window);
 category = arg_get_value(plugin, "CATEGORY");

 
 
 subbox = gtk_vbox_new(FALSE,3);
 gtk_box_pack_start(GTK_BOX(hbox), subbox, FALSE,FALSE,0);
 gtk_widget_show(subbox);
 
 label = gtk_label_new(pluginname);
 gtk_box_pack_start(GTK_BOX(subbox), label, FALSE, FALSE,0);
 gtk_widget_show(label);
 
 label = gtk_label_new(arg_get_value(plugin, "COPYRIGHT"));
 gtk_box_pack_start(GTK_BOX(subbox), label, FALSE,FALSE,0);
 gtk_widget_show(label);
 
 
 gtk_widget_show(box);
 gtk_widget_show(window);
  
 efree(&buf);
}
#endif
