/** @file api_generated.cc
 * @brief test common features of API classes
 */
/* Warning: This file is generated by /data/home/olly/tmp/xapian-svn-snapshot/tags/1.2.12/xapian/xapian-core/tests/generate-api_generated - do not modify directly! */
/* Copyright (C) 2007,2009 Olly Betts
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include <config.h>

#include "api_generated.h"

#include <xapian.h>

#include "apitest.h"
#include "testutils.h"

using namespace std;

/// Check uncopyable API classes which should have a default ctor actually do.
DEFINE_TESTCASE(defaultctor1, !backend) {
    Xapian::BM25Weight bm25weight;
    Xapian::BoolWeight boolweight;
    Xapian::DecreasingValueWeightPostingSource decreasingvalueweightpostingsource(0);
    (void)decreasingvalueweightpostingsource.get_description();
    Xapian::FixedWeightPostingSource fixedweightpostingsource(0);
    (void)fixedweightpostingsource.get_description();
    Xapian::TradWeight tradweight;
    Xapian::ValueCountMatchSpy valuecountmatchspy(0);
    (void)valuecountmatchspy.get_description();
    Xapian::ValueMapPostingSource valuemappostingsource(0);
    (void)valuemappostingsource.get_description();
    Xapian::ValuePostingSource valuepostingsource(0);
    (void)valuepostingsource.get_description();
    Xapian::ValueWeightPostingSource valueweightpostingsource(0);
    (void)valueweightpostingsource.get_description();
    return true;
}

/// Test that API classes have a copy ctor and assignment operator.
DEFINE_TESTCASE(copyassign1, !backend) {
    Xapian::Database database;
    (void)database.get_description();
    Xapian::Database copy_database(database);
    database = copy_database;

    Xapian::DateValueRangeProcessor datevaluerangeprocessor(0);
    Xapian::DateValueRangeProcessor copy_datevaluerangeprocessor(datevaluerangeprocessor);
    datevaluerangeprocessor = copy_datevaluerangeprocessor;

    Xapian::Document document;
    (void)document.get_description();
    Xapian::Document copy_document(document);
    document = copy_document;

    Xapian::ESet eset;
    (void)eset.get_description();
    Xapian::ESet copy_eset(eset);
    eset = copy_eset;

    Xapian::ESetIterator esetiterator;
    (void)esetiterator.get_description();
    Xapian::ESetIterator copy_esetiterator(esetiterator);
    esetiterator = copy_esetiterator;

#ifdef XAPIAN_HAS_INMEMORY_BACKEND
    Xapian::Enquire enquire(Xapian::InMemory::open());
    (void)enquire.get_description();
    Xapian::Enquire copy_enquire(enquire);
    enquire = copy_enquire;
#endif

    Xapian::MSet mset;
    (void)mset.get_description();
    Xapian::MSet copy_mset(mset);
    mset = copy_mset;

    Xapian::MSetIterator msetiterator;
    (void)msetiterator.get_description();
    Xapian::MSetIterator copy_msetiterator(msetiterator);
    msetiterator = copy_msetiterator;

    Xapian::MultiValueKeyMaker multivaluekeymaker;
    Xapian::MultiValueKeyMaker copy_multivaluekeymaker(multivaluekeymaker);
    multivaluekeymaker = copy_multivaluekeymaker;

    Xapian::NumberValueRangeProcessor numbervaluerangeprocessor(0, "");
    Xapian::NumberValueRangeProcessor copy_numbervaluerangeprocessor(numbervaluerangeprocessor);
    numbervaluerangeprocessor = copy_numbervaluerangeprocessor;

    Xapian::PositionIterator positioniterator;
    (void)positioniterator.get_description();
    Xapian::PositionIterator copy_positioniterator(positioniterator);
    positioniterator = copy_positioniterator;

    Xapian::PostingIterator postingiterator;
    (void)postingiterator.get_description();
    Xapian::PostingIterator copy_postingiterator(postingiterator);
    postingiterator = copy_postingiterator;

    Xapian::Query query;
    (void)query.get_description();
    Xapian::Query copy_query(query);
    query = copy_query;

    Xapian::QueryParser queryparser;
    (void)queryparser.get_description();
    Xapian::QueryParser copy_queryparser(queryparser);
    queryparser = copy_queryparser;

    Xapian::RSet rset;
    (void)rset.get_description();
    Xapian::RSet copy_rset(rset);
    rset = copy_rset;

    Xapian::Registry registry;
    Xapian::Registry copy_registry(registry);
    registry = copy_registry;

    Xapian::SimpleStopper simplestopper;
    (void)simplestopper.get_description();
    Xapian::SimpleStopper copy_simplestopper(simplestopper);
    simplestopper = copy_simplestopper;

    Xapian::Stem stem;
    (void)stem.get_description();
    Xapian::Stem copy_stem(stem);
    stem = copy_stem;

    Xapian::StringValueRangeProcessor stringvaluerangeprocessor(0);
    Xapian::StringValueRangeProcessor copy_stringvaluerangeprocessor(stringvaluerangeprocessor);
    stringvaluerangeprocessor = copy_stringvaluerangeprocessor;

    Xapian::TermGenerator termgenerator;
    (void)termgenerator.get_description();
    Xapian::TermGenerator copy_termgenerator(termgenerator);
    termgenerator = copy_termgenerator;

    Xapian::TermIterator termiterator;
    (void)termiterator.get_description();
    Xapian::TermIterator copy_termiterator(termiterator);
    termiterator = copy_termiterator;

    Xapian::ValueIterator valueiterator;
    (void)valueiterator.get_description();
    Xapian::ValueIterator copy_valueiterator(valueiterator);
    valueiterator = copy_valueiterator;

    Xapian::WritableDatabase writabledatabase;
    (void)writabledatabase.get_description();
    Xapian::WritableDatabase copy_writabledatabase(writabledatabase);
    writabledatabase = copy_writabledatabase;

    return true;
}
