/*******************************************************************************
 * Score Reading Trainer                                                       *
 * Copyright (C) 2004 by Jos Pablo Ezequiel Fernndez <pupeno@pupeno.com>     *
 *                                                                             *
 * This program is free software; you can redistribute it and/or               *
 * modify it under the terms of the GNU General Public License                 *
 * version 2 as published by the Free Software Foundation.                     *
 *                                                                             *
 * This program is distributed in the hope that it will be useful,             *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
 * GNU General Public License for more details.                                *
 *                                                                             *
 * You should have received a copy of the GNU General Public License           *
 * along with this program; if not, write to the Free Software                 *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
 *******************************************************************************/

#ifndef _PREFERENCES_H_
#define _PREFERENCES_H_

#include <kdialogbase.h>

class Program;

class Preferences : public KDialogBase {
	Q_OBJECT
	public:
		Preferences();

	private:
		/**
		 * Load the configuration to the dialog
		 */
		void loadSettings();

		/**
		 * Widget of the preferences
		 */
		Program *program;

	private slots:
		/**
		 * Save the settings to the KConfig
		 */
		void saveSettings();

		/**
		 * Put the default settings on the configuration dialog.
		 */
		void defaultSettings();
};

#endif // _PREFERENCES_H_
