#!/usr/bin/env python
# arch-tag: f6217865-fab7-4233-8a8b-ab6cb5388657
# Copyright (C) 2003 Ben Burns <bburns@mailops.com>
#               2004 David Allouche <david@allouche.net>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Coding style tests
"""

import sys
import os
import re
import unittest
import textwrap
from pybaz.tests import framework


def matchFiles(files, regexp):
    result = []
    for f in files:
        mymatch = re.findall(regexp, f)
        if mymatch:
             result.append(f)
    return result

def filesInDir(directory):
    result = []
    for (dirpath, dirname, filenames) in os.walk(directory):
        for f in filenames:
            result.append(dirpath + os.path.sep + f)
    return result

def findPythonFiles():
    files = filesInDir('.')
    files = matchFiles(files, r'.*\.py$')
    archfiles=matchFiles(files, '{arch}')
    for archfile in archfiles:
        files.remove(archfile)
    return files

def getWrappedText(text, length=80):
    wrappedLines = []
    for line in text.splitlines():
        if line == '':
            wrappedLines.append(line)
        else:
            for wrappedLine in textwrap.wrap(line, length):
                wrappedLines.append(wrappedLine)
    wrappedText = '\n'.join(wrappedLines)+'\n'
    return wrappedText


class CodingStandards(unittest.TestCase):

    """Test what we can as far as coding standards go."""

    def testTextWrap(self):
        """Wrapping is idempotent on source files."""
        for filename in findPythonFiles():
            text = open(filename).read()
            wrapped = getWrappedText(text)
            if not text == wrapped:
                lines = text.splitlines()
                wraps = wrapped.splitlines()
                index = 0
                for line in lines:
                    if not line == wraps[index]:
                        msg = "Difference in %s" % (filename,)
                        msg += " on line %s" % (index+1,)
                        msg += "\nLine: " + line
                        msg += "\nWrap: " + wraps[index]
                        self.failUnlessEqual(line, wraps[index], msg)
                    index += 1


framework.register(__name__)
