/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: baseencoding.cxx,v $
 * $Revision: 1.6 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_xmlsecurity.hxx"
#include "xmlsecurity/baseencoding.hxx"

#include <xmlsec/xmlsec.h>
#include <xmlsec/base64.h>
#include <com/sun/star/uno/Sequence.hxx>

//CP : added by CP
#include <rtl/locale.h>
#include <osl/nlsupport.h> 
#include <osl/process.h>

//CP : end


using namespace ::com::sun::star::uno ;
using ::rtl::OUString ;

//We only implment the base64 encoding at present.
::rtl::OUString SAL_CALL baseEncode( const ::com::sun::star::uno::Sequence< sal_Int8 >& rawdata, BaseType base ) {
	if( base == BASE64 ) {
		xmlChar* chData ;

		chData = xmlSecBase64Encode( ( const unsigned char* )&rawdata[0], rawdata.getLength(), 0 ) ;
		if( chData != NULL ) {
			OUString ouStr = OUString::createFromAscii( ( const sal_Char* )chData );
			xmlFree( chData ) ;

			return ouStr ;
		}
	} else {
		return OUString() ;
	}

	return OUString() ;
}

//We only implment the base64 encoding at present.
::com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL baseDecode( const ::rtl::OUString& oustr, BaseType base ) {
	if( base == BASE64 ) {
		xmlChar* chData ;
		xmlSecSize chSize ;

		// add By CP
		sal_uInt16 encoding;
		rtl_Locale* pLocale = NULL;
		osl_getProcessLocale(&pLocale);
		encoding = osl_getTextEncodingFromLocale(pLocale);
		// CP end

		rtl::OString ostr = rtl::OUStringToOString( oustr , encoding ) ;
		//rtl::OString ostr = rtl::OUStringToOString( oustr , RTL_TEXTENCODING_ASCII_US ) ;

		chData = xmlStrndup( ( const xmlChar* )ostr.getStr(), ( int )ostr.getLength() ) ;

		chSize = xmlSecBase64Decode( chData, ( xmlSecByte* )chData, xmlStrlen( chData ) ) ;

		Sequence< sal_Int8 > rawData( chSize ) ;
		for( unsigned int i = 0 ; i < chSize ; i ++ )
			rawData[i] = *( chData + i ) ;

		xmlFree( chData ) ;

		return rawData ;
	}

	return ::com::sun::star::uno::Sequence< sal_Int8 >() ;
}

