/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: svdocapt.hxx,v $
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SVDCAPT_HXX
#define _SVDCAPT_HXX

#include <svx/svdorect.hxx>
#include "svx/svxdllapi.h"

//************************************************************
//   Vorausdeklarationen
//************************************************************

class ImpCaptParams;

namespace sdr
{
	namespace properties
	{
		class CaptionProperties;
	} // end of namespace properties
} // end of namespace sdr

#define SDRSETITEM_CAPTION_ATTR		SDRSETITEM_ATTR_COUNT

//************************************************************
//   Hilfsklasse SdrCaptObjGeoData
//************************************************************

// #109872#
class SdrCaptObjGeoData : public SdrTextObjGeoData
{
public:
	Polygon						aTailPoly;
};

//************************************************************
//   SdrCaptionObj
//************************************************************

class SVX_DLLPUBLIC SdrCaptionObj : public SdrRectObj
{
	virtual sdr::properties::BaseProperties* CreateObjectSpecificProperties();

	// to allow sdr::properties::CaptionProperties access to ImpRecalcTail()
	friend class sdr::properties::CaptionProperties;

	friend class				SdrTextObj; // fuer ImpRecalcTail() bei AutoGrow

protected:
	Polygon						aTailPoly;  // das ganze Polygon des Schwanzes
	sal_Bool					mbSpecialTextBoxShadow; // for calc special shadow, default FALSE
	sal_Bool					mbFixedTail; // for calc note box fixed tail, default FALSE
	Point					        maFixedTailPos; // for calc note box fixed tail position.

private:
	SVX_DLLPRIVATE void ImpGetCaptParams(ImpCaptParams& rPara) const;
	SVX_DLLPRIVATE void ImpCalcTail1(const ImpCaptParams& rPara, Polygon& rPoly, Rectangle& rRect) const;
	SVX_DLLPRIVATE void ImpCalcTail2(const ImpCaptParams& rPara, Polygon& rPoly, Rectangle& rRect) const;
	SVX_DLLPRIVATE void ImpCalcTail3(const ImpCaptParams& rPara, Polygon& rPoly, Rectangle& rRect) const;
	SVX_DLLPRIVATE void ImpCalcTail4(const ImpCaptParams& rPara, Polygon& rPoly, Rectangle& rRect) const;
	SVX_DLLPRIVATE void ImpCalcTail (const ImpCaptParams& rPara, Polygon& rPoly, Rectangle& rRect) const;
	SVX_DLLPRIVATE void ImpRecalcTail();

public:
	TYPEINFO();
	SdrCaptionObj();
	SdrCaptionObj(const Rectangle& rRect);
	SdrCaptionObj(const Rectangle& rRect, const Point& rTail);
	virtual ~SdrCaptionObj();

	virtual void TakeObjInfo(SdrObjTransformInfoRec& rInfo) const;
	virtual UINT16 GetObjIdentifier() const;
	virtual void RecalcBoundRect();
	virtual SdrObject* CheckHit(const Point& rPnt, USHORT nTol, const SetOfByte* pVisiLayer) const;
	virtual void operator=(const SdrObject& rObj);

	// for calc: special shadow only for text box
	void SetSpecialTextBoxShadow() { mbSpecialTextBoxShadow = TRUE; }
	// for calc: fixed note tail position. 
	void SetFixedTail() { mbFixedTail = TRUE; }
	virtual sal_Bool DoPaintObject(XOutputDevice& rOut, const SdrPaintInfoRec& rInfoRec) const;

	virtual void TakeObjNameSingul(String& rName) const;
	virtual void TakeObjNamePlural(String& rName) const;

	virtual basegfx::B2DPolyPolygon TakeXorPoly(sal_Bool bDetail) const;
	virtual void SetModel(SdrModel* pNewModel);
	virtual void SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType, const SfxHint& rHint, const TypeId& rHintType);

	virtual sal_uInt32 GetHdlCount() const;
	virtual SdrHdl* GetHdl(sal_uInt32 nHdlNum) const;
	virtual FASTBOOL HasSpecialDrag() const;
	virtual FASTBOOL BegDrag(SdrDragStat& rDrag) const;
	virtual FASTBOOL MovDrag(SdrDragStat& rDrag) const;
	virtual FASTBOOL EndDrag(SdrDragStat& rDrag);
	virtual void BrkDrag(SdrDragStat& rDrag) const;

	virtual String GetDragComment(const SdrDragStat& rDrag, FASTBOOL bUndoDragComment, FASTBOOL bCreateComment) const;

	virtual basegfx::B2DPolyPolygon TakeDragPoly(const SdrDragStat& rDrag) const;
	virtual FASTBOOL BegCreate(SdrDragStat& rStat);
	virtual FASTBOOL MovCreate(SdrDragStat& rStat);
	virtual FASTBOOL EndCreate(SdrDragStat& rStat, SdrCreateCmd eCmd);
	virtual FASTBOOL BckCreate(SdrDragStat& rStat);
	virtual void BrkCreate(SdrDragStat& rStat);
	virtual basegfx::B2DPolyPolygon TakeCreatePoly(const SdrDragStat& rDrag) const;
	virtual Pointer GetCreatePointer() const;

	virtual void NbcMove(const Size& rSiz);
	virtual void NbcResize(const Point& rRef, const Fraction& xFact, const Fraction& yFact);

	virtual void NbcSetRelativePos(const Point& rPnt);
	virtual Point GetRelativePos() const;
	virtual void NbcSetAnchorPos(const Point& rPnt);
	virtual const Point& GetAnchorPos() const;

	virtual void RecalcSnapRect();
	virtual const Rectangle& GetSnapRect() const;
	virtual void NbcSetSnapRect(const Rectangle& rRect);
	virtual const Rectangle& GetLogicRect() const;
	virtual void NbcSetLogicRect(const Rectangle& rRect);

	virtual sal_uInt32 GetSnapPointCount() const;
	virtual Point GetSnapPoint(sal_uInt32 i) const;

protected:
	virtual SdrObjGeoData* NewGeoData() const;
	virtual void SaveGeoData(SdrObjGeoData& rGeo) const;
	virtual void RestGeoData(const SdrObjGeoData& rGeo);

public:
	virtual SdrObject* DoConvertToPolyObj(BOOL bBezier) const;

	const Point& GetTailPos() const;
	void SetTailPos(const Point& rPos);
	void NbcSetTailPos(const Point& rPos);

	// #i32599#
	// Add own implementation for TRSetBaseGeometry to handle TailPos over changes
	virtual void TRSetBaseGeometry(const basegfx::B2DHomMatrix& rMatrix, const basegfx::B2DPolyPolygon& rPolyPolygon);

	inline const Point& GetFixedTailPos() const  {return maFixedTailPos;} 
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#endif //_SVDOCAPT_HXX

