/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: accessibilityoptions.cxx,v $
 * $Revision: 1.16 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svtools.hxx"

#ifdef  SVL_DLLIMPLEMENTATION
#undef  SVL_DLLIMPLEMENTATION
#endif
#define SVT_DLLIMPLEMENTATION

#include <svtools/accessibilityoptions.hxx>
#include <unotools/configmgr.hxx>
#include <tools/debug.hxx>
#include <com/sun/star/uno/Any.hxx>
#include <com/sun/star/uno/Sequence.hxx>
#include <svtools/smplhint.hxx>

#include <vcl/settings.hxx>
#include <vcl/svapp.hxx>
#include <rtl/instance.hxx>

#include <itemholder2.hxx>

using namespace utl;
using namespace rtl;
using namespace com::sun::star::uno;

#define HELP_TIP_TIMEOUT 0xffff     // max. timeout setting to pretend a non-timeout

// class SvtAccessibilityOptions_Impl ---------------------------------------------

class SvtAccessibilityOptions_Impl : public utl::ConfigItem, public SfxBroadcaster
{
private:
	sal_Int16		m_nHelpTipSeconds;

    sal_Bool        m_bForPagePreviews;
	sal_Bool		m_bHelpTipsDisappear;
	sal_Bool		m_bAllowAnimatedGraphics;
	sal_Bool		m_bAllowAnimatedText;
	sal_Bool		m_bAutomaticFontColor;
	sal_Bool		m_bSystemFont;
    sal_Bool        m_bTextSelectionInReadonly;
	sal_Bool		m_bAutoDetectSystemHC;

	typedef sal_Bool SvtAccessibilityOptions_Impl:: *BoolPtr;

	sal_Bool	GetToken( BoolPtr pPtr ) const;
	void		SetToken( BoolPtr pPtr, sal_Bool bSet );
    void        Load();

	//this list needs exactly to mach the listet properties in GetPropertyNames
	enum PropertyNameIndex {  PAGEPREVIEWS
							, HELPTIPSDISAPPEAR
							, HELPTIPSECONDS
							, ALLOWANIMATEDGRAPHICS
							, ALLOWANIMATEDTEXT
							, AUTOMATICFONTCOLOR
							, SYSTEMFONT
                            , TEXTSELECTION
							, AUTODETECTSYSTEMHC
						};

	static Sequence< OUString > GetPropertyNames();

public:
	SvtAccessibilityOptions_Impl();

	virtual void 	Notify( const com::sun::star::uno::Sequence< rtl::OUString >& aPropertyNames );
	virtual void	Commit();

	void		SetVCLSettings();
	sal_Bool    GetAutoDetectSystemHC( )
					{return GetToken( &SvtAccessibilityOptions_Impl::m_bAutoDetectSystemHC ); }
    sal_Bool    GetIsForPagePreviews() const
					{return GetToken( &SvtAccessibilityOptions_Impl::m_bForPagePreviews );}
	sal_Bool 	GetIsHelpTipsDisappear() const
					{return GetToken( &SvtAccessibilityOptions_Impl::m_bHelpTipsDisappear );}
	sal_Bool 	GetIsAllowAnimatedGraphics() const
					{return GetToken( &SvtAccessibilityOptions_Impl::m_bAllowAnimatedGraphics );}
	sal_Bool 	GetIsAllowAnimatedText() const
					{return GetToken( &SvtAccessibilityOptions_Impl::m_bAllowAnimatedText );}
	sal_Bool 	GetIsAutomaticFontColor() const
					{return GetToken( &SvtAccessibilityOptions_Impl::m_bAutomaticFontColor );}
	sal_Bool 	GetIsSystemFont() const
					{return GetToken( &SvtAccessibilityOptions_Impl::m_bSystemFont );}
	sal_Int16	GetHelpTipSeconds() const
					{return m_nHelpTipSeconds;}
    sal_Bool    IsSelectionInReadonly() const
                    {return m_bTextSelectionInReadonly;}

	void		SetAutoDetectSystemHC( sal_Bool bSet )
					{ SetToken( &SvtAccessibilityOptions_Impl::m_bAutoDetectSystemHC, bSet ); }
    void        SetIsForPagePreviews(sal_Bool bSet)
					{ SetToken( &SvtAccessibilityOptions_Impl::m_bForPagePreviews, bSet ); }
	void 		SetIsHelpTipsDisappear(sal_Bool bSet)
					{ SetToken( &SvtAccessibilityOptions_Impl::m_bHelpTipsDisappear, bSet ); }
	void 		SetIsAllowAnimatedGraphics(sal_Bool bSet)
					{ SetToken( &SvtAccessibilityOptions_Impl::m_bAllowAnimatedGraphics, bSet ); }
	void 		SetIsAllowAnimatedText(sal_Bool bSet)
					{ SetToken( &SvtAccessibilityOptions_Impl::m_bAllowAnimatedText, bSet ); }
	void 		SetIsAutomaticFontColor(sal_Bool bSet)
					{ SetToken( &SvtAccessibilityOptions_Impl::m_bAutomaticFontColor, bSet ); }
	void 		SetIsSystemFont(sal_Bool bSet)
					{ SetToken( &SvtAccessibilityOptions_Impl::m_bSystemFont, bSet ); }
	void		SetHelpTipSeconds(sal_Int16 nSet)
					{
						if(m_nHelpTipSeconds!=nSet)
						{
							m_nHelpTipSeconds=nSet;
							SetModified();
						}
					}
    void        SetSelectionInReadonly(sal_Bool bSet)
                    {SetToken( &SvtAccessibilityOptions_Impl::m_bTextSelectionInReadonly, bSet);}
};

// initialization of static members --------------------------------------

SvtAccessibilityOptions_Impl* volatile 	SvtAccessibilityOptions::sm_pSingleImplConfig =NULL;
sal_Int32					  volatile 	SvtAccessibilityOptions::sm_nAccessibilityRefCount(0);

namespace
{
    struct SingletonMutex 
        : public rtl::Static< ::osl::Mutex, SingletonMutex > {}; 
}

// functions -------------------------------------------------------------

Sequence< OUString > SvtAccessibilityOptions_Impl::GetPropertyNames()
{
	//this list needs exactly to mach the enum PropertyNameIndex
	static const char* aPropNames[] =
	{
         "IsForPagePreviews"        // PAGEPREVIEWS
		,"IsHelpTipsDisappear"		// HELPTIPSDISAPPEAR
		,"HelpTipSeconds"			// HELPTIPSECONDS
		,"IsAllowAnimatedGraphics"	// ALLOWANIMATEDGRAPHICS
		,"IsAllowAnimatedText"		// ALLOWANIMATEDTEXT
		,"IsAutomaticFontColor"		// AUTOMATICFONTCOLOR
		,"IsSystemFont"				// SYSTEMFONT
        ,"IsSelectionInReadonly"    // TEXTSELECTION
		,"AutoDetectSystemHC"		// AUTODETECTSYSTEMHC
	};
	const int nCount = sizeof( aPropNames ) / sizeof( const char* );
	Sequence< OUString > aNames( nCount );
	OUString* pNames = aNames.getArray();
	for ( int i = 0; i < nCount; i++ )
		pNames[i] = OUString::createFromAscii( aPropNames[i] );

	return aNames;
}

// -----------------------------------------------------------------------
// class SvtAccessibilityOptions_Impl ---------------------------------------------

SvtAccessibilityOptions_Impl::SvtAccessibilityOptions_Impl() :
	ConfigItem( OUString::createFromAscii("Office.Common/Accessibility") )
{
    Load();
}
// -----------------------------------------------------------------------
void SvtAccessibilityOptions_Impl::Load()
{
	Sequence< OUString > aNames = GetPropertyNames();
	Sequence< Any > aValues = GetProperties( aNames );
	EnableNotification( aNames );
	const Any* pValues = aValues.getConstArray();
	DBG_ASSERT( aValues.getLength() == aNames.getLength(), "GetProperties failed" );
	if ( aValues.getLength() == aNames.getLength() )
	{
		sal_Bool bTemp = sal_Bool();

		for ( int nProp = 0; nProp < aNames.getLength(); nProp++ )
		{
			if ( pValues[nProp].hasValue() )
			{
				if ( pValues[nProp] >>= bTemp )
				{
					switch ( PropertyNameIndex(nProp) )
					{
                        case PAGEPREVIEWS:          m_bForPagePreviews = bTemp;     break;
						case HELPTIPSDISAPPEAR:		m_bHelpTipsDisappear = bTemp;	break;
						case ALLOWANIMATEDGRAPHICS:	m_bAllowAnimatedGraphics = bTemp; break;
						case ALLOWANIMATEDTEXT:		m_bAllowAnimatedText = bTemp;	break;
						case AUTOMATICFONTCOLOR:	m_bAutomaticFontColor = bTemp;	break;
						case SYSTEMFONT:			m_bSystemFont = bTemp;			break;
                        case TEXTSELECTION:         m_bTextSelectionInReadonly = bTemp; break;
						case AUTODETECTSYSTEMHC:	m_bAutoDetectSystemHC = bTemp;	break;
						default:
							DBG_ERRORFILE( "invalid index to load a user token" );
					}
				}
				else
				{
					sal_Int16 nTemp = sal_Int16();
					if( pValues[nProp] >>= nTemp )
					{
						if(PropertyNameIndex(nProp)==HELPTIPSECONDS)//this is an integer and not a bool
							m_nHelpTipSeconds=nTemp;
						else
						{
							DBG_ERRORFILE( "sal_Int16 any type not matched with property name" );
						}
					}
					else
					{
						DBG_ERRORFILE( "Wrong any type" );
					}
				}
			}
		}
	}
}
// -----------------------------------------------------------------------

void SvtAccessibilityOptions_Impl::SetVCLSettings()
{
	AllSettings aAllSettings = Application::GetSettings();
    HelpSettings aHelpSettings = aAllSettings.GetHelpSettings();
    aHelpSettings.SetTipTimeout( GetIsHelpTipsDisappear() ? GetHelpTipSeconds() * 1000 : HELP_TIP_TIMEOUT);
    aAllSettings.SetHelpSettings(aHelpSettings);
    if(aAllSettings.GetStyleSettings().GetUseSystemUIFonts() != GetIsSystemFont() )
    {
        StyleSettings aStyleSettings = aAllSettings.GetStyleSettings();
        aStyleSettings.SetUseSystemUIFonts( GetIsSystemFont()  );
        aAllSettings.SetStyleSettings(aStyleSettings);
        Application::MergeSystemSettings( aAllSettings );
    }

    Application::SetSettings(aAllSettings);
}

void SvtAccessibilityOptions_Impl::Commit()
{
	ClearModified();
	Sequence< OUString > aNames = GetPropertyNames();
	Sequence< Any > aValues( aNames.getLength() );
	Any* pValues = aValues.getArray();
	sal_Bool bTemp=false;
	for ( int nProp = 0; nProp < aNames.getLength(); nProp++ )
	{
		switch ( PropertyNameIndex(nProp) )
		{
            case PAGEPREVIEWS:          bTemp = m_bForPagePreviews;     break;
			case HELPTIPSDISAPPEAR:		bTemp = m_bHelpTipsDisappear;	break;
			case HELPTIPSECONDS:		pValues[nProp] <<= m_nHelpTipSeconds; continue;//this is an integer and not a bool
			case ALLOWANIMATEDGRAPHICS: bTemp = m_bAllowAnimatedGraphics; break;
			case ALLOWANIMATEDTEXT:		bTemp = m_bAllowAnimatedText;	break;
			case AUTOMATICFONTCOLOR:	bTemp = m_bAutomaticFontColor;	break;
			case SYSTEMFONT:			bTemp = m_bSystemFont;			break;
            case TEXTSELECTION:         bTemp = m_bTextSelectionInReadonly; break;
			case AUTODETECTSYSTEMHC:	bTemp = m_bAutoDetectSystemHC;	break;
            default:
				DBG_ERRORFILE( "invalid index to save a user token" );
		}
		pValues[nProp] <<= bTemp;
	}
	PutProperties( aNames, aValues );

	//notify SfxListener
	{
		SfxSimpleHint aHint = SfxSimpleHint( SFX_HINT_ACCESSIBILITY_CHANGED );
		Broadcast(aHint);
		SetVCLSettings();
	}
}

// -----------------------------------------------------------------------

void SvtAccessibilityOptions_Impl::Notify( const Sequence<rtl::OUString>& )
{
    Load();
}

// -----------------------------------------------------------------------

sal_Bool SvtAccessibilityOptions_Impl::GetToken( BoolPtr pPtr ) const
{
	return this->*pPtr;
}

void SvtAccessibilityOptions_Impl::SetToken( BoolPtr pPtr, sal_Bool bSet )
{
	if(this->*pPtr != bSet)
	{
		this->*pPtr = bSet;
		SetModified();
	}
}

// -----------------------------------------------------------------------
// class SvtAccessibilityOptions --------------------------------------------------

SvtAccessibilityOptions::SvtAccessibilityOptions()
{
	{
		::osl::MutexGuard aGuard( SingletonMutex::get() );
		if(!sm_pSingleImplConfig)
		{
			sm_pSingleImplConfig = new SvtAccessibilityOptions_Impl;
			ItemHolder2::holdConfigItem(E_ACCESSIBILITYOPTIONS);
		}
		 ++sm_nAccessibilityRefCount;
	}
	StartListening( *sm_pSingleImplConfig, TRUE );
}

// -----------------------------------------------------------------------

SvtAccessibilityOptions::~SvtAccessibilityOptions()
{
	EndListening( *sm_pSingleImplConfig, TRUE );
	::osl::MutexGuard aGuard( SingletonMutex::get() );
	if( !--sm_nAccessibilityRefCount )
	{
		if( sm_pSingleImplConfig->IsModified() )
			sm_pSingleImplConfig->Commit();
    	DELETEZ( sm_pSingleImplConfig );
	}
}

// -----------------------------------------------------------------------

void SvtAccessibilityOptions::Notify( SfxBroadcaster&, const SfxHint& rHint )
{
	Broadcast( rHint );
    if ( rHint.IsA(TYPE(SfxSimpleHint)) )
    {
		if ( ((SfxSimpleHint&)rHint).GetId()  == SFX_HINT_ACCESSIBILITY_CHANGED )
			SetVCLSettings();
	}
}

// -----------------------------------------------------------------------

sal_Bool SvtAccessibilityOptions::IsModified() const
{
	return sm_pSingleImplConfig->IsModified();
}
void SvtAccessibilityOptions::Commit()
{
	sm_pSingleImplConfig->Commit();
}

// -----------------------------------------------------------------------

sal_Bool SvtAccessibilityOptions::GetIsForDrawings() const
{
	DBG_ERROR( "SvtAccessibilityOptions::GetIsForDrawings: is obsolete!" );
    return sal_False;
}
sal_Bool SvtAccessibilityOptions::GetIsForBorders() const
{
	DBG_ERROR( "SvtAccessibilityOptions::GetIsForBorders: is obsolete!" );
    return sal_False;
}
sal_Bool SvtAccessibilityOptions::GetAutoDetectSystemHC() const
{
	return sm_pSingleImplConfig->GetAutoDetectSystemHC();
}
sal_Bool SvtAccessibilityOptions::GetIsForPagePreviews() const
{
	return sm_pSingleImplConfig->GetIsForPagePreviews();
}
sal_Bool SvtAccessibilityOptions::GetIsHelpTipsDisappear() const
{
	return sm_pSingleImplConfig->GetIsHelpTipsDisappear();
}
sal_Bool SvtAccessibilityOptions::GetIsAllowAnimatedGraphics() const
{
	return sm_pSingleImplConfig->GetIsAllowAnimatedGraphics();
}
sal_Bool SvtAccessibilityOptions::GetIsAllowAnimatedText() const
{
	return sm_pSingleImplConfig->GetIsAllowAnimatedText();
}
sal_Bool SvtAccessibilityOptions::GetIsAutomaticFontColor() const
{
	return sm_pSingleImplConfig->GetIsAutomaticFontColor();
}
sal_Bool SvtAccessibilityOptions::GetIsSystemFont() const
{
	return sm_pSingleImplConfig->GetIsSystemFont();
}
sal_Int16 SvtAccessibilityOptions::GetHelpTipSeconds() const
{
	return sm_pSingleImplConfig->GetHelpTipSeconds();
}
sal_Bool SvtAccessibilityOptions::IsSelectionInReadonly() const
{
    return sm_pSingleImplConfig->IsSelectionInReadonly();
}

// -----------------------------------------------------------------------
void SvtAccessibilityOptions::SetAutoDetectSystemHC(sal_Bool bSet)
{
	sm_pSingleImplConfig->SetAutoDetectSystemHC(bSet);
}
void SvtAccessibilityOptions::SetIsForPagePreviews(sal_Bool bSet)
{
	sm_pSingleImplConfig->SetIsForPagePreviews(bSet);
}
void SvtAccessibilityOptions::SetIsHelpTipsDisappear(sal_Bool bSet)
{
	sm_pSingleImplConfig->SetIsHelpTipsDisappear(bSet);
}
void SvtAccessibilityOptions::SetIsAllowAnimatedGraphics(sal_Bool bSet)
{
	sm_pSingleImplConfig->SetIsAllowAnimatedGraphics(bSet);
}
void SvtAccessibilityOptions::SetIsAllowAnimatedText(sal_Bool bSet)
{
	sm_pSingleImplConfig->SetIsAllowAnimatedText(bSet);
}
void SvtAccessibilityOptions::SetIsAutomaticFontColor(sal_Bool bSet)
{
	sm_pSingleImplConfig->SetIsAutomaticFontColor(bSet);
}
void SvtAccessibilityOptions::SetIsSystemFont(sal_Bool bSet)
{
	sm_pSingleImplConfig->SetIsSystemFont(bSet);
}
void SvtAccessibilityOptions::SetHelpTipSeconds(sal_Int16 nSet)
{
	sm_pSingleImplConfig->SetHelpTipSeconds(nSet);
}
void SvtAccessibilityOptions::SetSelectionInReadonly(sal_Bool bSet)
{
    sm_pSingleImplConfig->SetSelectionInReadonly(bSet);
}

void SvtAccessibilityOptions::SetVCLSettings()
{
    sm_pSingleImplConfig->SetVCLSettings();
}
// -----------------------------------------------------------------------

