/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: core_resource.cxx,v $
 * $Revision: 1.11 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_dbaccess.hxx"

#include "core_resource.hxx"

#ifndef _TOOLS_SIMPLERESMGR_HXX_
#include <tools/simplerm.hxx>
#endif

// ---- needed as long as we have no contexts for components ---
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
//---------------------------------------------------

#ifndef _SOLAR_HRC
#include <svtools/solar.hrc>
#endif

//.........................................................................
namespace dbaccess
{

	//==================================================================
	//= ResourceManager
	//==================================================================
	SimpleResMgr* ResourceManager::m_pImpl = NULL;

	//------------------------------------------------------------------
	ResourceManager::EnsureDelete::~EnsureDelete()
	{
		delete ResourceManager::m_pImpl;
	}

	//------------------------------------------------------------------
	void ResourceManager::ensureImplExists()
	{
		if (m_pImpl)
			return;

		::com::sun::star::lang::Locale aLocale = Application::GetSettings().GetUILocale();

		ByteString sFileName("dba");

		m_pImpl = SimpleResMgr::Create(sFileName.GetBuffer(), aLocale);

		if (m_pImpl)
		{
			// now that we have an impl class make sure it's deleted on unloading the library
			static ResourceManager::EnsureDelete	s_aDeleteTheImplClass;
		}
	}

	//------------------------------------------------------------------
	::rtl::OUString ResourceManager::loadString(sal_uInt16 _nResId)
	{
		::rtl::OUString sReturn;

		ensureImplExists();
		if (m_pImpl)
			sReturn = m_pImpl->ReadString(_nResId);

		return sReturn;
	}

	//------------------------------------------------------------------
	::rtl::OUString ResourceManager::loadString( sal_uInt16 _nResId, const sal_Char* _pPlaceholderAscii, const ::rtl::OUString& _rReplace )
    {
        String sString( loadString( _nResId ) );
        sString.SearchAndReplaceAscii( _pPlaceholderAscii, _rReplace );
        return sString;
    }

//.........................................................................
}
//.........................................................................

