#include "config.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "types.h"
#include "boot/plinkman.h"
#include "filesel/mdb.h"
#include "filesel/pfilesel.h"
#include "stuff/compat.h"

static int ayReadMemInfo(struct moduleinfostruct *m, const char *buf, size_t len)
{
	int authorptr;
	const char *authorstr;

	int miscptr;
	const char *miscstr;

	int left;

/*	uint8_t tracks, default_track;*/

	/*int i;*/
	
	if (len<14)
	{
/*		fprintf(stderr, "len<14 (len=%d)\n", len);*/
		return 0;
	}

	if (memcmp(buf, "ZXAYEMUL", 8))
	{
/*		fprintf(stderr, "AY header failed\n");*/
		return 0;
	}

	m->modtype=mtAY;

	/* filever at offset 8 */
	/* playerver at offset 9 */

	/* custom-player at offset 10/11 */

	authorptr=256*(uint8_t)buf[12]+(uint8_t)buf[13] + 12;

/*	fprintf(stderr, "authorptr=%x\n", authorptr);*/
	authorstr=buf+authorptr;

	miscptr=256*(uint8_t)buf[14]+(uint8_t)buf[15] + 14;
	miscstr=buf+miscptr;

	/* default track is at offset 16 */
	m->channels=(uint8_t)buf[17];

	if ((left=len-(authorstr-buf))<=0) /* outside buffer-space */
	{
		m->composer[0]=0;
	} else if (left>sizeof(m->composer)) /* we have all the space we need anyway */
	{
		strncpy(m->composer, authorstr, sizeof(m->composer));
	} else if (memchr(authorstr, 0, left)) /* we have \0 before end of buffer */
	{
		strncpy(m->composer, authorstr, sizeof(m->composer));
	} else {
		m->composer[0]=0;
	}
	
	if ((left=len-(miscstr-buf))<=0) /* outside buffer-space */
	{
		m->comment[0]=0;
	} else if (left>sizeof(m->comment)) /* we have all the space we need anyway */
	{
		strncpy(m->comment, miscstr, sizeof(m->comment));
	} else if (memchr(miscstr, 0, left)) /* we have \0 before end of buffer */
	{
		strncpy(m->comment, miscstr, sizeof(m->comment));
	} else {
		m->comment[0]=0;
	}

	return 1;
}

static int ayReadInfo(struct moduleinfostruct *m, FILE *f, const char *buf, size_t len)
{
	return ayReadMemInfo(m, buf, len);
}

static void ayEvent(int event)
{
	switch (event)
	{
		case mdbEvInit:
		{
			fsRegisterExt("ay");
		}
	}
}


struct mdbreadnforegstruct ayReadInfoReg = {ayReadMemInfo, ayReadInfo, ayEvent};
char *dllinfo = "readinfos ayReadInfoReg";
struct linkinfostruct dllextinfo = {"aytype", "OpenCP AY Detection (c) 2005 Stian Skjelstad", DLLVERSION, 0};
