#*************************************************************************
#
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
# 
# Copyright 2000, 2010 Oracle and/or its affiliates.
#
# OpenOffice.org - a multi-platform office productivity suite
#
# This file is part of OpenOffice.org.
#
# OpenOffice.org is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# only, as published by the Free Software Foundation.
#
# OpenOffice.org is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License version 3 for more details
# (a copy is included in the LICENSE file that accompanied this code).
#
# You should have received a copy of the GNU Lesser General Public License
# version 3 along with OpenOffice.org.  If not, see
# <http://www.openoffice.org/license.html>
# for a copy of the LGPLv3 License.
#
#*************************************************************************

TARGET=OpenOffice.org
MAKEFILERC=true

# 
# build targets
# 

build_all : build_instsetoo_native

all .PHONY : build_all

check_modules .PHONY :
	@+echo Checking module list
	@+perl $(SOLARENV)$/bin$/build.pl --checkmodules

# Only build when all modules available
build_instsetoo_native .SETDIR=instsetoo_native/prj : check_modules
	@+perl $(SOLARENV)$/bin$/build.pl --all $(PROFULLSWITCH)

depend .SETDIR=instsetoo_native/prj : check_modules
	@+perl $(SOLARENV)$/bin$/build.pl --all $(PROFULLSWITCH) depend=t


# 
# bootstrap target
# 

bootstrap .PHONY :
	@bootstrap


distclean .PHONY: clean
	-rm config.cache
	-rm config.log
.IF "$(BUILD_DMAKE)"!="NO"
	-$(GNUMAKE) -C dmake distclean
.ENDIF


clean .PHONY:
	-rm -rf */$(INPATH)
	-rm -rf solver/*/$(INPATH)
	-rm -rf install
.IF "$(BUILD_DMAKE)"!="NO"
	-echo cleaning up dmake...
	-$(GNUMAKE) -C dmake clean
	-rm -f solenv/*/bin/dmake*
.ENDIF

# 
# configure target
# 

configure .PHONY SETDIR=. :
	@configure


# 
# install target
# 

install .PHONY :
	@test "$(DESTDIR)$(prefix)" != "" || (echo Usage: make install [DESTDIR=DIR] prefix=DIR; exit 2)
	cp -p instsetoo_native/$(INPATH)/bin/* $(SOLARVER)/$(INPATH)/bin
	cd instsetoo_native/util \
	    && OUT=$(INPATH)\
	    LOCAL_OUT=$(INPATH)\
	    LOCAL_COMMON_OUT=$(INPATH)\
            DEFAULT_TO_ENGLISH_FOR_PACKING=1\
	    PYTHONPATH=$(SOLARVER)/$(INPATH)/bin:$(SOLARVER)/$(INPATH)/lib:$(PYTHONPATH) \
	    $(PERL) $(SOLARENV)/bin/make_installer.pl -f openoffice.lst -l $(WITH_LANG:f:t",") -p OpenOffice -buildid 0 -simple $(DESTDIR)$(prefix)

#*************************************************************************

